/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.message.LogFlushStats$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.utils.IteratorTemplate;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001\u001d\u0011aBR5mK6+7o]1hKN+GO\u0003\u0002\u0004\t\u00059Q.Z:tC\u001e,'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M!\u0001\u0001\u0003\u0007\u0013!\tI!\"D\u0001\u0003\u0013\tY!A\u0001\u0006NKN\u001c\u0018mZ3TKR\u0004\"!\u0004\t\u000e\u00039Q!a\u0004\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Eq!a\u0002'pO\u001eLgn\u001a\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0005\u001a\u0001\t\u0015\r\u0011\"\u0001\u00035\u000591\r[1o]\u0016dW#A\u000e\u0011\u0005q\u0019S\"A\u000f\u000b\u0005yy\u0012\u0001C2iC:tW\r\\:\u000b\u0005\u0001\n\u0013a\u00018j_*\t!%\u0001\u0003kCZ\f\u0017B\u0001\u0013\u001e\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\t\u0011\u0019\u0002!\u0011!Q\u0001\nm\t\u0001b\u00195b]:,G\u000e\t\u0005\nQ\u0001\u0011)\u0019!C\u0001\u0005%\naa\u001c4gg\u0016$X#\u0001\u0016\u0011\u0005MY\u0013B\u0001\u0017\u0015\u0005\u0011auN\\4\t\u00119\u0002!\u0011!Q\u0001\n)\nqa\u001c4gg\u0016$\b\u0005C\u00051\u0001\t\u0015\r\u0011\"\u0001\u0003S\u0005)A.[7ji\"A!\u0007\u0001B\u0001B\u0003%!&\u0001\u0004mS6LG\u000f\t\u0005\ti\u0001\u0011)\u0019!C\u0001k\u00059Q.\u001e;bE2,W#\u0001\u001c\u0011\u0005M9\u0014B\u0001\u001d\u0015\u0005\u001d\u0011un\u001c7fC:D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006IAN\u0001\t[V$\u0018M\u00197fA!AA\b\u0001BC\u0002\u0013\u0005Q(A\u0006oK\u0016$'+Z2pm\u0016\u0014X#\u0001 \u0011\u0005}2U\"\u0001!\u000b\u0005\u0005\u0013\u0015AB1u_6L7M\u0003\u0002D\t\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0015\u000b\u0013\u0001B;uS2L!a\u0012!\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011!I\u0005A!A!\u0002\u0013q\u0014\u0001\u00048fK\u0012\u0014VmY8wKJ\u0004\u0003BB&\u0001\t\u0003!A*\u0001\u0004=S:LGO\u0010\u000b\u0007\u001b:{\u0005+\u0015*\u0011\u0005%\u0001\u0001\"B\rK\u0001\u0004Y\u0002\"\u0002\u0015K\u0001\u0004Q\u0003\"\u0002\u0019K\u0001\u0004Q\u0003\"\u0002\u001bK\u0001\u00041\u0004\"\u0002\u001fK\u0001\u0004q\u0004b\u0002+\u0001\u0005\u0004%I!V\u0001\bg\u0016$8+\u001b>f+\u00051\u0006CA X\u0013\tA\u0006I\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDaA\u0017\u0001!\u0002\u00131\u0016\u0001C:fiNK'0\u001a\u0011\t\u000fq\u0003!\u0019!C\u0005+\u0006\u00012/\u001a;IS\u001eDw+\u0019;fe6\u000b'o\u001b\u0005\u0007=\u0002\u0001\u000b\u0011\u0002,\u0002#M,G\u000fS5hQ^\u000bG/\u001a:NCJ\\\u0007\u0005C\u0003L\u0001\u0011\u0005\u0001\rF\u0002NC\nDQ!G0A\u0002mAQ\u0001N0A\u0002YBQa\u0013\u0001\u0005\u0002\u0011$2!T3n\u0011\u001517\r1\u0001h\u0003\u00111\u0017\u000e\\3\u0011\u0005!\\W\"A5\u000b\u0005)\f\u0013AA5p\u0013\ta\u0017N\u0001\u0003GS2,\u0007\"\u0002\u001bd\u0001\u00041\u0004\"B&\u0001\t\u0003yG\u0003B'qcJDQ!\u00078A\u0002mAQ\u0001\u000e8A\u0002YBQ\u0001\u00108A\u0002yBQa\u0013\u0001\u0005\u0002Q$B!T;wo\")am\u001da\u0001O\")Ag\u001da\u0001m!)Ah\u001da\u0001}!)\u0011\u0010\u0001C\u0001u\u0006!!/Z1e)\rA10 \u0005\u0006yb\u0004\rAK\u0001\u000be\u0016\fGm\u00144gg\u0016$\b\"\u0002@y\u0001\u0004Q\u0013\u0001B:ju\u0016Dq!!\u0001\u0001\t\u0003\t\u0019!A\u0004xe&$X\rV8\u0015\u000f)\n)!a\u0004\u0002\u0014!9\u0011qA@A\u0002\u0005%\u0011a\u00033fgR\u001c\u0005.\u00198oK2\u00042\u0001HA\u0006\u0013\r\ti!\b\u0002\u0015\u000f\u0006$\b.\u001a:j]\u001e\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\t\r\u0005Eq\u00101\u0001+\u0003-9(/\u001b;f\u001f\u001a47/\u001a;\t\u000by|\b\u0019\u0001\u0016\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005A\u0011\u000e^3sCR|'/\u0006\u0002\u0002\u001cA1\u0011QDA\u0017\u0003gqA!a\b\u0002*9!\u0011\u0011EA\u0014\u001b\t\t\u0019CC\u0002\u0002&\u0019\ta\u0001\u0010:p_Rt\u0014\"A\u000b\n\u0007\u0005-B#A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\u0012\u0011\u0007\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111\u0006\u000b\u0011\u0007%\t)$C\u0002\u00028\t\u0011\u0001#T3tg\u0006<W-\u00118e\u001f\u001a47/\u001a;\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u0005Y1/\u001b>f\u0013:\u0014\u0015\u0010^3t)\u0005Q\u0003bBA!\u0001\u0011\u0005\u0011QH\u0001\u000eQ&<\u0007nV1uKJl\u0015M]6\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005a1\r[3dW6+H/\u00192mKR\u0011\u0011\u0011\n\t\u0004'\u0005-\u0013bAA')\t!QK\\5u\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'\na!\u00199qK:$G\u0003BA%\u0003+Bq!a\u0016\u0002P\u0001\u0007\u0001\"\u0001\u0005nKN\u001c\u0018mZ3t\u0011\u001d\tY\u0006\u0001C\u0001\u0003\u000f\nQA\u001a7vg\"Dq!a\u0018\u0001\t\u0003\t9%A\u0003dY>\u001cX\rC\u0004\u0002d\u0001!\t!!\u0010\u0002\u000fI,7m\u001c<fe\"9\u0011q\r\u0001\u0005\n\u0005%\u0014a\u0004<bY&$\u0017\r^3NKN\u001c\u0018mZ3\u0015\u0013)\nY'!\u001c\u0002r\u0005U\u0004BB\r\u0002f\u0001\u00071\u0004C\u0004\u0002p\u0005\u0015\u0004\u0019\u0001\u0016\u0002\u000bM$\u0018M\u001d;\t\u000f\u0005M\u0014Q\ra\u0001U\u0005\u0019A.\u001a8\t\u0011\u0005]\u0014Q\ra\u0001\u0003s\naAY;gM\u0016\u0014\b\u0003BA>\u0003{j\u0011aH\u0005\u0004\u0003\u007fz\"A\u0003\"zi\u0016\u0014UO\u001a4fe\"\u001a\u0001!a!\u0011\u00075\t))C\u0002\u0002\b:\u0011QB\\8oi\"\u0014X-\u00193tC\u001a,\u0007")
public class FileMessageSet
extends MessageSet
implements Logging {
    private final FileChannel channel;
    private final long offset;
    private final long limit;
    private final boolean mutable;
    private final AtomicBoolean needRecover;
    private final AtomicLong setSize;
    private final AtomicLong setHighWaterMark;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        FileMessageSet fileMessageSet = this;
        synchronized (fileMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public FileChannel channel() {
        return this.channel;
    }

    public long offset() {
        return this.offset;
    }

    public long limit() {
        return this.limit;
    }

    public boolean mutable() {
        return this.mutable;
    }

    public AtomicBoolean needRecover() {
        return this.needRecover;
    }

    private AtomicLong setSize() {
        return this.setSize;
    }

    private AtomicLong setHighWaterMark() {
        return this.setHighWaterMark;
    }

    public MessageSet read(long readOffset, long size2) {
        return new FileMessageSet(this.channel(), this.offset() + readOffset, package$.MODULE$.min(this.offset() + readOffset + size2, this.highWaterMark()), false, new AtomicBoolean(false));
    }

    @Override
    public long writeTo(GatheringByteChannel destChannel, long writeOffset, long size2) {
        return this.channel().transferTo(this.offset() + writeOffset, package$.MODULE$.min(size2, this.sizeInBytes()), destChannel);
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return new IteratorTemplate<MessageAndOffset>(this){
            private long location;
            private final FileMessageSet $outer;

            private long location() {
                return this.location;
            }

            private void location_$eq(long l) {
                this.location = l;
            }

            public MessageAndOffset makeNext() {
                ByteBuffer sizeBuffer = ByteBuffer.allocate(4);
                this.$outer.channel().read(sizeBuffer, this.location());
                if (sizeBuffer.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                sizeBuffer.rewind();
                int size2 = sizeBuffer.getInt();
                if (size2 < Message$.MODULE$.MinHeaderSize()) {
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer buffer = ByteBuffer.allocate(size2);
                this.$outer.channel().read(buffer, this.location() + 4L);
                if (buffer.hasRemaining()) {
                    return (MessageAndOffset)this.allDone();
                }
                buffer.rewind();
                this.location_$eq(this.location() + (long)(size2 + 4));
                return new MessageAndOffset(new Message(buffer), this.location());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.location = $outer.offset();
            }
        };
    }

    @Override
    public long sizeInBytes() {
        return this.setSize().get();
    }

    public long highWaterMark() {
        return this.setHighWaterMark().get();
    }

    public void checkMutable() {
        if (this.mutable()) {
            return;
        }
        throw new IllegalStateException("Attempt to invoke mutation on immutable message set.");
    }

    public void append(MessageSet messages) {
        long written;
        this.checkMutable();
        for (written = 0L; written < messages.sizeInBytes(); written += messages.writeTo(this.channel(), 0L, messages.sizeInBytes())) {
        }
        this.setSize().getAndAdd(written);
    }

    public void flush() {
        this.checkMutable();
        long startTime = SystemTime$.MODULE$.milliseconds();
        this.channel().force(true);
        long elapsedTime$1 = SystemTime$.MODULE$.milliseconds() - startTime;
        LogFlushStats$.MODULE$.recordFlushRequest(elapsedTime$1);
        this.debug((Function0<String>)((Object)new Serializable(this, elapsedTime$1){
            public static final long serialVersionUID;
            private final long elapsedTime$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"flush time ").append(BoxesRunTime.boxToLong(this.elapsedTime$1)).toString();
            }
            {
                this.elapsedTime$1 = l;
            }
        }));
        this.setHighWaterMark().set(this.sizeInBytes());
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final FileMessageSet $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"flush high water mark:").append(BoxesRunTime.boxToLong(this.$outer.highWaterMark())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    public void close() {
        if (this.mutable()) {
            this.flush();
        }
        this.channel().close();
    }

    public long recover() {
        this.checkMutable();
        long len = this.channel().size();
        ByteBuffer buffer = ByteBuffer.allocate(4);
        long validUpTo = 0L;
        long next2 = 0L;
        do {
            if ((next2 = this.validateMessage(this.channel(), validUpTo, len, buffer)) < 0L) continue;
            validUpTo = next2;
        } while (next2 >= 0L);
        this.channel().truncate(validUpTo);
        this.setSize().set(validUpTo);
        this.setHighWaterMark().set(validUpTo);
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final FileMessageSet $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"recover high water mark:").append(BoxesRunTime.boxToLong(this.$outer.highWaterMark())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.channel().position(validUpTo);
        this.needRecover().set(false);
        return len - validUpTo;
    }

    private long validateMessage(FileChannel channel, long start, long len, ByteBuffer buffer) {
        buffer.rewind();
        int read2 = channel.read(buffer, start);
        if (read2 < 4) {
            return -1L;
        }
        int size2 = buffer.getInt(0);
        if (size2 < Message$.MODULE$.MinHeaderSize()) {
            return -1L;
        }
        long next2 = start + 4L + (long)size2;
        if (next2 > len) {
            return -1L;
        }
        ByteBuffer messageBuffer = ByteBuffer.allocate(size2);
        long curr = start + 4L;
        while (messageBuffer.hasRemaining()) {
            read2 = channel.read(messageBuffer, curr);
            if (read2 < 0) {
                throw new IllegalStateException("File size changed during recovery!");
            }
            curr += (long)read2;
        }
        messageBuffer.rewind();
        Message message = new Message(messageBuffer);
        if (message.isValid()) {
            return next2;
        }
        return -1L;
    }

    public FileMessageSet(FileChannel channel, long offset, long limit, boolean mutable, AtomicBoolean needRecover) {
        Object object;
        this.channel = channel;
        this.offset = offset;
        this.limit = limit;
        this.mutable = mutable;
        this.needRecover = needRecover;
        Logging$class.$init$(this);
        this.setSize = new AtomicLong();
        this.setHighWaterMark = new AtomicLong();
        if (mutable) {
            if (limit < Long.MAX_VALUE || offset > 0L) {
                throw new IllegalArgumentException("Attempt to open a mutable message set with a view or offset, which is not allowed.");
            }
            if (needRecover.get()) {
                long startMs$1 = System.currentTimeMillis();
                long truncated$1 = this.recover();
                this.info((Function0<String>)((Object)new Serializable(this, startMs$1, truncated$1){
                    public static final long serialVersionUID;
                    private final long startMs$1;
                    private final long truncated$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Recovery succeeded in ").append(BoxesRunTime.boxToLong((System.currentTimeMillis() - this.startMs$1) / 1000L)).append((Object)" seconds. ").append(BoxesRunTime.boxToLong(this.truncated$1)).append((Object)" bytes truncated.").toString();
                    }
                    {
                        this.startMs$1 = l;
                        this.truncated$1 = l2;
                    }
                }));
                object = BoxedUnit.UNIT;
            } else {
                this.setSize().set(channel.size());
                this.setHighWaterMark().set(this.sizeInBytes());
                object = channel.position(channel.size());
            }
        } else {
            this.setSize().set(package$.MODULE$.min(channel.size(), limit) - offset);
            this.setHighWaterMark().set(this.sizeInBytes());
            this.debug((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;
                private final FileMessageSet $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"initializing high water mark in immutable mode: ").append(BoxesRunTime.boxToLong(this.$outer.highWaterMark())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            object = BoxedUnit.UNIT;
        }
    }

    public FileMessageSet(FileChannel channel, boolean mutable) {
        this(channel, 0L, Long.MAX_VALUE, mutable, new AtomicBoolean(false));
    }

    public FileMessageSet(File file, boolean mutable) {
        this(Utils$.MODULE$.openChannel(file, mutable), mutable);
    }

    public FileMessageSet(FileChannel channel, boolean mutable, AtomicBoolean needRecover) {
        this(channel, 0L, Long.MAX_VALUE, mutable, needRecover);
    }

    public FileMessageSet(File file, boolean mutable, AtomicBoolean needRecover) {
        this(Utils$.MODULE$.openChannel(file, mutable), mutable, needRecover);
    }
}

