/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import kafka.message.ByteBufferBackedInputStream;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionFacade;
import kafka.message.CompressionFactory$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.Message;
import kafka.message.MessageSet$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.immutable.Stream;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class CompressionUtils$
implements Logging {
    public static final CompressionUtils$ MODULE$;
    private CompressionCodec defaultCodec;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new CompressionUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        CompressionUtils$ compressionUtils$ = this;
        synchronized (compressionUtils$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private CompressionCodec defaultCodec() {
        return this.defaultCodec;
    }

    private void defaultCodec_$eq(CompressionCodec compressionCodec) {
        this.defaultCodec = compressionCodec;
    }

    public Message compress(Iterable<Message> messages$1, CompressionCodec compressionCodec) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.debug((Function0<String>)((Object)new Serializable(messages$1){
            public static final long serialVersionUID;
            private final Iterable messages$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Allocating message byte buffer of size = ").append(BoxesRunTime.boxToInteger(MessageSet$.MODULE$.messageSetSize(this.messages$1))).toString();
            }
            {
                this.messages$1 = iterable;
            }
        }));
        CompressionFacade cf = null;
        CompressionCodec compressionCodec2 = compressionCodec;
        DefaultCompressionCodec$ defaultCompressionCodec$ = DefaultCompressionCodec$.MODULE$;
        cf = !(compressionCodec2 != null ? !compressionCodec2.equals(defaultCompressionCodec$) : defaultCompressionCodec$ != null) ? CompressionFactory$.MODULE$.apply(this.defaultCodec(), outputStream) : CompressionFactory$.MODULE$.apply(compressionCodec, outputStream);
        ByteBuffer messageByteBuffer$1 = ByteBuffer.allocate(MessageSet$.MODULE$.messageSetSize(messages$1));
        messages$1.foreach(new Serializable(messageByteBuffer$1){
            public static final long serialVersionUID;
            private final ByteBuffer messageByteBuffer$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final ByteBuffer apply(Message m) {
                return m.serializeTo(this.messageByteBuffer$1);
            }
            {
                this.messageByteBuffer$1 = byteBuffer;
            }
        });
        messageByteBuffer$1.rewind();
        try {
            cf.write(messageByteBuffer$1.array());
            Message oneCompressedMessage = new Message(outputStream.toByteArray(), compressionCodec);
            return oneCompressedMessage;
        }
        catch (IOException iOException) {
            this.error((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error while writing to the GZIP output stream";
                }
            }), (Function0<Throwable>)((Object)new Serializable(iOException){
                public static final long serialVersionUID;
                private final IOException e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final IOException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = iOException;
                }
            }));
            throw iOException;
        }
        finally {
            cf.close();
        }
    }

    public CompressionCodec compress$default$2() {
        return DefaultCompressionCodec$.MODULE$;
    }

    public ByteBufferMessageSet decompress(Message message) {
        ByteBuffer outputBuffer;
        ByteArrayOutputStream outputStream$1 = new ByteArrayOutputStream();
        ByteBufferBackedInputStream inputStream = new ByteBufferBackedInputStream(message.payload());
        byte[] intermediateBuffer$1 = new byte[1024];
        ObjectRef cf$1 = new ObjectRef(null);
        CompressionCodec compressionCodec = message.compressionCodec();
        DefaultCompressionCodec$ defaultCompressionCodec$ = DefaultCompressionCodec$.MODULE$;
        cf$1.elem = !(compressionCodec != null ? !compressionCodec.equals(defaultCompressionCodec$) : defaultCompressionCodec$ != null) ? CompressionFactory$.MODULE$.apply(this.defaultCodec(), inputStream) : CompressionFactory$.MODULE$.apply(message.compressionCodec(), inputStream);
        try {
            ((Stream)package$.MODULE$.Stream().continually(new Serializable(intermediateBuffer$1, cf$1){
                public static final long serialVersionUID;
                private final byte[] intermediateBuffer$1;
                private final ObjectRef cf$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return ((CompressionFacade)this.cf$1.elem).read(this.intermediateBuffer$1);
                }
                {
                    this.intermediateBuffer$1 = byArray;
                    this.cf$1 = objectRef;
                }
            }).takeWhile((Function1)((Object)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(int n) {
                    return this.apply$mcZI$sp(n);
                }

                public boolean apply$mcZI$sp(int v1) {
                    return v1 > 0;
                }
            }))).foreach(new Serializable(outputStream$1, intermediateBuffer$1){
                public static final long serialVersionUID;
                private final ByteArrayOutputStream outputStream$1;
                private final byte[] intermediateBuffer$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(int dataRead) {
                    this.apply$mcVI$sp(dataRead);
                }

                public void apply$mcVI$sp(int v1) {
                    this.outputStream$1.write(this.intermediateBuffer$1, 0, v1);
                }
                {
                    this.outputStream$1 = byteArrayOutputStream;
                    this.intermediateBuffer$1 = byArray;
                }
            });
            outputBuffer = ByteBuffer.allocate(outputStream$1.size());
            outputBuffer.put(outputStream$1.toByteArray());
        }
        catch (IOException iOException) {
            this.error((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error while reading from the GZIP input stream";
                }
            }), (Function0<Throwable>)((Object)new Serializable(iOException){
                public static final long serialVersionUID;
                private final IOException e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final IOException apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = iOException;
                }
            }));
            throw iOException;
        }
        finally {
            ((CompressionFacade)cf$1.elem).close();
        }
        outputBuffer.rewind();
        byte[] outputByteArray = outputStream$1.toByteArray();
        return new ByteBufferMessageSet(outputBuffer, ByteBufferMessageSet$.MODULE$.init$default$2(), ByteBufferMessageSet$.MODULE$.init$default$3());
    }

    private CompressionUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.defaultCodec = GZIPCompressionCodec$.MODULE$;
    }
}

