/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.common.ErrorMapping$;
import kafka.common.InvalidMessageSizeException;
import kafka.common.MessageSizeTooLargeException;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionUtils$;
import kafka.message.InvalidMessageException;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.utils.IteratorTemplate;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001\u001d\u0011ACQ=uK\n+hMZ3s\u001b\u0016\u001c8/Y4f'\u0016$(BA\u0002\u0005\u0003\u001diWm]:bO\u0016T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001\u0002\u0004\n\u0011\u0005%QQ\"\u0001\u0002\n\u0005-\u0011!AC'fgN\fw-Z*fiB\u0011Q\u0002E\u0007\u0002\u001d)\u0011q\u0002B\u0001\u0006kRLGn]\u0005\u0003#9\u0011q\u0001T8hO&tw\r\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002C\r\u0001\u0005\u000b\u0007I\u0011\u0002\u000e\u0002\r\t,hMZ3s+\u0005Y\u0002C\u0001\u000f\"\u001b\u0005i\"B\u0001\u0010 \u0003\rq\u0017n\u001c\u0006\u0002A\u0005!!.\u0019<b\u0013\t\u0011SD\u0001\u0006CsR,')\u001e4gKJD\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IaG\u0001\bEV4g-\u001a:!\u0011!1\u0003A!b\u0001\n\u00139\u0013!D5oSRL\u0017\r\\(gMN,G/F\u0001)!\t\u0019\u0012&\u0003\u0002+)\t!Aj\u001c8h\u0011!a\u0003A!A!\u0002\u0013A\u0013AD5oSRL\u0017\r\\(gMN,G\u000f\t\u0005\t]\u0001\u0011)\u0019!C\u0005_\u0005IQM\u001d:pe\u000e{G-Z\u000b\u0002aA\u00111#M\u0005\u0003eQ\u00111!\u00138u\u0011!!\u0004A!A!\u0002\u0013\u0001\u0014AC3se>\u00148i\u001c3fA!)a\u0007\u0001C\u0001o\u00051A(\u001b8jiz\"B\u0001O\u001d;wA\u0011\u0011\u0002\u0001\u0005\u00063U\u0002\ra\u0007\u0005\bMU\u0002\n\u00111\u0001)\u0011\u001dqS\u0007%AA\u0002ABq!\u0010\u0001A\u0002\u0013%q%A\u000btQ\u0006dGn\\<WC2LGMQ=uK\u000e{WO\u001c;\t\u000f}\u0002\u0001\u0019!C\u0005\u0001\u0006I2\u000f[1mY><h+\u00197jI\nKH/Z\"pk:$x\fJ3r)\t\tE\t\u0005\u0002\u0014\u0005&\u00111\t\u0006\u0002\u0005+:LG\u000fC\u0004F}\u0005\u0005\t\u0019\u0001\u0015\u0002\u0007a$\u0013\u0007\u0003\u0004H\u0001\u0001\u0006K\u0001K\u0001\u0017g\"\fG\u000e\\8x-\u0006d\u0017\u000e\u001a\"zi\u0016\u001cu.\u001e8uA!)a\u0007\u0001C\u0001\u0013R\u0019\u0001HS(\t\u000b-C\u0005\u0019\u0001'\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007CA\u0005N\u0013\tq%A\u0001\tD_6\u0004(/Z:tS>t7i\u001c3fG\")\u0001\u000b\u0013a\u0001#\u0006AQ.Z:tC\u001e,7\u000fE\u0002\u0014%RK!a\u0015\u000b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002\n+&\u0011aK\u0001\u0002\b\u001b\u0016\u001c8/Y4f\u0011\u00151\u0004\u0001\"\u0001Y)\tA\u0014\fC\u0003Q/\u0002\u0007\u0011\u000bC\u0003\\\u0001\u0011\u0005q%\u0001\thKRLe.\u001b;jC2|eMZ:fi\")Q\f\u0001C\u00015\u0005Iq-\u001a;Ck\u001a4WM\u001d\u0005\u0006?\u0002!\taL\u0001\rO\u0016$XI\u001d:pe\u000e{G-\u001a\u0005\u0006C\u0002!\tAY\u0001\u000bg\u0016\u0014\u0018.\u00197ju\u0016$G#A\u000e\t\u000b\u0011\u0004A\u0011A\u0014\u0002\u0015Y\fG.\u001b3CsR,7\u000fC\u0003g\u0001\u0011%q%A\ttQ\u0006dGn\\<WC2LGMQ=uKNDQ\u0001\u001b\u0001\u0005\u0002%\fqa\u001e:ji\u0016$v\u000e\u0006\u0003)UJ$\b\"B6h\u0001\u0004a\u0017aB2iC:tW\r\u001c\t\u0003[Bl\u0011A\u001c\u0006\u0003_v\t\u0001b\u00195b]:,Gn]\u0005\u0003c:\u0014AcR1uQ\u0016\u0014\u0018N\\4CsR,7\t[1o]\u0016d\u0007\"B:h\u0001\u0004A\u0013AB8gMN,G\u000fC\u0003vO\u0002\u0007\u0001&\u0001\u0003tSj,\u0007\"B<\u0001\t\u0003B\u0018\u0001C5uKJ\fGo\u001c:\u0016\u0003e\u0004RA_A\u0003\u0003\u0017q1a_A\u0001\u001d\tax0D\u0001~\u0015\tqh!\u0001\u0004=e>|GOP\u0005\u0002+%\u0019\u00111\u0001\u000b\u0002\u000fA\f7m[1hK&!\u0011qAA\u0005\u0005!IE/\u001a:bi>\u0014(bAA\u0002)A\u0019\u0011\"!\u0004\n\u0007\u0005=!A\u0001\tNKN\u001c\u0018mZ3B]\u0012|eMZ:fi\"1\u00111\u0003\u0001\u0005\u0002a\fqb\u001d5bY2|w/\u0013;fe\u0006$xN\u001d\u0005\b\u0003/\u0001A\u0011AA\r\u0003E1XM]5gs6+7o]1hKNK'0\u001a\u000b\u0004\u0003\u0006m\u0001bBA\u000f\u0003+\u0001\r\u0001M\u0001\u000f[\u0006DX*Z:tC\u001e,7+\u001b>f\u0011\u001d\t\t\u0003\u0001C\u0005\u0003G\t\u0001#\u001b8uKJt\u0017\r\\%uKJ\fGo\u001c:\u0015\u0007e\f)\u0003\u0003\u0006\u0002(\u0005}\u0001\u0013!a\u0001\u0003S\t\u0011\"[:TQ\u0006dGn\\<\u0011\u0007M\tY#C\u0002\u0002.Q\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004\u00022\u0001!\taJ\u0001\fg&TX-\u00138CsR,7\u000fC\u0004\u00026\u0001!\t%a\u000e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u000f\u0011\t\u0005m\u0012\u0011\t\b\u0004'\u0005u\u0012bAA )\u00051\u0001K]3eK\u001aLA!a\u0011\u0002F\t11\u000b\u001e:j]\u001eT1!a\u0010\u0015\u0011\u001d\tI\u0005\u0001C!\u0003\u0017\na!Z9vC2\u001cH\u0003BA\u0015\u0003\u001bB\u0001\"a\u0014\u0002H\u0001\u0007\u0011\u0011K\u0001\u0006_RDWM\u001d\t\u0004'\u0005M\u0013bAA+)\t\u0019\u0011I\\=\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002*\u0005u\u0003\u0002CA(\u0003/\u0002\r!!\u0015\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d\u0005A\u0001.Y:i\u0007>$W\rF\u00011\u0011%\t9\u0007AI\u0001\n\u0013\tI'\u0001\u000ej]R,'O\\1m\u0013R,'/\u0019;pe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002l)\"\u0011\u0011FA7W\t\ty\u0007\u0005\u0003\u0002r\u0005mTBAA:\u0015\u0011\t)(a\u001e\u0002\u0013Ut7\r[3dW\u0016$'bAA=)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005u\u00141\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,w!CAA\u0005\u0005\u0005\tRAAB\u0003Q\u0011\u0015\u0010^3Ck\u001a4WM]'fgN\fw-Z*fiB\u0019\u0011\"!\"\u0007\u0011\u0005\u0011\u0011\u0011!E\u0003\u0003\u000f\u001bR!!\"\u0002\nJ\u0001B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0004\u0003\u001f{\u0012\u0001\u00027b]\u001eLA!a%\u0002\u000e\n1qJ\u00196fGRDqANAC\t\u0003\t9\n\u0006\u0002\u0002\u0004\"Q\u00111TAC#\u0003%\t!!(\u0002\u001d%t\u0017\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u0014\u0016\u0004Q\u00055\u0004BCAR\u0003\u000b\u000b\n\u0011\"\u0001\u0002&\u0006q\u0011N\\5uI\u0011,g-Y;mi\u0012\u001aTCAATU\r\u0001\u0014Q\u000e")
public class ByteBufferMessageSet
extends MessageSet
implements Logging {
    private final ByteBuffer kafka$message$ByteBufferMessageSet$$buffer;
    private final long kafka$message$ByteBufferMessageSet$$initialOffset;
    private final int errorCode;
    private long shallowValidByteCount;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    public static final int init$default$3() {
        return ByteBufferMessageSet$.MODULE$.init$default$3();
    }

    public static final long init$default$2() {
        return ByteBufferMessageSet$.MODULE$.init$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ByteBufferMessageSet byteBufferMessageSet = this;
        synchronized (byteBufferMessageSet) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public final ByteBuffer kafka$message$ByteBufferMessageSet$$buffer() {
        return this.kafka$message$ByteBufferMessageSet$$buffer;
    }

    public final long kafka$message$ByteBufferMessageSet$$initialOffset() {
        return this.kafka$message$ByteBufferMessageSet$$initialOffset;
    }

    private int errorCode() {
        return this.errorCode;
    }

    private long shallowValidByteCount() {
        return this.shallowValidByteCount;
    }

    private void shallowValidByteCount_$eq(long l) {
        this.shallowValidByteCount = l;
    }

    public long getInitialOffset() {
        return this.kafka$message$ByteBufferMessageSet$$initialOffset();
    }

    public ByteBuffer getBuffer() {
        return this.kafka$message$ByteBufferMessageSet$$buffer();
    }

    public int getErrorCode() {
        return this.errorCode();
    }

    public ByteBuffer serialized() {
        return this.kafka$message$ByteBufferMessageSet$$buffer();
    }

    public long validBytes() {
        return this.shallowValidBytes();
    }

    private long shallowValidBytes() {
        if (this.shallowValidByteCount() < 0L) {
            Iterator<MessageAndOffset> iter2 = this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
            while (iter2.hasNext()) {
                MessageAndOffset messageAndOffset = iter2.next();
                this.shallowValidByteCount_$eq(messageAndOffset.offset());
            }
        }
        return this.shallowValidByteCount() < this.kafka$message$ByteBufferMessageSet$$initialOffset() ? 0L : this.shallowValidByteCount() - this.kafka$message$ByteBufferMessageSet$$initialOffset();
    }

    @Override
    public long writeTo(GatheringByteChannel channel, long offset, long size2) {
        this.kafka$message$ByteBufferMessageSet$$buffer().mark();
        int written = channel.write(this.kafka$message$ByteBufferMessageSet$$buffer());
        this.kafka$message$ByteBufferMessageSet$$buffer().reset();
        return written;
    }

    @Override
    public Iterator<MessageAndOffset> iterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(this.kafka$message$ByteBufferMessageSet$$internalIterator$default$1());
    }

    public Iterator<MessageAndOffset> shallowIterator() {
        return this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
    }

    public void verifyMessageSize(int maxMessageSize) {
        Iterator<MessageAndOffset> shallowIter = this.kafka$message$ByteBufferMessageSet$$internalIterator(true);
        while (shallowIter.hasNext()) {
            MessageAndOffset messageAndOffset = shallowIter.next();
            int payloadSize = messageAndOffset.message().payloadSize();
            if (payloadSize <= maxMessageSize) continue;
            throw new MessageSizeTooLargeException(new StringBuilder().append((Object)"payload size of ").append(BoxesRunTime.boxToInteger(payloadSize)).append((Object)" larger than ").append(BoxesRunTime.boxToInteger(maxMessageSize)).toString());
        }
    }

    public final Iterator<MessageAndOffset> kafka$message$ByteBufferMessageSet$$internalIterator(boolean isShallow$1) {
        ErrorMapping$.MODULE$.maybeThrowException(this.errorCode());
        return new IteratorTemplate<MessageAndOffset>(this, isShallow$1){
            private ByteBuffer kafka$message$ByteBufferMessageSet$$anon$$topIter;
            private long kafka$message$ByteBufferMessageSet$$anon$$currValidBytes;
            private Iterator<MessageAndOffset> innerIter;
            private long lastMessageSize;
            private final ByteBufferMessageSet $outer;
            private final boolean isShallow$1;

            public final ByteBuffer kafka$message$ByteBufferMessageSet$$anon$$topIter() {
                return this.kafka$message$ByteBufferMessageSet$$anon$$topIter;
            }

            private void kafka$message$ByteBufferMessageSet$$anon$$topIter_$eq(ByteBuffer byteBuffer) {
                this.kafka$message$ByteBufferMessageSet$$anon$$topIter = byteBuffer;
            }

            public final long kafka$message$ByteBufferMessageSet$$anon$$currValidBytes() {
                return this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes;
            }

            private void kafka$message$ByteBufferMessageSet$$anon$$currValidBytes_$eq(long l) {
                this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes = l;
            }

            private Iterator<MessageAndOffset> innerIter() {
                return this.innerIter;
            }

            private void innerIter_$eq(Iterator<MessageAndOffset> iterator2) {
                this.innerIter = iterator2;
            }

            private long lastMessageSize() {
                return this.lastMessageSize;
            }

            private void lastMessageSize_$eq(long l) {
                this.lastMessageSize = l;
            }

            private boolean innerDone() {
                return this.innerIter() == null || !this.innerIter().hasNext();
            }

            private MessageAndOffset makeNextOuter() {
                if (this.kafka$message$ByteBufferMessageSet$$anon$$topIter().remaining() < 4) {
                    return (MessageAndOffset)this.allDone();
                }
                int size$1 = this.kafka$message$ByteBufferMessageSet$$anon$$topIter().getInt();
                this.lastMessageSize_$eq(size$1);
                this.$outer.trace((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final $anon$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Remaining bytes in iterator = ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$message$ByteBufferMessageSet$$anon$$topIter().remaining())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                this.$outer.trace((Function0<String>)((Object)new Serializable(this, size$1){
                    public static final long serialVersionUID;
                    private final int size$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"size of data = ").append(BoxesRunTime.boxToInteger(this.size$1)).toString();
                    }
                    {
                        this.size$1 = n;
                    }
                }));
                if (size$1 < 0 || this.kafka$message$ByteBufferMessageSet$$anon$$topIter().remaining() < size$1) {
                    if (this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes() == this.$outer.kafka$message$ByteBufferMessageSet$$initialOffset() || size$1 < 0) {
                        throw new InvalidMessageSizeException(new StringBuilder().append((Object)"invalid message size: ").append(BoxesRunTime.boxToInteger(size$1)).append((Object)" only received bytes: ").append(BoxesRunTime.boxToInteger(this.kafka$message$ByteBufferMessageSet$$anon$$topIter().remaining())).append((Object)" at ").append(BoxesRunTime.boxToLong(this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes())).append((Object)"( possible causes (1) a single message larger than ").append((Object)"the fetch size; (2) log corruption )").toString());
                    }
                    return (MessageAndOffset)this.allDone();
                }
                ByteBuffer message = this.kafka$message$ByteBufferMessageSet$$anon$$topIter().slice();
                message.limit(size$1);
                this.kafka$message$ByteBufferMessageSet$$anon$$topIter().position(this.kafka$message$ByteBufferMessageSet$$anon$$topIter().position() + size$1);
                Message newMessage = new Message(message);
                if (newMessage.isValid()) {
                    MessageAndOffset messageAndOffset;
                    if (this.isShallow$1) {
                        this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes_$eq(this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes() + (long)(4 + size$1));
                        this.$outer.trace((Function0<String>)((Object)new Serializable(this){
                            public static final long serialVersionUID;
                            private final $anon$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"shallow iterator currValidBytes = ").append(BoxesRunTime.boxToLong(this.$outer.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes())).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }));
                        messageAndOffset = new MessageAndOffset(newMessage, this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes());
                    } else {
                        CompressionCodec compressionCodec = newMessage.compressionCodec();
                        NoCompressionCodec$ noCompressionCodec$ = NoCompressionCodec$.MODULE$;
                        CompressionCodec compressionCodec2 = compressionCodec;
                        if (!(noCompressionCodec$ != null ? !noCompressionCodec$.equals(compressionCodec2) : compressionCodec2 != null)) {
                            this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anon$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Message is uncompressed. Valid byte count = %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            this.innerIter_$eq(null);
                            this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes_$eq(this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes() + (long)(4 + size$1));
                            this.$outer.trace((Function0<String>)((Object)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anon$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"currValidBytes = ").append(BoxesRunTime.boxToLong(this.$outer.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes())).toString();
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            messageAndOffset = new MessageAndOffset(newMessage, this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes());
                        } else {
                            this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                                public static final long serialVersionUID;
                                private final $anon$1 $outer;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Message is compressed. Valid byte count = %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                }
                            }));
                            ByteBufferMessageSet qual$1 = CompressionUtils$.MODULE$.decompress(newMessage);
                            boolean x$1 = qual$1.kafka$message$ByteBufferMessageSet$$internalIterator$default$1();
                            this.innerIter_$eq(qual$1.kafka$message$ByteBufferMessageSet$$internalIterator(x$1));
                            if (!this.innerIter().hasNext()) {
                                this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes_$eq(this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes() + (4L + this.lastMessageSize()));
                                this.innerIter_$eq(null);
                            }
                            messageAndOffset = this.makeNext();
                        }
                    }
                    return messageAndOffset;
                }
                throw new InvalidMessageException(new StringBuilder().append((Object)"message is invalid, compression codec: ").append(newMessage.compressionCodec()).append((Object)" size: ").append(BoxesRunTime.boxToInteger(size$1)).append((Object)" curr offset: ").append(BoxesRunTime.boxToLong(this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes())).append((Object)" init offset: ").append(BoxesRunTime.boxToLong(this.$outer.kafka$message$ByteBufferMessageSet$$initialOffset())).toString());
            }

            public MessageAndOffset makeNext() {
                boolean bl;
                block7: {
                    MessageAndOffset messageAndOffset;
                    block5: {
                        block6: {
                            block4: {
                                if (!this.isShallow$1) break block4;
                                messageAndOffset = this.makeNextOuter();
                                break block5;
                            }
                            boolean isInnerDone$1 = this.innerDone();
                            this.$outer.debug((Function0<String>)((Object)new Serializable(this, isInnerDone$1){
                                public static final long serialVersionUID;
                                private final boolean isInnerDone$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"makeNext() in internalIterator: innerDone = ").append(BoxesRunTime.boxToBoolean(this.isInnerDone$1)).toString();
                                }
                                {
                                    this.isInnerDone$1 = bl;
                                }
                            }));
                            bl = isInnerDone$1;
                            if (!bl) break block6;
                            messageAndOffset = this.makeNextOuter();
                            break block5;
                        }
                        if (bl) break block7;
                        MessageAndOffset messageAndOffset2 = this.innerIter().next();
                        if (!this.innerIter().hasNext()) {
                            this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes_$eq(this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes() + (4L + this.lastMessageSize()));
                        }
                        messageAndOffset = new MessageAndOffset(messageAndOffset2.message(), this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes());
                    }
                    return messageAndOffset;
                }
                throw new MatchError(BoxesRunTime.boxToBoolean(bl));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.isShallow$1 = bl;
                this.kafka$message$ByteBufferMessageSet$$anon$$topIter = $outer.kafka$message$ByteBufferMessageSet$$buffer().slice();
                this.kafka$message$ByteBufferMessageSet$$anon$$currValidBytes = $outer.kafka$message$ByteBufferMessageSet$$initialOffset();
                this.innerIter = null;
                this.lastMessageSize = 0L;
            }
        };
    }

    public final boolean kafka$message$ByteBufferMessageSet$$internalIterator$default$1() {
        return false;
    }

    @Override
    public long sizeInBytes() {
        return this.kafka$message$ByteBufferMessageSet$$buffer().limit();
    }

    @Override
    public String toString() {
        StringBuilder builder$1 = new StringBuilder();
        builder$1.append("ByteBufferMessageSet(");
        this.foreach(new Serializable(this, builder$1){
            public static final long serialVersionUID;
            private final StringBuilder builder$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final StringBuilder apply(MessageAndOffset message) {
                this.builder$1.append(message);
                return this.builder$1.append(", ");
            }
            {
                this.builder$1 = stringBuilder;
            }
        });
        builder$1.append(")");
        return builder$1.toString();
    }

    @Override
    public boolean equals(Object other) {
        ByteBufferMessageSet byteBufferMessageSet;
        ByteBufferMessageSet that;
        Object object = other;
        return object instanceof ByteBufferMessageSet ? (that = (byteBufferMessageSet = (ByteBufferMessageSet)object)).canEqual(this) && this.errorCode() == that.errorCode() && this.kafka$message$ByteBufferMessageSet$$buffer().equals(that.kafka$message$ByteBufferMessageSet$$buffer()) && this.kafka$message$ByteBufferMessageSet$$initialOffset() == that.kafka$message$ByteBufferMessageSet$$initialOffset() : false;
    }

    @Override
    public boolean canEqual(Object other) {
        return other instanceof ByteBufferMessageSet;
    }

    public int hashCode() {
        return 31 + 17 * this.errorCode() + this.kafka$message$ByteBufferMessageSet$$buffer().hashCode() + ((Object)BoxesRunTime.boxToLong(this.kafka$message$ByteBufferMessageSet$$initialOffset())).hashCode();
    }

    public ByteBufferMessageSet(ByteBuffer buffer, long initialOffset, int errorCode) {
        this.kafka$message$ByteBufferMessageSet$$buffer = buffer;
        this.kafka$message$ByteBufferMessageSet$$initialOffset = initialOffset;
        this.errorCode = errorCode;
        Logging$class.$init$(this);
        this.shallowValidByteCount = -1L;
        if (this.sizeInBytes() > Integer.MAX_VALUE) {
            throw new InvalidMessageSizeException(new StringBuilder().append((Object)"Message set cannot be larger than ").append(BoxesRunTime.boxToInteger(Integer.MAX_VALUE)).toString());
        }
    }

    public ByteBufferMessageSet(CompressionCodec compressionCodec, Seq<Message> messages) {
        this(MessageSet$.MODULE$.createByteBuffer(compressionCodec, messages), 0L, ErrorMapping$.MODULE$.NoError());
    }

    public ByteBufferMessageSet(Seq<Message> messages) {
        this(NoCompressionCodec$.MODULE$, messages);
    }
}

