/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import kafka.api.OffsetRequest;
import kafka.common.InvalidPartitionException;
import kafka.common.InvalidTopicException;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anon$1$;
import kafka.log.LogManager$StopActor$;
import kafka.log.LogSegment;
import kafka.server.KafkaConfig;
import kafka.server.KafkaZooKeeper;
import kafka.utils.IteratorTemplate;
import kafka.utils.KafkaScheduler;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Time;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function1$class;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.PartialFunction$class;
import scala.Predef$;
import scala.Tuple2;
import scala.actors.AbstractActor;
import scala.actors.AbstractActor$class;
import scala.actors.Actor;
import scala.actors.Actor$blocker$;
import scala.actors.Actor$class;
import scala.actors.ActorCanReply$class;
import scala.actors.Combinators$class;
import scala.actors.Future;
import scala.actors.IScheduler;
import scala.actors.MQueue;
import scala.actors.OutputChannel;
import scala.actors.Reactor;
import scala.actors.Reactor$class;
import scala.actors.ReactorCanReply$class;
import scala.actors.ReplyReactor$class;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t5g!B\u0001\u0003\u0001\u00111!A\u0003'pO6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019q\"\u0006\t\u0003\u00115i\u0011!\u0003\u0006\u0003\u0015-\tA\u0001\\1oO*\tA\"\u0001\u0003kCZ\f\u0017B\u0001\b\n\u0005\u0019y%M[3diB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\u0002\u0003\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\r\r|gNZ5h\u0007\u0001)\u0012a\b\t\u0003A\rj\u0011!\t\u0006\u0003E\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u0013\"\u0005-Y\u0015MZ6b\u0007>tg-[4\t\u0011\u0019\u0002!\u0011!Q\u0001\n}\tqaY8oM&<\u0007\u0005\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0003*\u0003%\u00198\r[3ek2,'/F\u0001+!\t\u00012&\u0003\u0002-#\tq1*\u00194lCN\u001b\u0007.\u001a3vY\u0016\u0014\b\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\u0002\u0015M\u001c\u0007.\u001a3vY\u0016\u0014\b\u0005\u0003\u00051\u0001\t\u0015\r\u0011\"\u00032\u0003\u0011!\u0018.\\3\u0016\u0003I\u0002\"\u0001E\u001a\n\u0005Q\n\"\u0001\u0002+j[\u0016D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IAM\u0001\u0006i&lW\r\t\u0005\tq\u0001\u0011)\u0019!C\u0001s\u0005!Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN,\u0012A\u000f\t\u0003-mJ!\u0001P\f\u0003\t1{gn\u001a\u0005\t}\u0001\u0011\t\u0011)A\u0005u\u0005)Bn\\4DY\u0016\fg.\u001e9J]R,'O^1m\u001bN\u0004\u0003\u0002\u0003!\u0001\u0005\u000b\u0007I\u0011A\u001d\u0002-1|wm\u00117fC:,\b\u000fR3gCVdG/Q4f\u001bND\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IAO\u0001\u0018Y><7\t\\3b]V\u0004H)\u001a4bk2$\u0018iZ3Ng\u0002B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\r]\u0016,GMU3d_Z,'/\u001f\t\u0003-\u0019K!aR\f\u0003\u000f\t{w\u000e\\3b]\")\u0011\n\u0001C\u0001\u0015\u00061A(\u001b8jiz\"raS'O\u001fB\u000b&\u000b\u0005\u0002M\u00015\t!\u0001C\u0003\u001d\u0011\u0002\u0007q\u0004C\u0003)\u0011\u0002\u0007!\u0006C\u00031\u0011\u0002\u0007!\u0007C\u00039\u0011\u0002\u0007!\bC\u0003A\u0011\u0002\u0007!\bC\u0003E\u0011\u0002\u0007Q\tC\u0004U\u0001\t\u0007I\u0011A+\u0002\r1|w\rR5s+\u00051\u0006CA,[\u001b\u0005A&BA-\f\u0003\tIw.\u0003\u0002\\1\n!a)\u001b7f\u0011\u0019i\u0006\u0001)A\u0005-\u00069An\\4ESJ\u0004\u0003bB0\u0001\u0005\u0004%I\u0001Y\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0016\u0003\u0005\u0004\"A\u00062\n\u0005\r<\"aA%oi\"1Q\r\u0001Q\u0001\n\u0005\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\u0005C\u0004h\u0001\t\u0007I\u0011B\u001d\u0002\u000f5\f\u0007pU5{K\"1\u0011\u000e\u0001Q\u0001\ni\n\u0001\"\\1y'&TX\r\t\u0005\bW\u0002\u0011\r\u0011\"\u0003a\u000351G.^:i\u0013:$XM\u001d<bY\"1Q\u000e\u0001Q\u0001\n\u0005\faB\u001a7vg\"Le\u000e^3sm\u0006d\u0007\u0005C\u0004p\u0001\t\u0007I\u0011\u00029\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]Nl\u0015\r]\u000b\u0002cB!!/^<b\u001b\u0005\u0019(B\u0001;\u0018\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mN\u00141!T1q!\tA8P\u0004\u0002\u0017s&\u0011!pF\u0001\u0007!J,G-\u001a4\n\u0005ql(AB*ue&twM\u0003\u0002{/!1q\u0010\u0001Q\u0001\nE\f1\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gn]'ba\u0002B\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\u0002\u001f1|wm\u0011:fCRLwN\u001c'pG.,\u0012a\u0002\u0005\b\u0003\u0013\u0001\u0001\u0015!\u0003\b\u0003AawnZ\"sK\u0006$\u0018n\u001c8M_\u000e\\\u0007\u0005C\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003\u0002\u0010\u00051!/\u00198e_6,\"!!\u0005\u0011\t\u0005M\u0011\u0011D\u0007\u0003\u0003+Q1!a\u0006\f\u0003\u0011)H/\u001b7\n\t\u0005m\u0011Q\u0003\u0002\u0007%\u0006tGm\\7\t\u0011\u0005}\u0001\u0001)A\u0005\u0003#\tqA]1oI>l\u0007\u0005C\u0005\u0002$\u0001\u0001\r\u0011\"\u0003\u0002&\u0005q1.\u00194lCj{wn[3fa\u0016\u0014XCAA\u0014!\r\u0001\u0013\u0011F\u0005\u0004\u0003W\t#AD&bM.\f'l\\8LK\u0016\u0004XM\u001d\u0005\n\u0003_\u0001\u0001\u0019!C\u0005\u0003c\t!c[1gW\u0006Tvn\\6fKB,'o\u0018\u0013fcR!\u00111GA\u001d!\r1\u0012QG\u0005\u0004\u0003o9\"\u0001B+oSRD!\"a\u000f\u0002.\u0005\u0005\t\u0019AA\u0014\u0003\rAH%\r\u0005\t\u0003\u007f\u0001\u0001\u0015)\u0003\u0002(\u0005y1.\u00194lCj{wn[3fa\u0016\u0014\b\u0005C\u0005\u0002D\u0001\u0001\r\u0011\"\u0003\u0002F\u00059!p[!di>\u0014XCAA$!\u0011\tI%a\u0014\u000e\u0005\u0005-#bAA'/\u00051\u0011m\u0019;peNLA!!\u0015\u0002L\t)\u0011i\u0019;pe\"I\u0011Q\u000b\u0001A\u0002\u0013%\u0011qK\u0001\fu.\f5\r^8s?\u0012*\u0017\u000f\u0006\u0003\u00024\u0005e\u0003BCA\u001e\u0003'\n\t\u00111\u0001\u0002H!A\u0011Q\f\u0001!B\u0013\t9%\u0001\u0005{W\u0006\u001bGo\u001c:!\u0011%\t\t\u0007\u0001b\u0001\n\u0013\t\u0019'\u0001\u0007ti\u0006\u0014H/\u001e9MCR\u001c\u0007.\u0006\u0002\u0002fA!\u0011qMA7\u001b\t\tIG\u0003\u0003\u0002l\u0005U\u0011AC2p]\u000e,(O]3oi&!\u0011qNA5\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"a\u001d\u0001A\u0003%\u0011QM\u0001\u000egR\f'\u000f^;q\u0019\u0006$8\r\u001b\u0011\t\u0011\u0005]\u0004A1A\u0005\n%\n1\u0003\\8h\r2,8\u000f[3s'\u000eDW\rZ;mKJDq!a\u001f\u0001A\u0003%!&\u0001\u000bm_\u001e4E.^:iKJ\u001c6\r[3ek2,'\u000f\t\u0005\t\u0003\u007f\u0002!\u0019!C\u0005a\u0006\u0019Bn\\4GYV\u001c\b.\u00138uKJ4\u0018\r\\'ba\"9\u00111\u0011\u0001!\u0002\u0013\t\u0018\u0001\u00067pO\u001acWo\u001d5J]R,'O^1m\u001b\u0006\u0004\b\u0005C\u0005\u0002\b\u0002\u0011\r\u0011\"\u0003\u0002\n\u0006\tBn\\4SKR,g\u000e^5p]6\u001bV*\u00199\u0016\u0005\u0005-\u0005\u0003\u0002:vojB\u0001\"a$\u0001A\u0003%\u00111R\u0001\u0013Y><'+\u001a;f]RLwN\\'T\u001b\u0006\u0004\b\u0005\u0003\u0005\u0002\u0014\u0002\u0011\r\u0011\"\u0003:\u0003Aawn\u001a*fi\u0016tG/[8o'&TX\rC\u0004\u0002\u0018\u0002\u0001\u000b\u0011\u0002\u001e\u0002#1|wMU3uK:$\u0018n\u001c8TSj,\u0007\u0005C\u0005\u0002\u001c\u0002\u0011\r\u0011\"\u0003\u0002\u001e\u0006!An\\4t+\t\ty\n\u0005\u0004\u0011\u0003C;\u0018QU\u0005\u0004\u0003G\u000b\"\u0001\u0002)p_2\u0004b\u0001EAQC\u0006\u001d\u0006c\u0001'\u0002*&\u0019\u00111\u0016\u0002\u0003\u00071{w\r\u0003\u0005\u00020\u0002\u0001\u000b\u0011BAP\u0003\u0015awnZ:!\u0011%\t\u0019\f\u0001b\u0001\n\u0003\t),A\u0004tk\n$\u0015N]:\u0016\u0005\u0005]\u0006\u0003\u0002\f\u0002:ZK1!a/\u0018\u0005\u0015\t%O]1z\u0011!\ty\f\u0001Q\u0001\n\u0005]\u0016\u0001C:vE\u0012K'o\u001d\u0011\b\u000f\u0005\r\u0007\u0001#\"\u0002F\u0006I1\u000b^8q\u0003\u000e$xN\u001d\t\u0005\u0003\u000f\fI-D\u0001\u0001\r\u001d\tY\r\u0001EC\u0003\u001b\u0014\u0011b\u0015;pa\u0006\u001bGo\u001c:\u0014\u0011\u0005%w!FAh\u0003+\u00042AFAi\u0013\r\t\u0019n\u0006\u0002\b!J|G-^2u!\r1\u0012q[\u0005\u0004\u00033<\"\u0001D*fe&\fG.\u001b>bE2,\u0007bB%\u0002J\u0012\u0005\u0011Q\u001c\u000b\u0003\u0003\u000bD\u0001\"!9\u0002J\u0012\u0015\u00131]\u0001\tQ\u0006\u001c\bnQ8eKR\t\u0011\r\u0003\u0005\u0002h\u0006%GQIAu\u0003!!xn\u0015;sS:<GCAAv!\rA\u0011Q^\u0005\u0003y&A\u0001\"!=\u0002J\u0012\u0005\u00131_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005-\bbBA|\u0003\u0013$\t\u0005Y\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\t\u0003w\fI\r\"\u0011\u0002~\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0000\u0005\u000b\u00012A\u0006B\u0001\u0013\r\u0011\u0019a\u0006\u0002\u0004\u0003:L\b\"CA\u001e\u0003s\f\t\u00111\u0001b\u0011!\u0011I!!3\u0005B\t-\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u0015\u0013i\u0001\u0003\u0006\u0002<\t\u001d\u0011\u0011!a\u0001\u0003\u007fDqA!\u0005\u0001\t\u0013\u0011\u0019\"\u0001\u000bhKRdun\u001a*fi\u0016tG/[8o\u001bNk\u0015\r\u001d\u000b\u0005\u0003\u0017\u0013)\u0002C\u0004\u0003\u0018\t=\u0001\u0019A9\u0002'1|wMU3uK:$\u0018n\u001c8I_V\u0014X*\u00199\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e\u000591\u000f^1siV\u0004HCAA\u001a\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005;\tA\"Y<bSR\u001cF/\u0019:ukBDqA!\n\u0001\t\u0013\u00119#\u0001\u000bsK\u001eL7\u000f^3s\u001d\u0016<Hk\u001c9jG&s'l\u0013\u000b\u0005\u0003g\u0011I\u0003C\u0004\u0003,\t\r\u0002\u0019A<\u0002\u000bQ|\u0007/[2\t\u000f\t=\u0002\u0001\"\u0003\u00032\u0005I1M]3bi\u0016dun\u001a\u000b\u0007\u0003O\u0013\u0019D!\u000e\t\u000f\t-\"Q\u0006a\u0001o\"9!q\u0007B\u0017\u0001\u0004\t\u0017!\u00039beRLG/[8o\u0011\u001d\u0011Y\u0004\u0001C\u0005\u0005{\t!bZ3u\u0019><\u0007k\\8m)\u0019\t)Ka\u0010\u0003B!9!1\u0006B\u001d\u0001\u00049\bb\u0002B\u001c\u0005s\u0001\r!\u0019\u0005\b\u0005\u000b\u0002A\u0011\u0001B$\u0003U\u0019\u0007n\\8tKJ\u000bg\u000eZ8n!\u0006\u0014H/\u001b;j_:$2!\u0019B%\u0011\u001d\u0011YCa\u0011A\u0002]DqA!\u0014\u0001\t\u0003\u0011y%\u0001\u0006hKR|eMZ:fiN$BA!\u0015\u0003TA!a#!/;\u0011!\u0011)Fa\u0013A\u0002\t]\u0013!D8gMN,GOU3rk\u0016\u001cH\u000f\u0005\u0003\u0003Z\t}SB\u0001B.\u0015\r\u0011i\u0006B\u0001\u0004CBL\u0017\u0002\u0002B1\u00057\u0012Qb\u00144gg\u0016$(+Z9vKN$\bb\u0002B3\u0001\u0011\u0005!qM\u0001\u0007O\u0016$Hj\\4\u0015\r\u0005\u001d&\u0011\u000eB6\u0011\u001d\u0011YCa\u0019A\u0002]DqAa\u000e\u0003d\u0001\u0007\u0011\rC\u0004\u0003p\u0001!\tA!\u001d\u0002\u001d\u001d,Go\u0014:De\u0016\fG/\u001a'pOR1\u0011q\u0015B:\u0005kBqAa\u000b\u0003n\u0001\u0007q\u000fC\u0004\u00038\t5\u0004\u0019A1\t\u000f\te\u0004\u0001\"\u0003\u0003|\u0005qA-\u001a7fi\u0016\u001cVmZ7f]R\u001cH#B1\u0003~\t}\u0004bB\u0002\u0003x\u0001\u0007\u0011q\u0015\u0005\t\u0005\u0003\u00139\b1\u0001\u0003\u0004\u0006A1/Z4nK:$8\u000fE\u0003s\u0005\u000b\u0013I)C\u0002\u0003\bN\u00141aU3r!\ra%1R\u0005\u0004\u0005\u001b\u0013!A\u0003'pON+w-\\3oi\"9!\u0011\u0013\u0001\u0005\n\tM\u0015AF2mK\u0006tW\u000f]#ya&\u0014X\rZ*fO6,g\u000e^:\u0015\u0007\u0005\u0014)\nC\u0004\u0004\u0005\u001f\u0003\r!a*\t\u000f\te\u0005\u0001\"\u0003\u0003\u001c\u0006i2\r\\3b]V\u00048+Z4nK:$8\u000fV8NC&tG/Y5o'&TX\rF\u0002b\u0005;Cqa\u0001BL\u0001\u0004\t9\u000bC\u0004\u0003\"\u0002!\tA!\b\u0002\u0017\rdW-\u00198va2{wm\u001d\u0005\b\u0005K\u0003A\u0011\u0001B\u000f\u0003\u0015\u0019Gn\\:f\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005W\u000babZ3u\u0019><\u0017\n^3sCR|'\u000f\u0006\u0002\u0003.B)!Oa,\u0002(&\u0019!\u0011W:\u0003\u0011%#XM]1u_JDqA!.\u0001\t\u0013\u0011i\"\u0001\u0007gYV\u001c\b.\u00117m\u0019><7\u000fC\u0004\u0003:\u0002!\tAa/\u0002\u0019\u001d,G/\u00117m)>\u0004\u0018nY:\u0015\u0005\tu\u0006\u0003\u0002:\u00030^DqA!1\u0001\t\u0003\u0011\u0019-A\u000bhKR$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cX*\u00199\u0015\u0003ED3\u0001\u0001Bd!\r\u0001\"\u0011Z\u0005\u0004\u0005\u0017\f\"A\u0003;ie\u0016\fGm]1gK\u0002")
public class LogManager
implements Logging {
    private final KafkaConfig config;
    private final KafkaScheduler scheduler;
    private final Time kafka$log$LogManager$$time;
    private final long logCleanupIntervalMs;
    private final long logCleanupDefaultAgeMs;
    public final boolean kafka$log$LogManager$$needRecovery;
    private final File logDir;
    private final int kafka$log$LogManager$$numPartitions;
    private final long kafka$log$LogManager$$maxSize;
    private final int kafka$log$LogManager$$flushInterval;
    private final Map<String, Object> kafka$log$LogManager$$topicPartitionsMap;
    private final Object logCreationLock;
    private final Random random;
    private KafkaZooKeeper kafka$log$LogManager$$kafkaZookeeper;
    private Actor zkActor;
    private final CountDownLatch startupLatch;
    private final KafkaScheduler logFlusherScheduler;
    private final Map<String, Object> kafka$log$LogManager$$logFlushIntervalMap;
    private final Map<String, Object> logRetentionMSMap;
    private final long logRetentionSize;
    private final Pool<String, Pool<Object, Log>> kafka$log$LogManager$$logs;
    private final File[] subDirs;
    private volatile LogManager$StopActor$ StopActor$module;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        LogManager logManager = this;
        synchronized (logManager) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public KafkaConfig config() {
        return this.config;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public final Time kafka$log$LogManager$$time() {
        return this.kafka$log$LogManager$$time;
    }

    public long logCleanupIntervalMs() {
        return this.logCleanupIntervalMs;
    }

    public long logCleanupDefaultAgeMs() {
        return this.logCleanupDefaultAgeMs;
    }

    public File logDir() {
        return this.logDir;
    }

    public final int kafka$log$LogManager$$numPartitions() {
        return this.kafka$log$LogManager$$numPartitions;
    }

    public final long kafka$log$LogManager$$maxSize() {
        return this.kafka$log$LogManager$$maxSize;
    }

    public final int kafka$log$LogManager$$flushInterval() {
        return this.kafka$log$LogManager$$flushInterval;
    }

    public final Map<String, Object> kafka$log$LogManager$$topicPartitionsMap() {
        return this.kafka$log$LogManager$$topicPartitionsMap;
    }

    private Object logCreationLock() {
        return this.logCreationLock;
    }

    private Random random() {
        return this.random;
    }

    public final KafkaZooKeeper kafka$log$LogManager$$kafkaZookeeper() {
        return this.kafka$log$LogManager$$kafkaZookeeper;
    }

    private void kafka$log$LogManager$$kafkaZookeeper_$eq(KafkaZooKeeper kafkaZooKeeper) {
        this.kafka$log$LogManager$$kafkaZookeeper = kafkaZooKeeper;
    }

    private Actor zkActor() {
        return this.zkActor;
    }

    private void zkActor_$eq(Actor actor) {
        this.zkActor = actor;
    }

    private CountDownLatch startupLatch() {
        return this.startupLatch;
    }

    private KafkaScheduler logFlusherScheduler() {
        return this.logFlusherScheduler;
    }

    public final Map<String, Object> kafka$log$LogManager$$logFlushIntervalMap() {
        return this.kafka$log$LogManager$$logFlushIntervalMap;
    }

    private Map<String, Object> logRetentionMSMap() {
        return this.logRetentionMSMap;
    }

    private long logRetentionSize() {
        return this.logRetentionSize;
    }

    public final Pool<String, Pool<Object, Log>> kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    public File[] subDirs() {
        return this.subDirs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final LogManager$StopActor$ StopActor() {
        if (this.StopActor$module != null) return this.StopActor$module;
        LogManager logManager = this;
        synchronized (logManager) {
            if (this.StopActor$module == null) {
                this.StopActor$module = new LogManager$StopActor$(this);
            }
            return this.StopActor$module;
        }
    }

    private Map<String, Object> getLogRetentionMSMap(Map<String, Object> logRetentionHourMap) {
        ObjectRef ret$1 = new ObjectRef(new HashMap());
        ((IterableLike)logRetentionHourMap.filter((Function1<String, Object>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<String, Object> tuple2) {
                Tuple2<String, Object> tuple22 = tuple2;
                return tuple22 != null;
            }
        }))).foreach(new scala.Serializable(this, ret$1){
            public static final long serialVersionUID;
            private final ObjectRef ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Option<Object> apply(Tuple2<String, Object> tuple2) {
                Tuple2<String, Object> tuple22 = tuple2;
                if (tuple22 != null) {
                    return ((HashMap)this.ret$1.elem).put(tuple22._1(), BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToInt(tuple22._2()) * 60 * 60) * 1000L));
                }
                throw new MatchError(tuple22);
            }
            {
                this.ret$1 = objectRef;
            }
        });
        return (HashMap)ret$1.elem;
    }

    public void startup() {
        if (this.config().enableZookeeper()) {
            this.kafka$log$LogManager$$kafkaZookeeper().registerBrokerInZk();
            this.getAllTopics().foreach(new scala.Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(String topic) {
                    this.$outer.kafka$log$LogManager$$kafkaZookeeper().registerTopicInZk(topic);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.startupLatch().countDown();
        }
        this.info((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Starting log flusher every ").append(BoxesRunTime.boxToInteger(this.$outer.config().flushSchedulerThreadRate())).append((Object)" ms with the following overrides ").append(this.$outer.kafka$log$LogManager$$logFlushIntervalMap()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.logFlusherScheduler().scheduleWithRate((Function0<BoxedUnit>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$log$LogManager$$flushAllLogs();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), this.config().flushSchedulerThreadRate(), this.config().flushSchedulerThreadRate());
    }

    private void awaitStartup() {
        if (this.config().enableZookeeper()) {
            this.startupLatch().await();
        }
    }

    private void registerNewTopicInZK(String topic) {
        if (this.config().enableZookeeper()) {
            this.zkActor().$bang(topic);
        }
    }

    private Log createLog(String topic, int partition2) {
        Object object = this.logCreationLock();
        synchronized (object) {
            File d = new File(this.logDir(), new StringBuilder().append((Object)topic).append((Object)"-").append(BoxesRunTime.boxToInteger(partition2)).toString());
            d.mkdirs();
            Log log2 = new Log(d, this.kafka$log$LogManager$$maxSize(), this.kafka$log$LogManager$$flushInterval(), false);
            return log2;
        }
    }

    private Pool<Object, Log> getLogPool(String topic$1, int partition$1) {
        this.awaitStartup();
        if (topic$1.length() <= 0) {
            throw new InvalidTopicException("topic name can't be empty");
        }
        if (partition$1 < 0 || partition$1 >= BoxesRunTime.unboxToInt(this.kafka$log$LogManager$$topicPartitionsMap().getOrElse(topic$1, new scala.Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.kafka$log$LogManager$$numPartitions();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }))) {
            this.warn((Function0<String>)((Object)new scala.Serializable(this, topic$1, partition$1){
                public static final long serialVersionUID;
                private final LogManager $outer;
                private final String topic$1;
                private final int partition$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Wrong partition ").append(BoxesRunTime.boxToInteger(this.partition$1)).append((Object)" valid partitions (0,").append(BoxesRunTime.boxToInteger(BoxesRunTime.unboxToInt(this.$outer.kafka$log$LogManager$$topicPartitionsMap().getOrElse(this.topic$1, new scala.Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$getLogPool$2 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return this.$outer.kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$numPartitions();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    })) - 1)).append((Object)")").toString();
                }

                public LogManager kafka$log$LogManager$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.topic$1 = string2;
                    this.partition$1 = n;
                }
            }));
            throw new InvalidPartitionException(new StringBuilder().append((Object)"wrong partition ").append(BoxesRunTime.boxToInteger(partition$1)).toString());
        }
        return this.kafka$log$LogManager$$logs().get(topic$1);
    }

    public int chooseRandomPartition(String topic) {
        return this.random().nextInt(BoxesRunTime.unboxToInt(this.kafka$log$LogManager$$topicPartitionsMap().getOrElse(topic, new scala.Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.$outer.kafka$log$LogManager$$numPartitions();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        })));
    }

    public long[] getOffsets(OffsetRequest offsetRequest) {
        Log log2 = this.getLog(offsetRequest.topic(), offsetRequest.partition());
        if (log2 == null) {
            return Log$.MODULE$.getEmptyOffsets(offsetRequest);
        }
        return log2.getOffsetsBefore(offsetRequest);
    }

    public Log getLog(String topic, int partition2) {
        Pool<Object, Log> parts = this.getLogPool(topic, partition2);
        if (parts == null) {
            return null;
        }
        return parts.get(BoxesRunTime.boxToInteger(partition2));
    }

    public Log getOrCreateLog(String topic$2, int partition$2) {
        Log log2;
        boolean hasNewTopic = false;
        Pool<Object, Log> parts = this.getLogPool(topic$2, partition$2);
        if (parts == null) {
            Pool found = this.kafka$log$LogManager$$logs().putIfNotExists(topic$2, new Pool());
            if (found == null) {
                hasNewTopic = true;
            }
            parts = this.kafka$log$LogManager$$logs().get(topic$2);
        }
        if ((log2 = parts.get(BoxesRunTime.boxToInteger(partition$2))) == null) {
            log2 = this.createLog(topic$2, partition$2);
            Log found = parts.putIfNotExists(BoxesRunTime.boxToInteger(partition$2), log2);
            if (found == null) {
                this.info((Function0<String>)((Object)new scala.Serializable(this, topic$2, partition$2){
                    public static final long serialVersionUID;
                    private final String topic$2;
                    private final int partition$2;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Created log for '").append((Object)this.topic$2).append((Object)"'-").append(BoxesRunTime.boxToInteger(this.partition$2)).toString();
                    }
                    {
                        this.topic$2 = string2;
                        this.partition$2 = n;
                    }
                }));
            } else {
                log2.close();
                log2 = found;
            }
        }
        if (hasNewTopic) {
            this.registerNewTopicInZK(topic$2);
        }
        return log2;
    }

    private int deleteSegments(Log log$2, Seq<LogSegment> segments) {
        IntRef total$1 = new IntRef(0);
        segments.foreach(new scala.Serializable(this, log$2, total$1){
            public static final long serialVersionUID;
            private final LogManager $outer;
            public final Log log$2;
            private final IntRef total$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(LogSegment segment$1) {
                this.$outer.info((Function0<String>)((Object)new scala.Serializable(this, segment$1){
                    public static final long serialVersionUID;
                    private final $anonfun$deleteSegments$1 $outer;
                    private final LogSegment segment$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Deleting log segment ").append((Object)this.segment$1.file().getName()).append((Object)" from ").append((Object)this.$outer.log$2.name()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.segment$1 = logSegment;
                    }
                }));
                Utils$.MODULE$.swallow((Function2<Object, Throwable, BoxedUnit>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final $anonfun$deleteSegments$1 $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(Object object, Throwable throwable) {
                        this.$outer.kafka$log$LogManager$$anonfun$$$outer().logger().warn(object, throwable);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), (Function0<BoxedUnit>)((Object)new scala.Serializable(this, segment$1){
                    public static final long serialVersionUID;
                    private final LogSegment segment$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.segment$1.messageSet().close();
                    }
                    {
                        this.segment$1 = logSegment;
                    }
                }));
                if (segment$1.file().delete()) {
                    ++this.total$1.elem;
                } else {
                    this.$outer.warn((Function0<String>)((Object)new scala.Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return "Delete failed.";
                        }
                    }));
                }
            }

            public LogManager kafka$log$LogManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$2 = log2;
                this.total$1 = intRef;
            }
        });
        return total$1.elem;
    }

    private int cleanupExpiredSegments(Log log2) {
        long startMs$1 = this.kafka$log$LogManager$$time().milliseconds();
        String topic = Utils$.MODULE$.getTopicPartition(log2.dir().getName())._1();
        long logCleanupThresholdMS$1 = BoxesRunTime.unboxToLong(this.logRetentionMSMap().get(topic).getOrElse(new scala.Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return this.$outer.logCleanupDefaultAgeMs();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        Seq<LogSegment> toBeDeleted = log2.markDeletedWhile((Function1<LogSegment, Object>)((Object)new scala.Serializable(this, startMs$1, logCleanupThresholdMS$1){
            public static final long serialVersionUID;
            private final long startMs$1;
            private final long logCleanupThresholdMS$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment logSegment) {
                return this.startMs$1 - logSegment.file().lastModified() > this.logCleanupThresholdMS$1;
            }
            {
                this.startMs$1 = l;
                this.logCleanupThresholdMS$1 = l2;
            }
        }));
        int total = this.deleteSegments(log2, toBeDeleted);
        return total;
    }

    private int cleanupSegmentsToMaintainSize(Log log2) {
        if (this.logRetentionSize() < 0L || log2.size() < this.logRetentionSize()) {
            return 0;
        }
        LongRef diff$1 = new LongRef(log2.size() - this.logRetentionSize());
        Seq<LogSegment> toBeDeleted = log2.markDeletedWhile((Function1<LogSegment, Object>)((Object)new scala.Serializable(this, diff$1){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final LongRef diff$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(LogSegment logSegment) {
                return this.$outer.shouldDelete$1(logSegment, this.diff$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.diff$1 = longRef;
            }
        }));
        int total = this.deleteSegments(log2, toBeDeleted);
        return total;
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Beginning log cleanup...";
            }
        }));
        Iterator<Log> iter2 = this.getLogIterator();
        IntRef total$2 = new IntRef(0);
        long startMs$2 = this.kafka$log$LogManager$$time().milliseconds();
        while (iter2.hasNext()) {
            Log log$3 = iter2.next();
            this.debug((Function0<String>)((Object)new scala.Serializable(this, log$3){
                public static final long serialVersionUID;
                private final Log log$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Garbage collecting '").append((Object)this.log$3.name()).append((Object)"'").toString();
                }
                {
                    this.log$3 = log2;
                }
            }));
            total$2.elem += this.cleanupExpiredSegments(log$3) + this.cleanupSegmentsToMaintainSize(log$3);
        }
        this.debug((Function0<String>)((Object)new scala.Serializable(this, total$2, startMs$2){
            public static final long serialVersionUID;
            private final LogManager $outer;
            private final IntRef total$2;
            private final long startMs$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Log cleanup completed. ").append(BoxesRunTime.boxToInteger(this.total$2.elem)).append((Object)" files deleted in ").append(BoxesRunTime.boxToLong((this.$outer.kafka$log$LogManager$$time().milliseconds() - this.startMs$2) / 1000L)).append((Object)" seconds").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.total$2 = intRef;
                this.startMs$2 = l;
            }
        }));
    }

    public void close() {
        this.logFlusherScheduler().shutdown();
        Iterator<Log> iter2 = this.getLogIterator();
        while (iter2.hasNext()) {
            iter2.next().close();
        }
        if (this.config().enableZookeeper()) {
            this.zkActor().$bang(this.StopActor());
            this.kafka$log$LogManager$$kafkaZookeeper().close();
        }
    }

    private Iterator<Log> getLogIterator() {
        return new IteratorTemplate<Log>(this){
            private final Iterator<Pool<Object, Log>> partsIter;
            private Iterator<Log> logIter;

            private Iterator<Pool<Object, Log>> partsIter() {
                return this.partsIter;
            }

            private Iterator<Log> logIter() {
                return this.logIter;
            }

            private void logIter_$eq(Iterator<Log> iterator2) {
                this.logIter = iterator2;
            }

            public Log makeNext() {
                while (true) {
                    if (this.logIter() != null && this.logIter().hasNext()) {
                        return this.logIter().next();
                    }
                    if (!this.partsIter().hasNext()) break;
                    this.logIter_$eq(this.partsIter().next().values().iterator());
                }
                return (Log)this.allDone();
            }
            {
                this.partsIter = $outer.kafka$log$LogManager$$logs().values().iterator();
                this.logIter = null;
            }
        };
    }

    public final void kafka$log$LogManager$$flushAllLogs() {
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "flushing the high watermark of all logs";
            }
        }));
        this.getLogIterator().foreach(new scala.Serializable(this){
            public static final long serialVersionUID;
            private final LogManager $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Log log$1) {
                block4: {
                    try {
                        long timeSinceLastFlush$1 = System.currentTimeMillis() - log$1.getLastFlushedTime();
                        IntRef logFlushInterval$1 = new IntRef(this.$outer.config().defaultFlushIntervalMs());
                        if (this.$outer.kafka$log$LogManager$$logFlushIntervalMap().contains(log$1.getTopicName())) {
                            logFlushInterval$1.elem = BoxesRunTime.unboxToInt(this.$outer.kafka$log$LogManager$$logFlushIntervalMap().apply(log$1.getTopicName()));
                        }
                        this.$outer.debug((Function0<String>)((Object)new scala.Serializable(this, log$1, timeSinceLastFlush$1, logFlushInterval$1){
                            public static final long serialVersionUID;
                            private final Log log$1;
                            private final long timeSinceLastFlush$1;
                            private final IntRef logFlushInterval$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)this.log$1.getTopicName()).append((Object)" flush interval  ").append(BoxesRunTime.boxToInteger(this.logFlushInterval$1.elem)).append((Object)" last flushed ").append(BoxesRunTime.boxToLong(this.log$1.getLastFlushedTime())).append((Object)" timesincelastFlush: ").append(BoxesRunTime.boxToLong(this.timeSinceLastFlush$1)).toString();
                            }
                            {
                                this.log$1 = log2;
                                this.timeSinceLastFlush$1 = l;
                                this.logFlushInterval$1 = intRef;
                            }
                        }));
                        if (timeSinceLastFlush$1 >= (long)logFlushInterval$1.elem) {
                            log$1.flush();
                        }
                    }
                    catch (Throwable throwable) {
                        this.$outer.error((Function0<String>)((Object)new scala.Serializable(this, log$1){
                            public static final long serialVersionUID;
                            private final Log log$1;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Error flushing topic ").append((Object)this.log$1.getTopicName()).toString();
                            }
                            {
                                this.log$1 = log2;
                            }
                        }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable e$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Throwable apply() {
                                return this.e$2;
                            }
                            {
                                this.e$2 = throwable;
                            }
                        }));
                        Throwable throwable2 = throwable;
                        if (!(throwable2 instanceof IOException)) break block4;
                        this.$outer.fatal((Function0<String>)((Object)new scala.Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable e$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return new StringBuilder().append((Object)"Halting due to unrecoverable I/O error while flushing logs: ").append((Object)this.e$2.getMessage()).toString();
                            }
                            {
                                this.e$2 = throwable;
                            }
                        }), (Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                            public static final long serialVersionUID;
                            private final Throwable e$2;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final Throwable apply() {
                                return this.e$2;
                            }
                            {
                                this.e$2 = throwable;
                            }
                        }));
                        Runtime.getRuntime().halt(1);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Iterator<String> getAllTopics() {
        return this.kafka$log$LogManager$$logs().keys().iterator();
    }

    public Map<String, Object> getTopicPartitionsMap() {
        return this.kafka$log$LogManager$$topicPartitionsMap();
    }

    public final boolean shouldDelete$1(LogSegment segment, LongRef longRef) {
        boolean bl;
        if (longRef.elem - segment.size() >= 0L) {
            longRef.elem -= segment.size();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public LogManager(KafkaConfig config, KafkaScheduler scheduler, Time time, long logCleanupIntervalMs, long logCleanupDefaultAgeMs, boolean needRecovery) {
        Serializable serializable2;
        this.config = config;
        this.scheduler = scheduler;
        this.kafka$log$LogManager$$time = time;
        this.logCleanupIntervalMs = logCleanupIntervalMs;
        this.logCleanupDefaultAgeMs = logCleanupDefaultAgeMs;
        this.kafka$log$LogManager$$needRecovery = needRecovery;
        Logging$class.$init$(this);
        this.logDir = new File(config.logDir());
        this.kafka$log$LogManager$$numPartitions = config.numPartitions();
        this.kafka$log$LogManager$$maxSize = config.logFileSize();
        this.kafka$log$LogManager$$flushInterval = config.flushInterval();
        this.kafka$log$LogManager$$topicPartitionsMap = config.topicPartitionsMap();
        this.logCreationLock = new Object();
        this.random = new Random();
        this.kafka$log$LogManager$$kafkaZookeeper = null;
        this.zkActor = null;
        this.startupLatch = config.enableZookeeper() ? new CountDownLatch(1) : null;
        this.logFlusherScheduler = new KafkaScheduler(1, "kafka-logflusher-", false);
        this.kafka$log$LogManager$$logFlushIntervalMap = config.flushIntervalMap();
        this.logRetentionMSMap = this.getLogRetentionMSMap(config.logRetentionHoursMap());
        this.logRetentionSize = config.logRetentionSize();
        this.kafka$log$LogManager$$logs = new Pool();
        if (this.logDir().exists()) {
            serializable2 = BoxedUnit.UNIT;
        } else {
            this.info((Function0<String>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID;
                private final LogManager $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"No log directory found, creating '").append((Object)this.$outer.logDir().getAbsolutePath()).append((Object)"'").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            serializable2 = BoxesRunTime.boxToBoolean(this.logDir().mkdirs());
        }
        if (this.logDir().isDirectory() && this.logDir().canRead()) {
            Serializable serializable3;
            Object object;
            this.subDirs = this.logDir().listFiles();
            if (this.subDirs() != null) {
                Predef$.MODULE$.refArrayOps((Object[])this.subDirs()).foreach(new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final LogManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Object apply(File dir$1) {
                        Object object;
                        if (dir$1.isDirectory()) {
                            this.$outer.info((Function0<String>)((Object)new scala.Serializable(this, dir$1){
                                public static final long serialVersionUID;
                                private final File dir$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Loading log '").append((Object)this.dir$1.getName()).append((Object)"'").toString();
                                }
                                {
                                    this.dir$1 = file;
                                }
                            }));
                            Log log2 = new Log(dir$1, this.$outer.kafka$log$LogManager$$maxSize(), this.$outer.kafka$log$LogManager$$flushInterval(), this.$outer.kafka$log$LogManager$$needRecovery);
                            Tuple2<String, Object> topicPartion = Utils$.MODULE$.getTopicPartition(dir$1.getName());
                            this.$outer.kafka$log$LogManager$$logs().putIfNotExists(topicPartion._1(), new Pool<K, V>());
                            Pool<Object, Log> parts = this.$outer.kafka$log$LogManager$$logs().get(topicPartion._1());
                            object = parts.put(BoxesRunTime.boxToInteger(topicPartion._2$mcI$sp()), log2);
                        } else {
                            this.$outer.warn((Function0<String>)((Object)new scala.Serializable(this, dir$1){
                                public static final long serialVersionUID;
                                private final File dir$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Skipping unexplainable file '").append((Object)this.dir$1.getAbsolutePath()).append((Object)"'--should it be there?").toString();
                                }
                                {
                                    this.dir$1 = file;
                                }
                            }));
                            object = BoxedUnit.UNIT;
                        }
                        return object;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            if (scheduler == null) {
                object = BoxedUnit.UNIT;
            } else {
                this.info((Function0<String>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final LogManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"starting log cleaner every ").append(BoxesRunTime.boxToLong(this.$outer.logCleanupIntervalMs())).append((Object)" ms").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                object = scheduler.scheduleWithRate((Function0<BoxedUnit>)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID;
                    private final LogManager $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.cleanupLogs();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), 60000L, logCleanupIntervalMs);
            }
            if (config.enableZookeeper()) {
                this.kafka$log$LogManager$$kafkaZookeeper_$eq(new KafkaZooKeeper(config, this));
                this.kafka$log$LogManager$$kafkaZookeeper().startup();
                this.zkActor_$eq(new Actor(this){
                    private final LogManager $outer;
                    private volatile boolean scala$actors$Actor$$isSuspended;
                    private volatile Option<Object> scala$actors$Actor$$received;
                    private List<AbstractActor> links;
                    private volatile boolean trapExit;
                    private Object scala$actors$Actor$$exitReason;
                    private boolean shouldExit;
                    private volatile List<OutputChannel<Object>> senders;
                    private Option<TimerTask> onTimeout;
                    private final MQueue<Object> mailbox;
                    private final MQueue<Object> sendBuffer;
                    private PartialFunction<Object, Object> waitingFor;
                    private Enumeration.Value _state;
                    private volatile Function0<BoxedUnit> kill;
                    private volatile Actor$blocker$ scala$actors$Actor$$blocker$module;

                    public final boolean scala$actors$Actor$$isSuspended() {
                        return this.scala$actors$Actor$$isSuspended;
                    }

                    public final void scala$actors$Actor$$isSuspended_$eq(boolean bl) {
                        this.scala$actors$Actor$$isSuspended = bl;
                    }

                    public final Option<Object> scala$actors$Actor$$received() {
                        return this.scala$actors$Actor$$received;
                    }

                    public final void scala$actors$Actor$$received_$eq(Option<Object> option) {
                        this.scala$actors$Actor$$received = option;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Actor$blocker$ scala$actors$Actor$$blocker() {
                        if (this.scala$actors$Actor$$blocker$module != null) return this.scala$actors$Actor$$blocker$module;
                        $anon$1 var1_1 = this;
                        synchronized (var1_1) {
                            if (this.scala$actors$Actor$$blocker$module == null) {
                                this.scala$actors$Actor$$blocker$module = new Actor$blocker$(this);
                            }
                            return this.scala$actors$Actor$$blocker$module;
                        }
                    }

                    public List<AbstractActor> links() {
                        return this.links;
                    }

                    public void links_$eq(List<AbstractActor> list2) {
                        this.links = list2;
                    }

                    public boolean trapExit() {
                        return this.trapExit;
                    }

                    public void trapExit_$eq(boolean bl) {
                        this.trapExit = bl;
                    }

                    public final Object scala$actors$Actor$$exitReason() {
                        return this.scala$actors$Actor$$exitReason;
                    }

                    public final void scala$actors$Actor$$exitReason_$eq(Object object) {
                        this.scala$actors$Actor$$exitReason = object;
                    }

                    public boolean shouldExit() {
                        return this.shouldExit;
                    }

                    public void shouldExit_$eq(boolean bl) {
                        this.shouldExit = bl;
                    }

                    public final Function0 scala$actors$Actor$$super$startSearch(Object msg, OutputChannel replyTo, PartialFunction handler) {
                        return Reactor$class.startSearch(this, msg, replyTo, handler);
                    }

                    public final Nothing$ scala$actors$Actor$$super$react(PartialFunction handler) {
                        return ReplyReactor$class.react(this, handler);
                    }

                    public final Nothing$ scala$actors$Actor$$super$reactWithin(long msec, PartialFunction handler) {
                        return ReplyReactor$class.reactWithin(this, msec, handler);
                    }

                    public final void scala$actors$Actor$$super$dostart() {
                        Reactor$class.dostart(this);
                    }

                    public final Reactor scala$actors$Actor$$super$start() {
                        return Reactor$class.start(this);
                    }

                    public final Enumeration.Value scala$actors$Actor$$super$getState() {
                        return ReplyReactor$class.getState(this);
                    }

                    public final Nothing$ scala$actors$Actor$$super$exit() {
                        return Reactor$class.exit(this);
                    }

                    public IScheduler scheduler() {
                        return Actor$class.scheduler(this);
                    }

                    public Function0<BoxedUnit> startSearch(Object msg, OutputChannel<Object> replyTo, PartialFunction<Object, Object> handler) {
                        return Actor$class.startSearch(this, msg, replyTo, handler);
                    }

                    public void searchMailbox(MQueue<Object> startMbox, PartialFunction<Object, Object> handler, boolean resumeOnSameThread) {
                        Actor$class.searchMailbox(this, startMbox, handler, resumeOnSameThread);
                    }

                    public Runnable makeReaction(Function0<BoxedUnit> fun, PartialFunction<Object, Object> handler, Object msg) {
                        return Actor$class.makeReaction(this, fun, handler, msg);
                    }

                    public <R> R receive(PartialFunction<Object, R> f2) {
                        return (R)Actor$class.receive(this, f2);
                    }

                    public <R> R receiveWithin(long msec, PartialFunction<Object, R> f2) {
                        return (R)Actor$class.receiveWithin(this, msec, f2);
                    }

                    public Nothing$ react(PartialFunction<Object, BoxedUnit> handler) {
                        return Actor$class.react(this, handler);
                    }

                    public Nothing$ reactWithin(long msec, PartialFunction<Object, BoxedUnit> handler) {
                        return Actor$class.reactWithin(this, msec, handler);
                    }

                    public Object $qmark() {
                        return Actor$class.$qmark(this);
                    }

                    public void scheduleActor(PartialFunction<Object, Object> f2, Object msg) {
                        Actor$class.scheduleActor(this, f2, msg);
                    }

                    public boolean exiting() {
                        return Actor$class.exiting(this);
                    }

                    public void dostart() {
                        Actor$class.dostart(this);
                    }

                    public Actor start() {
                        return Actor$class.start(this);
                    }

                    public Enumeration.Value getState() {
                        return Actor$class.getState(this);
                    }

                    public AbstractActor link(AbstractActor to2) {
                        return Actor$class.link((Actor)this, to2);
                    }

                    public Actor link(Function0<BoxedUnit> body) {
                        return Actor$class.link((Actor)this, body);
                    }

                    public void linkTo(AbstractActor to2) {
                        Actor$class.linkTo(this, to2);
                    }

                    public void unlink(AbstractActor from2) {
                        Actor$class.unlink(this, from2);
                    }

                    public void unlinkFrom(AbstractActor from2) {
                        Actor$class.unlinkFrom(this, from2);
                    }

                    public Nothing$ exit(Object reason) {
                        return Actor$class.exit(this, reason);
                    }

                    public Nothing$ exit() {
                        return Actor$class.exit(this);
                    }

                    public Function0<BoxedUnit> exitLinked() {
                        return Actor$class.exitLinked(this);
                    }

                    public Function0<BoxedUnit> exitLinked(Object reason) {
                        return Actor$class.exitLinked(this, reason);
                    }

                    public void exit(AbstractActor from2, Object reason) {
                        Actor$class.exit(this, from2, reason);
                    }

                    public void onTerminate(Function0<BoxedUnit> f2) {
                        Actor$class.onTerminate(this, f2);
                    }

                    public Object $bang$qmark(Object msg) {
                        return ActorCanReply$class.$bang$qmark(this, msg);
                    }

                    public Option<Object> $bang$qmark(long msec, Object msg) {
                        return ActorCanReply$class.$bang$qmark(this, msec, msg);
                    }

                    public <A> Future<A> $bang$bang(Object msg, PartialFunction<Object, A> handler) {
                        return ActorCanReply$class.$bang$bang(this, msg, handler);
                    }

                    public Future<Object> $bang$bang(Object msg) {
                        return ActorCanReply$class.$bang$bang(this, msg);
                    }

                    public List<OutputChannel<Object>> senders() {
                        return this.senders;
                    }

                    public void senders_$eq(List<OutputChannel<Object>> list2) {
                        this.senders = list2;
                    }

                    public Option<TimerTask> onTimeout() {
                        return this.onTimeout;
                    }

                    public void onTimeout_$eq(Option<TimerTask> option) {
                        this.onTimeout = option;
                    }

                    public final void scala$actors$ReplyReactor$$super$resumeReceiver(Tuple2 item, PartialFunction handler, boolean onSameThread) {
                        Reactor$class.resumeReceiver(this, item, handler, onSameThread);
                    }

                    public final Nothing$ scala$actors$ReplyReactor$$super$react(PartialFunction handler) {
                        return Reactor$class.react(this, handler);
                    }

                    public OutputChannel<Object> sender() {
                        return ReplyReactor$class.sender(this);
                    }

                    public void reply(Object msg) {
                        ReplyReactor$class.reply(this, msg);
                    }

                    public void $bang(Object msg) {
                        ReplyReactor$class.$bang(this, msg);
                    }

                    public void forward(Object msg) {
                        ReplyReactor$class.forward(this, msg);
                    }

                    public void resumeReceiver(Tuple2<Object, OutputChannel<Object>> item, PartialFunction<Object, Object> handler, boolean onSameThread) {
                        ReplyReactor$class.resumeReceiver(this, item, handler, onSameThread);
                    }

                    public MQueue<Object> mailbox() {
                        return this.mailbox;
                    }

                    public MQueue<Object> sendBuffer() {
                        return this.sendBuffer;
                    }

                    public PartialFunction<Object, Object> waitingFor() {
                        return this.waitingFor;
                    }

                    public void waitingFor_$eq(PartialFunction<Object, Object> partialFunction) {
                        this.waitingFor = partialFunction;
                    }

                    public Enumeration.Value _state() {
                        return this._state;
                    }

                    public void _state_$eq(Enumeration.Value value2) {
                        this._state = value2;
                    }

                    public Function0<BoxedUnit> kill() {
                        return this.kill;
                    }

                    public void kill_$eq(Function0<BoxedUnit> function0) {
                        this.kill = function0;
                    }

                    public void scala$actors$Reactor$_setter_$mailbox_$eq(MQueue mQueue) {
                        this.mailbox = mQueue;
                    }

                    public void scala$actors$Reactor$_setter_$sendBuffer_$eq(MQueue mQueue) {
                        this.sendBuffer = mQueue;
                    }

                    public PartialFunction<Exception, BoxedUnit> exceptionHandler() {
                        return Reactor$class.exceptionHandler(this);
                    }

                    public int mailboxSize() {
                        return Reactor$class.mailboxSize(this);
                    }

                    public void send(Object msg, OutputChannel<Object> replyTo) {
                        Reactor$class.send(this, msg, replyTo);
                    }

                    public final Runnable makeReaction(Function0<BoxedUnit> fun) {
                        return Reactor$class.makeReaction(this, fun);
                    }

                    public Actor receiver() {
                        return Reactor$class.receiver(this);
                    }

                    public void drainSendBuffer(MQueue<Object> mbox) {
                        Reactor$class.drainSendBuffer(this, mbox);
                    }

                    public void restart() {
                        Reactor$class.restart(this);
                    }

                    public <A> Object mkBody(Function0<A> body) {
                        return Reactor$class.mkBody(this, body);
                    }

                    public <a, b> void seq(Function0<a> first, Function0<b> next2) {
                        Reactor$class.seq(this, first, next2);
                    }

                    public void terminated() {
                        Reactor$class.terminated(this);
                    }

                    public void loop(Function0<BoxedUnit> body) {
                        Combinators$class.loop(this, body);
                    }

                    public void loopWhile(Function0<Object> cond, Function0<BoxedUnit> body) {
                        Combinators$class.loopWhile(this, cond, body);
                    }

                    public void continue() {
                        Combinators$class.continue(this);
                    }

                    public void act() {
                        this.loop((Function0<BoxedUnit>)((Object)new scala.Serializable(this){
                            public static final long serialVersionUID;
                            private final $anon$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.$outer.receive(new PartialFunction(this){
                                    public static final long serialVersionUID;
                                    private final $anon$1$$anonfun$act$1 $outer;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public <A1, B1> PartialFunction<A1, B1> orElse(PartialFunction<A1, B1> that) {
                                        return PartialFunction$class.orElse(this, that);
                                    }

                                    public <C> PartialFunction<Object, C> andThen(Function1<Object, C> k) {
                                        return PartialFunction$class.andThen(this, k);
                                    }

                                    public Function1<Object, Option<Object>> lift() {
                                        return PartialFunction$class.lift(this);
                                    }

                                    public boolean apply$mcZD$sp(double v1) {
                                        return Function1$class.apply$mcZD$sp(this, v1);
                                    }

                                    public double apply$mcDD$sp(double v1) {
                                        return Function1$class.apply$mcDD$sp(this, v1);
                                    }

                                    public float apply$mcFD$sp(double v1) {
                                        return Function1$class.apply$mcFD$sp(this, v1);
                                    }

                                    public int apply$mcID$sp(double v1) {
                                        return Function1$class.apply$mcID$sp(this, v1);
                                    }

                                    public long apply$mcJD$sp(double v1) {
                                        return Function1$class.apply$mcJD$sp(this, v1);
                                    }

                                    public void apply$mcVD$sp(double v1) {
                                        Function1$class.apply$mcVD$sp(this, v1);
                                    }

                                    public boolean apply$mcZF$sp(float v1) {
                                        return Function1$class.apply$mcZF$sp(this, v1);
                                    }

                                    public double apply$mcDF$sp(float v1) {
                                        return Function1$class.apply$mcDF$sp(this, v1);
                                    }

                                    public float apply$mcFF$sp(float v1) {
                                        return Function1$class.apply$mcFF$sp(this, v1);
                                    }

                                    public int apply$mcIF$sp(float v1) {
                                        return Function1$class.apply$mcIF$sp(this, v1);
                                    }

                                    public long apply$mcJF$sp(float v1) {
                                        return Function1$class.apply$mcJF$sp(this, v1);
                                    }

                                    public void apply$mcVF$sp(float v1) {
                                        Function1$class.apply$mcVF$sp(this, v1);
                                    }

                                    public boolean apply$mcZI$sp(int v1) {
                                        return Function1$class.apply$mcZI$sp(this, v1);
                                    }

                                    public double apply$mcDI$sp(int v1) {
                                        return Function1$class.apply$mcDI$sp(this, v1);
                                    }

                                    public float apply$mcFI$sp(int v1) {
                                        return Function1$class.apply$mcFI$sp(this, v1);
                                    }

                                    public int apply$mcII$sp(int v1) {
                                        return Function1$class.apply$mcII$sp(this, v1);
                                    }

                                    public long apply$mcJI$sp(int v1) {
                                        return Function1$class.apply$mcJI$sp(this, v1);
                                    }

                                    public void apply$mcVI$sp(int v1) {
                                        Function1$class.apply$mcVI$sp(this, v1);
                                    }

                                    public boolean apply$mcZJ$sp(long v1) {
                                        return Function1$class.apply$mcZJ$sp(this, v1);
                                    }

                                    public double apply$mcDJ$sp(long v1) {
                                        return Function1$class.apply$mcDJ$sp(this, v1);
                                    }

                                    public float apply$mcFJ$sp(long v1) {
                                        return Function1$class.apply$mcFJ$sp(this, v1);
                                    }

                                    public int apply$mcIJ$sp(long v1) {
                                        return Function1$class.apply$mcIJ$sp(this, v1);
                                    }

                                    public long apply$mcJJ$sp(long v1) {
                                        return Function1$class.apply$mcJJ$sp(this, v1);
                                    }

                                    public void apply$mcVJ$sp(long v1) {
                                        Function1$class.apply$mcVJ$sp(this, v1);
                                    }

                                    public <A> Function1<A, Object> compose(Function1<A, Object> g) {
                                        return Function1$class.compose(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcZD$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcZD$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcDD$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcDD$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcFD$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcFD$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcID$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcID$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcJD$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcJD$sp(this, g);
                                    }

                                    public <A> Function1<A, BoxedUnit> compose$mcVD$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcVD$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcZF$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcZF$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcDF$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcDF$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcFF$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcFF$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcIF$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcIF$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcJF$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcJF$sp(this, g);
                                    }

                                    public <A> Function1<A, BoxedUnit> compose$mcVF$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcVF$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcZI$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcZI$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcDI$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcDI$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcFI$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcFI$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcII$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcII$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcJI$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcJI$sp(this, g);
                                    }

                                    public <A> Function1<A, BoxedUnit> compose$mcVI$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcVI$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcZJ$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcZJ$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcDJ$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcDJ$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcFJ$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcFJ$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcIJ$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcIJ$sp(this, g);
                                    }

                                    public <A> Function1<A, Object> compose$mcJJ$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcJJ$sp(this, g);
                                    }

                                    public <A> Function1<A, BoxedUnit> compose$mcVJ$sp(Function1<A, Object> g) {
                                        return Function1$class.compose$mcVJ$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcZD$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcZD$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcDD$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcDD$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcFD$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcFD$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcID$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcID$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcJD$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcJD$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcVD$sp(Function1<BoxedUnit, A> g) {
                                        return Function1$class.andThen$mcVD$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcZF$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcZF$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcDF$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcDF$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcFF$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcFF$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcIF$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcIF$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcJF$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcJF$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcVF$sp(Function1<BoxedUnit, A> g) {
                                        return Function1$class.andThen$mcVF$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcZI$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcZI$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcDI$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcDI$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcFI$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcFI$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcII$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcII$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcJI$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcJI$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcVI$sp(Function1<BoxedUnit, A> g) {
                                        return Function1$class.andThen$mcVI$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcZJ$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcZJ$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcDJ$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcDJ$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcFJ$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcFJ$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcIJ$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcIJ$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcJJ$sp(Function1<Object, A> g) {
                                        return Function1$class.andThen$mcJJ$sp(this, g);
                                    }

                                    public <A> Function1<Object, A> andThen$mcVJ$sp(Function1<BoxedUnit, A> g) {
                                        return Function1$class.andThen$mcVJ$sp(this, g);
                                    }

                                    public String toString() {
                                        return Function1$class.toString(this);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled aggressive block sorting
                                     * Enabled unnecessary exception pruning
                                     * Enabled aggressive exception aggregation
                                     */
                                    public final Object apply(Object object) {
                                        Object object2 = object;
                                        if (object2 instanceof String) {
                                            void var3_3;
                                            Object exceptionResult1 = null;
                                            try {
                                                this.$outer.kafka$log$LogManager$$anon$$anonfun$$$outer().kafka$log$LogManager$$anon$$$outer().kafka$log$LogManager$$kafkaZookeeper().registerTopicInZk((String)object2);
                                                exceptionResult1 = BoxedUnit.UNIT;
                                                return var3_3;
                                            }
                                            catch (Throwable throwable) {
                                                exceptionResult1 = this.$outer.kafka$log$LogManager$$anon$$anonfun$$$outer().kafka$log$LogManager$$anon$$$outer().error((Function0<Throwable>)((Object)new scala.Serializable(this, throwable){
                                                    public static final long serialVersionUID;
                                                    private final Throwable e$1;

                                                    static {
                                                        long l = serialVersionUID = 0L;
                                                    }

                                                    public final Throwable apply() {
                                                        return this.e$1;
                                                    }
                                                    {
                                                        this.e$1 = throwable;
                                                    }
                                                }));
                                                return var3_3;
                                            }
                                        } else {
                                            LogManager$StopActor$ logManager$StopActor$ = this.$outer.kafka$log$LogManager$$anon$$anonfun$$$outer().kafka$log$LogManager$$anon$$$outer().StopActor();
                                            Object object3 = object2;
                                            if (logManager$StopActor$ == null) {
                                                if (object3 != null) {
                                                    throw new MatchError(object2);
                                                }
                                            } else if (!logManager$StopActor$.equals(object3)) throw new MatchError(object2);
                                            this.$outer.kafka$log$LogManager$$anon$$anonfun$$$outer().kafka$log$LogManager$$anon$$$outer().info((Function0<String>)((Object)new scala.Serializable(this){
                                                public static final long serialVersionUID;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final String apply() {
                                                    return "zkActor stopped";
                                                }
                                            }));
                                            throw this.$outer.kafka$log$LogManager$$anon$$anonfun$$$outer().exit();
                                        }
                                    }

                                    public final boolean isDefinedAt(Object object) {
                                        boolean bl;
                                        Object object2 = object;
                                        if (object2 instanceof String) {
                                            bl = true;
                                        } else {
                                            LogManager$StopActor$ logManager$StopActor$ = this.$outer.kafka$log$LogManager$$anon$$anonfun$$$outer().kafka$log$LogManager$$anon$$$outer().StopActor();
                                            Object object3 = object2;
                                            bl = !(logManager$StopActor$ != null ? !logManager$StopActor$.equals(object3) : object3 != null);
                                        }
                                        return bl;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        Function1$class.$init$(this);
                                        PartialFunction$class.$init$(this);
                                    }
                                });
                            }

                            public $anon$1 kafka$log$LogManager$$anon$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }));
                    }

                    public LogManager kafka$log$LogManager$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        AbstractActor$class.$init$(this);
                        Combinators$class.$init$(this);
                        Reactor$class.$init$(this);
                        ReactorCanReply$class.$init$(this);
                        ReplyReactor$class.$init$(this);
                        ActorCanReply$class.$init$(this);
                        Actor$class.$init$(this);
                    }
                });
                serializable3 = this.zkActor().start();
            } else {
                serializable3 = BoxedUnit.UNIT;
            }
            return;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)this.logDir().getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
    }
}

