/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.common.InvalidMessageSizeException;
import kafka.log.Log$;
import kafka.log.LogSegment;
import kafka.log.LogStats;
import kafka.log.SegmentList;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.FileMessageSet;
import kafka.message.InvalidMessageException;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.server.BrokerTopicStat$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Range;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015sAB\u0001\u0003\u0011\u000b\u0011a!A\u0002M_\u001eT!a\u0001\u0003\u0002\u00071|wMC\u0001\u0006\u0003\u0015Y\u0017MZ6b!\t9\u0001\"D\u0001\u0003\r\u0019I!\u0001#\u0002\u0003\u0015\t\u0019Aj\\4\u0014\u0007!Y1\u0003\u0005\u0002\r#5\tQB\u0003\u0002\u000f\u001f\u0005!A.\u00198h\u0015\u0005\u0001\u0012\u0001\u00026bm\u0006L!AE\u0007\u0003\r=\u0013'.Z2u!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000biAA\u0011\u0001\u000f\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u0002\u0005\b=!\u0011\r\u0011\"\u0001 \u0003)1\u0015\u000e\\3Tk\u001a4\u0017\u000e_\u000b\u0002AA\u0011A\"I\u0005\u0003E5\u0011aa\u0015;sS:<\u0007B\u0002\u0013\tA\u0003%\u0001%A\u0006GS2,7+\u001e4gSb\u0004\u0003\"\u0002\u0014\t\t\u00039\u0013!\u00034j]\u0012\u0014\u0016M\\4f+\tAc\u0006\u0006\u0003*u}\"\u0005c\u0001\u000b+Y%\u00111&\u0006\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00055rC\u0002\u0001\u0003\u0006_\u0015\u0012\r\u0001\r\u0002\u0002)F\u0011\u0011\u0007\u000e\t\u0003)IJ!aM\u000b\u0003\u000f9{G\u000f[5oOB\u0011Q\u0007O\u0007\u0002m)\u0011q\u0007B\u0001\u0006kRLGn]\u0005\u0003sY\u0012QAU1oO\u0016DQaO\u0013A\u0002q\naA]1oO\u0016\u001c\bc\u0001\u000b>Y%\u0011a(\u0006\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006\u0001\u0016\u0002\r!Q\u0001\u0006m\u0006dW/\u001a\t\u0003)\tK!aQ\u000b\u0003\t1{gn\u001a\u0005\u0006\u000b\u0016\u0002\rAR\u0001\nCJ\u0014\u0018-_*ju\u0016\u0004\"\u0001F$\n\u0005!+\"aA%oi\")a\u0005\u0003C\u0001\u0015V\u00111J\u0014\u000b\u0004\u0019>\u000b\u0006c\u0001\u000b+\u001bB\u0011QF\u0014\u0003\u0006_%\u0013\r\u0001\r\u0005\u0006w%\u0003\r\u0001\u0015\t\u0004)uj\u0005\"\u0002!J\u0001\u0004\t\u0005\"B*\t\t\u0003!\u0016A\u00048b[\u00164%o\\7PM\u001a\u001cX\r\u001e\u000b\u0003+n\u0003\"AV-\u000f\u0005Q9\u0016B\u0001-\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011!E\u0017\u0006\u00031VAQ\u0001\u0018*A\u0002\u0005\u000baa\u001c4gg\u0016$\b\"\u00020\t\t\u0003y\u0016aD4fi\u0016k\u0007\u000f^=PM\u001a\u001cX\r^:\u0015\u0005\u0001\f\u0007c\u0001\u000b>\u0003\")!-\u0018a\u0001G\u00069!/Z9vKN$\bC\u00013h\u001b\u0005)'B\u00014\u0005\u0003\r\t\u0007/[\u0005\u0003Q\u0016\u0014Qb\u00144gg\u0016$(+Z9vKN$h!B\u0005\u0003\u0001\tQ7\u0003B5\fWN\u0001\"!\u000e7\n\u000554$a\u0002'pO\u001eLgn\u001a\u0005\t_&\u0014)\u0019!C\u0001a\u0006\u0019A-\u001b:\u0016\u0003E\u0004\"A];\u000e\u0003MT!\u0001^\b\u0002\u0005%|\u0017B\u0001<t\u0005\u00111\u0015\u000e\\3\t\u0011aL'\u0011!Q\u0001\nE\fA\u0001Z5sA!A!0\u001bBC\u0002\u0013\u000510A\u0004nCb\u001c\u0016N_3\u0016\u0003\u0005C\u0001\"`5\u0003\u0002\u0003\u0006I!Q\u0001\t[\u0006D8+\u001b>fA!Iq0\u001bBC\u0002\u0013\u0005\u0011\u0011A\u0001\u000eM2,8\u000f[%oi\u0016\u0014h/\u00197\u0016\u0003\u0019C\u0011\"!\u0002j\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u001d\u0019dWo\u001d5J]R,'O^1mA!Q\u0011\u0011B5\u0003\u0006\u0004%\t!a\u0003\u0002\u00199,W\r\u001a*fG>4XM]=\u0016\u0005\u00055\u0001c\u0001\u000b\u0002\u0010%\u0019\u0011\u0011C\u000b\u0003\u000f\t{w\u000e\\3b]\"Q\u0011QC5\u0003\u0002\u0003\u0006I!!\u0004\u0002\u001b9,W\r\u001a*fG>4XM]=!\u0011\u0019Q\u0012\u000e\"\u0001\u0002\u001aQQ\u00111DA\u000f\u0003?\t\t#a\t\u0011\u0005\u001dI\u0007BB8\u0002\u0018\u0001\u0007\u0011\u000f\u0003\u0004{\u0003/\u0001\r!\u0011\u0005\u0007\u007f\u0006]\u0001\u0019\u0001$\t\u0011\u0005%\u0011q\u0003a\u0001\u0003\u001bA\u0011\"a\nj\u0005\u0004%I!!\u000b\u0002\t1|7m[\u000b\u0002\u0017!9\u0011QF5!\u0002\u0013Y\u0011!\u00027pG.\u0004\u0003\"CA\u0019S\n\u0007I\u0011BA\u001a\u0003%)hN\u001a7vg\",G-\u0006\u0002\u00026A!\u0011qGA#\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012AB1u_6L7M\u0003\u0003\u0002@\u0005\u0005\u0013AC2p]\u000e,(O]3oi*\u0019\u00111I\b\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000f\nIDA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\t\u0003\u0017J\u0007\u0015!\u0003\u00026\u0005QQO\u001c4mkNDW\r\u001a\u0011\t\u0013\u0005=\u0013N1A\u0005\n\u0005E\u0013a\u00047bgR4G.^:iK\u0012$\u0016.\\3\u0016\u0005\u0005M\u0003\u0003BA\u001c\u0003+JA!a\u0016\u0002:\tQ\u0011\t^8nS\u000eduN\\4\t\u0011\u0005m\u0013\u000e)A\u0005\u0003'\n\u0001\u0003\\1ti\u001adWo\u001d5fIRKW.\u001a\u0011\t\u0015\u0005}\u0013N1A\u0005\u0002\t\t\t'\u0001\u0005tK\u001elWM\u001c;t+\t\t\u0019\u0007E\u0003\b\u0003K\nI'C\u0002\u0002h\t\u00111bU3h[\u0016tG\u000fT5tiB\u0019q!a\u001b\n\u0007\u00055$A\u0001\u0006M_\u001e\u001cVmZ7f]RD\u0001\"!\u001djA\u0003%\u00111M\u0001\ng\u0016<W.\u001a8ug\u0002B\u0001\"!\u001ej\u0005\u0004%\taH\u0001\u0005]\u0006lW\rC\u0004\u0002z%\u0004\u000b\u0011\u0002\u0011\u0002\u000b9\fW.\u001a\u0011\t\u0013\u0005u\u0014N1A\u0005\n\u0005}\u0014\u0001\u00037pON#\u0018\r^:\u0016\u0005\u0005\u0005\u0005cA\u0004\u0002\u0004&\u0019\u0011Q\u0011\u0002\u0003\u00111{wm\u0015;biND\u0001\"!#jA\u0003%\u0011\u0011Q\u0001\nY><7\u000b^1ug\u0002Bq!!$j\t\u0013\ty)\u0001\u0007m_\u0006$7+Z4nK:$8\u000f\u0006\u0002\u0002d!9\u00111S5\u0005\n\u0005U\u0015\u0001\u0005<bY&$\u0017\r^3TK\u001elWM\u001c;t)\u0011\t9*!(\u0011\u0007Q\tI*C\u0002\u0002\u001cV\u0011A!\u00168ji\"A\u0011qLAI\u0001\u0004\ty\n\u0005\u0004\u0002\"\u0006\r\u0016\u0011N\u0007\u0003\u0003\u0003JA!!*\u0002B\tI\u0011I\u001d:bs2K7\u000f\u001e\u0005\b\u0003SKG\u0011AA\u0001\u0003AqW/\u001c2fe>37+Z4nK:$8\u000fC\u0004\u0002.&$\t!a,\u0002\u000b\rdwn]3\u0015\u0005\u0005]\u0005bBAZS\u0012\u0005\u0011QW\u0001\u0007CB\u0004XM\u001c3\u0015\t\u0005]\u0015q\u0017\u0005\t\u0003s\u000b\t\f1\u0001\u0002<\u0006AQ.Z:tC\u001e,7\u000f\u0005\u0003\u0002>\u0006\rWBAA`\u0015\r\t\t\rB\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\t)-a0\u0003)\tKH/\u001a\"vM\u001a,'/T3tg\u0006<WmU3u\u0011\u001d\tI-\u001bC\u0001\u0003\u0017\fAA]3bIR1\u0011QZAj\u0003+\u0004B!!0\u0002P&!\u0011\u0011[A`\u0005)iUm]:bO\u0016\u001cV\r\u001e\u0005\u00079\u0006\u001d\u0007\u0019A!\t\u000f\u0005]\u0017q\u0019a\u0001\r\u00061A.\u001a8hi\"Dq!a7j\t\u0003\ti.\u0001\tnCJ\\G)\u001a7fi\u0016$w\u000b[5mKR!\u0011q\\A|!\u0019\t\t/!=\u0002j9!\u00111]Aw\u001d\u0011\t)/a;\u000e\u0005\u0005\u001d(bAAu7\u00051AH]8pizJ\u0011AF\u0005\u0004\u0003_,\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003g\f)PA\u0002TKFT1!a<\u0016\u0011!\tI0!7A\u0002\u0005m\u0018!\u00039sK\u0012L7-\u0019;f!\u001d!\u0012Q`A5\u0003\u001bI1!a@\u0016\u0005%1UO\\2uS>t\u0017\u0007\u0003\u0004\u0003\u0004%$\ta_\u0001\u0005g&TX\r\u0003\u0004\u0003\b%$\ta_\u0001\u0011]\u0016DH/\u00119qK:$wJ\u001a4tKRDaAa\u0003j\t\u0003Y\u0018\u0001E4fi\"Kw\r[<bi\u0016\u0014X*\u0019:l\u0011\u001d\u0011y!\u001bC\u0005\u0005#\t\u0011\"\\1zE\u0016\u0014v\u000e\u001c7\u0015\t\u0005]%1\u0003\u0005\t\u0005+\u0011i\u00011\u0001\u0002j\u000591/Z4nK:$\bb\u0002B\rS\u0012\u0005\u0011qV\u0001\u0005e>dG\u000eC\u0004\u0003\u001e%$IAa\b\u0002\u00155\f\u0017PY3GYV\u001c\b\u000e\u0006\u0003\u0002\u0018\n\u0005\u0002b\u0002B\u0012\u00057\u0001\rAR\u0001\u0011]Vl'-\u001a:PM6+7o]1hKNDqAa\nj\t\u0003\ty+A\u0003gYV\u001c\b\u000eC\u0004\u0003,%$\tA!\f\u0002!\u001d,Go\u00144gg\u0016$8OQ3g_J,Gc\u00011\u00030!1!M!\u000bA\u0002\rDqAa\rj\t\u0003\u0011)$\u0001\u0007hKR$v\u000e]5d\u001d\u0006lW\rF\u0001V\u0011\u001d\u0011I$\u001bC\u0001\u0005w\t!cZ3u\u0019\u0006\u001cHO\u00127vg\",G\rV5nKR\t\u0011\tK\u0002j\u0005\u007f\u00012!\u000eB!\u0013\r\u0011\u0019E\u000e\u0002\u000bi\"\u0014X-\u00193tC\u001a,\u0007")
public class Log
implements Logging {
    private final File dir;
    private final long maxSize;
    private final int flushInterval;
    private final boolean needRecovery;
    private final Object lock;
    private final AtomicInteger unflushed;
    private final AtomicLong lastflushedTime;
    private final SegmentList<LogSegment> segments;
    private final String name;
    private final LogStats logStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    public static final long[] getEmptyOffsets(OffsetRequest offsetRequest) {
        return Log$.MODULE$.getEmptyOffsets(offsetRequest);
    }

    public static final String nameFromOffset(long l) {
        return Log$.MODULE$.nameFromOffset(l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l) {
        return Log$.MODULE$.findRange((Range[])TArray, l);
    }

    public static final <T extends Range> Option<T> findRange(T[] TArray, long l, int n) {
        return Log$.MODULE$.findRange((Range[])TArray, l, n);
    }

    public static final String FileSuffix() {
        return Log$.MODULE$.FileSuffix();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Log log2 = this;
        synchronized (log2) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File dir() {
        return this.dir;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public int flushInterval() {
        return this.flushInterval;
    }

    public boolean needRecovery() {
        return this.needRecovery;
    }

    private Object lock() {
        return this.lock;
    }

    private AtomicInteger unflushed() {
        return this.unflushed;
    }

    private AtomicLong lastflushedTime() {
        return this.lastflushedTime;
    }

    public SegmentList<LogSegment> segments() {
        return this.segments;
    }

    public String name() {
        return this.name;
    }

    private LogStats logStats() {
        return this.logStats;
    }

    private SegmentList<LogSegment> loadSegments() {
        boolean bl;
        ArrayList<LogSegment> accum$1 = new ArrayList<LogSegment>();
        File[] ls = this.dir().listFiles();
        if (ls != null) {
            Predef$.MODULE$.refArrayOps((Object[])ls).withFilter(new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File file) {
                    return file.isFile() && file.toString().endsWith(Log$.MODULE$.FileSuffix());
                }
            }).foreach(new scala.Serializable(this, accum$1){
                public static final long serialVersionUID;
                private final ArrayList accum$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final boolean apply(File file) {
                    if (file.canRead()) {
                        String filename = file.getName();
                        long start = Predef$.MODULE$.augmentString(filename.substring(0, filename.length() - Log$.MODULE$.FileSuffix().length())).toLong();
                        FileMessageSet messageSet = new FileMessageSet(file, false);
                        return this.accum$1.add(new LogSegment(file, messageSet, start));
                    }
                    throw new IOException(new StringBuilder().append((Object)"Could not read file ").append(file).toString());
                }
                {
                    this.accum$1 = arrayList;
                }
            });
        }
        if (accum$1.size() == 0) {
            File newFile = new File(this.dir(), Log$.MODULE$.nameFromOffset(0L));
            FileMessageSet set = new FileMessageSet(newFile, true);
            bl = accum$1.add(new LogSegment(newFile, set, 0L));
        } else {
            Collections.sort(accum$1, new Comparator<LogSegment>(this){

                public int compare(LogSegment s1, LogSegment s2) {
                    return s1.start() == s2.start() ? 0 : (s1.start() < s2.start() ? -1 : 1);
                }
            });
            this.validateSegments(accum$1);
            LogSegment last$1 = accum$1.remove(accum$1.size() - 1);
            last$1.messageSet().close();
            this.info((Function0<String>)((Object)new scala.Serializable(this, last$1){
                public static final long serialVersionUID;
                private final Log $outer;
                private final LogSegment last$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Loading the last segment ").append((Object)this.last$1.file().getAbsolutePath()).append((Object)" in mutable mode, recovery ").append(BoxesRunTime.boxToBoolean(this.$outer.needRecovery())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.last$1 = logSegment;
                }
            }));
            LogSegment mutable = new LogSegment(last$1.file(), new FileMessageSet(last$1.file(), true, new AtomicBoolean(this.needRecovery())), last$1.start());
            bl = accum$1.add(mutable);
        }
        return new SegmentList<Object>(Predef$.MODULE$.wrapRefArray(accum$1.toArray((Object[])new LogSegment[accum$1.size()])), ClassManifest$.MODULE$.classType(LogSegment.class));
    }

    private void validateSegments(ArrayList<LogSegment> segments$1) {
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.intWrapper(0).until(segments$1.size() - 1).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(this, segments$1){
                public static final long serialVersionUID;
                private final ArrayList segments$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int v1) {
                    LogSegment curr = (LogSegment)this.segments$1.get(v1);
                    LogSegment next2 = (LogSegment)this.segments$1.get(v1 + 1);
                    if (curr.start() + curr.size() != next2.start()) {
                        throw new IllegalStateException(new StringBuilder().append((Object)"The following segments don't validate: ").append((Object)curr.file().getAbsolutePath()).append((Object)", ").append((Object)next2.file().getAbsolutePath()).toString());
                    }
                }
                {
                    this.segments$1 = arrayList;
                }
            }));
            return;
        }
    }

    public int numberOfSegments() {
        return ((LogSegment[])this.segments().view()).length;
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foreach(new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment seg) {
                    seg.messageSet().close();
                }
            });
            return;
        }
    }

    public void append(ByteBufferMessageSet messages) {
        IntRef numberOfMessages$1 = new IntRef(0);
        messages.foreach(new scala.Serializable(this, numberOfMessages$1){
            public static final long serialVersionUID;
            private final IntRef numberOfMessages$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(MessageAndOffset messageAndOffset) {
                if (messageAndOffset.message().isValid()) {
                    ++this.numberOfMessages$1.elem;
                    return;
                }
                throw new InvalidMessageException();
            }
            {
                this.numberOfMessages$1 = intRef;
            }
        });
        BrokerTopicStat$.MODULE$.getBrokerTopicStat(this.getTopicName()).recordMessagesIn(numberOfMessages$1.elem);
        BrokerTopicStat$.MODULE$.getBrokerAllTopicStat().recordMessagesIn(numberOfMessages$1.elem);
        this.logStats().recordAppendedMessages(numberOfMessages$1.elem);
        ByteBuffer validByteBuffer = messages.getBuffer().duplicate();
        long messageSetValidBytes = messages.validBytes();
        if (messageSetValidBytes > Integer.MAX_VALUE || messageSetValidBytes < 0L) {
            throw new InvalidMessageSizeException(new StringBuilder().append((Object)"Illegal length of message set ").append(BoxesRunTime.boxToLong(messageSetValidBytes)).append((Object)" Message set cannot be appended to log. Possible causes are corrupted produce requests").toString());
        }
        validByteBuffer.limit((int)messageSetValidBytes);
        ByteBufferMessageSet validMessages$1 = new ByteBufferMessageSet(validByteBuffer, ByteBufferMessageSet$.MODULE$.init$default$2(), ByteBufferMessageSet$.MODULE$.init$default$3());
        Object object = this.lock();
        synchronized (object) {
            this.liftedTree1$1(numberOfMessages$1, validMessages$1);
            return;
        }
    }

    public MessageSet read(long offset, int length) {
        MessageSet messageSet;
        LogSegment[] view = (LogSegment[])this.segments().view();
        Option option = Log$.MODULE$.findRange(view, offset, view.length);
        if (option instanceof Some) {
            LogSegment logSegment;
            Some some = (Some)option;
            LogSegment segment = logSegment = (LogSegment)some.x();
            messageSet = segment.messageSet().read(offset - segment.start(), length);
        } else {
            messageSet = MessageSet$.MODULE$.Empty();
        }
        return messageSet;
    }

    public Seq<LogSegment> markDeletedWhile(Function1<LogSegment, Object> predicate) {
        Object object = this.lock();
        synchronized (object) {
            LogSegment[] view = (LogSegment[])this.segments().view();
            LogSegment[] deletable = (LogSegment[])Predef$.MODULE$.refArrayOps((Object[])view).takeWhile(predicate);
            Predef$.MODULE$.refArrayOps((Object[])deletable).foreach(new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment seg) {
                    seg.deleted_$eq(true);
                }
            });
            int numToDelete = Predef$.MODULE$.refArrayOps((Object[])deletable).size();
            if (numToDelete == Predef$.MODULE$.refArrayOps((Object[])view).size()) {
                if (view[numToDelete - 1].size() > 0L) {
                    this.roll();
                } else {
                    view[numToDelete - 1].file().setLastModified(SystemTime$.MODULE$.milliseconds());
                    --numToDelete;
                }
            }
            Seq<LogSegment> seq2 = this.segments().trunc(numToDelete);
            return seq2;
        }
    }

    public long size() {
        return BoxesRunTime.unboxToLong(Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).foldLeft(BoxesRunTime.boxToLong(0L), new scala.Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(long l, LogSegment logSegment) {
                return l + logSegment.size();
            }
        }));
    }

    public long nextAppendOffset() {
        this.flush();
        LogSegment last2 = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
        return last2.start() + last2.size();
    }

    public long getHighwaterMark() {
        return ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).messageSet().highWaterMark();
    }

    private void maybeRoll(LogSegment segment) {
        if (segment.messageSet().sizeInBytes() > this.maxSize()) {
            this.roll();
        }
    }

    public void roll() {
        Object object = this.lock();
        synchronized (object) {
            Serializable serializable2;
            long newOffset = this.nextAppendOffset();
            File newFile$1 = new File(this.dir(), Log$.MODULE$.nameFromOffset(newOffset));
            if (newFile$1.exists()) {
                this.warn((Function0<String>)((Object)new scala.Serializable(this, newFile$1){
                    public static final long serialVersionUID;
                    private final File newFile$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"newly rolled logsegment ").append((Object)this.newFile$1.getName()).append((Object)" already exists; deleting it first").toString();
                    }
                    {
                        this.newFile$1 = file;
                    }
                }));
                serializable2 = BoxesRunTime.boxToBoolean(newFile$1.delete());
            } else {
                serializable2 = BoxedUnit.UNIT;
            }
            this.debug((Function0<String>)((Object)new scala.Serializable(this, newFile$1){
                public static final long serialVersionUID;
                private final Log $outer;
                private final File newFile$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Rolling log '").append((Object)this.$outer.name()).append((Object)"' to ").append((Object)this.newFile$1.getName()).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newFile$1 = file;
                }
            }));
            this.segments().append(Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{new LogSegment(newFile$1, new FileMessageSet(newFile$1, true), newOffset)}), ClassManifest$.MODULE$.classType(LogSegment.class));
            return;
        }
    }

    private void maybeFlush(int numberOfMessages) {
        if (this.unflushed().addAndGet(numberOfMessages) >= this.flushInterval()) {
            this.flush();
        }
    }

    public void flush() {
        if (this.unflushed().get() == 0) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.debug((Function0<String>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID;
                private final Log $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Flushing log '").append((Object)this.$outer.name()).append((Object)"' last flushed: ").append(BoxesRunTime.boxToLong(this.$outer.getLastFlushedTime())).append((Object)" current time: ").append(BoxesRunTime.boxToLong(System.currentTimeMillis())).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last()).messageSet().flush();
            this.unflushed().set(0);
            this.lastflushedTime().set(System.currentTimeMillis());
            return;
        }
    }

    public long[] getOffsetsBefore(OffsetRequest request) {
        LogSegment[] segsArray$1 = (LogSegment[])this.segments().view();
        ObjectRef offsetTimeArray$1 = new ObjectRef(null);
        offsetTimeArray$1.elem = ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).size() > 0L ? new Tuple2[segsArray$1.length + 1] : new Tuple2[segsArray$1.length];
        Predef$.MODULE$.intWrapper(0).until(segsArray$1.length).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(this, segsArray$1, offsetTimeArray$1){
            public static final long serialVersionUID;
            private final LogSegment[] segsArray$1;
            private final ObjectRef offsetTimeArray$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int v1) {
                ((Tuple2[])this.offsetTimeArray$1.elem)[v1] = new Tuple2$mcJJ$sp(this.segsArray$1[v1].start(), this.segsArray$1[v1].file().lastModified());
            }
            {
                this.segsArray$1 = logSegmentArray;
                this.offsetTimeArray$1 = objectRef;
            }
        }));
        if (((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).size() > 0L) {
            ((Tuple2[])offsetTimeArray$1.elem)[segsArray$1.length] = new Tuple2$mcJJ$sp(((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).start() + ((LogSegment)Predef$.MODULE$.refArrayOps((Object[])segsArray$1).last()).messageSet().highWaterMark(), SystemTime$.MODULE$.milliseconds());
        }
        IntRef startIndex$1 = new IntRef(-1);
        long l = request.time();
        if (BoxesRunTime.equals(BoxesRunTime.boxToLong(OffsetRequest$.MODULE$.LatestTime()), BoxesRunTime.boxToLong(l))) {
            startIndex$1.elem = ((Tuple2[])offsetTimeArray$1.elem).length - 1;
        } else if (BoxesRunTime.equals(BoxesRunTime.boxToLong(OffsetRequest$.MODULE$.EarliestTime()), BoxesRunTime.boxToLong(l))) {
            startIndex$1.elem = 0;
        } else {
            boolean isFound = false;
            this.debug((Function0<String>)((Object)new scala.Serializable(this, offsetTimeArray$1){
                public static final long serialVersionUID;
                private final ObjectRef offsetTimeArray$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    StringBuilder stringBuilder = new StringBuilder().append((Object)"Offset time array = ");
                    Predef$.MODULE$.refArrayOps((Object[])((Tuple2[])this.offsetTimeArray$1.elem)).foreach(new scala.Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply(Tuple2<Object, Object> o) {
                            return Predef$.MODULE$.augmentString("%d, %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(o._1$mcJ$sp()), BoxesRunTime.boxToLong(o._2$mcJ$sp())}));
                        }
                    });
                    return stringBuilder.append(BoxedUnit.UNIT).toString();
                }
                {
                    this.offsetTimeArray$1 = objectRef;
                }
            }));
            startIndex$1.elem = ((Tuple2[])offsetTimeArray$1.elem).length - 1;
            while (startIndex$1.elem >= 0 && !isFound) {
                if (((Tuple2[])offsetTimeArray$1.elem)[startIndex$1.elem]._2$mcJ$sp() <= request.time()) {
                    isFound = true;
                    continue;
                }
                --startIndex$1.elem;
            }
        }
        int retSize = Predef$.MODULE$.intWrapper(request.maxNumOffsets()).min(startIndex$1.elem + 1);
        long[] ret$1 = new long[retSize];
        Predef$.MODULE$.intWrapper(0).until(retSize).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new scala.Serializable(this, offsetTimeArray$1, startIndex$1, ret$1){
            public static final long serialVersionUID;
            private final ObjectRef offsetTimeArray$1;
            private final IntRef startIndex$1;
            private final long[] ret$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int v1) {
                this.ret$1[v1] = ((Tuple2[])this.offsetTimeArray$1.elem)[this.startIndex$1.elem]._1$mcJ$sp();
                --this.startIndex$1.elem;
            }
            {
                this.offsetTimeArray$1 = objectRef;
                this.startIndex$1 = intRef;
                this.ret$1 = lArray;
            }
        }));
        return ret$1;
    }

    public String getTopicName() {
        return this.name().substring(0, this.name().lastIndexOf("-"));
    }

    public long getLastFlushedTime() {
        return this.lastflushedTime().get();
    }

    private final void liftedTree1$1(IntRef intRef, ByteBufferMessageSet byteBufferMessageSet) {
        try {
            LogSegment segment = (LogSegment)Predef$.MODULE$.refArrayOps((Object[])this.segments().view()).last();
            segment.messageSet().append(byteBufferMessageSet);
            this.maybeFlush(intRef.elem);
            this.maybeRoll(segment);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.fatal((Function0<String>)((Object)new scala.Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Halting due to unrecoverable I/O error while handling producer request";
                }
            }), (Function0<Throwable>)((Object)new scala.Serializable(this, iOException){
                public static final long serialVersionUID;
                private final IOException e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final IOException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = iOException;
                }
            }));
            Runtime.getRuntime().halt(1);
        }
    }

    public Log(File dir, long maxSize, int flushInterval, boolean needRecovery) {
        this.dir = dir;
        this.maxSize = maxSize;
        this.flushInterval = flushInterval;
        this.needRecovery = needRecovery;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.unflushed = new AtomicInteger(0);
        this.lastflushedTime = new AtomicLong(System.currentTimeMillis());
        this.segments = this.loadSegments();
        this.name = dir.getName();
        this.logStats = new LogStats(this);
        Utils$.MODULE$.registerMBean(this.logStats(), new StringBuilder().append((Object)"kafka:type=kafka.logs.").append((Object)dir.getName()).toString());
    }
}

