/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer.storage;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.consumer.storage.OffsetStorage;
import scala.MatchError;
import scala.ScalaObject;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001m3A!\u0001\u0002\u0001\u0013\t\u0019R*Z7pef|eMZ:fiN#xN]1hK*\u00111\u0001B\u0001\bgR|'/Y4f\u0015\t)a!\u0001\u0005d_:\u001cX/\\3s\u0015\u00059\u0011!B6bM.\f7\u0001A\n\u0005\u0001)\u0011b\u0003\u0005\u0002\f!5\tAB\u0003\u0002\u000e\u001d\u0005!A.\u00198h\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!\u0005\u0007\u0003\r=\u0013'.Z2u!\t\u0019B#D\u0001\u0003\u0013\t)\"AA\u0007PM\u001a\u001cX\r^*u_J\fw-\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u00023\u0005)1oY1mC&\u00111\u0004\u0007\u0002\f'\u000e\fG.Y(cU\u0016\u001cG\u000fC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u00111\u0003\u0001\u0005\bC\u0001\u0011\r\u0011\"\u0001#\u00035ygMZ:fi\u0006sG\rT8dWV\t1\u0005\u0005\u0003%S-BT\"A\u0013\u000b\u0005\u0019:\u0013AC2p]\u000e,(O]3oi*\u0011\u0001FD\u0001\u0005kRLG.\u0003\u0002+K\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\t]ac&M\u0005\u0003[a\u0011a\u0001V;qY\u0016\u0014\u0004CA\f0\u0013\t\u0001\u0004DA\u0002J]R\u0004\"AM\u001b\u000f\u0005]\u0019\u0014B\u0001\u001b\u0019\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005QB\u0002\u0003B\f-s}\u0002\"AO\u001f\u000e\u0003mR!\u0001P\u0013\u0002\r\u0005$x.\\5d\u0013\tq4H\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\u0004\"\u0001Q\"\u000e\u0003\u0005S!AQ\u0013\u0002\u000b1|7m[:\n\u0005\u0011\u000b%\u0001\u0002'pG.DaA\u0012\u0001!\u0002\u0013\u0019\u0013AD8gMN,G/\u00118e\u0019>\u001c7\u000e\t\u0005\u0006\u0011\u0002!\t!S\u0001\be\u0016\u001cXM\u001d<f)\rQUj\u0014\t\u0003/-K!\u0001\u0014\r\u0003\t1{gn\u001a\u0005\u0006\u001d\u001e\u0003\rAL\u0001\u0005]>$W\rC\u0003Q\u000f\u0002\u0007\u0011'A\u0003u_BL7\rC\u0003S\u0001\u0011\u00051+\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0005)^C\u0016\f\u0005\u0002\u0018+&\u0011a\u000b\u0007\u0002\u0005+:LG\u000fC\u0003O#\u0002\u0007a\u0006C\u0003Q#\u0002\u0007\u0011\u0007C\u0003[#\u0002\u0007!*\u0001\u0004pM\u001a\u001cX\r\u001e")
public class MemoryOffsetStorage
implements OffsetStorage,
ScalaObject {
    private final ConcurrentHashMap<Tuple2<Object, String>, Tuple2<AtomicLong, Lock>> offsetAndLock = new ConcurrentHashMap();

    public ConcurrentHashMap<Tuple2<Object, String>, Tuple2<AtomicLong, Lock>> offsetAndLock() {
        return this.offsetAndLock;
    }

    @Override
    public long reserve(int node, String topic) {
        Tuple2<Integer, String> key = new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(node), topic);
        Serializable serializable2 = this.offsetAndLock().containsKey(key) ? BoxedUnit.UNIT : this.offsetAndLock().putIfAbsent(key, new Tuple2<AtomicLong, ReentrantLock>(new AtomicLong(0L), new ReentrantLock()));
        Tuple2<AtomicLong, Lock> tuple2 = this.offsetAndLock().get(key);
        if (tuple2 != null) {
            Tuple2<AtomicLong, Lock> tuple22 = new Tuple2<AtomicLong, Lock>(tuple2._1(), tuple2._2());
            AtomicLong offset = tuple22._1();
            Lock lock = tuple22._2();
            lock.lock();
            return offset.get();
        }
        throw new MatchError(tuple2);
    }

    @Override
    public void commit(int node, String topic, long offset) {
        Tuple2<AtomicLong, Lock> tuple2 = this.offsetAndLock().get(new Tuple2<Integer, String>(BoxesRunTime.boxToInteger(node), topic));
        if (tuple2 != null) {
            Tuple2<AtomicLong, Lock> tuple22 = new Tuple2<AtomicLong, Lock>(tuple2._1(), tuple2._2());
            AtomicLong highwater = tuple22._1();
            Lock lock = tuple22._2();
            highwater.set(offset);
            lock.unlock();
            return;
        }
        throw new MatchError(tuple2);
    }
}

