/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kafka.consumer.Blacklist;
import kafka.consumer.StaticTopicCount;
import kafka.consumer.TopicCount;
import kafka.consumer.TopicCount$;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.consumer.WildcardTopicCount;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZKGroupDirs;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.mutable.StringBuilder;
import scala.util.parsing.json.JSON$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class TopicCount$
implements Logging {
    public static final TopicCount$ MODULE$;
    private final String WHITELIST_MARKER;
    private final String BLACKLIST_MARKER;
    private final Pattern kafka$consumer$TopicCount$$WHITELIST_PATTERN;
    private final Pattern kafka$consumer$TopicCount$$BLACKLIST_PATTERN;
    private final Function1<String, Object> myConversionFunc;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new TopicCount$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        TopicCount$ topicCount$ = this;
        synchronized (topicCount$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String WHITELIST_MARKER() {
        return this.WHITELIST_MARKER;
    }

    public String BLACKLIST_MARKER() {
        return this.BLACKLIST_MARKER;
    }

    public final Pattern kafka$consumer$TopicCount$$WHITELIST_PATTERN() {
        return this.kafka$consumer$TopicCount$$WHITELIST_PATTERN;
    }

    public final Pattern kafka$consumer$TopicCount$$BLACKLIST_PATTERN() {
        return this.kafka$consumer$TopicCount$$BLACKLIST_PATTERN;
    }

    public Function1<String, Object> myConversionFunc() {
        return this.myConversionFunc;
    }

    public TopicCount constructTopicCount(String group, String consumerId$1, ZkClient zkClient) {
        Option<Object> option;
        String topicCountString$1;
        block7: {
            TopicCount topicCount;
            ZKGroupDirs dirs = new ZKGroupDirs(group);
            topicCountString$1 = ZkUtils$.MODULE$.readData(zkClient, new StringBuilder().append((Object)dirs.consumerRegistryDir()).append((Object)"/").append((Object)consumerId$1).toString());
            boolean hasWhitelist$1 = topicCountString$1.startsWith(this.WHITELIST_MARKER());
            boolean hasBlacklist = topicCountString$1.startsWith(this.BLACKLIST_MARKER());
            if (hasWhitelist$1 || hasBlacklist) {
                this.info((Function0<String>)((Object)new Serializable(consumerId$1, topicCountString$1, hasWhitelist$1){
                    public static final long serialVersionUID;
                    private final String consumerId$1;
                    private final String topicCountString$1;
                    private final boolean hasWhitelist$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Constructing topic count for %s from %s using %s as pattern.").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.consumerId$1, this.topicCountString$1, this.hasWhitelist$1 ? TopicCount$.MODULE$.kafka$consumer$TopicCount$$WHITELIST_PATTERN() : TopicCount$.MODULE$.kafka$consumer$TopicCount$$BLACKLIST_PATTERN()}));
                    }
                    {
                        this.consumerId$1 = string2;
                        this.topicCountString$1 = string3;
                        this.hasWhitelist$1 = bl;
                    }
                }));
            }
            if (hasWhitelist$1 || hasBlacklist) {
                Matcher matcher = hasWhitelist$1 ? this.kafka$consumer$TopicCount$$WHITELIST_PATTERN().matcher(topicCountString$1) : this.kafka$consumer$TopicCount$$BLACKLIST_PATTERN().matcher(topicCountString$1);
                Predef$.MODULE$.require(matcher.matches());
                int numStreams = Predef$.MODULE$.augmentString(matcher.group(1)).toInt();
                String regex = matcher.group(2);
                TopicFilter filter2 = hasWhitelist$1 ? new Whitelist(regex) : new Blacklist(regex);
                topicCount = new WildcardTopicCount(zkClient, consumerId$1, filter2, numStreams);
            } else {
                Map topMap = null;
                option = JSON$.MODULE$.parseFull(topicCountString$1);
                if (!(option instanceof Some)) break block7;
                topMap = (Map)((Some)option).x();
                topicCount = new StaticTopicCount(consumerId$1, topMap);
            }
            return topicCount;
        }
        try {
            None$ none$ = None$.MODULE$;
            Option<Object> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                throw new RuntimeException(new StringBuilder().append((Object)"error constructing TopicCount : ").append((Object)topicCountString$1).toString());
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(topicCountString$1){
                public static final long serialVersionUID;
                private final String topicCountString$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"error parsing consumer json string ").append((Object)this.topicCountString$1).toString();
                }
                {
                    this.topicCountString$1 = string2;
                }
            }), (Function0<Throwable>)((Object)new Serializable(throwable){
                public static final long serialVersionUID;
                private final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = throwable;
                }
            }));
            throw throwable;
        }
    }

    public StaticTopicCount constructTopicCount(String consumerIdString, Map<String, Object> topicCount) {
        return new StaticTopicCount(consumerIdString, topicCount);
    }

    public WildcardTopicCount constructTopicCount(String consumerIdString, TopicFilter filter2, int numStreams, ZkClient zkClient) {
        return new WildcardTopicCount(zkClient, consumerIdString, filter2, numStreams);
    }

    private TopicCount$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.WHITELIST_MARKER = "*";
        this.BLACKLIST_MARKER = "!";
        this.kafka$consumer$TopicCount$$WHITELIST_PATTERN = Pattern.compile("\\*(\\p{Digit}+)\\*(.*)");
        this.kafka$consumer$TopicCount$$BLACKLIST_PATTERN = Pattern.compile("!(\\p{Digit}+)!(.*)");
        this.myConversionFunc = new anonfun.1();
        JSON$.MODULE$.globalNumberParser_$eq(this.myConversionFunc());
    }
}

