/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import kafka.api.FetchRequest;
import kafka.api.MultiFetchRequest;
import kafka.api.MultiFetchResponse;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.consumer.SimpleConsumerStats$;
import kafka.message.ByteBufferMessageSet;
import kafka.network.BoundedByteBufferReceive;
import kafka.network.BoundedByteBufferSend;
import kafka.network.Receive;
import kafka.network.Request;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.SystemTime$;
import kafka.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001\u001d\u0011abU5na2,7i\u001c8tk6,'O\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u0011-A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005)Q\u000f^5mg&\u0011QC\u0005\u0002\b\u0019><w-\u001b8h!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011u\u0001!Q1A\u0005\u0002y\tA\u0001[8tiV\tq\u0004\u0005\u0002!G9\u0011q#I\u0005\u0003Ea\ta\u0001\u0015:fI\u00164\u0017B\u0001\u0013&\u0005\u0019\u0019FO]5oO*\u0011!\u0005\u0007\u0005\tO\u0001\u0011\t\u0011)A\u0005?\u0005)\u0001n\\:uA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&\u0001\u0003q_J$X#A\u0016\u0011\u0005]a\u0013BA\u0017\u0019\u0005\rIe\u000e\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005W\u0005)\u0001o\u001c:uA!A\u0011\u0007\u0001BC\u0002\u0013\u0005!&A\u0005t_RKW.Z8vi\"A1\u0007\u0001B\u0001B\u0003%1&\u0001\u0006t_RKW.Z8vi\u0002B\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAK\u0001\u000bEV4g-\u001a:TSj,\u0007\u0002C\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0017\t,hMZ3s'&TX\r\t\u0005\u0006s\u0001!\tAO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bmjdh\u0010!\u0011\u0005q\u0002Q\"\u0001\u0002\t\u000buA\u0004\u0019A\u0010\t\u000b%B\u0004\u0019A\u0016\t\u000bEB\u0004\u0019A\u0016\t\u000bUB\u0004\u0019A\u0016\t\u000f\t\u0003\u0001\u0019!C\u0005\u0007\u000691\r[1o]\u0016dW#\u0001#\u0011\u0005\u0015SU\"\u0001$\u000b\u0005\u001dC\u0015\u0001C2iC:tW\r\\:\u000b\u0005%c\u0011a\u00018j_&\u00111J\u0012\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\u000f5\u0003\u0001\u0019!C\u0005\u001d\u0006Y1\r[1o]\u0016dw\fJ3r)\ty%\u000b\u0005\u0002\u0018!&\u0011\u0011\u000b\u0007\u0002\u0005+:LG\u000fC\u0004T\u0019\u0006\u0005\t\u0019\u0001#\u0002\u0007a$\u0013\u0007\u0003\u0004V\u0001\u0001\u0006K\u0001R\u0001\tG\"\fgN\\3mA!9q\u000b\u0001b\u0001\n\u0013A\u0016\u0001\u00027pG.,\u0012\u0001\u0003\u0005\u00075\u0002\u0001\u000b\u0011\u0002\u0005\u0002\u000b1|7m\u001b\u0011\t\u000bq\u0003A\u0011B/\u0002\u000f\r|gN\\3diR\tA\tC\u0003`\u0001\u0011%\u0001-A\u0003dY>\u001cX\r\u0006\u0002PC\")!I\u0018a\u0001\t\")q\f\u0001C\u0001GR\tq\nC\u0003f\u0001\u0011\u0005a-A\u0003gKR\u001c\u0007\u000e\u0006\u0002h[B\u0011\u0001n[\u0007\u0002S*\u0011!\u000eB\u0001\b[\u0016\u001c8/Y4f\u0013\ta\u0017N\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0005\u0006]\u0012\u0004\ra\\\u0001\be\u0016\fX/Z:u!\t\u00018/D\u0001r\u0015\t\u0011H!A\u0002ba&L!\u0001^9\u0003\u0019\u0019+Go\u00195SKF,Xm\u001d;\t\u000bY\u0004A\u0011A<\u0002\u00155,H\u000e^5gKR\u001c\u0007\u000e\u0006\u0002ywB\u0011\u0001/_\u0005\u0003uF\u0014!#T;mi&4U\r^2i%\u0016\u001c\bo\u001c8tK\")A0\u001ea\u0001{\u00069a-\u001a;dQ\u0016\u001c\bcA\f\u007f_&\u0011q\u0010\u0007\u0002\u000byI,\u0007/Z1uK\u0012t\u0004bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0011O\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016$\"\"a\u0002\u0002\u0014\u0005]\u00111DA\u0010!\u00159\u0012\u0011BA\u0007\u0013\r\tY\u0001\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004/\u0005=\u0011bAA\t1\t!Aj\u001c8h\u0011\u001d\t)\"!\u0001A\u0002}\tQ\u0001^8qS\u000eDq!!\u0007\u0002\u0002\u0001\u00071&A\u0005qCJ$\u0018\u000e^5p]\"A\u0011QDA\u0001\u0001\u0004\ti!\u0001\u0003uS6,\u0007bBA\u0011\u0003\u0003\u0001\raK\u0001\u000e[\u0006Dh*^7PM\u001a\u001cX\r^:\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(\u0005Y1/\u001a8e%\u0016\fX/Z:u)\rY\u0013\u0011\u0006\u0005\b]\u0006\r\u0002\u0019AA\u0016!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019\t\u00059a.\u001a;x_J\\\u0017\u0002BA\u001b\u0003_\u0011qAU3rk\u0016\u001cH\u000fC\u0004\u0002:\u0001!I!a\u000f\u0002\u0017\u001d,GOU3ta>t7/\u001a\u000b\u0003\u0003{\u0001baFA \u0003\u0007Z\u0013bAA!1\t1A+\u001e9mKJ\u0002B!!\f\u0002F%!\u0011qIA\u0018\u0005\u001d\u0011VmY3jm\u0016Da!a\u0013\u0001\t\u0013\u0019\u0017aE4fi>\u0013X*Y6f\u0007>tg.Z2uS>t\u0007f\u0001\u0001\u0002PA\u0019\u0011#!\u0015\n\u0007\u0005M#C\u0001\u0006uQJ,\u0017\rZ:bM\u0016\u0004")
public class SimpleConsumer
implements Logging {
    private final String host;
    private final int port;
    private final int soTimeout;
    private final int bufferSize;
    private SocketChannel channel;
    private final Object lock;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        SimpleConsumer simpleConsumer = this;
        synchronized (simpleConsumer) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public int soTimeout() {
        return this.soTimeout;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    private SocketChannel channel() {
        return this.channel;
    }

    private void channel_$eq(SocketChannel socketChannel) {
        this.channel = socketChannel;
    }

    private Object lock() {
        return this.lock;
    }

    /*
     * WARNING - void declaration
     */
    private SocketChannel connect() {
        void var2_2;
        this.close();
        InetSocketAddress address$1 = new InetSocketAddress(this.host(), this.port());
        SocketChannel channel$1 = SocketChannel.open();
        this.debug((Function0<String>)((Object)new Serializable(this, address$1){
            public static final long serialVersionUID;
            private final InetSocketAddress address$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Connected to ").append(this.address$1).append((Object)" for fetching.").toString();
            }
            {
                this.address$1 = inetSocketAddress;
            }
        }));
        channel$1.configureBlocking(true);
        channel$1.socket().setReceiveBufferSize(this.bufferSize());
        channel$1.socket().setSoTimeout(this.soTimeout());
        channel$1.socket().setKeepAlive(true);
        channel$1.socket().setTcpNoDelay(true);
        channel$1.connect(address$1);
        this.trace((Function0<String>)((Object)new Serializable(this, channel$1){
            public static final long serialVersionUID;
            private final SimpleConsumer $outer;
            private final SocketChannel channel$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"requested receive buffer size=").append(BoxesRunTime.boxToInteger(this.$outer.bufferSize())).append((Object)" actual receive buffer size= ").append(BoxesRunTime.boxToInteger(this.channel$1.socket().getReceiveBufferSize())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.channel$1 = socketChannel;
            }
        }));
        this.trace((Function0<String>)((Object)new Serializable(this, channel$1){
            public static final long serialVersionUID;
            private final SimpleConsumer $outer;
            private final SocketChannel channel$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"soTimeout=").append(BoxesRunTime.boxToInteger(this.$outer.soTimeout())).append((Object)" actual soTimeout= ").append(BoxesRunTime.boxToInteger(this.channel$1.socket().getSoTimeout())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.channel$1 = socketChannel;
            }
        }));
        return var2_2;
    }

    private void close(SocketChannel channel$2) {
        this.debug((Function0<String>)((Object)new Serializable(this, channel$2){
            public static final long serialVersionUID;
            private final SocketChannel channel$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Disconnecting from ").append(this.channel$2.socket().getRemoteSocketAddress()).toString();
            }
            {
                this.channel$2 = socketChannel;
            }
        }));
        Utils$.MODULE$.swallow((Function2<Object, Throwable, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final SimpleConsumer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object, Throwable throwable) {
                this.$outer.logger().warn(object, throwable);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), (Function0<BoxedUnit>)((Object)new Serializable(this, channel$2){
            public static final long serialVersionUID;
            private final SocketChannel channel$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.channel$2.close();
            }
            {
                this.channel$2 = socketChannel;
            }
        }));
        Utils$.MODULE$.swallow((Function2<Object, Throwable, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final SimpleConsumer $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object, Throwable throwable) {
                this.$outer.logger().warn(object, throwable);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), (Function0<BoxedUnit>)((Object)new Serializable(this, channel$2){
            public static final long serialVersionUID;
            private final SocketChannel channel$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.channel$2.socket().close();
            }
            {
                this.channel$2 = socketChannel;
            }
        }));
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            if (this.channel() != null) {
                this.close(this.channel());
            }
            this.channel_$eq(null);
            return;
        }
    }

    public ByteBufferMessageSet fetch(FetchRequest request$1) {
        Object object = this.lock();
        synchronized (object) {
            long startTime = SystemTime$.MODULE$.nanoseconds();
            this.getOrMakeConnection();
            ObjectRef response$1 = new ObjectRef(null);
            this.liftedTree1$1(request$1, response$1);
            long endTime = SystemTime$.MODULE$.nanoseconds();
            SimpleConsumerStats$.MODULE$.recordFetchRequest(endTime - startTime);
            SimpleConsumerStats$.MODULE$.recordConsumptionThroughput(((Receive)((Tuple2)response$1.elem)._1()).buffer().limit());
            ByteBufferMessageSet byteBufferMessageSet = new ByteBufferMessageSet(((Receive)((Tuple2)response$1.elem)._1()).buffer(), request$1.offset(), ((Tuple2)response$1.elem)._2$mcI$sp());
            return byteBufferMessageSet;
        }
    }

    public MultiFetchResponse multifetch(Seq<FetchRequest> fetches$1) {
        Object object = this.lock();
        synchronized (object) {
            long startTime = SystemTime$.MODULE$.nanoseconds();
            this.getOrMakeConnection();
            ObjectRef response$2 = new ObjectRef(null);
            this.liftedTree2$1(fetches$1, response$2);
            long endTime = SystemTime$.MODULE$.nanoseconds();
            SimpleConsumerStats$.MODULE$.recordFetchRequest(endTime - startTime);
            SimpleConsumerStats$.MODULE$.recordConsumptionThroughput(((Receive)((Tuple2)response$2.elem)._1()).buffer().limit());
            MultiFetchResponse multiFetchResponse = new MultiFetchResponse(((Receive)((Tuple2)response$2.elem)._1()).buffer(), fetches$1.length(), (long[])Predef$.MODULE$.refArrayOps((Object[])fetches$1.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))).map(new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final long apply(FetchRequest f2) {
                    return f2.offset();
                }
            }, Array$.MODULE$.canBuildFrom(Manifest$.MODULE$.Long())));
            return multiFetchResponse;
        }
    }

    public long[] getOffsetsBefore(String topic$1, int partition$1, long time$1, int maxNumOffsets$1) {
        Object object = this.lock();
        synchronized (object) {
            this.getOrMakeConnection();
            ObjectRef response$3 = new ObjectRef(null);
            this.liftedTree3$1(topic$1, partition$1, time$1, maxNumOffsets$1, response$3);
            long[] lArray = OffsetRequest$.MODULE$.deserializeOffsetArray(((Receive)((Tuple2)response$3.elem)._1()).buffer());
            return lArray;
        }
    }

    private int sendRequest(Request request) {
        BoundedByteBufferSend send2 = new BoundedByteBufferSend(request);
        return send2.writeCompletely(this.channel());
    }

    private Tuple2<Receive, Object> getResponse() {
        BoundedByteBufferReceive response = new BoundedByteBufferReceive();
        response.readCompletely(this.channel());
        short errorCode = response.buffer().getShort();
        return new Tuple2<Receive, Object>(response, BoxesRunTime.boxToInteger(errorCode));
    }

    private void getOrMakeConnection() {
        if (this.channel() == null) {
            this.channel_$eq(this.connect());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree1$1(FetchRequest fetchRequest, ObjectRef objectRef) {
        try {
            this.sendRequest(fetchRequest);
            objectRef.elem = this.getResponse();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Reconnect in fetch request due to socket error: ";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, iOException){
                public static final long serialVersionUID;
                private final IOException e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final IOException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = iOException;
                }
            }));
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(fetchRequest);
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree2$1(Seq seq2, ObjectRef objectRef) {
        try {
            this.sendRequest(new MultiFetchRequest((FetchRequest[])seq2.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))));
            objectRef.elem = this.getResponse();
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Reconnect in multifetch due to socket error: ";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, iOException){
                public static final long serialVersionUID;
                private final IOException e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final IOException apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = iOException;
                }
            }));
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(new MultiFetchRequest((FetchRequest[])seq2.toArray(ClassManifest$.MODULE$.classType(FetchRequest.class))));
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void liftedTree3$1(String string2, int n, long l, int n2, ObjectRef objectRef) {
        try {
            this.sendRequest(new OffsetRequest(string2, n, l, n2));
            objectRef.elem = this.getResponse();
            return;
        }
        catch (IOException iOException) {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Reconnect in get offetset request due to socket error: ";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, iOException){
                public static final long serialVersionUID;
                private final IOException e$3;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final IOException apply() {
                    return this.e$3;
                }
                {
                    this.e$3 = iOException;
                }
            }));
            try {
                this.channel_$eq(this.connect());
                this.sendRequest(new OffsetRequest(string2, n, l, n2));
                objectRef.elem = this.getResponse();
                return;
            }
            catch (IOException iOException2) {
                this.channel_$eq(null);
                throw iOException2;
            }
        }
    }

    public SimpleConsumer(String host, int port, int soTimeout, int bufferSize) {
        this.host = host;
        this.port = port;
        this.soTimeout = soTimeout;
        this.bufferSize = bufferSize;
        Logging$class.$init$(this);
        this.channel = null;
        this.lock = new Object();
    }
}

