/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.Serializable;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.cluster.Partition;
import kafka.common.ErrorMapping$;
import kafka.consumer.ConsumerTopicStat$;
import kafka.consumer.FetchedDataChunk;
import kafka.message.ByteBufferMessageSet;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-c!B\u0001\u0003\u0001\t1!A\u0005)beRLG/[8o)>\u0004\u0018nY%oM>T!a\u0001\u0003\u0002\u0011\r|gn];nKJT\u0011!B\u0001\u0006W\u000647.Y\n\u0005\u0001\u001dyQ\u0003\u0005\u0002\t\u001b5\t\u0011B\u0003\u0002\u000b\u0017\u0005!A.\u00198h\u0015\u0005a\u0011\u0001\u00026bm\u0006L!AD\u0005\u0003\r=\u0013'.Z2u!\t\u00012#D\u0001\u0012\u0015\t\u0011B!A\u0003vi&d7/\u0003\u0002\u0015#\t9Aj\\4hS:<\u0007C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"aC*dC2\fwJ\u00196fGRD\u0001\u0002\b\u0001\u0003\u0006\u0004%\tAH\u0001\u0006i>\u0004\u0018nY\u0002\u0001+\u0005y\u0002C\u0001\u0011$\u001d\t1\u0012%\u0003\u0002#/\u00051\u0001K]3eK\u001aL!\u0001J\u0013\u0003\rM#(/\u001b8h\u0015\t\u0011s\u0003\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003 \u0003\u0019!x\u000e]5dA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&\u0001\u0005ce>\\WM]%e+\u0005Y\u0003C\u0001\f-\u0013\tisCA\u0002J]RD\u0001b\f\u0001\u0003\u0002\u0003\u0006IaK\u0001\nEJ|7.\u001a:JI\u0002B\u0001\"\r\u0001\u0003\u0006\u0004%\tAM\u0001\na\u0006\u0014H/\u001b;j_:,\u0012a\r\t\u0003i]j\u0011!\u000e\u0006\u0003m\u0011\tqa\u00197vgR,'/\u0003\u00029k\tI\u0001+\u0019:uSRLwN\u001c\u0005\tu\u0001\u0011\t\u0011)A\u0005g\u0005Q\u0001/\u0019:uSRLwN\u001c\u0011\t\u0011q\u0002!Q1A\u0005\nu\n!b\u00195v].\fV/Z;f+\u0005q\u0004cA E\r6\t\u0001I\u0003\u0002B\u0005\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\r[\u0011\u0001B;uS2L!!\u0012!\u0003\u001b\tcwnY6j]\u001e\fV/Z;f!\t9\u0005*D\u0001\u0003\u0013\tI%A\u0001\tGKR\u001c\u0007.\u001a3ECR\f7\t[;oW\"A1\n\u0001B\u0001B\u0003%a(A\u0006dQVt7.U;fk\u0016\u0004\u0003\u0002C'\u0001\u0005\u000b\u0007I\u0011\u0002(\u0002\u001d\r|gn];nK\u0012|eMZ:fiV\tq\n\u0005\u0002Q'6\t\u0011K\u0003\u0002S\u0001\u00061\u0011\r^8nS\u000eL!\u0001V)\u0003\u0015\u0005#x.\\5d\u0019>tw\r\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003P\u0003=\u0019wN\\:v[\u0016$wJ\u001a4tKR\u0004\u0003\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011\u0002(\u0002\u001b\u0019,Go\u00195fI>3gm]3u\u0011!Q\u0006A!A!\u0002\u0013y\u0015A\u00044fi\u000eDW\rZ(gMN,G\u000f\t\u0005\t9\u0002\u0011)\u0019!C\u0005;\u0006Ia-\u001a;dQNK'0Z\u000b\u0002=B\u0011\u0001kX\u0005\u0003AF\u0013Q\"\u0011;p[&\u001c\u0017J\u001c;fO\u0016\u0014\b\u0002\u00032\u0001\u0005\u0003\u0005\u000b\u0011\u00020\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0003e\u0001\u0011\u0005Q-\u0001\u0004=S:LGO\u0010\u000b\tM\u001eD\u0017N[6m[B\u0011q\t\u0001\u0005\u00069\r\u0004\ra\b\u0005\u0006S\r\u0004\ra\u000b\u0005\u0006c\r\u0004\ra\r\u0005\u0006y\r\u0004\rA\u0010\u0005\u0006\u001b\u000e\u0004\ra\u0014\u0005\u00061\u000e\u0004\ra\u0014\u0005\u00069\u000e\u0004\rA\u0018\u0005\u0006_\u0002!\t\u0001]\u0001\u0011O\u0016$8i\u001c8tk6,wJ\u001a4tKR$\u0012!\u001d\t\u0003-IL!a]\f\u0003\t1{gn\u001a\u0005\u0006k\u0002!\t\u0001]\u0001\u000fO\u0016$h)\u001a;dQ>3gm]3u\u0011\u00159\b\u0001\"\u0001y\u0003I\u0011Xm]3u\u0007>t7/^7f\u001f\u001a47/\u001a;\u0015\u0005ed\bC\u0001\f{\u0013\tYxC\u0001\u0003V]&$\b\"B?w\u0001\u0004\t\u0018\u0001\u00058fo\u000e{gn];nK>3gm]3u\u0011\u0019y\b\u0001\"\u0001\u0002\u0002\u0005\u0001\"/Z:fi\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u000b\u0004s\u0006\r\u0001BBA\u0003}\u0002\u0007\u0011/\u0001\boK^4U\r^2i\u001f\u001a47/\u001a;\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\u00059QM\\9vKV,G#B9\u0002\u000e\u0005u\u0001\u0002CA\b\u0003\u000f\u0001\r!!\u0005\u0002\u00115,7o]1hKN\u0004B!a\u0005\u0002\u001a5\u0011\u0011Q\u0003\u0006\u0004\u0003/!\u0011aB7fgN\fw-Z\u0005\u0005\u00037\t)B\u0001\u000bCsR,')\u001e4gKJlUm]:bO\u0016\u001cV\r\u001e\u0005\b\u0003?\t9\u00011\u0001r\u0003-1W\r^2i\u001f\u001a47/\u001a;\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005aQM\\9vKV,WI\u001d:peR)\u00110a\n\u0002D!A\u0011\u0011FA\u0011\u0001\u0004\tY#A\u0001f!\u0011\ti#!\u0010\u000f\t\u0005=\u0012\u0011\b\b\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG\u000f\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012bAA\u001e/\u00059\u0001/Y2lC\u001e,\u0017\u0002BA \u0003\u0003\u0012\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005mr\u0003C\u0004\u0002 \u0005\u0005\u0002\u0019A9\t\u000f\u0005\u001d\u0003\u0001\"\u0011\u0002J\u0005AAo\\*ue&tw\rF\u0001 \u0001")
public class PartitionTopicInfo
implements Logging {
    private final String topic;
    private final int brokerId;
    private final Partition partition;
    private final BlockingQueue<FetchedDataChunk> chunkQueue;
    private final AtomicLong kafka$consumer$PartitionTopicInfo$$consumedOffset;
    private final AtomicLong kafka$consumer$PartitionTopicInfo$$fetchedOffset;
    private final AtomicInteger fetchSize;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        PartitionTopicInfo partitionTopicInfo = this;
        synchronized (partitionTopicInfo) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String topic() {
        return this.topic;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    private BlockingQueue<FetchedDataChunk> chunkQueue() {
        return this.chunkQueue;
    }

    public final AtomicLong kafka$consumer$PartitionTopicInfo$$consumedOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$consumedOffset;
    }

    public final AtomicLong kafka$consumer$PartitionTopicInfo$$fetchedOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$fetchedOffset;
    }

    private AtomicInteger fetchSize() {
        return this.fetchSize;
    }

    public long getConsumeOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$consumedOffset().get();
    }

    public long getFetchOffset() {
        return this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get();
    }

    public void resetConsumeOffset(long newConsumeOffset$1) {
        this.kafka$consumer$PartitionTopicInfo$$consumedOffset().set(newConsumeOffset$1);
        this.debug((Function0<String>)((Object)new scala.Serializable(this, newConsumeOffset$1){
            public static final long serialVersionUID;
            private final PartitionTopicInfo $outer;
            private final long newConsumeOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"reset consume offset of ").append(this.$outer).append((Object)" to ").append(BoxesRunTime.boxToLong(this.newConsumeOffset$1)).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newConsumeOffset$1 = l;
            }
        }));
    }

    public void resetFetchOffset(long newFetchOffset$1) {
        this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().set(newFetchOffset$1);
        this.debug((Function0<String>)((Object)new scala.Serializable(this, newFetchOffset$1){
            public static final long serialVersionUID;
            private final PartitionTopicInfo $outer;
            private final long newFetchOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("reset fetch offset of ( %s ) to %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer, BoxesRunTime.boxToLong(this.newFetchOffset$1)}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newFetchOffset$1 = l;
            }
        }));
    }

    public long enqueue(ByteBufferMessageSet messages, long fetchOffset) {
        Serializable serializable2;
        long size$1 = messages.validBytes();
        if (size$1 > 0L) {
            this.trace((Function0<String>)((Object)new scala.Serializable(this, size$1){
                public static final long serialVersionUID;
                private final PartitionTopicInfo $outer;
                private final long size$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Updating fetch offset = ").append(BoxesRunTime.boxToLong(this.$outer.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).append((Object)" with size = ").append(BoxesRunTime.boxToLong(this.size$1)).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.size$1 = l;
                }
            }));
            this.chunkQueue().put(new FetchedDataChunk(messages, this, fetchOffset));
            long newOffset$1 = this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().addAndGet(size$1);
            this.debug((Function0<String>)((Object)new scala.Serializable(this, newOffset$1){
                public static final long serialVersionUID;
                private final PartitionTopicInfo $outer;
                private final long newOffset$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("updated fetch offset of ( %s ) to %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer, BoxesRunTime.boxToLong(this.newOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newOffset$1 = l;
                }
            }));
            ConsumerTopicStat$.MODULE$.getConsumerTopicStat(this.topic()).recordBytesPerTopic(size$1);
            serializable2 = BoxesRunTime.boxToLong(ConsumerTopicStat$.MODULE$.getConsumerAllTopicStat().recordBytesPerTopic(size$1));
        } else {
            serializable2 = BoxedUnit.UNIT;
        }
        return size$1;
    }

    public void enqueueError(Throwable e, long fetchOffset) {
        ByteBufferMessageSet messages = new ByteBufferMessageSet(ErrorMapping$.MODULE$.EmptyByteBuffer(), 0L, ErrorMapping$.MODULE$.codeFor(e.getClass()));
        this.chunkQueue().put(new FetchedDataChunk(messages, this, fetchOffset));
    }

    public String toString() {
        return new StringBuilder().append((Object)this.topic()).append((Object)":").append((Object)this.partition().toString()).append((Object)": fetched offset = ").append(BoxesRunTime.boxToLong(this.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).append((Object)": consumed offset = ").append(BoxesRunTime.boxToLong(this.kafka$consumer$PartitionTopicInfo$$consumedOffset().get())).toString();
    }

    public PartitionTopicInfo(String topic, int brokerId, Partition partition2, BlockingQueue<FetchedDataChunk> chunkQueue, AtomicLong consumedOffset, AtomicLong fetchedOffset, AtomicInteger fetchSize) {
        this.topic = topic;
        this.brokerId = brokerId;
        this.partition = partition2;
        this.chunkQueue = chunkQueue;
        this.kafka$consumer$PartitionTopicInfo$$consumedOffset = consumedOffset;
        this.kafka$consumer$PartitionTopicInfo$$fetchedOffset = fetchedOffset;
        this.fetchSize = fetchSize;
        Logging$class.$init$(this);
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;
            private final PartitionTopicInfo $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"initial consumer offset of ").append(this.$outer).append((Object)" is ").append(BoxesRunTime.boxToLong(this.$outer.kafka$consumer$PartitionTopicInfo$$consumedOffset().get())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.debug((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID;
            private final PartitionTopicInfo $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"initial fetch offset of ").append(this.$outer).append((Object)" is ").append(BoxesRunTime.boxToLong(this.$outer.kafka$consumer$PartitionTopicInfo$$fetchedOffset().get())).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }
}

