/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import kafka.api.FetchRequest;
import kafka.api.MultiFetchResponse;
import kafka.api.OffsetRequest$;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.common.ErrorMapping$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.FetcherRunnable$;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\u0001\u0003\u0001\u001d\u0011qBR3uG\",'OU;o]\u0006\u0014G.\u001a\u0006\u0003\u0007\u0011\t\u0001bY8ogVlWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t!Y\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004UQJ,\u0017\r\u001a\t\u0003#Qi\u0011A\u0005\u0006\u0003'\u0011\tQ!\u001e;jYNL!!\u0006\n\u0003\u000f1{wmZ5oOB\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\tY1kY1mC>\u0013'.Z2u\u0011!i\u0002A!b\u0001\n\u0003q\u0012\u0001\u00028b[\u0016,\u0012a\b\t\u0003A\rr!aF\u0011\n\u0005\tB\u0012A\u0002)sK\u0012,g-\u0003\u0002%K\t11\u000b\u001e:j]\u001eT!A\t\r\t\u0011\u001d\u0002!\u0011!Q\u0001\n}\tQA\\1nK\u0002B\u0001\"\u000b\u0001\u0003\u0006\u0004%\tAK\u0001\tu.\u001cE.[3oiV\t1\u0006\u0005\u0002-g5\tQF\u0003\u0002/_\u0005A!p[2mS\u0016tGO\u0003\u00021c\u00051\u0011\nM%uK\u000eT\u0011AM\u0001\u0004_J<\u0017B\u0001\u001b.\u0005!Q6n\u00117jK:$\b\u0002\u0003\u001c\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002\u0013i\\7\t\\5f]R\u0004\u0003\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011A\u001d\u0002\r\r|gNZ5h+\u0005Q\u0004CA\u001e=\u001b\u0005\u0011\u0011BA\u001f\u0003\u00059\u0019uN\\:v[\u0016\u00148i\u001c8gS\u001eD\u0001b\u0010\u0001\u0003\u0002\u0003\u0006IAO\u0001\bG>tg-[4!\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015A\u00022s_.,'/F\u0001D!\t!u)D\u0001F\u0015\t1E!A\u0004dYV\u001cH/\u001a:\n\u0005!+%A\u0002\"s_.,'\u000f\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003D\u0003\u001d\u0011'o\\6fe\u0002B\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t!T\u0001\u0014a\u0006\u0014H/\u001b;j_:$v\u000e]5d\u0013:4wn]\u000b\u0002\u001dB\u0019qj\u0016.\u000f\u0005A+fBA)U\u001b\u0005\u0011&BA*\u0007\u0003\u0019a$o\\8u}%\t\u0011$\u0003\u0002W1\u00059\u0001/Y2lC\u001e,\u0017B\u0001-Z\u0005\u0011a\u0015n\u001d;\u000b\u0005YC\u0002CA\u001e\\\u0013\ta&A\u0001\nQCJ$\u0018\u000e^5p]R{\u0007/[2J]\u001a|\u0007\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\u0002)A\f'\u000f^5uS>tGk\u001c9jG&sgm\\:!\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003\u0019a\u0014N\\5u}Q1!m\u00193fM\u001e\u0004\"a\u000f\u0001\t\u000buy\u0006\u0019A\u0010\t\u000b%z\u0006\u0019A\u0016\t\u000baz\u0006\u0019\u0001\u001e\t\u000b\u0005{\u0006\u0019A\"\t\u000b1{\u0006\u0019\u0001(\t\u000f%\u0004!\u0019!C\u0005U\u0006i1\u000f[;uI><h\u000eT1uG\",\u0012a\u001b\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f!bY8oGV\u0014(/\u001a8u\u0015\t\u0001H\"\u0001\u0003vi&d\u0017B\u0001:n\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"Da\u0001\u001e\u0001!\u0002\u0013Y\u0017AD:ikR$wn\u001e8MCR\u001c\u0007\u000e\t\u0005\bm\u0002\u0011\r\u0011\"\u0003x\u00039\u0019\u0018.\u001c9mK\u000e{gn];nKJ,\u0012\u0001\u001f\t\u0003weL!A\u001f\u0002\u0003\u001dMKW\u000e\u001d7f\u0007>t7/^7fe\"1A\u0010\u0001Q\u0001\na\fqb]5na2,7i\u001c8tk6,'\u000f\t\u0005\b}\u0002\u0001\r\u0011\"\u0003\u0000\u0003\u001d\u0019Ho\u001c9qK\u0012,\"!!\u0001\u0011\u0007]\t\u0019!C\u0002\u0002\u0006a\u0011qAQ8pY\u0016\fg\u000eC\u0005\u0002\n\u0001\u0001\r\u0011\"\u0003\u0002\f\u0005Y1\u000f^8qa\u0016$w\fJ3r)\u0011\ti!a\u0005\u0011\u0007]\ty!C\u0002\u0002\u0012a\u0011A!\u00168ji\"Q\u0011QCA\u0004\u0003\u0003\u0005\r!!\u0001\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0015BA\u0001\u0003!\u0019Ho\u001c9qK\u0012\u0004\u0003\u0006BA\f\u0003;\u00012aFA\u0010\u0013\r\t\t\u0003\u0007\u0002\tm>d\u0017\r^5mK\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0012\u0001C:ikR$wn\u001e8\u0015\u0005\u00055\u0001bBA\u0016\u0001\u0011\u0005\u0013qE\u0001\u0004eVt\u0007bBA\u0018\u0001\u0011%\u0011qE\u0001\u0011g\",H\u000fZ8x]\u000e{W\u000e\u001d7fi\u0016Dq!a\r\u0001\t\u0013\t)$\u0001\u000bsKN,GoQ8ogVlWM](gMN,Go\u001d\u000b\u0007\u0003o\ti$!\u0011\u0011\u0007]\tI$C\u0002\u0002<a\u0011A\u0001T8oO\"9\u0011qHA\u0019\u0001\u0004y\u0012!\u0002;pa&\u001c\u0007\u0002CA\"\u0003c\u0001\r!!\u0012\u0002\u0013A\f'\u000f^5uS>t\u0007c\u0001#\u0002H%\u0019\u0011\u0011J#\u0003\u0013A\u000b'\u000f^5uS>t\u0007")
public class FetcherRunnable
extends Thread
implements Logging {
    private final String name;
    private final ZkClient zkClient;
    private final ConsumerConfig config;
    private final Broker broker;
    private final List<PartitionTopicInfo> partitionTopicInfos;
    private final CountDownLatch shutdownLatch;
    private final SimpleConsumer kafka$consumer$FetcherRunnable$$simpleConsumer;
    private volatile boolean kafka$consumer$FetcherRunnable$$stopped;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        FetcherRunnable fetcherRunnable = this;
        synchronized (fetcherRunnable) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String name() {
        return this.name;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public ConsumerConfig config() {
        return this.config;
    }

    public Broker broker() {
        return this.broker;
    }

    public List<PartitionTopicInfo> partitionTopicInfos() {
        return this.partitionTopicInfos;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    public final SimpleConsumer kafka$consumer$FetcherRunnable$$simpleConsumer() {
        return this.kafka$consumer$FetcherRunnable$$simpleConsumer;
    }

    public final boolean kafka$consumer$FetcherRunnable$$stopped() {
        return this.kafka$consumer$FetcherRunnable$$stopped;
    }

    private void kafka$consumer$FetcherRunnable$$stopped_$eq(boolean bl) {
        this.kafka$consumer$FetcherRunnable$$stopped = bl;
    }

    public void shutdown() {
        this.kafka$consumer$FetcherRunnable$$stopped_$eq(true);
        this.interrupt();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final FetcherRunnable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"awaiting shutdown on fetcher ").append((Object)this.$outer.name()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.shutdownLatch().await();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final FetcherRunnable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"shutdown of fetcher ").append((Object)this.$outer.name()).append((Object)" thread complete").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }

    @Override
    public void run() {
        this.partitionTopicInfos().foreach(new Serializable(this){
            public static final long serialVersionUID;
            private final FetcherRunnable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(PartitionTopicInfo infopti$1) {
                this.$outer.info((Function0<String>)((Object)new Serializable(this, infopti$1){
                    public static final long serialVersionUID;
                    private final $anonfun$run$2 $outer;
                    private final PartitionTopicInfo infopti$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)this.$outer.kafka$consumer$FetcherRunnable$$anonfun$$$outer().name()).append((Object)" start fetching topic: ").append((Object)this.infopti$1.topic()).append((Object)" part: ").append(BoxesRunTime.boxToInteger(this.infopti$1.partition().partId())).append((Object)" offset: ").append(BoxesRunTime.boxToLong(this.infopti$1.getFetchOffset())).append((Object)" from ").append((Object)this.$outer.kafka$consumer$FetcherRunnable$$anonfun$$$outer().broker().host()).append((Object)":").append(BoxesRunTime.boxToInteger(this.$outer.kafka$consumer$FetcherRunnable$$anonfun$$$outer().broker().port())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.infopti$1 = partitionTopicInfo;
                    }
                }));
            }

            public FetcherRunnable kafka$consumer$FetcherRunnable$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        try {
            while (!this.kafka$consumer$FetcherRunnable$$stopped()) {
                List<FetchRequest> fetches$1 = this.partitionTopicInfos().map(new Serializable(this){
                    public static final long serialVersionUID;
                    private final FetcherRunnable $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final FetchRequest apply(PartitionTopicInfo info) {
                        return new FetchRequest(info.topic(), info.partition().partId(), info.getFetchOffset(), this.$outer.config().fetchSize());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, List$.MODULE$.canBuildFrom());
                this.trace((Function0<String>)((Object)new Serializable(this, fetches$1){
                    public static final long serialVersionUID;
                    private final List fetches$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"fetch request: ").append((Object)this.fetches$1.toString()).toString();
                    }
                    {
                        this.fetches$1 = list2;
                    }
                }));
                MultiFetchResponse response = this.kafka$consumer$FetcherRunnable$$simpleConsumer().multifetch(fetches$1);
                this.trace((Function0<String>)((Object)new Serializable(this, fetches$1){
                    public static final long serialVersionUID;
                    private final List fetches$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"recevied response from fetch request: ").append((Object)this.fetches$1.toString()).toString();
                    }
                    {
                        this.fetches$1 = list2;
                    }
                }));
                LongRef read$1 = new LongRef(0L);
                ((IterableLike)((TraversableLike)response.zip(this.partitionTopicInfos(), Iterable$.MODULE$.canBuildFrom())).filter(new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Tuple2<ByteBufferMessageSet, PartitionTopicInfo> tuple2) {
                        Tuple2<ByteBufferMessageSet, PartitionTopicInfo> tuple22 = tuple2;
                        return tuple22 != null;
                    }
                })).foreach(new Serializable(this, read$1){
                    public static final long serialVersionUID;
                    private final FetcherRunnable $outer;
                    private final LongRef read$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final void apply(Tuple2<ByteBufferMessageSet, PartitionTopicInfo> tuple2) {
                        Tuple2<ByteBufferMessageSet, PartitionTopicInfo> tuple22 = tuple2;
                        if (tuple22 == null) throw new MatchError(tuple22);
                        ByteBufferMessageSet byteBufferMessageSet = tuple22._1();
                        PartitionTopicInfo partitionTopicInfo = tuple22._2();
                        ByteBufferMessageSet messages = byteBufferMessageSet;
                        PartitionTopicInfo infopti$2 = partitionTopicInfo;
                        try {
                            boolean done = false;
                            if (messages.getErrorCode() == ErrorMapping$.MODULE$.OffsetOutOfRangeCode()) {
                                this.$outer.info((Function0<String>)((Object)new Serializable(this, infopti$2){
                                    public static final long serialVersionUID;
                                    private final PartitionTopicInfo infopti$2;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"offset for ").append(this.infopti$2).append((Object)" out of range").toString();
                                    }
                                    {
                                        this.infopti$2 = partitionTopicInfo;
                                    }
                                }));
                                long resetOffset = this.$outer.kafka$consumer$FetcherRunnable$$resetConsumerOffsets(infopti$2.topic(), infopti$2.partition());
                                if (resetOffset >= 0L) {
                                    infopti$2.resetFetchOffset(resetOffset);
                                    infopti$2.resetConsumeOffset(resetOffset);
                                    return;
                                }
                            }
                            if (done) return;
                            this.read$1.elem += infopti$2.enqueue(messages, infopti$2.getFetchOffset());
                            return;
                        }
                        catch (Throwable throwable) {
                            if (this.$outer.kafka$consumer$FetcherRunnable$$stopped()) throw throwable;
                            this.$outer.error((Function0<String>)((Object)new Serializable(this, infopti$2){
                                public static final long serialVersionUID;
                                private final PartitionTopicInfo infopti$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return new StringBuilder().append((Object)"error in FetcherRunnable for ").append(this.infopti$2).toString();
                                }
                                {
                                    this.infopti$2 = partitionTopicInfo;
                                }
                            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                                public static final long serialVersionUID;
                                private final Throwable e2$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Throwable apply() {
                                    return this.e2$1;
                                }
                                {
                                    this.e2$1 = throwable;
                                }
                            }));
                            infopti$2.enqueueError(throwable, infopti$2.getFetchOffset());
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            throw iOException;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.read$1 = longRef;
                    }
                });
                this.trace((Function0<String>)((Object)new Serializable(this, read$1){
                    public static final long serialVersionUID;
                    private final LongRef read$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"fetched bytes: ").append(BoxesRunTime.boxToLong(this.read$1.elem)).toString();
                    }
                    {
                        this.read$1 = longRef;
                    }
                }));
                if (read$1.elem != 0L) continue;
                this.debug((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final FetcherRunnable $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"backing off ").append(BoxesRunTime.boxToLong(this.$outer.config().fetcherBackoffMs())).append((Object)" ms").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
                Thread.sleep(this.config().fetcherBackoffMs());
            }
        }
        catch (Throwable throwable) {
            if (this.kafka$consumer$FetcherRunnable$$stopped()) {
                this.info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;
                    private final FetcherRunnable $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"FecherRunnable ").append(this.$outer).append((Object)" interrupted").toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            this.error((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "error in FetcherRunnable ";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID;
                private final Throwable e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = throwable;
                }
            }));
        }
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final FetcherRunnable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"stopping fetcher ").append((Object)this.$outer.name()).append((Object)" to host ").append((Object)this.$outer.broker().host()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        Utils$.MODULE$.swallow((Function2<Object, Throwable, BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final FetcherRunnable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Object object, Throwable throwable) {
                this.$outer.logger().info(object, throwable);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }), (Function0<BoxedUnit>)((Object)new Serializable(this){
            public static final long serialVersionUID;
            private final FetcherRunnable $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.kafka$consumer$FetcherRunnable$$simpleConsumer().close();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.shutdownComplete();
    }

    private void shutdownComplete() {
        this.shutdownLatch().countDown();
    }

    public final long kafka$consumer$FetcherRunnable$$resetConsumerOffsets(String topic$1, Partition partition$1) {
        block4: {
            LongRef offset$1;
            block3: {
                String string2;
                block2: {
                    offset$1 = new LongRef(0L);
                    string2 = this.config().autoOffsetReset();
                    String string3 = OffsetRequest$.MODULE$.SmallestTimeString();
                    String string4 = string2;
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block2;
                    offset$1.elem = OffsetRequest$.MODULE$.EarliestTime();
                    break block3;
                }
                String string5 = OffsetRequest$.MODULE$.LargestTimeString();
                String string6 = string2;
                if (string5 != null ? !string5.equals(string6) : string6 != null) break block4;
                offset$1.elem = OffsetRequest$.MODULE$.LatestTime();
            }
            long[] offsets$1 = this.kafka$consumer$FetcherRunnable$$simpleConsumer().getOffsetsBefore(topic$1, partition$1.partId(), offset$1.elem, 1);
            ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(this.config().groupId(), topic$1);
            this.info((Function0<String>)((Object)new Serializable(this, topic$1, partition$1, offset$1, offsets$1){
                public static final long serialVersionUID;
                private final String topic$1;
                private final Partition partition$1;
                private final LongRef offset$1;
                private final long[] offsets$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"updating partition ").append((Object)this.partition$1.name()).append((Object)" for topic ").append((Object)this.topic$1).append((Object)" with ").append((Object)(this.offset$1.elem == OffsetRequest$.MODULE$.EarliestTime() ? "earliest " : " latest ")).append((Object)"offset ").append(BoxesRunTime.boxToLong(this.offsets$1[0])).toString();
                }
                {
                    this.topic$1 = string2;
                    this.partition$1 = partition2;
                    this.offset$1 = longRef;
                    this.offsets$1 = lArray;
                }
            }));
            ZkUtils$.MODULE$.updatePersistentPath(this.zkClient(), new StringBuilder().append((Object)topicDirs.consumerOffsetDir()).append((Object)"/").append((Object)partition$1.name()).toString(), ((Object)BoxesRunTime.boxToLong(offsets$1[0])).toString());
            return offsets$1[0];
        }
        return -1L;
    }

    public FetcherRunnable(String name, ZkClient zkClient, ConsumerConfig config, Broker broker, List<PartitionTopicInfo> partitionTopicInfos) {
        this.name = name;
        this.zkClient = zkClient;
        this.config = config;
        this.broker = broker;
        this.partitionTopicInfos = partitionTopicInfos;
        super(name);
        Logging$class.$init$(this);
        this.shutdownLatch = new CountDownLatch(1);
        this.kafka$consumer$FetcherRunnable$$simpleConsumer = new SimpleConsumer(broker.host(), broker.port(), config.socketTimeoutMs(), config.socketBufferSize());
        this.kafka$consumer$FetcherRunnable$$stopped = false;
    }
}

