/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.ConsumerTopicStat$;
import kafka.consumer.FetchedDataChunk;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.ZookeeperConsumerConnector$;
import kafka.message.MessageAndMetadata;
import kafka.message.MessageAndOffset;
import kafka.serializer.Decoder;
import kafka.utils.IteratorTemplate;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cQ8ogVlWM]%uKJ\fGo\u001c:\u000b\u0005\r!\u0011\u0001C2p]N,X.\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!\u0006\u0002\t/M!\u0001!C\u0012'!\rQQbD\u0007\u0002\u0017)\u0011A\u0002B\u0001\u0006kRLGn]\u0005\u0003\u001d-\u0011\u0001#\u0013;fe\u0006$xN\u001d+f[Bd\u0017\r^3\u0011\u0007A\u0019R#D\u0001\u0012\u0015\t\u0011B!A\u0004nKN\u001c\u0018mZ3\n\u0005Q\t\"AE'fgN\fw-Z!oI6+G/\u00193bi\u0006\u0004\"AF\f\r\u0001\u0011)\u0001\u0004\u0001b\u00013\t\tA+\u0005\u0002\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t9aj\u001c;iS:<\u0007CA\u000e\"\u0013\t\u0011CDA\u0002B]f\u0004\"A\u0003\u0013\n\u0005\u0015Z!a\u0002'pO\u001eLgn\u001a\t\u00037\u001dJ!\u0001\u000b\u000f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\tU\u0001\u0011)\u0019!C\u0005W\u000591\r[1o]\u0016dW#\u0001\u0017\u0011\u00075\"d'D\u0001/\u0015\ty\u0003'\u0001\u0006d_:\u001cWO\u001d:f]RT!!\r\u001a\u0002\tU$\u0018\u000e\u001c\u0006\u0002g\u0005!!.\u0019<b\u0013\t)dFA\u0007CY>\u001c7.\u001b8h#V,W/\u001a\t\u0003oaj\u0011AA\u0005\u0003s\t\u0011\u0001CR3uG\",G\rR1uC\u000eCWO\\6\t\u0011m\u0002!\u0011!Q\u0001\n1\n\u0001b\u00195b]:,G\u000e\t\u0005\t{\u0001\u0011\t\u0011)A\u0005}\u0005\t2m\u001c8tk6,'\u000fV5nK>,H/T:\u0011\u0005my\u0014B\u0001!\u001d\u0005\rIe\u000e\u001e\u0005\t\u0005\u0002\u0011)\u0019!C\u0005\u0007\u00069A-Z2pI\u0016\u0014X#\u0001#\u0011\u0007\u0015CU#D\u0001G\u0015\t9E!\u0001\u0006tKJL\u0017\r\\5{KJL!!\u0013$\u0003\u000f\u0011+7m\u001c3fe\"A1\n\u0001B\u0001B\u0003%A)\u0001\u0005eK\u000e|G-\u001a:!\u0011!i\u0005A!b\u0001\n\u0003q\u0015!F3oC\ndWm\u00155bY2|w/\u0013;fe\u0006$xN]\u000b\u0002\u001fB\u00111\u0004U\u0005\u0003#r\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003P\u0003Y)g.\u00192mKNC\u0017\r\u001c7po&#XM]1u_J\u0004\u0003\"B+\u0001\t\u00031\u0016A\u0002\u001fj]&$h\bF\u0003X1fS6\fE\u00028\u0001UAQA\u000b+A\u00021BQ!\u0010+A\u0002yBQA\u0011+A\u0002\u0011CQ!\u0014+A\u0002=Cq!\u0018\u0001A\u0002\u0013%a,A\u0004dkJ\u0014XM\u001c;\u0016\u0003}\u00032\u0001Y2f\u001b\u0005\t'B\u00012/\u0003\u0019\tGo\\7jG&\u0011A-\u0019\u0002\u0010\u0003R|W.[2SK\u001a,'/\u001a8dKB\u0019aM\\9\u000f\u0005\u001ddgB\u00015l\u001b\u0005I'B\u00016\u0007\u0003\u0019a$o\\8u}%\tQ$\u0003\u0002n9\u00059\u0001/Y2lC\u001e,\u0017BA8q\u0005!IE/\u001a:bi>\u0014(BA7\u001d!\t\u0001\"/\u0003\u0002t#\t\u0001R*Z:tC\u001e,\u0017I\u001c3PM\u001a\u001cX\r\u001e\u0005\bk\u0002\u0001\r\u0011\"\u0003w\u0003-\u0019WO\u001d:f]R|F%Z9\u0015\u0005]T\bCA\u000ey\u0013\tIHD\u0001\u0003V]&$\bbB>u\u0003\u0003\u0005\raX\u0001\u0004q\u0012\n\u0004BB?\u0001A\u0003&q,\u0001\u0005dkJ\u0014XM\u001c;!\u0011!y\b\u00011A\u0005\n\u0005\u0005\u0011\u0001E2veJ,g\u000e\u001e+pa&\u001c\u0017J\u001c4p+\t\t\u0019\u0001E\u00028\u0003\u000bI1!a\u0002\u0003\u0005I\u0001\u0016M\u001d;ji&|g\u000eV8qS\u000eLeNZ8\t\u0013\u0005-\u0001\u00011A\u0005\n\u00055\u0011\u0001F2veJ,g\u000e\u001e+pa&\u001c\u0017J\u001c4p?\u0012*\u0017\u000fF\u0002x\u0003\u001fA\u0011b_A\u0005\u0003\u0003\u0005\r!a\u0001\t\u0011\u0005M\u0001\u0001)Q\u0005\u0003\u0007\t\u0011cY;se\u0016tG\u000fV8qS\u000eLeNZ8!\u0011%\t9\u0002\u0001a\u0001\n\u0013\tI\"\u0001\bd_:\u001cX/\\3e\u001f\u001a47/\u001a;\u0016\u0005\u0005m\u0001cA\u000e\u0002\u001e%\u0019\u0011q\u0004\u000f\u0003\t1{gn\u001a\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003K\t!cY8ogVlW\rZ(gMN,Go\u0018\u0013fcR\u0019q/a\n\t\u0013m\f\t#!AA\u0002\u0005m\u0001\u0002CA\u0016\u0001\u0001\u0006K!a\u0007\u0002\u001f\r|gn];nK\u0012|eMZ:fi\u0002Bq!a\f\u0001\t\u0003\n\t$\u0001\u0003oKb$H#A\b\t\u000f\u0005U\u0002\u0001\"\u0005\u00022\u0005AQ.Y6f\u001d\u0016DH\u000fC\u0004\u0002:\u0001!\t!a\u000f\u0002#\rdW-\u0019:DkJ\u0014XM\u001c;DQVt7\u000eF\u0001x\u0001")
public class ConsumerIterator<T>
extends IteratorTemplate<MessageAndMetadata<T>>
implements Logging,
ScalaObject {
    private final BlockingQueue<FetchedDataChunk> channel;
    private final int consumerTimeoutMs;
    private final Decoder<T> decoder;
    private final boolean enableShallowIterator;
    private AtomicReference<Iterator<MessageAndOffset>> current;
    private PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo;
    private long kafka$consumer$ConsumerIterator$$consumedOffset;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsumerIterator consumerIterator = this;
        synchronized (consumerIterator) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    private BlockingQueue<FetchedDataChunk> channel() {
        return this.channel;
    }

    private Decoder<T> decoder() {
        return this.decoder;
    }

    public boolean enableShallowIterator() {
        return this.enableShallowIterator;
    }

    private AtomicReference<Iterator<MessageAndOffset>> current() {
        return this.current;
    }

    private void current_$eq(AtomicReference<Iterator<MessageAndOffset>> atomicReference) {
        this.current = atomicReference;
    }

    public final PartitionTopicInfo kafka$consumer$ConsumerIterator$$currentTopicInfo() {
        return this.kafka$consumer$ConsumerIterator$$currentTopicInfo;
    }

    private void kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(PartitionTopicInfo partitionTopicInfo) {
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = partitionTopicInfo;
    }

    public final long kafka$consumer$ConsumerIterator$$consumedOffset() {
        return this.kafka$consumer$ConsumerIterator$$consumedOffset;
    }

    private void kafka$consumer$ConsumerIterator$$consumedOffset_$eq(long l) {
        this.kafka$consumer$ConsumerIterator$$consumedOffset = l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MessageAndMetadata<T> next() {
        void var1_1;
        MessageAndMetadata item = (MessageAndMetadata)super.next();
        if (this.kafka$consumer$ConsumerIterator$$consumedOffset() < 0L) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("Offset returned by the message set is invalid %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.kafka$consumer$ConsumerIterator$$consumedOffset())})));
        }
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(this.kafka$consumer$ConsumerIterator$$consumedOffset());
        String topic$1 = this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic();
        this.trace((Function0<String>)((Object)new Serializable(this, topic$1){
            public static final long serialVersionUID;
            private final ConsumerIterator $outer;
            private final String topic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Setting %s consumed offset to %d").format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToLong(this.$outer.kafka$consumer$ConsumerIterator$$consumedOffset())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.topic$1 = consumerIterator;
            }
        }));
        ConsumerTopicStat$.MODULE$.getConsumerTopicStat(topic$1).recordMessagesPerTopic(1);
        ConsumerTopicStat$.MODULE$.getConsumerAllTopicStat().recordMessagesPerTopic(1);
        return var1_1;
    }

    @Override
    public MessageAndMetadata<T> makeNext() {
        ObjectRef currentDataChunk$1 = new ObjectRef(null);
        Iterator<MessageAndOffset> localCurrent = this.current().get();
        if (localCurrent == null || !localCurrent.hasNext()) {
            if (this.consumerTimeoutMs < 0) {
                currentDataChunk$1.elem = this.channel().take();
            } else {
                currentDataChunk$1.elem = this.channel().poll(this.consumerTimeoutMs, TimeUnit.MILLISECONDS);
                if ((FetchedDataChunk)currentDataChunk$1.elem == null) {
                    this.resetState();
                    throw new ConsumerTimeoutException();
                }
            }
            if ((FetchedDataChunk)currentDataChunk$1.elem == ZookeeperConsumerConnector$.MODULE$.shutdownCommand()) {
                this.debug((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return "Received the shutdown command";
                    }
                }));
                this.channel().offer((FetchedDataChunk)currentDataChunk$1.elem);
                return (MessageAndMetadata)this.allDone();
            }
            this.kafka$consumer$ConsumerIterator$$currentTopicInfo_$eq(((FetchedDataChunk)currentDataChunk$1.elem).topicInfo());
            if (this.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset() != ((FetchedDataChunk)currentDataChunk$1.elem).fetchOffset()) {
                this.error((Function0<String>)((Object)new Serializable(this, currentDataChunk$1){
                    public static final long serialVersionUID;
                    private final ConsumerIterator $outer;
                    private final ObjectRef currentDataChunk$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("consumed offset: %d doesn't match fetch offset: %d for %s;\n Consumer may lose data").format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.kafka$consumer$ConsumerIterator$$currentTopicInfo().getConsumeOffset()), BoxesRunTime.boxToLong(((FetchedDataChunk)this.currentDataChunk$1.elem).fetchOffset()), this.$outer.kafka$consumer$ConsumerIterator$$currentTopicInfo()}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.currentDataChunk$1 = consumerIterator;
                    }
                }));
                this.kafka$consumer$ConsumerIterator$$currentTopicInfo().resetConsumeOffset(((FetchedDataChunk)currentDataChunk$1.elem).fetchOffset());
            }
            localCurrent = this.enableShallowIterator() ? ((FetchedDataChunk)currentDataChunk$1.elem).messages().shallowIterator() : ((FetchedDataChunk)currentDataChunk$1.elem).messages().iterator();
            this.current().set(localCurrent);
        }
        MessageAndOffset item = localCurrent.next();
        this.kafka$consumer$ConsumerIterator$$consumedOffset_$eq(item.offset());
        return new MessageAndMetadata<T>(this.decoder().toEvent(item.message()), this.kafka$consumer$ConsumerIterator$$currentTopicInfo().topic());
    }

    public void clearCurrentChunk() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return "Clearing the current data chunk for this consumer iterator";
            }
        }));
        this.current().set(null);
    }

    public ConsumerIterator(BlockingQueue<FetchedDataChunk> channel, int consumerTimeoutMs, Decoder<T> decoder2, boolean enableShallowIterator) {
        this.channel = channel;
        this.consumerTimeoutMs = consumerTimeoutMs;
        this.decoder = decoder2;
        this.enableShallowIterator = enableShallowIterator;
        Logging$class.$init$(this);
        this.current = new AtomicReference<Object>(null);
        this.kafka$consumer$ConsumerIterator$$currentTopicInfo = null;
        this.kafka$consumer$ConsumerIterator$$consumedOffset = -1L;
    }
}

