/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import java.io.OutputStream;
import java.util.Properties;
import java.util.Random;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.Blacklist;
import kafka.consumer.ConsoleConsumer;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.consumer.TopicFilter;
import kafka.consumer.Whitelist;
import kafka.message.Message;
import kafka.message.MessageAndMetadata;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.JavaConversions$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ConsoleConsumer$
implements Logging {
    public static final ConsoleConsumer$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    public volatile int bitmap$0;

    static {
        new ConsoleConsumer$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ConsoleConsumer$ consoleConsumer$ = this;
        synchronized (consoleConsumer$) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string2) {
        this.logIdent = string2;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string2) {
        this.loggerName = string2;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec topicIdOpt = parser.accepts("topic", "The topic id to consume on.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec whitelistOpt = parser.accepts("whitelist", "Whitelist of topics to include for consumption.").withRequiredArg().describedAs("whitelist").ofType(String.class);
        ArgumentAcceptingOptionSpec blacklistOpt = parser.accepts("blacklist", "Blacklist of topics to exclude from consumption.").withRequiredArg().describedAs("blacklist").ofType(String.class);
        ArgumentAcceptingOptionSpec zkConnectOpt$1 = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        ArgumentAcceptingOptionSpec groupIdOpt$1 = parser.accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo((Object)new StringBuilder().append((Object)"console-consumer-").append(BoxesRunTime.boxToInteger(new Random().nextInt(100000))).toString(), (Object[])new String[0]).ofType(String.class);
        ArgumentAcceptingOptionSpec fetchSizeOpt = parser.accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x100000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec socketBufferSizeOpt = parser.accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(0x200000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec consumerTimeoutMsOpt = parser.accepts("consumer-timeout-ms", "consumer throws timeout exception after waiting this much of time without incoming messages").withRequiredArg().describedAs("prop").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(-1), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec messageFormatterOpt = parser.accepts("formatter", "The name of a class to use for formatting kafka messages for display.").withRequiredArg().describedAs("class").ofType(String.class).defaultsTo((Object)ConsoleConsumer.NewlineMessageFormatter.class.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec messageFormatterArgOpt = parser.accepts("property").withRequiredArg().describedAs("prop").ofType(String.class);
        OptionSpecBuilder resetBeginningOpt = parser.accepts("from-beginning", "If the consumer does not already have an established offset to consume from, start with the earliest message present in the log rather than the latest message.");
        ArgumentAcceptingOptionSpec autoCommitIntervalOpt = parser.accepts("autocommit.interval.ms", "The time interval at which to save the current offset in ms").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(10000), (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec maxMessagesOpt = parser.accepts("max-messages", "The maximum number of messages to consume before exiting. If not set, consumption is continual.").withRequiredArg().describedAs("num_messages").ofType(Integer.class);
        OptionSpecBuilder skipMessageOnErrorOpt = parser.accepts("skip-message-on-error", "If there is an error when processing a message, skip it instead of halt.");
        OptionSet options$1 = this.tryParse(parser, args);
        Utils$.MODULE$.checkRequiredArgs(parser, options$1, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt$1}));
        List topicOrFilterOpt = (List)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new ArgumentAcceptingOptionSpec[]{topicIdOpt, whitelistOpt, blacklistOpt})).filter(new Serializable(options$1){
            public static final long serialVersionUID;
            private final OptionSet options$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(OptionSpec<?> optionSpec) {
                return this.options$1.has(optionSpec);
            }
            {
                this.options$1 = optionSet;
            }
        });
        if (topicOrFilterOpt.size() != 1) {
            this.error((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Exactly one of whitelist/blacklist/topic is required.";
                }
            }));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String topicArg = (String)options$1.valueOf((OptionSpec)topicOrFilterOpt.head());
        TopicFilter filterSpec = options$1.has((OptionSpec)blacklistOpt) ? new Blacklist(topicArg) : new Whitelist(topicArg);
        Properties props = new Properties();
        props.put("groupid", options$1.valueOf((OptionSpec)groupIdOpt$1));
        props.put("socket.buffersize", ((Integer)options$1.valueOf((OptionSpec)socketBufferSizeOpt)).toString());
        props.put("fetch.size", ((Integer)options$1.valueOf((OptionSpec)fetchSizeOpt)).toString());
        props.put("auto.commit", "true");
        props.put("autocommit.interval.ms", ((Integer)options$1.valueOf((OptionSpec)autoCommitIntervalOpt)).toString());
        props.put("autooffset.reset", options$1.has((OptionSpec)resetBeginningOpt) ? "smallest" : "largest");
        props.put("zk.connect", options$1.valueOf((OptionSpec)zkConnectOpt$1));
        props.put("consumer.timeout.ms", ((Integer)options$1.valueOf((OptionSpec)consumerTimeoutMsOpt)).toString());
        ConsumerConfig config = new ConsumerConfig(props);
        boolean skipMessageOnError$1 = options$1.has((OptionSpec)skipMessageOnErrorOpt);
        Class<?> messageFormatterClass = Class.forName((String)options$1.valueOf((OptionSpec)messageFormatterOpt));
        Properties formatterArgs = this.tryParseFormatterArgs(JavaConversions$.MODULE$.asScalaBuffer(options$1.valuesOf((OptionSpec)messageFormatterArgOpt)));
        int maxMessages = options$1.has((OptionSpec)maxMessagesOpt) ? (Integer)options$1.valueOf((OptionSpec)maxMessagesOpt) : -1;
        ConsumerConnector connector$1 = Consumer$.MODULE$.create(config);
        if (options$1.has((OptionSpec)resetBeginningOpt)) {
            this.tryCleanupZookeeper((String)options$1.valueOf((OptionSpec)zkConnectOpt$1), (String)options$1.valueOf((OptionSpec)groupIdOpt$1));
        }
        Runtime.getRuntime().addShutdownHook(new Thread(zkConnectOpt$1, groupIdOpt$1, options$1, connector$1){
            private final ArgumentAcceptingOptionSpec zkConnectOpt$1;
            private final ArgumentAcceptingOptionSpec groupIdOpt$1;
            private final OptionSet options$1;
            private final ConsumerConnector connector$1;

            public void run() {
                this.connector$1.shutdown();
                if (!this.options$1.has((OptionSpec)this.groupIdOpt$1)) {
                    ConsoleConsumer$.MODULE$.tryCleanupZookeeper((String)this.options$1.valueOf((OptionSpec)this.zkConnectOpt$1), (String)this.options$1.valueOf((OptionSpec)this.groupIdOpt$1));
                }
            }
            {
                this.zkConnectOpt$1 = argumentAcceptingOptionSpec;
                this.groupIdOpt$1 = argumentAcceptingOptionSpec2;
                this.options$1 = optionSet;
                this.connector$1 = consumerConnector;
            }
        });
        KafkaStream<Message> stream = JavaConversions$.MODULE$.seqAsJavaList(connector$1.createMessageStreamsByFilter(filterSpec, connector$1.createMessageStreamsByFilter$default$2(), connector$1.createMessageStreamsByFilter$default$3())).get(0);
        KafkaStream<Message> iter2 = maxMessages >= 0 ? (Iterable)stream.slice(0, maxMessages) : stream;
        ConsoleConsumer.MessageFormatter formatter$1 = (ConsoleConsumer.MessageFormatter)messageFormatterClass.newInstance();
        formatter$1.init(formatterArgs);
        try {
            iter2.foreach(new Serializable(skipMessageOnError$1, connector$1, formatter$1){
                public static final long serialVersionUID;
                private final boolean skipMessageOnError$1;
                private final ConsumerConnector connector$1;
                private final ConsoleConsumer.MessageFormatter formatter$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(MessageAndMetadata<Message> messageAndTopic) {
                    Throwable throwable2;
                    block3: {
                        try {
                            this.formatter$1.writeTo(messageAndTopic.message(), System.out);
                        }
                        catch (Throwable throwable2) {
                            if (!this.skipMessageOnError$1) break block3;
                            ConsoleConsumer$.MODULE$.error((Function0<String>)((Object)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return "Error processing message, skipping this message: ";
                                }
                            }), (Function0<Throwable>)((Object)new Serializable(this, throwable2){
                                public static final long serialVersionUID;
                                private final Throwable e$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final Throwable apply() {
                                    return this.e$1;
                                }
                                {
                                    this.e$1 = throwable;
                                }
                            }));
                        }
                        if (System.out.checkError()) {
                            System.err.println("Unable to write to standard out, closing consumer.");
                            this.formatter$1.close();
                            this.connector$1.shutdown();
                            System.exit(1);
                        }
                        return;
                    }
                    throw throwable2;
                }
                {
                    this.skipMessageOnError$1 = bl;
                    this.connector$1 = consumerConnector;
                    this.formatter$1 = messageFormatter;
                }
            });
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Error processing message, stopping consumer: ";
                }
            }), (Function0<Throwable>)((Object)new Serializable(throwable){
                public static final long serialVersionUID;
                private final Throwable e$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Throwable apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = throwable;
                }
            }));
        }
        System.out.flush();
        formatter$1.close();
        connector$1.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public OptionSet tryParse(OptionParser parser, String[] args) {
        void var3_3;
        OptionSet exceptionResult1 = null;
        try {
            exceptionResult1 = parser.parse(args);
        }
        catch (OptionException optionException) {
            Utils$.MODULE$.croak(optionException.getMessage());
            exceptionResult1 = null;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Properties tryParseFormatterArgs(scala.collection.mutable.Iterable<String> args) {
        void var3_3;
        scala.collection.mutable.Iterable splits = (scala.collection.mutable.Iterable)((TraversableLike)((TraversableLike)args.map(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String[] apply(String string2) {
                return string2.split("=");
            }
        }, Iterable$.MODULE$.canBuildFrom())).filterNot(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray == null;
            }
        })).filterNot(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray.length == 0;
            }
        });
        if (!splits.forall(new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(String[] stringArray) {
                return stringArray.length == 2;
            }
        })) {
            System.err.println(new StringBuilder().append((Object)"Invalid parser arguments: ").append((Object)args.mkString(" ")).toString());
            System.exit(1);
        }
        Properties props$1 = new Properties();
        splits.foreach(new Serializable(props$1){
            public static final long serialVersionUID;
            private final Properties props$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Object apply(String[] a) {
                return this.props$1.put(a[0], a[1]);
            }
            {
                this.props$1 = properties;
            }
        });
        return var3_3;
    }

    public void tryCleanupZookeeper(String zkUrl, String groupId) {
        try {
            String dir$1 = new StringBuilder().append((Object)"/consumers/").append((Object)groupId).toString();
            this.info((Function0<String>)((Object)new Serializable(dir$1){
                public static final long serialVersionUID;
                private final String dir$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Cleaning up temporary zookeeper data under ").append((Object)this.dir$1).append((Object)".").toString();
                }
                {
                    this.dir$1 = string2;
                }
            }));
            ZkClient zk = new ZkClient(zkUrl, 30000, 30000, ZKStringSerializer$.MODULE$);
            zk.deleteRecursive(dir$1);
            zk.close();
        }
        catch (Throwable throwable) {}
    }

    private ConsoleConsumer$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

