/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import kafka.api.ProducerRequest$;
import kafka.api.RequestKeys$;
import kafka.message.ByteBufferMessageSet;
import kafka.network.Request;
import kafka.utils.Utils$;
import scala.Function1;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001}<Q!\u0001\u0002\t\u0006\u001d\tq\u0002\u0015:pIV\u001cWM\u001d*fcV,7\u000f\u001e\u0006\u0003\u0007\u0011\t1!\u00199j\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA)a\u0003\u0002\u0010!J|G-^2feJ+\u0017/^3tiN\u0019\u0011\u0002\u0004\u000b\u0011\u00055\u0011R\"\u0001\b\u000b\u0005=\u0001\u0012\u0001\u00027b]\u001eT\u0011!E\u0001\u0005U\u00064\u0018-\u0003\u0002\u0014\u001d\t1qJ\u00196fGR\u0004\"!\u0006\r\u000e\u0003YQ\u0011aF\u0001\u0006g\u000e\fG.Y\u0005\u00033Y\u00111bU2bY\u0006|%M[3di\")1$\u0003C\u00019\u00051A(\u001b8jiz\"\u0012a\u0002\u0005\b=%\u0011\r\u0011\"\u0001 \u0003=\u0011\u0016M\u001c3p[B\u000b'\u000f^5uS>tW#\u0001\u0011\u0011\u0005U\t\u0013B\u0001\u0012\u0017\u0005\rIe\u000e\u001e\u0005\u0007I%\u0001\u000b\u0011\u0002\u0011\u0002!I\u000bg\u000eZ8n!\u0006\u0014H/\u001b;j_:\u0004\u0003\"\u0002\u0014\n\t\u00039\u0013\u0001\u0003:fC\u00124%o\\7\u0015\u0005!r\bC\u0001\u0005*\r\u0011Q!\u0001\u0001\u0016\u0014\u0007%ZC\u0003\u0005\u0002-_5\tQF\u0003\u0002/\t\u00059a.\u001a;x_J\\\u0017B\u0001\u0019.\u0005\u001d\u0011V-];fgRD\u0001BM\u0015\u0003\u0006\u0004%\taM\u0001\u0006i>\u0004\u0018nY\u000b\u0002iA\u0011Q\u0007\u000f\b\u0003+YJ!a\u000e\f\u0002\rA\u0013X\rZ3g\u0013\tI$H\u0001\u0004TiJLgn\u001a\u0006\u0003oYA\u0001\u0002P\u0015\u0003\u0002\u0003\u0006I\u0001N\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u0011yJ#Q1A\u0005\u0002}\t\u0011\u0002]1si&$\u0018n\u001c8\t\u0011\u0001K#\u0011!Q\u0001\n\u0001\n!\u0002]1si&$\u0018n\u001c8!\u0011!\u0011\u0015F!b\u0001\n\u0003\u0019\u0015\u0001C7fgN\fw-Z:\u0016\u0003\u0011\u0003\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0003\u0002\u000f5,7o]1hK&\u0011\u0011J\u0012\u0002\u0015\u0005f$XMQ;gM\u0016\u0014X*Z:tC\u001e,7+\u001a;\t\u0011-K#\u0011!Q\u0001\n\u0011\u000b\u0011\"\\3tg\u0006<Wm\u001d\u0011\t\u000bmIC\u0011A'\u0015\t!ru\n\u0015\u0005\u0006e1\u0003\r\u0001\u000e\u0005\u0006}1\u0003\r\u0001\t\u0005\u0006\u00052\u0003\r\u0001\u0012\u0005\u0006%&\"\taU\u0001\boJLG/\u001a+p)\t!v\u000b\u0005\u0002\u0016+&\u0011aK\u0006\u0002\u0005+:LG\u000fC\u0003Y#\u0002\u0007\u0011,\u0001\u0004ck\u001a4WM\u001d\t\u00035vk\u0011a\u0017\u0006\u00039B\t1A\\5p\u0013\tq6L\u0001\u0006CsR,')\u001e4gKJDQ\u0001Y\u0015\u0005\u0002\u0005\f1b]5{K&s')\u001f;fgR\t\u0001\u0005C\u0003dS\u0011\u0005A-\u0001\fhKR$&/\u00198tY\u0006$X\r\u001a)beRLG/[8o)\t\u0001S\rC\u0003gE\u0002\u0007q-\u0001\bsC:$w.\\*fY\u0016\u001cGo\u001c:\u0011\tUAG\u0007I\u0005\u0003SZ\u0011\u0011BR;oGRLwN\\\u0019\t\u000b-LC\u0011\t7\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\u000e\u0005\u0006]&\"\te\\\u0001\u0007KF,\u0018\r\\:\u0015\u0005A\u001c\bCA\u000br\u0013\t\u0011hCA\u0004C_>dW-\u00198\t\u000bQl\u0007\u0019A;\u0002\u000b=$\b.\u001a:\u0011\u0005U1\u0018BA<\u0017\u0005\r\te.\u001f\u0005\u0006s&\"\tA_\u0001\tG\u0006tW)];bYR\u0011\u0001o\u001f\u0005\u0006ib\u0004\r!\u001e\u0005\u0006{&\"\t%Y\u0001\tQ\u0006\u001c\bnQ8eK\")\u0001,\na\u00013\u0002")
public class ProducerRequest
extends Request
implements ScalaObject {
    private final String topic;
    private final int partition;
    private final ByteBufferMessageSet messages;

    public static final ProducerRequest readFrom(ByteBuffer byteBuffer) {
        return ProducerRequest$.MODULE$.readFrom(byteBuffer);
    }

    public static final int RandomPartition() {
        return ProducerRequest$.MODULE$.RandomPartition();
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public ByteBufferMessageSet messages() {
        return this.messages;
    }

    @Override
    public void writeTo(ByteBuffer buffer) {
        Utils$.MODULE$.writeShortString(buffer, this.topic(), "UTF-8");
        buffer.putInt(this.partition());
        buffer.putInt(this.messages().serialized().limit());
        buffer.put(this.messages().serialized());
        this.messages().serialized().rewind();
    }

    @Override
    public int sizeInBytes() {
        return 2 + this.topic().length() + 4 + 4 + (int)this.messages().sizeInBytes();
    }

    public int getTranslatedPartition(Function1<String, Object> randomSelector) {
        if (this.partition() == ProducerRequest$.MODULE$.RandomPartition()) {
            return BoxesRunTime.unboxToInt(randomSelector.apply(this.topic()));
        }
        return this.partition();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProducerRequest(");
        builder.append(new StringBuilder().append((Object)this.topic()).append((Object)",").toString());
        builder.append(new StringBuilder().append(this.partition()).append((Object)",").toString());
        builder.append(this.messages().sizeInBytes());
        builder.append(")");
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof ProducerRequest)) return false;
        ProducerRequest producerRequest = (ProducerRequest)object;
        ProducerRequest that = producerRequest;
        if (!that.canEqual(this)) return false;
        String string2 = this.topic();
        String string3 = that.topic();
        if (string2 == null) {
            if (string3 != null) {
                return false;
            }
        } else if (!string2.equals(string3)) return false;
        if (this.partition() != that.partition()) return false;
        if (!this.messages().equals(that.messages())) return false;
        return true;
    }

    public boolean canEqual(Object other) {
        return other instanceof ProducerRequest;
    }

    public int hashCode() {
        return 31 + 17 * this.partition() + this.topic().hashCode() + this.messages().hashCode();
    }

    public ProducerRequest(String topic, int partition2, ByteBufferMessageSet messages) {
        this.topic = topic;
        this.partition = partition2;
        this.messages = messages;
        super(RequestKeys$.MODULE$.Produce());
    }
}

