/*
 * Decompiled with CFR 0.152.
 */
package pattern.predictor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import pattern.PatternException;
import pattern.Schema;
import pattern.datafield.CategoricalDataField;
import pattern.predictor.CategoricalPredictor;
import pattern.predictor.NumericPredictor;
import pattern.predictor.Predictor;

public class PredictorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PredictorFactory.class);

    public static Predictor getPredictor(Schema schema, Element node) throws PatternException {
        Predictor pred = null;
        String name = node.getAttribute("name");
        if ("NumericPredictor".equals(node.getNodeName())) {
            String exponent_text = node.getAttribute("exponent");
            Double exponent = new Double(1.0);
            if (exponent_text != null) {
                exponent = Double.valueOf(exponent_text);
            }
            Double coefficient = Double.valueOf(node.getAttribute("coefficient"));
            pred = new NumericPredictor(name, coefficient, exponent);
        } else if ("CategoricalPredictor".equals(node.getNodeName())) {
            CategoricalDataField df = (CategoricalDataField)schema.get(name);
            Integer value = df.categories.indexOf(node.getAttribute("value"));
            Double coefficient = Double.valueOf(node.getAttribute("coefficient"));
            pred = new CategoricalPredictor(name, coefficient, value);
        } else {
            String message = String.format("unsupported Predictor type %s", node.getNodeName());
            LOG.error(message);
            throw new PatternException(message);
        }
        return pred;
    }
}

