/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.tree;

import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.xpath.XPathConstants;
import org.jgrapht.DirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PMML;
import pattern.PatternException;
import pattern.Schema;
import pattern.model.Model;
import pattern.model.tree.Context;
import pattern.model.tree.Edge;
import pattern.model.tree.Tree;
import pattern.model.tree.Vertex;
import storm.trident.tuple.TridentTuple;

public class TreeModel
extends Model
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TreeModel.class);
    public Context context = null;
    public Tree tree;

    public TreeModel(PMML pmml) throws PatternException {
        this.schema = pmml.getSchema();
        this.context = new Context();
        this.schema.parseMiningSchema(pmml.getNodeList("/PMML/TreeModel/MiningSchema/MiningField"));
        this.tree = new Tree("default");
        String node_expr = "./TreeModel/Node[1]";
        NodeList root_node = pmml.getNodeList(node_expr);
        this.buildTree(pmml, this.context, (Element)root_node.item(0), this.tree);
    }

    public TreeModel(PMML pmml, Context context, Node parent) throws PatternException {
        String id = ((Element)parent).getAttribute("id");
        this.tree = new Tree(id);
        String node_expr = "./TreeModel/Node[1]";
        NodeList root_node = (NodeList)pmml.getReader().read(parent, node_expr, XPathConstants.NODESET);
        this.buildTree(pmml, context, (Element)root_node.item(0), this.tree);
    }

    @Override
    public void prepare() {
        this.context.prepare(this.schema);
    }

    @Override
    public String classifyTuple(TridentTuple values) throws PatternException {
        return "null";
    }

    public void buildTree(PMML pmml, Context shared_context, Element root, Tree tree) throws PatternException {
        Vertex vertex = this.makeVertex(root, tree.getGraph());
        tree.setRoot(vertex);
        this.buildNode(pmml, shared_context, root, vertex, tree.getGraph());
    }

    protected void buildNode(PMML pmml, Context shared_context, Element node, Vertex vertex, DirectedGraph<Vertex, Edge> graph) throws PatternException {
        Schema schema = pmml.getSchema();
        String[] param_names = schema.getParamNames();
        ArrayList<String> params = new ArrayList<String>();
        int i = 0;
        while (i < param_names.length) {
            params.add(param_names[i]);
            ++i;
        }
        NodeList child_nodes = node.getChildNodes();
        int i2 = 0;
        while (i2 < child_nodes.getLength()) {
            Node child = child_nodes.item(i2);
            if (child.getNodeType() == 1) {
                if ("SimplePredicate".equals(child.getNodeName()) || "SimpleSetPredicate".equals(child.getNodeName())) {
                    Integer predicate_id = shared_context.makePredicate(schema, pmml.getReader(), (Element)child, params);
                    if (node.hasAttribute("score")) {
                        String score = node.getAttribute("score");
                        vertex.setScore(score);
                    }
                    for (Edge e : graph.edgesOf((Object)vertex)) {
                        e.setPredicateId(predicate_id);
                    }
                } else if ("Node".equals(child.getNodeName())) {
                    Vertex child_vertex = this.makeVertex((Element)child, graph);
                    Edge edge = (Edge)((Object)graph.addEdge((Object)vertex, (Object)child_vertex));
                    this.buildNode(pmml, shared_context, (Element)child, child_vertex, graph);
                }
            }
            ++i2;
        }
    }

    protected Vertex makeVertex(Element node, DirectedGraph<Vertex, Edge> graph) {
        String id = node.getAttribute("id");
        Vertex vertex = new Vertex(id);
        graph.addVertex((Object)vertex);
        return vertex;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.schema != null) {
            buf.append(this.schema);
            buf.append("\n");
            buf.append("---------");
            buf.append("\n");
        }
        if (this.context != null) {
            buf.append(this.context);
            buf.append("\n");
            buf.append("---------");
            buf.append("\n");
        }
        buf.append(this.tree);
        buf.append(this.tree.getRoot());
        for (Edge edge : this.tree.getGraph().edgeSet()) {
            buf.append((Object)edge);
        }
        buf.append("\n");
        return buf.toString();
    }
}

