/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.tree;

import java.io.Serializable;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pattern.model.tree.Edge;
import pattern.model.tree.Vertex;

public class Tree
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Tree.class);
    public String tree_name;
    public Vertex root;
    public DirectedGraph<Vertex, Edge> graph = new DefaultDirectedGraph(Edge.class);

    public Tree(String id) {
        this.tree_name = "tree_" + id;
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.tree_name);
        }
    }

    public void setRoot(Vertex root) {
        this.root = root;
    }

    public Vertex getRoot() {
        return this.root;
    }

    public DirectedGraph<Vertex, Edge> getGraph() {
        return this.graph;
    }

    public String traverse(Boolean[] pred_eval) {
        return this.traverseVertex(this.root, pred_eval);
    }

    protected String traverseVertex(Vertex vertex, Boolean[] pred_eval) {
        String score = vertex.getScore();
        if (score != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("  then " + score);
            }
            return score;
        }
        for (Edge edge : this.graph.outgoingEdgesOf((Object)vertex)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(edge.toString());
                LOG.debug(" if pred_eval[ " + edge.getPredicateId() + " ]:" + pred_eval[edge.getPredicateId()]);
            }
            if (!pred_eval[edge.getPredicateId()].booleanValue() || (score = this.traverseVertex((Vertex)this.graph.getEdgeTarget((Object)edge), pred_eval)) == null) continue;
            return score;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.tree_name) + ": " + this.graph;
    }
}

