/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.lm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PMML;
import pattern.PatternException;
import pattern.model.Model;
import pattern.predictor.Predictor;
import pattern.predictor.PredictorFactory;
import storm.trident.tuple.TridentTuple;

public class RegressionModel
extends Model
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(RegressionModel.class);
    public Double intercept = 0.0;
    public List<Predictor> predictors = new ArrayList<Predictor>();

    public RegressionModel(PMML pmml) throws PatternException {
        this.schema = pmml.getSchema();
        this.schema.parseMiningSchema(pmml.getNodeList("/PMML/RegressionModel/MiningSchema/MiningField"));
        String node_expr = "/PMML/RegressionModel/RegressionTable[1]";
        Element model_node = (Element)pmml.getNodeList(node_expr).item(0);
        this.intercept = Double.valueOf(model_node.getAttribute("intercept"));
        LOG.debug("Intercept: " + this.intercept);
        NodeList child_nodes = model_node.getChildNodes();
        int i = 0;
        while (i < child_nodes.getLength()) {
            Node child = child_nodes.item(i);
            if (child.getNodeType() == 1) {
                Predictor pred = PredictorFactory.getPredictor(this.schema, (Element)child);
                this.predictors.add(pred);
                LOG.debug(pred.toString());
            }
            ++i;
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public String classifyTuple(TridentTuple values) throws PatternException {
        Map<String, Object> param_map = this.schema.getParamMap(values);
        double result = this.intercept;
        for (Predictor pred : this.predictors) {
            double term = pred.calcTerm(param_map);
            result += term;
        }
        LOG.debug("result: " + result);
        return Double.toString(result);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.schema != null) {
            buf.append(this.schema);
            buf.append("\n");
            buf.append("---------");
            buf.append("\n");
            buf.append(this.predictors);
            buf.append("---------");
            buf.append("\n");
        }
        return buf.toString();
    }
}

