/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.glm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PatternException;
import pattern.model.glm.PPCell;

public class PPMatrix
extends LinkedHashMap<String, ArrayList<PPCell>>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PPMatrix.class);

    public void parsePPCell(NodeList node_list) throws PatternException {
        int i = 0;
        while (i < node_list.getLength()) {
            Node node = node_list.item(i);
            if (node.getNodeType() == 1) {
                String name = ((Element)node).getAttribute("parameterName");
                String predictorName = ((Element)node).getAttribute("predictorName");
                String value = ((Element)node).getAttribute("value");
                if (!this.containsKey(name)) {
                    ArrayList<PPCell> arrPPCell = new ArrayList<PPCell>();
                    PPCell ppCell = new PPCell();
                    ppCell.setParameterName(name);
                    ppCell.setPredictorName(predictorName);
                    ppCell.setValue(value);
                    arrPPCell.add(ppCell);
                    this.put(name, arrPPCell);
                    LOG.debug("PMML add DataField: " + arrPPCell.toString());
                } else {
                    PPCell ppCell = new PPCell();
                    ppCell.setParameterName(name);
                    ppCell.setPredictorName(predictorName);
                    ppCell.setValue(value);
                    ArrayList arrPPCell = (ArrayList)this.get(name);
                    arrPPCell.add(ppCell);
                    this.put(name, arrPPCell);
                    LOG.debug("PMML add DataField: " + arrPPCell.toString());
                }
            }
            ++i;
        }
    }
}

