/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.glm;

public enum LinkFunction {
    NONE("none"){

        @Override
        public String calc(double value) {
            return Double.toString(Double.NaN);
        }
    }
    ,
    LOGIT("logit"){

        @Override
        public String calc(double value) {
            return Double.toString(1.0 / (1.0 + Math.exp(-value)));
        }
    }
    ,
    CLOGLOG("cloglog"){

        @Override
        public String calc(double value) {
            return Double.toString(1.0 - Math.exp(-Math.exp(value)));
        }
    }
    ,
    LOGLOG("loglog"){

        @Override
        public String calc(double value) {
            return Double.toString(Math.exp(-Math.exp(-value)));
        }
    }
    ,
    CAUCHIT("cauchit"){

        @Override
        public String calc(double value) {
            return Double.toString(0.5 + 0.3183098861837907 * Math.atan(value));
        }
    };

    public String function;

    private LinkFunction(String function) {
        this.function = function;
    }

    public static LinkFunction getFunction(String functionName) {
        LinkFunction[] linkFunctionArray = LinkFunction.values();
        int n = linkFunctionArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinkFunction lf = linkFunctionArray[n2];
            if (lf.function.matches(functionName)) {
                return lf;
            }
            ++n2;
        }
        return NONE;
    }

    public abstract String calc(double var1);

    /* synthetic */ LinkFunction(String string, int n, String string2, LinkFunction linkFunction) {
        this(string2);
    }
}

