/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.clust;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PatternException;

public class Exemplar
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Exemplar.class);
    public List<Double> points = new ArrayList<Double>();
    public String name;

    public Exemplar(Element cluster_node) throws PatternException {
        this.name = cluster_node.getAttribute("name");
        NodeList child_nodes = cluster_node.getChildNodes();
        int j = 0;
        while (j < child_nodes.getLength()) {
            Element child_elem;
            Node child_node = child_nodes.item(j);
            if (child_node.getNodeType() == 1 && "Array".equals((child_elem = (Element)child_node).getNodeName())) {
                int n = Integer.valueOf(child_elem.getAttribute("n"));
                String type = child_elem.getAttribute("type");
                String text = child_elem.getTextContent();
                String[] stringArray = text.split("\\s+");
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String val = stringArray[n3];
                    this.points.add(Double.valueOf(val));
                    ++n3;
                }
                if (this.points.size() != n) {
                    String message = String.format("expected %d data points in PMML for cluster %s [ %s ]", n, this.name, text);
                    LOG.error(message);
                    throw new PatternException(message);
                }
            }
            ++j;
        }
    }

    public double calcDistance(Double[] param_values) {
        double sum_sq = 0.0;
        int i = 0;
        while (i < param_values.length) {
            sum_sq += Math.pow(param_values[i] - this.points.get(i), 2.0);
            ++i;
        }
        return Math.sqrt(sum_sq);
    }

    public String toString() {
        return String.format("Exemplar: %s %s", this.name, this.points.toString());
    }
}

