/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.clust;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PMML;
import pattern.PatternException;
import pattern.model.Model;
import pattern.model.clust.Exemplar;
import storm.trident.tuple.TridentTuple;

public class ClusteringModel
extends Model
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringModel.class);
    public List<Exemplar> exemplars = new ArrayList<Exemplar>();

    public ClusteringModel(PMML pmml) throws PatternException {
        this.schema = pmml.getSchema();
        this.schema.parseMiningSchema(pmml.getNodeList("/PMML/ClusteringModel/MiningSchema/MiningField"));
        String node_expr = "/PMML/ClusteringModel/Cluster";
        NodeList node_list = pmml.getNodeList(node_expr);
        int i = 0;
        while (i < node_list.getLength()) {
            Element node_elem;
            Node node = node_list.item(i);
            if (node.getNodeType() == 1 && "Cluster".equals((node_elem = (Element)node).getNodeName())) {
                this.exemplars.add(new Exemplar(node_elem));
            }
            ++i;
        }
    }

    @Override
    public void prepare() {
    }

    @Override
    public String classifyTuple(TridentTuple values) throws PatternException {
        Map<String, Object> param_map = this.schema.getParamMap(values);
        String[] param_names = this.schema.getParamNames();
        Double[] param_values = new Double[param_names.length];
        int i = 0;
        while (i < param_names.length) {
            param_values[i] = (Double)param_map.get(param_names[i]);
            ++i;
        }
        Exemplar best_clust = null;
        double best_dist = 0.0;
        for (Exemplar clust : this.exemplars) {
            double distance = clust.calcDistance(param_values);
            if (best_clust != null && !(distance < best_dist)) continue;
            best_clust = clust;
            best_dist = distance;
        }
        return best_clust.name;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.schema != null) {
            buf.append(this.schema);
            buf.append("\n");
            buf.append("---------");
            buf.append("\n");
            buf.append(this.exemplars);
            buf.append("---------");
            buf.append("\n");
        }
        return buf.toString();
    }
}

