/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.io.IOException;
import java.io.Reader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import pattern.PatternException;

public class XPathReader {
    private static final Logger LOG = LoggerFactory.getLogger(XPathReader.class);
    private Document xmlDocument;
    private XPath xPath;

    public XPathReader(Reader xmlSource) {
        try {
            this.xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(xmlSource));
            this.xPath = XPathFactory.newInstance().newXPath();
        }
        catch (IOException exception) {
            LOG.error("could not read PMML file", (Throwable)exception);
            throw new PatternException(" could not read PMML file", exception);
        }
        catch (SAXException exception) {
            LOG.error("could not parse PMML file", (Throwable)exception);
            throw new PatternException(" could not parse PMML file", exception);
        }
        catch (ParserConfigurationException exception) {
            LOG.error("could not configure parser for PMML file", (Throwable)exception);
            throw new PatternException(" could not configure parser for PMML file", exception);
        }
    }

    public Object read(String expression, QName returnType) {
        Object result = null;
        try {
            try {
                XPathExpression xPathExpression = this.xPath.compile(expression);
                result = xPathExpression.evaluate(this.xmlDocument, returnType);
            }
            catch (XPathExpressionException exception) {
                String message = String.format("could not evaluate XPath [ %s ] from doc root", expression);
                LOG.error(message, (Throwable)exception);
                throw new PatternException(message, exception);
            }
        }
        catch (Throwable throwable) {}
        return result;
    }

    public Object read(Object item, String expression, QName returnType) {
        Object result = null;
        try {
            try {
                XPathExpression xPathExpression = this.xPath.compile(expression);
                result = xPathExpression.evaluate(item, returnType);
            }
            catch (XPathExpressionException exception) {
                String message = String.format("could not evaluate XPath [ %s ] from %s", expression, item.toString());
                LOG.error(message, (Throwable)exception);
                throw new PatternException(message, exception);
            }
        }
        catch (Throwable throwable) {}
        return result;
    }
}

