/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.io.Reader;
import javax.xml.xpath.XPathConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pattern.PatternException;
import pattern.Schema;
import pattern.XPathReader;

public class PMML {
    private static final Logger LOG = LoggerFactory.getLogger(PMML.class);
    protected XPathReader reader;
    protected Schema schema = new Schema();
    public Models model_type = Models.UNKNOWN;
    public String version;

    public PMML(Reader pmmlSource) throws PatternException {
        this.reader = new XPathReader(pmmlSource);
        this.version = ((Element)this.getNodeList("/PMML").item(0)).getAttribute("version");
        this.model_type = this.parseModelType();
        LOG.debug(String.format("Model: %s", this.model_type.name()));
        LOG.debug(String.format("Version: %s", this.version));
        this.schema.parseDictionary(this, this.getNodeList("/PMML/DataDictionary/DataField"));
    }

    public Models parseModelType() {
        Models model_type = Models.UNKNOWN;
        if (this.reader.read("/PMML/MiningModel", XPathConstants.NODE) != null) {
            return Models.MINING;
        }
        if (this.reader.read("/PMML/TreeModel", XPathConstants.NODE) != null) {
            return Models.TREE;
        }
        if (this.reader.read("/PMML/RegressionModel", XPathConstants.NODE) != null) {
            return Models.REGRESSION;
        }
        if (this.reader.read("/PMML/ClusteringModel", XPathConstants.NODE) != null) {
            return Models.CLUSTERING;
        }
        if (this.reader.read("/PMML/GeneralRegressionModel", XPathConstants.NODE) != null) {
            return Models.GENERALIZED_REGRESSION;
        }
        return model_type;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public XPathReader getReader() {
        return this.reader;
    }

    public NodeList getNodeList(String expr) {
        return (NodeList)this.reader.read(expr, XPathConstants.NODESET);
    }

    public static enum Models {
        UNKNOWN,
        MINING,
        TREE,
        REGRESSION,
        CLUSTERING,
        GENERALIZED_REGRESSION;

    }
}

