/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.glm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PatternException;
import pattern.model.glm.PCell;
import pattern.model.glm.PPMatrix;

public class ParamMatrix
extends LinkedHashMap<String, ArrayList<PCell>>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PPMatrix.class);

    public void parsePCell(NodeList node_list) throws PatternException {
        for (int i = 0; i < node_list.getLength(); ++i) {
            Node node = node_list.item(i);
            if (node.getNodeType() != 1) continue;
            String name = ((Element)node).getAttribute("parameterName");
            String predictorName = ((Element)node).getAttribute("beta");
            String df = ((Element)node).getAttribute("df");
            LOG.info(name);
            if (!this.containsKey(name)) {
                ArrayList<PCell> arrPCell = new ArrayList<PCell>();
                PCell pCell = new PCell();
                pCell.setParameterName(name);
                pCell.setBeta(predictorName);
                pCell.setDf(df);
                arrPCell.add(pCell);
                this.put(name, arrPCell);
                LOG.debug("PMML add DataField: " + arrPCell.toString());
                continue;
            }
            PCell pCell = new PCell();
            pCell.setParameterName(name);
            pCell.setBeta(predictorName);
            pCell.setDf(df);
            ArrayList arrPCell = (ArrayList)this.get(name);
            arrPCell.add(pCell);
            this.put(name, arrPCell);
            LOG.debug("PMML add DataField: " + arrPCell.toString());
        }
    }
}

