/*
 * Decompiled with CFR 0.152.
 */
package pattern.datafield;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import pattern.PatternException;
import pattern.XPathReader;
import pattern.datafield.CategoricalDataField;
import pattern.datafield.ContinuousDataField;
import pattern.datafield.DataField;

public class DataFieldFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DataFieldFactory.class);

    public static DataField getDataField(XPathReader reader, Node node, String name, String op_type, String data_type) throws PatternException {
        DataField df = null;
        if ("continuous".equals(op_type) && "double".equals(data_type)) {
            df = new ContinuousDataField(name, op_type, data_type);
        } else if ("categorical".equals(op_type) && "string".equals(data_type)) {
            df = new CategoricalDataField(name, op_type, data_type);
            df.parse(reader, node);
        } else {
            String message = String.format("unsupported DataField type %s / %s: ", op_type, data_type);
            LOG.error(message);
            throw new PatternException(message);
        }
        return df;
    }
}

