/*
 * Decompiled with CFR 0.152.
 */
package pattern.datafield;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import pattern.PatternException;
import pattern.XPathReader;
import pattern.datafield.DataField;
import storm.trident.tuple.TridentTuple;

public class ContinuousDataField
extends DataField {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousDataField.class);

    public ContinuousDataField(String name, String op_type, String data_type) {
        this.name = name;
        this.op_type = op_type;
        this.data_type = data_type;
    }

    @Override
    public String getEval(XPathReader reader, Element node) throws PatternException {
        String operator = node.getAttribute("operator");
        String value = node.getAttribute("value");
        String eval = null;
        if (operator.equals("equal")) {
            eval = this.name + " == " + value;
        } else if (operator.equals("notEqual")) {
            eval = this.name + " != " + value;
        } else if (operator.equals("lessThan")) {
            eval = this.name + " < " + value;
        } else if (operator.equals("lessOrEqual")) {
            eval = this.name + " <= " + value;
        } else if (operator.equals("greaterThan")) {
            eval = this.name + " > " + value;
        } else if (operator.equals("greaterOrEqual")) {
            eval = this.name + " >= " + value;
        } else {
            throw new PatternException("unknown operator: " + operator);
        }
        return eval;
    }

    @Override
    public Class getClassType() {
        return Double.TYPE;
    }

    @Override
    public Object getValue(TridentTuple values, int i) throws PatternException {
        try {
            return values.getDouble(i);
        }
        catch (NumberFormatException exception) {
            LOG.error("tuple format is bad", (Throwable)exception);
            throw new PatternException("tuple format is bad", exception);
        }
    }
}

