/*
 * Decompiled with CFR 0.152.
 */
package pattern.datafield;

import java.util.ArrayList;
import javax.xml.xpath.XPathConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PatternException;
import pattern.XPathReader;
import pattern.datafield.DataField;
import pattern.datafield.PortableBitSet;
import storm.trident.tuple.TridentTuple;

public class CategoricalDataField
extends DataField {
    private static final Logger LOG = LoggerFactory.getLogger(CategoricalDataField.class);
    public ArrayList<String> categories = new ArrayList();

    public CategoricalDataField(String name, String op_type, String data_type) {
        this.name = name;
        this.op_type = op_type;
        this.data_type = data_type;
    }

    @Override
    public void parse(XPathReader reader, Node node) {
        String node_expr = "./Value";
        NodeList node_list = (NodeList)reader.read(node, node_expr, XPathConstants.NODESET);
        for (int i = 0; i < node_list.getLength(); ++i) {
            Node child = node_list.item(i);
            if (child.getNodeType() != 1) continue;
            String value = ((Element)child).getAttribute("value");
            LOG.debug(String.format("PMML categorical value: %s", value));
            this.categories.add(value);
        }
    }

    @Override
    public String getEval(XPathReader reader, Element node) throws PatternException {
        String operator = node.getAttribute("booleanOperator");
        String eval = null;
        String expr = "./Array[1]";
        NodeList node_list = (NodeList)reader.read(node, expr, XPathConstants.NODESET);
        Element child = (Element)node_list.item(0);
        PortableBitSet bits = new PortableBitSet(this.categories.size());
        String value = child.getTextContent();
        value = value.substring(1, value.length() - 1);
        for (String s : value.split("\\\"\\s+\\\"")) {
            bits.set(this.categories.indexOf(s));
        }
        if (!operator.equals("isIn")) {
            throw new PatternException("unknown operator: " + operator);
        }
        eval = String.format("pattern.datafield.PortableBitSet.isIn( \"%s\", %s )", bits.toString(), this.name);
        return eval;
    }

    @Override
    public Class getClassType() {
        return Integer.TYPE;
    }

    @Override
    public Object getValue(TridentTuple values, int i) {
        String field_value = values.getString(i);
        int bit_index = this.categories.indexOf(field_value);
        LOG.debug(String.format("%s @ %d | %s", field_value, bit_index, this.categories));
        return bit_index;
    }
}

