/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import backtype.storm.tuple.Fields;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PMML;
import pattern.PatternException;
import pattern.datafield.DataField;
import pattern.datafield.DataFieldFactory;
import storm.trident.tuple.TridentTuple;

public class Schema
extends LinkedHashMap<String, DataField>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Schema.class);
    public DataField label_field;

    public void parseDictionary(PMML pmml, NodeList node_list) throws PatternException {
        for (int i = 0; i < node_list.getLength(); ++i) {
            Node node = node_list.item(i);
            if (node.getNodeType() != 1) continue;
            String name = ((Element)node).getAttribute("name");
            String op_type = ((Element)node).getAttribute("optype");
            String data_type = ((Element)node).getAttribute("dataType");
            if (this.containsKey(name)) continue;
            DataField df = DataFieldFactory.getDataField(pmml.getReader(), node, name, op_type, data_type);
            this.put(name, df);
            LOG.debug("PMML add DataField: " + df);
        }
    }

    public void parseMiningSchema(NodeList node_list) throws PatternException {
        for (int i = 0; i < node_list.getLength(); ++i) {
            Node node = node_list.item(i);
            if (node.getNodeType() != 1) continue;
            String name = ((Element)node).getAttribute("name");
            String usage_type = ((Element)node).getAttribute("usageType");
            LOG.debug(String.format("DataField: %s:%s", name, usage_type));
            if (this.containsKey(name)) {
                if ("predicted".equals(usage_type)) {
                    this.label_field = (DataField)this.remove(name);
                    continue;
                }
                if ("active".equals(usage_type)) continue;
                this.remove(name);
                continue;
            }
            String message = String.format("unknown DataField referenced in PMML [ %s ]", name);
            LOG.error(message);
            throw new PatternException(message);
        }
    }

    public Fields getInputFields() {
        return new Fields(this.getParamNames());
    }

    public String[] getParamNames() {
        return this.keySet().toArray(new String[0]);
    }

    public Class[] getParamTypes() {
        Class[] param_types = new Class[this.size()];
        Iterator iter = this.values().iterator();
        for (int i = 0; i < this.size(); ++i) {
            DataField df = (DataField)iter.next();
            param_types[i] = df.getClassType();
        }
        return param_types;
    }

    public void setParamValues(TridentTuple values, Object[] param_values) throws PatternException {
        Iterator iter = this.values().iterator();
        for (int i = 0; i < this.size(); ++i) {
            DataField df = (DataField)iter.next();
            param_values[i] = df.getValue(values, i);
        }
    }

    public Map<String, Object> getParamMap(TridentTuple values) throws PatternException {
        HashMap<String, Object> param_map = new HashMap<String, Object>();
        Iterator iter = this.values().iterator();
        for (int i = 0; i < this.size(); ++i) {
            DataField df = (DataField)iter.next();
            param_map.put(df.name, df.getValue(values, i));
        }
        return param_map;
    }
}

