/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pattern.PMML;
import pattern.PatternException;
import pattern.model.MiningModel;
import pattern.model.Model;
import pattern.model.clust.ClusteringModel;
import pattern.model.glm.GeneralizedRegressionModel;
import pattern.model.lm.RegressionModel;
import pattern.model.tree.TreeModel;
import storm.trident.tuple.TridentTuple;

public class Classifier
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Classifier.class);
    public Model model;

    public Classifier(String pmmlUri) throws PatternException {
        block7: {
            try {
                PMML pmml = new PMML(this.getSourceReader(pmmlUri));
                if (PMML.Models.MINING.equals((Object)pmml.model_type)) {
                    this.model = new MiningModel(pmml);
                    break block7;
                }
                if (PMML.Models.TREE.equals((Object)pmml.model_type)) {
                    this.model = new TreeModel(pmml);
                    break block7;
                }
                if (PMML.Models.REGRESSION.equals((Object)pmml.model_type)) {
                    this.model = new RegressionModel(pmml);
                    break block7;
                }
                if (PMML.Models.CLUSTERING.equals((Object)pmml.model_type)) {
                    this.model = new ClusteringModel(pmml);
                    break block7;
                }
                if (PMML.Models.GENERALIZED_REGRESSION.equals((Object)pmml.model_type)) {
                    this.model = new GeneralizedRegressionModel(pmml);
                    break block7;
                }
                throw new PatternException("unsupported model type: " + pmml.model_type.name());
            }
            catch (IOException exception) {
                LOG.error("could not read PMML file", (Throwable)exception);
                throw new PatternException(" could not read PMML file", exception);
            }
        }
    }

    public Reader getSourceReader(String filePath) throws IOException {
        File file = new File(filePath);
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = null;
        StringBuilder stringBuilder = new StringBuilder();
        String ls = System.getProperty("line.separator");
        while ((line = reader.readLine()) != null) {
            stringBuilder.append(line);
            stringBuilder.append(ls);
        }
        reader.close();
        return new StringReader(stringBuilder.toString());
    }

    public void prepare() {
        this.model.prepare();
    }

    public String classifyTuple(TridentTuple values) throws PatternException {
        return this.model.classifyTuple(values);
    }
}

