/*
 * Decompiled with CFR 0.152.
 */
package pattern.predictor;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pattern.predictor.Predictor;

public class NumericPredictor
extends Predictor {
    private static final Logger LOG = LoggerFactory.getLogger(NumericPredictor.class);
    public Double exponent;

    public NumericPredictor(String name, Double coefficient, Double exponent) {
        this.name = name;
        this.coefficient = coefficient;
        this.exponent = exponent;
    }

    @Override
    public double calcTerm(Map<String, Object> param_map) {
        double value = (Double)param_map.get(this.name);
        double result = Math.pow(value, this.exponent) * this.coefficient;
        LOG.debug(String.format("calc: %s, %e, %e, %e, %e", this.name, value, this.exponent, this.coefficient, result));
        return result;
    }

    public String toString() {
        return String.format("NumericPredictor: %s, %e, %e", this.name, this.exponent, this.coefficient);
    }
}

