/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.tree;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import pattern.PatternException;
import pattern.Schema;
import pattern.XPathReader;
import pattern.datafield.DataField;
import storm.trident.tuple.TridentTuple;

public class Context
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(Context.class);
    public List<String> predicates = new ArrayList<String>();
    public List<ArrayList<Integer>> variables = new ArrayList<ArrayList<Integer>>();
    protected Boolean[] pred_eval;
    protected Object[] param_values;
    protected ExpressionEvaluator[] ee_list;

    public Integer makePredicate(Schema schema, XPathReader reader, Element node, List<String> params) throws PatternException {
        String field = node.getAttribute("field");
        String eval = ((DataField)schema.get(field)).getEval(reader, node);
        ArrayList<Integer> pred_vars = new ArrayList<Integer>();
        LOG.debug("eval: " + eval + " | " + params.toString());
        for (String s : eval.split("[^\\w\\_]")) {
            if ((s = s.trim()).length() <= 0) continue;
            int var_index = params.indexOf(s);
            if (var_index >= 0) {
                pred_vars.add(var_index);
            }
            LOG.debug("param: " + s + " ? " + var_index + " | " + pred_vars.toString());
        }
        if (!this.predicates.contains(eval)) {
            this.predicates.add(eval);
            this.variables.add(pred_vars);
            LOG.debug("pred: " + eval + " ? " + this.predicates.toString());
        }
        Integer predicate_id = this.predicates.indexOf(eval);
        return predicate_id;
    }

    public void prepare(Schema schema) {
        String[] param_names = schema.getParamNames();
        Class[] param_types = schema.getParamTypes();
        this.ee_list = new ExpressionEvaluator[this.predicates.size()];
        for (int i = 0; i < this.predicates.size(); ++i) {
            String message;
            try {
                ArrayList<Integer> pred_vars = this.variables.get(i);
                String[] pred_param_names = new String[pred_vars.size()];
                Class[] pred_param_types = new Class[pred_vars.size()];
                int j = 0;
                for (Integer pv : pred_vars) {
                    LOG.debug("pv: " + pv + " name: " + param_names[pv] + " type: " + param_types[pv]);
                    pred_param_names[j] = param_names[pv];
                    pred_param_types[j++] = param_types[pv];
                }
                LOG.debug("eval: " + this.predicates.get(i) + " param len: " + pred_vars.size() + " ? " + pred_vars);
                this.ee_list[i] = new ExpressionEvaluator(this.predicates.get(i), Boolean.TYPE, pred_param_names, pred_param_types, new Class[0], null);
                continue;
            }
            catch (NullPointerException exception) {
                message = String.format("predicate [ %s ] failed", this.predicates.get(i));
                LOG.error(message, (Throwable)exception);
                throw new PatternException(message, exception);
            }
            catch (CompileException exception) {
                message = String.format("predicate [ %s ] did not compile", this.predicates.get(i));
                LOG.error(message, (Throwable)exception);
                throw new PatternException(message, exception);
            }
        }
        this.param_values = new Object[schema.size()];
        this.pred_eval = new Boolean[this.predicates.size()];
    }

    public Boolean[] evalPredicates(Schema schema, TridentTuple values) throws PatternException {
        schema.setParamValues(values, this.param_values);
        for (int i = 0; i < this.predicates.size(); ++i) {
            try {
                ArrayList<Integer> pred_vars = this.variables.get(i);
                Object[] pred_param_values = new Object[pred_vars.size()];
                int j = 0;
                for (Integer pv : pred_vars) {
                    LOG.debug("pv: " + pv + " value: " + this.param_values[pv]);
                    pred_param_values[j++] = this.param_values[pv];
                }
                this.pred_eval[i] = new Boolean(this.ee_list[i].evaluate(pred_param_values).toString());
                continue;
            }
            catch (InvocationTargetException exception) {
                String message = String.format("predicate [ %s ] did not evaluate", this.predicates.get(i));
                LOG.error(message, (Throwable)exception);
                throw new PatternException(message, exception);
            }
        }
        return this.pred_eval;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String predicate : this.predicates) {
            buf.append("expr[ " + this.predicates.indexOf(predicate) + " ]: " + predicate);
            buf.append("\n");
        }
        return buf.toString();
    }
}

