/*
 * Decompiled with CFR 0.152.
 */
package pattern.model.glm;

public enum LinkFunction {
    NONE("none"){

        @Override
        public String calc(double value) {
            return Double.toString(Double.NaN);
        }
    }
    ,
    LOGIT("logit"){

        @Override
        public String calc(double value) {
            return Double.toString(1.0 / (1.0 + Math.exp(-value)));
        }
    }
    ,
    CLOGLOG("cloglog"){

        @Override
        public String calc(double value) {
            return Double.toString(1.0 - Math.exp(-Math.exp(value)));
        }
    }
    ,
    LOGLOG("loglog"){

        @Override
        public String calc(double value) {
            return Double.toString(Math.exp(-Math.exp(-value)));
        }
    }
    ,
    CAUCHIT("cauchit"){

        @Override
        public String calc(double value) {
            return Double.toString(0.5 + 0.3183098861837907 * Math.atan(value));
        }
    };

    public String function;

    private LinkFunction(String function) {
        this.function = function;
    }

    public static LinkFunction getFunction(String functionName) {
        for (LinkFunction lf : LinkFunction.values()) {
            if (!lf.function.matches(functionName)) continue;
            return lf;
        }
        return NONE;
    }

    public abstract String calc(double var1);
}

