/*
 * Decompiled with CFR 0.152.
 */
package pattern.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pattern.PMML;
import pattern.PatternException;
import pattern.model.Model;
import pattern.model.tree.Context;
import pattern.model.tree.TreeModel;
import storm.trident.tuple.TridentTuple;

public class MiningModel
extends Model
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MiningModel.class);
    public Context context = null;
    public List<Model> segments = new ArrayList<Model>();
    public Map<String, Integer> votes = new HashMap<String, Integer>();

    public MiningModel(PMML pmml) throws PatternException {
        this.schema = pmml.getSchema();
        this.context = new Context();
        this.schema.parseMiningSchema(pmml.getNodeList("/PMML/MiningModel/MiningSchema/MiningField"));
        String expr = "/PMML/MiningModel/Segmentation/Segment";
        NodeList node_list = pmml.getNodeList(expr);
        for (int i = 0; i < node_list.getLength(); ++i) {
            Node node = node_list.item(i);
            if (node.getNodeType() != 1) continue;
            TreeModel tree_model = new TreeModel(pmml, this.context, node);
            this.segments.add(tree_model);
        }
    }

    @Override
    public void prepare() {
        this.context.prepare(this.schema);
    }

    @Override
    public String classifyTuple(TridentTuple values) throws PatternException {
        Boolean[] pred_eval = this.context.evalPredicates(this.schema, values);
        String label = null;
        Integer winning_vote = 0;
        this.votes.clear();
        for (Model model : this.segments) {
            label = ((TreeModel)model).tree.traverse(pred_eval);
            winning_vote = !this.votes.containsKey(label) ? Integer.valueOf(1) : Integer.valueOf(this.votes.get(label) + 1);
            this.votes.put(label, winning_vote);
        }
        for (String key : this.votes.keySet()) {
            if (this.votes.get(key) <= winning_vote) continue;
            label = key;
            winning_vote = this.votes.get(key);
        }
        return label;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.schema != null) {
            buf.append(this.schema);
            buf.append("\n");
            buf.append("---------");
            buf.append("\n");
        }
        if (this.context != null) {
            buf.append(this.context);
            buf.append("\n");
            buf.append("---------");
            buf.append("\n");
        }
        buf.append("segments: ");
        buf.append(this.segments);
        buf.append("---------");
        buf.append("\n");
        for (Model model : this.segments) {
            buf.append(((TreeModel)model).tree);
            buf.append("\n");
        }
        buf.append("---------");
        buf.append("\n");
        buf.append("votes: ");
        buf.append(this.votes);
        return buf.toString();
    }
}

