/*
 * Decompiled with CFR 0.152.
 */
package pattern.datafield;

import java.io.Serializable;
import java.util.BitSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortableBitSet
extends BitSet
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PortableBitSet.class);
    protected long max_size = 0L;

    public PortableBitSet(int nbits) {
        super(nbits);
        this.max_size = nbits;
    }

    public PortableBitSet(String bit_str) {
        super(bit_str.length());
        this.max_size = bit_str.length();
        int i = 0;
        while ((long)i < this.max_size) {
            if (bit_str.charAt(i) == '1') {
                this.set(i);
            }
            ++i;
        }
    }

    public static boolean isIn(String bit_str, int i) {
        boolean result = false;
        if (i >= 0 && i < bit_str.length()) {
            PortableBitSet bits = new PortableBitSet(bit_str);
            result = bits.get(i);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((long)i < this.max_size) {
            sb.append(this.get(i) ? "1" : "0");
            ++i;
        }
        return sb.toString();
    }
}

