/*
 * Decompiled with CFR 0.152.
 */
package pattern;

import backtype.storm.tuple.Values;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pattern.Classifier;
import pattern.PatternException;
import storm.trident.operation.BaseFunction;
import storm.trident.operation.TridentCollector;
import storm.trident.operation.TridentOperationContext;
import storm.trident.tuple.TridentTuple;

public class ClassifierSplitFunction
extends BaseFunction {
    private static final Logger LOG = LoggerFactory.getLogger(ClassifierSplitFunction.class);
    public Map<String, Classifier> classifierMap;
    public String splitField;
    Map<String, String> pmmlMap;

    public ClassifierSplitFunction(String splitField, Map<String, String> pmmlMap) {
        this.pmmlMap = pmmlMap;
        this.splitField = splitField;
    }

    public void prepare(Map conf, TridentOperationContext context) {
        this.classifierMap = new HashMap<String, Classifier>();
        for (Map.Entry<String, String> entry : this.pmmlMap.entrySet()) {
            String splitId = entry.getKey();
            String pmmlPath = entry.getValue();
            Classifier classifier = new Classifier(pmmlPath);
            this.classifierMap.put(splitId, classifier);
            classifier.prepare();
        }
    }

    public void execute(TridentTuple tuple, TridentCollector collector) {
        String splitId = tuple.getStringByField(this.splitField);
        Classifier classifier = this.classifierMap.get(splitId);
        if (classifier == null) {
            String message = String.format("unknown experimental split ID [ %s ]", splitId);
            LOG.error(message);
            throw new PatternException(message);
        }
        String label = classifier.classifyTuple(tuple);
        collector.emit((List)new Values(new Object[]{label}));
    }
}

