goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_34650 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_34650(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_34653 = (function (this$){
var x__5393__auto__ = (((this$ == null))?null:this$);
var m__5394__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5394__auto__.call(null,this$));
} else {
var m__5392__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5392__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_34653(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__32972 = coll;
var G__32974 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__32972,G__32974) : shadow.dom.lazy_native_coll_seq.call(null,G__32972,G__32974));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5045__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__33018 = arguments.length;
switch (G__33018) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__33030 = arguments.length;
switch (G__33030) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__33043 = arguments.length;
switch (G__33043) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__33055 = arguments.length;
switch (G__33055) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__33142 = arguments.length;
switch (G__33142) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__33193 = arguments.length;
switch (G__33193) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e33208){if((e33208 instanceof Object)){
var e = e33208;
return console.log("didnt support attachEvent",el,e);
} else {
throw e33208;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5045__auto__ = (!((typeof document !== 'undefined')));
if(or__5045__auto__){
return or__5045__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__33220 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__33221 = null;
var count__33222 = (0);
var i__33223 = (0);
while(true){
if((i__33223 < count__33222)){
var el = chunk__33221.cljs$core$IIndexed$_nth$arity$2(null,i__33223);
var handler_34720__$1 = ((function (seq__33220,chunk__33221,count__33222,i__33223,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33220,chunk__33221,count__33222,i__33223,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34720__$1);


var G__34726 = seq__33220;
var G__34727 = chunk__33221;
var G__34728 = count__33222;
var G__34729 = (i__33223 + (1));
seq__33220 = G__34726;
chunk__33221 = G__34727;
count__33222 = G__34728;
i__33223 = G__34729;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33220);
if(temp__5804__auto__){
var seq__33220__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33220__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33220__$1);
var G__34738 = cljs.core.chunk_rest(seq__33220__$1);
var G__34739 = c__5568__auto__;
var G__34740 = cljs.core.count(c__5568__auto__);
var G__34741 = (0);
seq__33220 = G__34738;
chunk__33221 = G__34739;
count__33222 = G__34740;
i__33223 = G__34741;
continue;
} else {
var el = cljs.core.first(seq__33220__$1);
var handler_34742__$1 = ((function (seq__33220,chunk__33221,count__33222,i__33223,el,seq__33220__$1,temp__5804__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__33220,chunk__33221,count__33222,i__33223,el,seq__33220__$1,temp__5804__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_34742__$1);


var G__34746 = cljs.core.next(seq__33220__$1);
var G__34747 = null;
var G__34748 = (0);
var G__34749 = (0);
seq__33220 = G__34746;
chunk__33221 = G__34747;
count__33222 = G__34748;
i__33223 = G__34749;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__33248 = arguments.length;
switch (G__33248) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__33261 = cljs.core.seq(events);
var chunk__33262 = null;
var count__33263 = (0);
var i__33264 = (0);
while(true){
if((i__33264 < count__33263)){
var vec__33278 = chunk__33262.cljs$core$IIndexed$_nth$arity$2(null,i__33264);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33278,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33278,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34776 = seq__33261;
var G__34777 = chunk__33262;
var G__34778 = count__33263;
var G__34779 = (i__33264 + (1));
seq__33261 = G__34776;
chunk__33262 = G__34777;
count__33263 = G__34778;
i__33264 = G__34779;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33261);
if(temp__5804__auto__){
var seq__33261__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33261__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33261__$1);
var G__34780 = cljs.core.chunk_rest(seq__33261__$1);
var G__34781 = c__5568__auto__;
var G__34782 = cljs.core.count(c__5568__auto__);
var G__34783 = (0);
seq__33261 = G__34780;
chunk__33262 = G__34781;
count__33263 = G__34782;
i__33264 = G__34783;
continue;
} else {
var vec__33285 = cljs.core.first(seq__33261__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33285,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33285,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__34785 = cljs.core.next(seq__33261__$1);
var G__34786 = null;
var G__34787 = (0);
var G__34788 = (0);
seq__33261 = G__34785;
chunk__33262 = G__34786;
count__33263 = G__34787;
i__33264 = G__34788;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__33291 = cljs.core.seq(styles);
var chunk__33292 = null;
var count__33293 = (0);
var i__33294 = (0);
while(true){
if((i__33294 < count__33293)){
var vec__33307 = chunk__33292.cljs$core$IIndexed$_nth$arity$2(null,i__33294);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33307,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33307,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__34792 = seq__33291;
var G__34793 = chunk__33292;
var G__34794 = count__33293;
var G__34795 = (i__33294 + (1));
seq__33291 = G__34792;
chunk__33292 = G__34793;
count__33293 = G__34794;
i__33294 = G__34795;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33291);
if(temp__5804__auto__){
var seq__33291__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33291__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33291__$1);
var G__34799 = cljs.core.chunk_rest(seq__33291__$1);
var G__34800 = c__5568__auto__;
var G__34801 = cljs.core.count(c__5568__auto__);
var G__34802 = (0);
seq__33291 = G__34799;
chunk__33292 = G__34800;
count__33293 = G__34801;
i__33294 = G__34802;
continue;
} else {
var vec__33311 = cljs.core.first(seq__33291__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33311,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33311,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__34803 = cljs.core.next(seq__33291__$1);
var G__34804 = null;
var G__34805 = (0);
var G__34806 = (0);
seq__33291 = G__34803;
chunk__33292 = G__34804;
count__33293 = G__34805;
i__33294 = G__34806;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__33315_34808 = key;
var G__33315_34809__$1 = (((G__33315_34808 instanceof cljs.core.Keyword))?G__33315_34808.fqn:null);
switch (G__33315_34809__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_34816 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5045__auto__ = goog.string.startsWith(ks_34816,"data-");
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return goog.string.startsWith(ks_34816,"aria-");
}
})())){
el.setAttribute(ks_34816,value);
} else {
(el[ks_34816] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__33331){
var map__33333 = p__33331;
var map__33333__$1 = cljs.core.__destructure_map(map__33333);
var props = map__33333__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33333__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__33335 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33335,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33335,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33335,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__33338 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__33338,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__33338;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__33341 = arguments.length;
switch (G__33341) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5804__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5804__auto__)){
var n = temp__5804__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__33347){
var vec__33349 = p__33347;
var seq__33350 = cljs.core.seq(vec__33349);
var first__33351 = cljs.core.first(seq__33350);
var seq__33350__$1 = cljs.core.next(seq__33350);
var nn = first__33351;
var first__33351__$1 = cljs.core.first(seq__33350__$1);
var seq__33350__$2 = cljs.core.next(seq__33350__$1);
var np = first__33351__$1;
var nc = seq__33350__$2;
var node = vec__33349;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33363 = nn;
var G__33364 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33363,G__33364) : create_fn.call(null,G__33363,G__33364));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__33368 = nn;
var G__33369 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__33368,G__33369) : create_fn.call(null,G__33368,G__33369));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__33411 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33411,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33411,(1),null);
var seq__33416_34836 = cljs.core.seq(node_children);
var chunk__33417_34838 = null;
var count__33418_34839 = (0);
var i__33419_34840 = (0);
while(true){
if((i__33419_34840 < count__33418_34839)){
var child_struct_34841 = chunk__33417_34838.cljs$core$IIndexed$_nth$arity$2(null,i__33419_34840);
var children_34842 = shadow.dom.dom_node(child_struct_34841);
if(cljs.core.seq_QMARK_(children_34842)){
var seq__33495_34844 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34842));
var chunk__33497_34845 = null;
var count__33498_34846 = (0);
var i__33499_34847 = (0);
while(true){
if((i__33499_34847 < count__33498_34846)){
var child_34852 = chunk__33497_34845.cljs$core$IIndexed$_nth$arity$2(null,i__33499_34847);
if(cljs.core.truth_(child_34852)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34852);


var G__34853 = seq__33495_34844;
var G__34854 = chunk__33497_34845;
var G__34855 = count__33498_34846;
var G__34856 = (i__33499_34847 + (1));
seq__33495_34844 = G__34853;
chunk__33497_34845 = G__34854;
count__33498_34846 = G__34855;
i__33499_34847 = G__34856;
continue;
} else {
var G__34857 = seq__33495_34844;
var G__34858 = chunk__33497_34845;
var G__34859 = count__33498_34846;
var G__34860 = (i__33499_34847 + (1));
seq__33495_34844 = G__34857;
chunk__33497_34845 = G__34858;
count__33498_34846 = G__34859;
i__33499_34847 = G__34860;
continue;
}
} else {
var temp__5804__auto___34861 = cljs.core.seq(seq__33495_34844);
if(temp__5804__auto___34861){
var seq__33495_34862__$1 = temp__5804__auto___34861;
if(cljs.core.chunked_seq_QMARK_(seq__33495_34862__$1)){
var c__5568__auto___34863 = cljs.core.chunk_first(seq__33495_34862__$1);
var G__34864 = cljs.core.chunk_rest(seq__33495_34862__$1);
var G__34865 = c__5568__auto___34863;
var G__34866 = cljs.core.count(c__5568__auto___34863);
var G__34867 = (0);
seq__33495_34844 = G__34864;
chunk__33497_34845 = G__34865;
count__33498_34846 = G__34866;
i__33499_34847 = G__34867;
continue;
} else {
var child_34868 = cljs.core.first(seq__33495_34862__$1);
if(cljs.core.truth_(child_34868)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34868);


var G__34869 = cljs.core.next(seq__33495_34862__$1);
var G__34870 = null;
var G__34871 = (0);
var G__34872 = (0);
seq__33495_34844 = G__34869;
chunk__33497_34845 = G__34870;
count__33498_34846 = G__34871;
i__33499_34847 = G__34872;
continue;
} else {
var G__34873 = cljs.core.next(seq__33495_34862__$1);
var G__34874 = null;
var G__34875 = (0);
var G__34876 = (0);
seq__33495_34844 = G__34873;
chunk__33497_34845 = G__34874;
count__33498_34846 = G__34875;
i__33499_34847 = G__34876;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34842);
}


var G__34877 = seq__33416_34836;
var G__34878 = chunk__33417_34838;
var G__34879 = count__33418_34839;
var G__34880 = (i__33419_34840 + (1));
seq__33416_34836 = G__34877;
chunk__33417_34838 = G__34878;
count__33418_34839 = G__34879;
i__33419_34840 = G__34880;
continue;
} else {
var temp__5804__auto___34881 = cljs.core.seq(seq__33416_34836);
if(temp__5804__auto___34881){
var seq__33416_34882__$1 = temp__5804__auto___34881;
if(cljs.core.chunked_seq_QMARK_(seq__33416_34882__$1)){
var c__5568__auto___34883 = cljs.core.chunk_first(seq__33416_34882__$1);
var G__34884 = cljs.core.chunk_rest(seq__33416_34882__$1);
var G__34885 = c__5568__auto___34883;
var G__34886 = cljs.core.count(c__5568__auto___34883);
var G__34887 = (0);
seq__33416_34836 = G__34884;
chunk__33417_34838 = G__34885;
count__33418_34839 = G__34886;
i__33419_34840 = G__34887;
continue;
} else {
var child_struct_34888 = cljs.core.first(seq__33416_34882__$1);
var children_34889 = shadow.dom.dom_node(child_struct_34888);
if(cljs.core.seq_QMARK_(children_34889)){
var seq__33514_34890 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_34889));
var chunk__33516_34891 = null;
var count__33517_34892 = (0);
var i__33518_34893 = (0);
while(true){
if((i__33518_34893 < count__33517_34892)){
var child_34894 = chunk__33516_34891.cljs$core$IIndexed$_nth$arity$2(null,i__33518_34893);
if(cljs.core.truth_(child_34894)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34894);


var G__34895 = seq__33514_34890;
var G__34896 = chunk__33516_34891;
var G__34897 = count__33517_34892;
var G__34898 = (i__33518_34893 + (1));
seq__33514_34890 = G__34895;
chunk__33516_34891 = G__34896;
count__33517_34892 = G__34897;
i__33518_34893 = G__34898;
continue;
} else {
var G__34899 = seq__33514_34890;
var G__34900 = chunk__33516_34891;
var G__34901 = count__33517_34892;
var G__34902 = (i__33518_34893 + (1));
seq__33514_34890 = G__34899;
chunk__33516_34891 = G__34900;
count__33517_34892 = G__34901;
i__33518_34893 = G__34902;
continue;
}
} else {
var temp__5804__auto___34903__$1 = cljs.core.seq(seq__33514_34890);
if(temp__5804__auto___34903__$1){
var seq__33514_34904__$1 = temp__5804__auto___34903__$1;
if(cljs.core.chunked_seq_QMARK_(seq__33514_34904__$1)){
var c__5568__auto___34905 = cljs.core.chunk_first(seq__33514_34904__$1);
var G__34906 = cljs.core.chunk_rest(seq__33514_34904__$1);
var G__34907 = c__5568__auto___34905;
var G__34908 = cljs.core.count(c__5568__auto___34905);
var G__34909 = (0);
seq__33514_34890 = G__34906;
chunk__33516_34891 = G__34907;
count__33517_34892 = G__34908;
i__33518_34893 = G__34909;
continue;
} else {
var child_34910 = cljs.core.first(seq__33514_34904__$1);
if(cljs.core.truth_(child_34910)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_34910);


var G__34911 = cljs.core.next(seq__33514_34904__$1);
var G__34912 = null;
var G__34913 = (0);
var G__34914 = (0);
seq__33514_34890 = G__34911;
chunk__33516_34891 = G__34912;
count__33517_34892 = G__34913;
i__33518_34893 = G__34914;
continue;
} else {
var G__34915 = cljs.core.next(seq__33514_34904__$1);
var G__34916 = null;
var G__34917 = (0);
var G__34918 = (0);
seq__33514_34890 = G__34915;
chunk__33516_34891 = G__34916;
count__33517_34892 = G__34917;
i__33518_34893 = G__34918;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_34889);
}


var G__34919 = cljs.core.next(seq__33416_34882__$1);
var G__34920 = null;
var G__34921 = (0);
var G__34922 = (0);
seq__33416_34836 = G__34919;
chunk__33417_34838 = G__34920;
count__33418_34839 = G__34921;
i__33419_34840 = G__34922;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__33582 = cljs.core.seq(node);
var chunk__33583 = null;
var count__33584 = (0);
var i__33585 = (0);
while(true){
if((i__33585 < count__33584)){
var n = chunk__33583.cljs$core$IIndexed$_nth$arity$2(null,i__33585);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34926 = seq__33582;
var G__34927 = chunk__33583;
var G__34928 = count__33584;
var G__34929 = (i__33585 + (1));
seq__33582 = G__34926;
chunk__33583 = G__34927;
count__33584 = G__34928;
i__33585 = G__34929;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33582);
if(temp__5804__auto__){
var seq__33582__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33582__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33582__$1);
var G__34930 = cljs.core.chunk_rest(seq__33582__$1);
var G__34931 = c__5568__auto__;
var G__34932 = cljs.core.count(c__5568__auto__);
var G__34933 = (0);
seq__33582 = G__34930;
chunk__33583 = G__34931;
count__33584 = G__34932;
i__33585 = G__34933;
continue;
} else {
var n = cljs.core.first(seq__33582__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__34934 = cljs.core.next(seq__33582__$1);
var G__34935 = null;
var G__34936 = (0);
var G__34937 = (0);
seq__33582 = G__34934;
chunk__33583 = G__34935;
count__33584 = G__34936;
i__33585 = G__34937;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__33613 = arguments.length;
switch (G__33613) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__33639 = arguments.length;
switch (G__33639) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__33694 = arguments.length;
switch (G__33694) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5045__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5775__auto__ = [];
var len__5769__auto___34944 = arguments.length;
var i__5770__auto___34945 = (0);
while(true){
if((i__5770__auto___34945 < len__5769__auto___34944)){
args__5775__auto__.push((arguments[i__5770__auto___34945]));

var G__34946 = (i__5770__auto___34945 + (1));
i__5770__auto___34945 = G__34946;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((0) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5776__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__33721_34947 = cljs.core.seq(nodes);
var chunk__33722_34948 = null;
var count__33723_34949 = (0);
var i__33724_34950 = (0);
while(true){
if((i__33724_34950 < count__33723_34949)){
var node_34951 = chunk__33722_34948.cljs$core$IIndexed$_nth$arity$2(null,i__33724_34950);
fragment.appendChild(shadow.dom._to_dom(node_34951));


var G__34952 = seq__33721_34947;
var G__34953 = chunk__33722_34948;
var G__34954 = count__33723_34949;
var G__34955 = (i__33724_34950 + (1));
seq__33721_34947 = G__34952;
chunk__33722_34948 = G__34953;
count__33723_34949 = G__34954;
i__33724_34950 = G__34955;
continue;
} else {
var temp__5804__auto___34956 = cljs.core.seq(seq__33721_34947);
if(temp__5804__auto___34956){
var seq__33721_34957__$1 = temp__5804__auto___34956;
if(cljs.core.chunked_seq_QMARK_(seq__33721_34957__$1)){
var c__5568__auto___34958 = cljs.core.chunk_first(seq__33721_34957__$1);
var G__34959 = cljs.core.chunk_rest(seq__33721_34957__$1);
var G__34960 = c__5568__auto___34958;
var G__34961 = cljs.core.count(c__5568__auto___34958);
var G__34962 = (0);
seq__33721_34947 = G__34959;
chunk__33722_34948 = G__34960;
count__33723_34949 = G__34961;
i__33724_34950 = G__34962;
continue;
} else {
var node_34963 = cljs.core.first(seq__33721_34957__$1);
fragment.appendChild(shadow.dom._to_dom(node_34963));


var G__34964 = cljs.core.next(seq__33721_34957__$1);
var G__34965 = null;
var G__34966 = (0);
var G__34967 = (0);
seq__33721_34947 = G__34964;
chunk__33722_34948 = G__34965;
count__33723_34949 = G__34966;
i__33724_34950 = G__34967;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq33716){
var self__5755__auto__ = this;
return self__5755__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq33716));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__33733_34971 = cljs.core.seq(scripts);
var chunk__33734_34972 = null;
var count__33735_34973 = (0);
var i__33736_34974 = (0);
while(true){
if((i__33736_34974 < count__33735_34973)){
var vec__33762_34979 = chunk__33734_34972.cljs$core$IIndexed$_nth$arity$2(null,i__33736_34974);
var script_tag_34980 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33762_34979,(0),null);
var script_body_34981 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33762_34979,(1),null);
eval(script_body_34981);


var G__34982 = seq__33733_34971;
var G__34983 = chunk__33734_34972;
var G__34984 = count__33735_34973;
var G__34985 = (i__33736_34974 + (1));
seq__33733_34971 = G__34982;
chunk__33734_34972 = G__34983;
count__33735_34973 = G__34984;
i__33736_34974 = G__34985;
continue;
} else {
var temp__5804__auto___34986 = cljs.core.seq(seq__33733_34971);
if(temp__5804__auto___34986){
var seq__33733_34987__$1 = temp__5804__auto___34986;
if(cljs.core.chunked_seq_QMARK_(seq__33733_34987__$1)){
var c__5568__auto___34988 = cljs.core.chunk_first(seq__33733_34987__$1);
var G__34989 = cljs.core.chunk_rest(seq__33733_34987__$1);
var G__34990 = c__5568__auto___34988;
var G__34991 = cljs.core.count(c__5568__auto___34988);
var G__34992 = (0);
seq__33733_34971 = G__34989;
chunk__33734_34972 = G__34990;
count__33735_34973 = G__34991;
i__33736_34974 = G__34992;
continue;
} else {
var vec__33771_34993 = cljs.core.first(seq__33733_34987__$1);
var script_tag_34994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33771_34993,(0),null);
var script_body_34995 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33771_34993,(1),null);
eval(script_body_34995);


var G__34996 = cljs.core.next(seq__33733_34987__$1);
var G__34997 = null;
var G__34998 = (0);
var G__34999 = (0);
seq__33733_34971 = G__34996;
chunk__33734_34972 = G__34997;
count__33735_34973 = G__34998;
i__33736_34974 = G__34999;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__33781){
var vec__33784 = p__33781;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33784,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33784,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__33867 = arguments.length;
switch (G__33867) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__33904 = cljs.core.seq(style_keys);
var chunk__33905 = null;
var count__33906 = (0);
var i__33907 = (0);
while(true){
if((i__33907 < count__33906)){
var it = chunk__33905.cljs$core$IIndexed$_nth$arity$2(null,i__33907);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35008 = seq__33904;
var G__35009 = chunk__33905;
var G__35010 = count__33906;
var G__35011 = (i__33907 + (1));
seq__33904 = G__35008;
chunk__33905 = G__35009;
count__33906 = G__35010;
i__33907 = G__35011;
continue;
} else {
var temp__5804__auto__ = cljs.core.seq(seq__33904);
if(temp__5804__auto__){
var seq__33904__$1 = temp__5804__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__33904__$1)){
var c__5568__auto__ = cljs.core.chunk_first(seq__33904__$1);
var G__35012 = cljs.core.chunk_rest(seq__33904__$1);
var G__35013 = c__5568__auto__;
var G__35014 = cljs.core.count(c__5568__auto__);
var G__35015 = (0);
seq__33904 = G__35012;
chunk__33905 = G__35013;
count__33906 = G__35014;
i__33907 = G__35015;
continue;
} else {
var it = cljs.core.first(seq__33904__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__35016 = cljs.core.next(seq__33904__$1);
var G__35017 = null;
var G__35018 = (0);
var G__35019 = (0);
seq__33904 = G__35016;
chunk__33905 = G__35017;
count__33906 = G__35018;
i__33907 = G__35019;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k33915,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__33923 = k33915;
var G__33923__$1 = (((G__33923 instanceof cljs.core.Keyword))?G__33923.fqn:null);
switch (G__33923__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k33915,else__5346__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__33933){
var vec__33934 = p__33933;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33934,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33934,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33914){
var self__ = this;
var G__33914__$1 = this;
return (new cljs.core.RecordIter((0),G__33914__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this33916,other33917){
var self__ = this;
var this33916__$1 = this;
return (((!((other33917 == null)))) && ((((this33916__$1.constructor === other33917.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33916__$1.x,other33917.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33916__$1.y,other33917.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33916__$1.__extmap,other33917.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k33915){
var self__ = this;
var this__5350__auto____$1 = this;
var G__33952 = k33915;
var G__33952__$1 = (((G__33952 instanceof cljs.core.Keyword))?G__33952.fqn:null);
switch (G__33952__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k33915);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__33914){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__33953 = cljs.core.keyword_identical_QMARK_;
var expr__33954 = k__5352__auto__;
if(cljs.core.truth_((pred__33953.cljs$core$IFn$_invoke$arity$2 ? pred__33953.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__33954) : pred__33953.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__33954)))){
return (new shadow.dom.Coordinate(G__33914,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__33953.cljs$core$IFn$_invoke$arity$2 ? pred__33953.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__33954) : pred__33953.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__33954)))){
return (new shadow.dom.Coordinate(self__.x,G__33914,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__33914),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__33914){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__33914,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__33922){
var extmap__5385__auto__ = (function (){var G__33962 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__33922,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__33922)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__33962);
} else {
return G__33962;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__33922),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__33922),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5343__auto__,k__5344__auto__){
var self__ = this;
var this__5343__auto____$1 = this;
return this__5343__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__5344__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5345__auto__,k33982,else__5346__auto__){
var self__ = this;
var this__5345__auto____$1 = this;
var G__33995 = k33982;
var G__33995__$1 = (((G__33995 instanceof cljs.core.Keyword))?G__33995.fqn:null);
switch (G__33995__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k33982,else__5346__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5363__auto__,f__5364__auto__,init__5365__auto__){
var self__ = this;
var this__5363__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5366__auto__,p__33999){
var vec__34000 = p__33999;
var k__5367__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34000,(0),null);
var v__5368__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34000,(1),null);
return (f__5364__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5364__auto__.cljs$core$IFn$_invoke$arity$3(ret__5366__auto__,k__5367__auto__,v__5368__auto__) : f__5364__auto__.call(null,ret__5366__auto__,k__5367__auto__,v__5368__auto__));
}),init__5365__auto__,this__5363__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5358__auto__,writer__5359__auto__,opts__5360__auto__){
var self__ = this;
var this__5358__auto____$1 = this;
var pr_pair__5361__auto__ = (function (keyval__5362__auto__){
return cljs.core.pr_sequential_writer(writer__5359__auto__,cljs.core.pr_writer,""," ","",opts__5360__auto__,keyval__5362__auto__);
});
return cljs.core.pr_sequential_writer(writer__5359__auto__,pr_pair__5361__auto__,"#shadow.dom.Size{",", ","}",opts__5360__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__33981){
var self__ = this;
var G__33981__$1 = this;
return (new cljs.core.RecordIter((0),G__33981__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5341__auto__){
var self__ = this;
var this__5341__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5338__auto__){
var self__ = this;
var this__5338__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5347__auto__){
var self__ = this;
var this__5347__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5339__auto__){
var self__ = this;
var this__5339__auto____$1 = this;
var h__5154__auto__ = self__.__hash;
if((!((h__5154__auto__ == null)))){
return h__5154__auto__;
} else {
var h__5154__auto____$1 = (function (coll__5340__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5340__auto__));
})(this__5339__auto____$1);
(self__.__hash = h__5154__auto____$1);

return h__5154__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this33983,other33984){
var self__ = this;
var this33983__$1 = this;
return (((!((other33984 == null)))) && ((((this33983__$1.constructor === other33984.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33983__$1.w,other33984.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33983__$1.h,other33984.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this33983__$1.__extmap,other33984.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5353__auto__,k__5354__auto__){
var self__ = this;
var this__5353__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5354__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5353__auto____$1),self__.__meta),k__5354__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5354__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5350__auto__,k33982){
var self__ = this;
var this__5350__auto____$1 = this;
var G__34046 = k33982;
var G__34046__$1 = (((G__34046 instanceof cljs.core.Keyword))?G__34046.fqn:null);
switch (G__34046__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k33982);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5351__auto__,k__5352__auto__,G__33981){
var self__ = this;
var this__5351__auto____$1 = this;
var pred__34049 = cljs.core.keyword_identical_QMARK_;
var expr__34050 = k__5352__auto__;
if(cljs.core.truth_((pred__34049.cljs$core$IFn$_invoke$arity$2 ? pred__34049.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__34050) : pred__34049.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__34050)))){
return (new shadow.dom.Size(G__33981,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__34049.cljs$core$IFn$_invoke$arity$2 ? pred__34049.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__34050) : pred__34049.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__34050)))){
return (new shadow.dom.Size(self__.w,G__33981,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5352__auto__,G__33981),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5356__auto__){
var self__ = this;
var this__5356__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5342__auto__,G__33981){
var self__ = this;
var this__5342__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__33981,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5348__auto__,entry__5349__auto__){
var self__ = this;
var this__5348__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5349__auto__)){
return this__5348__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__5349__auto__,(0)),cljs.core._nth(entry__5349__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5348__auto____$1,entry__5349__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5389__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5389__auto__,writer__5390__auto__){
return cljs.core._write(writer__5390__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__33988){
var extmap__5385__auto__ = (function (){var G__34057 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__33988,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__33988)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34057);
} else {
return G__34057;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__33988),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__33988),null,cljs.core.not_empty(extmap__5385__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5633__auto__ = opts;
var l__5634__auto__ = a__5633__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5634__auto__)){
var G__35048 = (i + (1));
var G__35049 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__35048;
ret = G__35049;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__34077){
var vec__34085 = p__34077;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34085,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34085,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__34100 = arguments.length;
switch (G__34100) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5802__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5802__auto__)){
var child = temp__5802__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__35054 = ps;
var G__35055 = (i + (1));
el__$1 = G__35054;
i = G__35055;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__34270 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34270,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34270,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34270,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__34276_35060 = cljs.core.seq(props);
var chunk__34277_35061 = null;
var count__34278_35062 = (0);
var i__34279_35063 = (0);
while(true){
if((i__34279_35063 < count__34278_35062)){
var vec__34310_35064 = chunk__34277_35061.cljs$core$IIndexed$_nth$arity$2(null,i__34279_35063);
var k_35065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34310_35064,(0),null);
var v_35066 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34310_35064,(1),null);
el.setAttributeNS((function (){var temp__5804__auto__ = cljs.core.namespace(k_35065);
if(cljs.core.truth_(temp__5804__auto__)){
var ns = temp__5804__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35065),v_35066);


var G__35071 = seq__34276_35060;
var G__35072 = chunk__34277_35061;
var G__35073 = count__34278_35062;
var G__35074 = (i__34279_35063 + (1));
seq__34276_35060 = G__35071;
chunk__34277_35061 = G__35072;
count__34278_35062 = G__35073;
i__34279_35063 = G__35074;
continue;
} else {
var temp__5804__auto___35075 = cljs.core.seq(seq__34276_35060);
if(temp__5804__auto___35075){
var seq__34276_35076__$1 = temp__5804__auto___35075;
if(cljs.core.chunked_seq_QMARK_(seq__34276_35076__$1)){
var c__5568__auto___35077 = cljs.core.chunk_first(seq__34276_35076__$1);
var G__35078 = cljs.core.chunk_rest(seq__34276_35076__$1);
var G__35079 = c__5568__auto___35077;
var G__35080 = cljs.core.count(c__5568__auto___35077);
var G__35081 = (0);
seq__34276_35060 = G__35078;
chunk__34277_35061 = G__35079;
count__34278_35062 = G__35080;
i__34279_35063 = G__35081;
continue;
} else {
var vec__34340_35082 = cljs.core.first(seq__34276_35076__$1);
var k_35083 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34340_35082,(0),null);
var v_35084 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34340_35082,(1),null);
el.setAttributeNS((function (){var temp__5804__auto____$1 = cljs.core.namespace(k_35083);
if(cljs.core.truth_(temp__5804__auto____$1)){
var ns = temp__5804__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_35083),v_35084);


var G__35085 = cljs.core.next(seq__34276_35076__$1);
var G__35086 = null;
var G__35087 = (0);
var G__35088 = (0);
seq__34276_35060 = G__35085;
chunk__34277_35061 = G__35086;
count__34278_35062 = G__35087;
i__34279_35063 = G__35088;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__34376 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34376,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34376,(1),null);
var seq__34380_35091 = cljs.core.seq(node_children);
var chunk__34382_35092 = null;
var count__34383_35093 = (0);
var i__34384_35094 = (0);
while(true){
if((i__34384_35094 < count__34383_35093)){
var child_struct_35095 = chunk__34382_35092.cljs$core$IIndexed$_nth$arity$2(null,i__34384_35094);
if((!((child_struct_35095 == null)))){
if(typeof child_struct_35095 === 'string'){
var text_35099 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35099),child_struct_35095].join(''));
} else {
var children_35100 = shadow.dom.svg_node(child_struct_35095);
if(cljs.core.seq_QMARK_(children_35100)){
var seq__34443_35101 = cljs.core.seq(children_35100);
var chunk__34445_35102 = null;
var count__34446_35103 = (0);
var i__34447_35104 = (0);
while(true){
if((i__34447_35104 < count__34446_35103)){
var child_35105 = chunk__34445_35102.cljs$core$IIndexed$_nth$arity$2(null,i__34447_35104);
if(cljs.core.truth_(child_35105)){
node.appendChild(child_35105);


var G__35106 = seq__34443_35101;
var G__35107 = chunk__34445_35102;
var G__35108 = count__34446_35103;
var G__35109 = (i__34447_35104 + (1));
seq__34443_35101 = G__35106;
chunk__34445_35102 = G__35107;
count__34446_35103 = G__35108;
i__34447_35104 = G__35109;
continue;
} else {
var G__35110 = seq__34443_35101;
var G__35111 = chunk__34445_35102;
var G__35112 = count__34446_35103;
var G__35113 = (i__34447_35104 + (1));
seq__34443_35101 = G__35110;
chunk__34445_35102 = G__35111;
count__34446_35103 = G__35112;
i__34447_35104 = G__35113;
continue;
}
} else {
var temp__5804__auto___35114 = cljs.core.seq(seq__34443_35101);
if(temp__5804__auto___35114){
var seq__34443_35115__$1 = temp__5804__auto___35114;
if(cljs.core.chunked_seq_QMARK_(seq__34443_35115__$1)){
var c__5568__auto___35116 = cljs.core.chunk_first(seq__34443_35115__$1);
var G__35117 = cljs.core.chunk_rest(seq__34443_35115__$1);
var G__35118 = c__5568__auto___35116;
var G__35119 = cljs.core.count(c__5568__auto___35116);
var G__35120 = (0);
seq__34443_35101 = G__35117;
chunk__34445_35102 = G__35118;
count__34446_35103 = G__35119;
i__34447_35104 = G__35120;
continue;
} else {
var child_35124 = cljs.core.first(seq__34443_35115__$1);
if(cljs.core.truth_(child_35124)){
node.appendChild(child_35124);


var G__35125 = cljs.core.next(seq__34443_35115__$1);
var G__35126 = null;
var G__35127 = (0);
var G__35128 = (0);
seq__34443_35101 = G__35125;
chunk__34445_35102 = G__35126;
count__34446_35103 = G__35127;
i__34447_35104 = G__35128;
continue;
} else {
var G__35129 = cljs.core.next(seq__34443_35115__$1);
var G__35130 = null;
var G__35131 = (0);
var G__35132 = (0);
seq__34443_35101 = G__35129;
chunk__34445_35102 = G__35130;
count__34446_35103 = G__35131;
i__34447_35104 = G__35132;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35100);
}
}


var G__35134 = seq__34380_35091;
var G__35135 = chunk__34382_35092;
var G__35136 = count__34383_35093;
var G__35137 = (i__34384_35094 + (1));
seq__34380_35091 = G__35134;
chunk__34382_35092 = G__35135;
count__34383_35093 = G__35136;
i__34384_35094 = G__35137;
continue;
} else {
var G__35138 = seq__34380_35091;
var G__35139 = chunk__34382_35092;
var G__35140 = count__34383_35093;
var G__35141 = (i__34384_35094 + (1));
seq__34380_35091 = G__35138;
chunk__34382_35092 = G__35139;
count__34383_35093 = G__35140;
i__34384_35094 = G__35141;
continue;
}
} else {
var temp__5804__auto___35143 = cljs.core.seq(seq__34380_35091);
if(temp__5804__auto___35143){
var seq__34380_35144__$1 = temp__5804__auto___35143;
if(cljs.core.chunked_seq_QMARK_(seq__34380_35144__$1)){
var c__5568__auto___35145 = cljs.core.chunk_first(seq__34380_35144__$1);
var G__35146 = cljs.core.chunk_rest(seq__34380_35144__$1);
var G__35147 = c__5568__auto___35145;
var G__35148 = cljs.core.count(c__5568__auto___35145);
var G__35149 = (0);
seq__34380_35091 = G__35146;
chunk__34382_35092 = G__35147;
count__34383_35093 = G__35148;
i__34384_35094 = G__35149;
continue;
} else {
var child_struct_35151 = cljs.core.first(seq__34380_35144__$1);
if((!((child_struct_35151 == null)))){
if(typeof child_struct_35151 === 'string'){
var text_35156 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_35156),child_struct_35151].join(''));
} else {
var children_35157 = shadow.dom.svg_node(child_struct_35151);
if(cljs.core.seq_QMARK_(children_35157)){
var seq__34452_35158 = cljs.core.seq(children_35157);
var chunk__34454_35159 = null;
var count__34455_35160 = (0);
var i__34456_35161 = (0);
while(true){
if((i__34456_35161 < count__34455_35160)){
var child_35164 = chunk__34454_35159.cljs$core$IIndexed$_nth$arity$2(null,i__34456_35161);
if(cljs.core.truth_(child_35164)){
node.appendChild(child_35164);


var G__35165 = seq__34452_35158;
var G__35166 = chunk__34454_35159;
var G__35167 = count__34455_35160;
var G__35168 = (i__34456_35161 + (1));
seq__34452_35158 = G__35165;
chunk__34454_35159 = G__35166;
count__34455_35160 = G__35167;
i__34456_35161 = G__35168;
continue;
} else {
var G__35169 = seq__34452_35158;
var G__35170 = chunk__34454_35159;
var G__35171 = count__34455_35160;
var G__35172 = (i__34456_35161 + (1));
seq__34452_35158 = G__35169;
chunk__34454_35159 = G__35170;
count__34455_35160 = G__35171;
i__34456_35161 = G__35172;
continue;
}
} else {
var temp__5804__auto___35173__$1 = cljs.core.seq(seq__34452_35158);
if(temp__5804__auto___35173__$1){
var seq__34452_35174__$1 = temp__5804__auto___35173__$1;
if(cljs.core.chunked_seq_QMARK_(seq__34452_35174__$1)){
var c__5568__auto___35175 = cljs.core.chunk_first(seq__34452_35174__$1);
var G__35176 = cljs.core.chunk_rest(seq__34452_35174__$1);
var G__35177 = c__5568__auto___35175;
var G__35178 = cljs.core.count(c__5568__auto___35175);
var G__35179 = (0);
seq__34452_35158 = G__35176;
chunk__34454_35159 = G__35177;
count__34455_35160 = G__35178;
i__34456_35161 = G__35179;
continue;
} else {
var child_35180 = cljs.core.first(seq__34452_35174__$1);
if(cljs.core.truth_(child_35180)){
node.appendChild(child_35180);


var G__35181 = cljs.core.next(seq__34452_35174__$1);
var G__35182 = null;
var G__35183 = (0);
var G__35184 = (0);
seq__34452_35158 = G__35181;
chunk__34454_35159 = G__35182;
count__34455_35160 = G__35183;
i__34456_35161 = G__35184;
continue;
} else {
var G__35185 = cljs.core.next(seq__34452_35174__$1);
var G__35186 = null;
var G__35187 = (0);
var G__35188 = (0);
seq__34452_35158 = G__35185;
chunk__34454_35159 = G__35186;
count__34455_35160 = G__35187;
i__34456_35161 = G__35188;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_35157);
}
}


var G__35189 = cljs.core.next(seq__34380_35144__$1);
var G__35190 = null;
var G__35191 = (0);
var G__35192 = (0);
seq__34380_35091 = G__35189;
chunk__34382_35092 = G__35190;
count__34383_35093 = G__35191;
i__34384_35094 = G__35192;
continue;
} else {
var G__35193 = cljs.core.next(seq__34380_35144__$1);
var G__35194 = null;
var G__35195 = (0);
var G__35196 = (0);
seq__34380_35091 = G__35193;
chunk__34382_35092 = G__35194;
count__34383_35093 = G__35195;
i__34384_35094 = G__35196;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5775__auto__ = [];
var len__5769__auto___35218 = arguments.length;
var i__5770__auto___35219 = (0);
while(true){
if((i__5770__auto___35219 < len__5769__auto___35218)){
args__5775__auto__.push((arguments[i__5770__auto___35219]));

var G__35228 = (i__5770__auto___35219 + (1));
i__5770__auto___35219 = G__35228;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq34462){
var G__34463 = cljs.core.first(seq34462);
var seq34462__$1 = cljs.core.next(seq34462);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34463,seq34462__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__34538 = arguments.length;
switch (G__34538) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__5043__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__5043__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__5043__auto__;
}
})())){
var c__27606__auto___35249 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_34610){
var state_val_34611 = (state_34610[(1)]);
if((state_val_34611 === (1))){
var state_34610__$1 = state_34610;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34610__$1,(2),once_or_cleanup);
} else {
if((state_val_34611 === (2))){
var inst_34607 = (state_34610[(2)]);
var inst_34608 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_34610__$1 = (function (){var statearr_34612 = state_34610;
(statearr_34612[(7)] = inst_34607);

return statearr_34612;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_34610__$1,inst_34608);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__27443__auto__ = null;
var shadow$dom$state_machine__27443__auto____0 = (function (){
var statearr_34613 = [null,null,null,null,null,null,null,null];
(statearr_34613[(0)] = shadow$dom$state_machine__27443__auto__);

(statearr_34613[(1)] = (1));

return statearr_34613;
});
var shadow$dom$state_machine__27443__auto____1 = (function (state_34610){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_34610);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e34614){var ex__27446__auto__ = e34614;
var statearr_34615_35257 = state_34610;
(statearr_34615_35257[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_34610[(4)]))){
var statearr_34616_35258 = state_34610;
(statearr_34616_35258[(1)] = cljs.core.first((state_34610[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__35259 = state_34610;
state_34610 = G__35259;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
shadow$dom$state_machine__27443__auto__ = function(state_34610){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__27443__auto____0.call(this);
case 1:
return shadow$dom$state_machine__27443__auto____1.call(this,state_34610);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__27443__auto____0;
shadow$dom$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__27443__auto____1;
return shadow$dom$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_34617 = f__27607__auto__();
(statearr_34617[(6)] = c__27606__auto___35249);

return statearr_34617;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
