goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30129 = (function (f,blockable,meta30130){
this.f = f;
this.blockable = blockable;
this.meta30130 = meta30130;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30129.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30131,meta30130__$1){
var self__ = this;
var _30131__$1 = this;
return (new cljs.core.async.t_cljs$core$async30129(self__.f,self__.blockable,meta30130__$1));
}));

(cljs.core.async.t_cljs$core$async30129.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30131){
var self__ = this;
var _30131__$1 = this;
return self__.meta30130;
}));

(cljs.core.async.t_cljs$core$async30129.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30129.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30129.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async30129.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async30129.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta30130","meta30130",1434330832,null)], null);
}));

(cljs.core.async.t_cljs$core$async30129.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30129.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30129");

(cljs.core.async.t_cljs$core$async30129.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30129");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30129.
 */
cljs.core.async.__GT_t_cljs$core$async30129 = (function cljs$core$async$__GT_t_cljs$core$async30129(f,blockable,meta30130){
return (new cljs.core.async.t_cljs$core$async30129(f,blockable,meta30130));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__30121 = arguments.length;
switch (G__30121) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async30129(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__30152 = arguments.length;
switch (G__30152) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__30165 = arguments.length;
switch (G__30165) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__30180 = arguments.length;
switch (G__30180) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_32983 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32983) : fn1.call(null,val_32983));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_32983) : fn1.call(null,val_32983));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__30187 = arguments.length;
switch (G__30187) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5802__auto__)){
var ret = temp__5802__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5802__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5802__auto__)){
var retb = temp__5802__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5636__auto___33002 = n;
var x_33003 = (0);
while(true){
if((x_33003 < n__5636__auto___33002)){
(a[x_33003] = x_33003);

var G__33004 = (x_33003 + (1));
x_33003 = G__33004;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30192 = (function (flag,meta30193){
this.flag = flag;
this.meta30193 = meta30193;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30194,meta30193__$1){
var self__ = this;
var _30194__$1 = this;
return (new cljs.core.async.t_cljs$core$async30192(self__.flag,meta30193__$1));
}));

(cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30194){
var self__ = this;
var _30194__$1 = this;
return self__.meta30193;
}));

(cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30192.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async30192.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta30193","meta30193",1761183619,null)], null);
}));

(cljs.core.async.t_cljs$core$async30192.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30192.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30192");

(cljs.core.async.t_cljs$core$async30192.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30192");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30192.
 */
cljs.core.async.__GT_t_cljs$core$async30192 = (function cljs$core$async$__GT_t_cljs$core$async30192(flag,meta30193){
return (new cljs.core.async.t_cljs$core$async30192(flag,meta30193));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async30192(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30197 = (function (flag,cb,meta30198){
this.flag = flag;
this.cb = cb;
this.meta30198 = meta30198;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30197.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30199,meta30198__$1){
var self__ = this;
var _30199__$1 = this;
return (new cljs.core.async.t_cljs$core$async30197(self__.flag,self__.cb,meta30198__$1));
}));

(cljs.core.async.t_cljs$core$async30197.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30199){
var self__ = this;
var _30199__$1 = this;
return self__.meta30198;
}));

(cljs.core.async.t_cljs$core$async30197.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30197.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async30197.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async30197.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async30197.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta30198","meta30198",173826118,null)], null);
}));

(cljs.core.async.t_cljs$core$async30197.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30197.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30197");

(cljs.core.async.t_cljs$core$async30197.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30197");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30197.
 */
cljs.core.async.__GT_t_cljs$core$async30197 = (function cljs$core$async$__GT_t_cljs$core$async30197(flag,cb,meta30198){
return (new cljs.core.async.t_cljs$core$async30197(flag,cb,meta30198));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async30197(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30204_SHARP_){
var G__30210 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30204_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30210) : fret.call(null,G__30210));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__30205_SHARP_){
var G__30211 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__30205_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__30211) : fret.call(null,G__30211));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5045__auto__ = wport;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return port;
}
})()], null));
} else {
var G__33032 = (i + (1));
i = G__33032;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5045__auto__ = ret;
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5804__auto__ = (function (){var and__5043__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__5043__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__5043__auto__;
}
})();
if(cljs.core.truth_(temp__5804__auto__)){
var got = temp__5804__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___33036 = arguments.length;
var i__5770__auto___33040 = (0);
while(true){
if((i__5770__auto___33040 < len__5769__auto___33036)){
args__5775__auto__.push((arguments[i__5770__auto___33040]));

var G__33042 = (i__5770__auto___33040 + (1));
i__5770__auto___33040 = G__33042;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((1) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5776__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__30218){
var map__30219 = p__30218;
var map__30219__$1 = cljs.core.__destructure_map(map__30219);
var opts = map__30219__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq30214){
var G__30215 = cljs.core.first(seq30214);
var seq30214__$1 = cljs.core.next(seq30214);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__30215,seq30214__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__30225 = arguments.length;
switch (G__30225) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__27606__auto___33056 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_30249){
var state_val_30250 = (state_30249[(1)]);
if((state_val_30250 === (7))){
var inst_30245 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
var statearr_30251_33058 = state_30249__$1;
(statearr_30251_33058[(2)] = inst_30245);

(statearr_30251_33058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (1))){
var state_30249__$1 = state_30249;
var statearr_30252_33060 = state_30249__$1;
(statearr_30252_33060[(2)] = null);

(statearr_30252_33060[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (4))){
var inst_30228 = (state_30249[(7)]);
var inst_30228__$1 = (state_30249[(2)]);
var inst_30229 = (inst_30228__$1 == null);
var state_30249__$1 = (function (){var statearr_30253 = state_30249;
(statearr_30253[(7)] = inst_30228__$1);

return statearr_30253;
})();
if(cljs.core.truth_(inst_30229)){
var statearr_30254_33061 = state_30249__$1;
(statearr_30254_33061[(1)] = (5));

} else {
var statearr_30255_33063 = state_30249__$1;
(statearr_30255_33063[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (13))){
var state_30249__$1 = state_30249;
var statearr_30256_33064 = state_30249__$1;
(statearr_30256_33064[(2)] = null);

(statearr_30256_33064[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (6))){
var inst_30228 = (state_30249[(7)]);
var state_30249__$1 = state_30249;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30249__$1,(11),to,inst_30228);
} else {
if((state_val_30250 === (3))){
var inst_30247 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30249__$1,inst_30247);
} else {
if((state_val_30250 === (12))){
var state_30249__$1 = state_30249;
var statearr_30257_33066 = state_30249__$1;
(statearr_30257_33066[(2)] = null);

(statearr_30257_33066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (2))){
var state_30249__$1 = state_30249;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30249__$1,(4),from);
} else {
if((state_val_30250 === (11))){
var inst_30238 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
if(cljs.core.truth_(inst_30238)){
var statearr_30258_33072 = state_30249__$1;
(statearr_30258_33072[(1)] = (12));

} else {
var statearr_30259_33073 = state_30249__$1;
(statearr_30259_33073[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (9))){
var state_30249__$1 = state_30249;
var statearr_30260_33077 = state_30249__$1;
(statearr_30260_33077[(2)] = null);

(statearr_30260_33077[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (5))){
var state_30249__$1 = state_30249;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30261_33079 = state_30249__$1;
(statearr_30261_33079[(1)] = (8));

} else {
var statearr_30262_33080 = state_30249__$1;
(statearr_30262_33080[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (14))){
var inst_30243 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
var statearr_30263_33081 = state_30249__$1;
(statearr_30263_33081[(2)] = inst_30243);

(statearr_30263_33081[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (10))){
var inst_30235 = (state_30249[(2)]);
var state_30249__$1 = state_30249;
var statearr_30264_33082 = state_30249__$1;
(statearr_30264_33082[(2)] = inst_30235);

(statearr_30264_33082[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30250 === (8))){
var inst_30232 = cljs.core.async.close_BANG_(to);
var state_30249__$1 = state_30249;
var statearr_30265_33086 = state_30249__$1;
(statearr_30265_33086[(2)] = inst_30232);

(statearr_30265_33086[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_30266 = [null,null,null,null,null,null,null,null];
(statearr_30266[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_30266[(1)] = (1));

return statearr_30266;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_30249){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30249);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30267){var ex__27446__auto__ = e30267;
var statearr_30268_33089 = state_30249;
(statearr_30268_33089[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30249[(4)]))){
var statearr_30269_33093 = state_30249;
(statearr_30269_33093[(1)] = cljs.core.first((state_30249[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33095 = state_30249;
state_30249 = G__33095;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_30249){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_30249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_30270 = f__27607__auto__();
(statearr_30270[(6)] = c__27606__auto___33056);

return statearr_30270;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__30271){
var vec__30272 = p__30271;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30272,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30272,(1),null);
var job = vec__30272;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__27606__auto___33100 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_30279){
var state_val_30280 = (state_30279[(1)]);
if((state_val_30280 === (1))){
var state_30279__$1 = state_30279;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30279__$1,(2),res,v);
} else {
if((state_val_30280 === (2))){
var inst_30276 = (state_30279[(2)]);
var inst_30277 = cljs.core.async.close_BANG_(res);
var state_30279__$1 = (function (){var statearr_30288 = state_30279;
(statearr_30288[(7)] = inst_30276);

return statearr_30288;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_30279__$1,inst_30277);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0 = (function (){
var statearr_30289 = [null,null,null,null,null,null,null,null];
(statearr_30289[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__);

(statearr_30289[(1)] = (1));

return statearr_30289;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1 = (function (state_30279){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30279);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30290){var ex__27446__auto__ = e30290;
var statearr_30291_33108 = state_30279;
(statearr_30291_33108[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30279[(4)]))){
var statearr_30292_33109 = state_30279;
(statearr_30292_33109[(1)] = cljs.core.first((state_30279[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33111 = state_30279;
state_30279 = G__33111;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = function(state_30279){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1.call(this,state_30279);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_30293 = f__27607__auto__();
(statearr_30293[(6)] = c__27606__auto___33100);

return statearr_30293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__30294){
var vec__30295 = p__30294;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30295,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30295,(1),null);
var job = vec__30295;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5636__auto___33112 = n;
var __33113 = (0);
while(true){
if((__33113 < n__5636__auto___33112)){
var G__30298_33116 = type;
var G__30298_33117__$1 = (((G__30298_33116 instanceof cljs.core.Keyword))?G__30298_33116.fqn:null);
switch (G__30298_33117__$1) {
case "compute":
var c__27606__auto___33119 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33113,c__27606__auto___33119,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async){
return (function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = ((function (__33113,c__27606__auto___33119,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async){
return (function (state_30311){
var state_val_30312 = (state_30311[(1)]);
if((state_val_30312 === (1))){
var state_30311__$1 = state_30311;
var statearr_30313_33129 = state_30311__$1;
(statearr_30313_33129[(2)] = null);

(statearr_30313_33129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30312 === (2))){
var state_30311__$1 = state_30311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30311__$1,(4),jobs);
} else {
if((state_val_30312 === (3))){
var inst_30309 = (state_30311[(2)]);
var state_30311__$1 = state_30311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30311__$1,inst_30309);
} else {
if((state_val_30312 === (4))){
var inst_30301 = (state_30311[(2)]);
var inst_30302 = process__$1(inst_30301);
var state_30311__$1 = state_30311;
if(cljs.core.truth_(inst_30302)){
var statearr_30314_33135 = state_30311__$1;
(statearr_30314_33135[(1)] = (5));

} else {
var statearr_30315_33136 = state_30311__$1;
(statearr_30315_33136[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30312 === (5))){
var state_30311__$1 = state_30311;
var statearr_30316_33137 = state_30311__$1;
(statearr_30316_33137[(2)] = null);

(statearr_30316_33137[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30312 === (6))){
var state_30311__$1 = state_30311;
var statearr_30317_33141 = state_30311__$1;
(statearr_30317_33141[(2)] = null);

(statearr_30317_33141[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30312 === (7))){
var inst_30307 = (state_30311[(2)]);
var state_30311__$1 = state_30311;
var statearr_30318_33144 = state_30311__$1;
(statearr_30318_33144[(2)] = inst_30307);

(statearr_30318_33144[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33113,c__27606__auto___33119,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async))
;
return ((function (__33113,switch__27442__auto__,c__27606__auto___33119,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0 = (function (){
var statearr_30319 = [null,null,null,null,null,null,null];
(statearr_30319[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__);

(statearr_30319[(1)] = (1));

return statearr_30319;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1 = (function (state_30311){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30311);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30320){var ex__27446__auto__ = e30320;
var statearr_30321_33149 = state_30311;
(statearr_30321_33149[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30311[(4)]))){
var statearr_30322_33150 = state_30311;
(statearr_30322_33150[(1)] = cljs.core.first((state_30311[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33151 = state_30311;
state_30311 = G__33151;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = function(state_30311){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1.call(this,state_30311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__;
})()
;})(__33113,switch__27442__auto__,c__27606__auto___33119,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async))
})();
var state__27608__auto__ = (function (){var statearr_30323 = f__27607__auto__();
(statearr_30323[(6)] = c__27606__auto___33119);

return statearr_30323;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
});})(__33113,c__27606__auto___33119,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async))
);


break;
case "async":
var c__27606__auto___33153 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__33113,c__27606__auto___33153,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async){
return (function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = ((function (__33113,c__27606__auto___33153,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async){
return (function (state_30336){
var state_val_30337 = (state_30336[(1)]);
if((state_val_30337 === (1))){
var state_30336__$1 = state_30336;
var statearr_30338_33158 = state_30336__$1;
(statearr_30338_33158[(2)] = null);

(statearr_30338_33158[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30337 === (2))){
var state_30336__$1 = state_30336;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30336__$1,(4),jobs);
} else {
if((state_val_30337 === (3))){
var inst_30334 = (state_30336[(2)]);
var state_30336__$1 = state_30336;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30336__$1,inst_30334);
} else {
if((state_val_30337 === (4))){
var inst_30326 = (state_30336[(2)]);
var inst_30327 = async(inst_30326);
var state_30336__$1 = state_30336;
if(cljs.core.truth_(inst_30327)){
var statearr_30339_33165 = state_30336__$1;
(statearr_30339_33165[(1)] = (5));

} else {
var statearr_30340_33168 = state_30336__$1;
(statearr_30340_33168[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30337 === (5))){
var state_30336__$1 = state_30336;
var statearr_30341_33169 = state_30336__$1;
(statearr_30341_33169[(2)] = null);

(statearr_30341_33169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30337 === (6))){
var state_30336__$1 = state_30336;
var statearr_30342_33170 = state_30336__$1;
(statearr_30342_33170[(2)] = null);

(statearr_30342_33170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30337 === (7))){
var inst_30332 = (state_30336[(2)]);
var state_30336__$1 = state_30336;
var statearr_30347_33171 = state_30336__$1;
(statearr_30347_33171[(2)] = inst_30332);

(statearr_30347_33171[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__33113,c__27606__auto___33153,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async))
;
return ((function (__33113,switch__27442__auto__,c__27606__auto___33153,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0 = (function (){
var statearr_30354 = [null,null,null,null,null,null,null];
(statearr_30354[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__);

(statearr_30354[(1)] = (1));

return statearr_30354;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1 = (function (state_30336){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30336);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30355){var ex__27446__auto__ = e30355;
var statearr_30356_33176 = state_30336;
(statearr_30356_33176[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30336[(4)]))){
var statearr_30357_33177 = state_30336;
(statearr_30357_33177[(1)] = cljs.core.first((state_30336[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33182 = state_30336;
state_30336 = G__33182;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = function(state_30336){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1.call(this,state_30336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__;
})()
;})(__33113,switch__27442__auto__,c__27606__auto___33153,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async))
})();
var state__27608__auto__ = (function (){var statearr_30358 = f__27607__auto__();
(statearr_30358[(6)] = c__27606__auto___33153);

return statearr_30358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
});})(__33113,c__27606__auto___33153,G__30298_33116,G__30298_33117__$1,n__5636__auto___33112,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__30298_33117__$1)].join('')));

}

var G__33183 = (__33113 + (1));
__33113 = G__33183;
continue;
} else {
}
break;
}

var c__27606__auto___33184 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_30384){
var state_val_30385 = (state_30384[(1)]);
if((state_val_30385 === (7))){
var inst_30380 = (state_30384[(2)]);
var state_30384__$1 = state_30384;
var statearr_30386_33185 = state_30384__$1;
(statearr_30386_33185[(2)] = inst_30380);

(statearr_30386_33185[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30385 === (1))){
var state_30384__$1 = state_30384;
var statearr_30387_33186 = state_30384__$1;
(statearr_30387_33186[(2)] = null);

(statearr_30387_33186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30385 === (4))){
var inst_30361 = (state_30384[(7)]);
var inst_30361__$1 = (state_30384[(2)]);
var inst_30362 = (inst_30361__$1 == null);
var state_30384__$1 = (function (){var statearr_30388 = state_30384;
(statearr_30388[(7)] = inst_30361__$1);

return statearr_30388;
})();
if(cljs.core.truth_(inst_30362)){
var statearr_30389_33188 = state_30384__$1;
(statearr_30389_33188[(1)] = (5));

} else {
var statearr_30390_33189 = state_30384__$1;
(statearr_30390_33189[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30385 === (6))){
var inst_30361 = (state_30384[(7)]);
var inst_30366 = (state_30384[(8)]);
var inst_30366__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_30371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30372 = [inst_30361,inst_30366__$1];
var inst_30373 = (new cljs.core.PersistentVector(null,2,(5),inst_30371,inst_30372,null));
var state_30384__$1 = (function (){var statearr_30397 = state_30384;
(statearr_30397[(8)] = inst_30366__$1);

return statearr_30397;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30384__$1,(8),jobs,inst_30373);
} else {
if((state_val_30385 === (3))){
var inst_30382 = (state_30384[(2)]);
var state_30384__$1 = state_30384;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30384__$1,inst_30382);
} else {
if((state_val_30385 === (2))){
var state_30384__$1 = state_30384;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30384__$1,(4),from);
} else {
if((state_val_30385 === (9))){
var inst_30377 = (state_30384[(2)]);
var state_30384__$1 = (function (){var statearr_30399 = state_30384;
(statearr_30399[(9)] = inst_30377);

return statearr_30399;
})();
var statearr_30400_33194 = state_30384__$1;
(statearr_30400_33194[(2)] = null);

(statearr_30400_33194[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30385 === (5))){
var inst_30364 = cljs.core.async.close_BANG_(jobs);
var state_30384__$1 = state_30384;
var statearr_30401_33195 = state_30384__$1;
(statearr_30401_33195[(2)] = inst_30364);

(statearr_30401_33195[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30385 === (8))){
var inst_30366 = (state_30384[(8)]);
var inst_30375 = (state_30384[(2)]);
var state_30384__$1 = (function (){var statearr_30402 = state_30384;
(statearr_30402[(10)] = inst_30375);

return statearr_30402;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30384__$1,(9),results,inst_30366);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0 = (function (){
var statearr_30407 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30407[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__);

(statearr_30407[(1)] = (1));

return statearr_30407;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1 = (function (state_30384){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30384);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30408){var ex__27446__auto__ = e30408;
var statearr_30409_33197 = state_30384;
(statearr_30409_33197[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30384[(4)]))){
var statearr_30410_33198 = state_30384;
(statearr_30410_33198[(1)] = cljs.core.first((state_30384[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33203 = state_30384;
state_30384 = G__33203;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = function(state_30384){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1.call(this,state_30384);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_30411 = f__27607__auto__();
(statearr_30411[(6)] = c__27606__auto___33184);

return statearr_30411;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


var c__27606__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_30451){
var state_val_30452 = (state_30451[(1)]);
if((state_val_30452 === (7))){
var inst_30446 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
var statearr_30453_33209 = state_30451__$1;
(statearr_30453_33209[(2)] = inst_30446);

(statearr_30453_33209[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (20))){
var state_30451__$1 = state_30451;
var statearr_30455_33212 = state_30451__$1;
(statearr_30455_33212[(2)] = null);

(statearr_30455_33212[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (1))){
var state_30451__$1 = state_30451;
var statearr_30456_33214 = state_30451__$1;
(statearr_30456_33214[(2)] = null);

(statearr_30456_33214[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (4))){
var inst_30414 = (state_30451[(7)]);
var inst_30414__$1 = (state_30451[(2)]);
var inst_30416 = (inst_30414__$1 == null);
var state_30451__$1 = (function (){var statearr_30457 = state_30451;
(statearr_30457[(7)] = inst_30414__$1);

return statearr_30457;
})();
if(cljs.core.truth_(inst_30416)){
var statearr_30458_33215 = state_30451__$1;
(statearr_30458_33215[(1)] = (5));

} else {
var statearr_30459_33216 = state_30451__$1;
(statearr_30459_33216[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (15))){
var inst_30428 = (state_30451[(8)]);
var state_30451__$1 = state_30451;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30451__$1,(18),to,inst_30428);
} else {
if((state_val_30452 === (21))){
var inst_30441 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
var statearr_30462_33218 = state_30451__$1;
(statearr_30462_33218[(2)] = inst_30441);

(statearr_30462_33218[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (13))){
var inst_30443 = (state_30451[(2)]);
var state_30451__$1 = (function (){var statearr_30464 = state_30451;
(statearr_30464[(9)] = inst_30443);

return statearr_30464;
})();
var statearr_30465_33219 = state_30451__$1;
(statearr_30465_33219[(2)] = null);

(statearr_30465_33219[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (6))){
var inst_30414 = (state_30451[(7)]);
var state_30451__$1 = state_30451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30451__$1,(11),inst_30414);
} else {
if((state_val_30452 === (17))){
var inst_30436 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
if(cljs.core.truth_(inst_30436)){
var statearr_30466_33224 = state_30451__$1;
(statearr_30466_33224[(1)] = (19));

} else {
var statearr_30467_33225 = state_30451__$1;
(statearr_30467_33225[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (3))){
var inst_30448 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30451__$1,inst_30448);
} else {
if((state_val_30452 === (12))){
var inst_30425 = (state_30451[(10)]);
var state_30451__$1 = state_30451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30451__$1,(14),inst_30425);
} else {
if((state_val_30452 === (2))){
var state_30451__$1 = state_30451;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30451__$1,(4),results);
} else {
if((state_val_30452 === (19))){
var state_30451__$1 = state_30451;
var statearr_30470_33226 = state_30451__$1;
(statearr_30470_33226[(2)] = null);

(statearr_30470_33226[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (11))){
var inst_30425 = (state_30451[(2)]);
var state_30451__$1 = (function (){var statearr_30472 = state_30451;
(statearr_30472[(10)] = inst_30425);

return statearr_30472;
})();
var statearr_30473_33230 = state_30451__$1;
(statearr_30473_33230[(2)] = null);

(statearr_30473_33230[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (9))){
var state_30451__$1 = state_30451;
var statearr_30474_33234 = state_30451__$1;
(statearr_30474_33234[(2)] = null);

(statearr_30474_33234[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (5))){
var state_30451__$1 = state_30451;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30475_33235 = state_30451__$1;
(statearr_30475_33235[(1)] = (8));

} else {
var statearr_30476_33236 = state_30451__$1;
(statearr_30476_33236[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (14))){
var inst_30428 = (state_30451[(8)]);
var inst_30430 = (state_30451[(11)]);
var inst_30428__$1 = (state_30451[(2)]);
var inst_30429 = (inst_30428__$1 == null);
var inst_30430__$1 = cljs.core.not(inst_30429);
var state_30451__$1 = (function (){var statearr_30477 = state_30451;
(statearr_30477[(8)] = inst_30428__$1);

(statearr_30477[(11)] = inst_30430__$1);

return statearr_30477;
})();
if(inst_30430__$1){
var statearr_30478_33238 = state_30451__$1;
(statearr_30478_33238[(1)] = (15));

} else {
var statearr_30479_33239 = state_30451__$1;
(statearr_30479_33239[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (16))){
var inst_30430 = (state_30451[(11)]);
var state_30451__$1 = state_30451;
var statearr_30480_33240 = state_30451__$1;
(statearr_30480_33240[(2)] = inst_30430);

(statearr_30480_33240[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (10))){
var inst_30422 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
var statearr_30482_33241 = state_30451__$1;
(statearr_30482_33241[(2)] = inst_30422);

(statearr_30482_33241[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (18))){
var inst_30433 = (state_30451[(2)]);
var state_30451__$1 = state_30451;
var statearr_30484_33242 = state_30451__$1;
(statearr_30484_33242[(2)] = inst_30433);

(statearr_30484_33242[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30452 === (8))){
var inst_30419 = cljs.core.async.close_BANG_(to);
var state_30451__$1 = state_30451;
var statearr_30485_33243 = state_30451__$1;
(statearr_30485_33243[(2)] = inst_30419);

(statearr_30485_33243[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0 = (function (){
var statearr_30486 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30486[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__);

(statearr_30486[(1)] = (1));

return statearr_30486;
});
var cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1 = (function (state_30451){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30451);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30487){var ex__27446__auto__ = e30487;
var statearr_30488_33245 = state_30451;
(statearr_30488_33245[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30451[(4)]))){
var statearr_30489_33247 = state_30451;
(statearr_30489_33247[(1)] = cljs.core.first((state_30451[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33249 = state_30451;
state_30451 = G__33249;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__ = function(state_30451){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1.call(this,state_30451);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__27443__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_30491 = f__27607__auto__();
(statearr_30491[(6)] = c__27606__auto__);

return statearr_30491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));

return c__27606__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__30497 = arguments.length;
switch (G__30497) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__30510 = arguments.length;
switch (G__30510) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__30522 = arguments.length;
switch (G__30522) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__27606__auto___33314 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_30579){
var state_val_30580 = (state_30579[(1)]);
if((state_val_30580 === (7))){
var inst_30573 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
var statearr_30596_33316 = state_30579__$1;
(statearr_30596_33316[(2)] = inst_30573);

(statearr_30596_33316[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (1))){
var state_30579__$1 = state_30579;
var statearr_30598_33317 = state_30579__$1;
(statearr_30598_33317[(2)] = null);

(statearr_30598_33317[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (4))){
var inst_30551 = (state_30579[(7)]);
var inst_30551__$1 = (state_30579[(2)]);
var inst_30555 = (inst_30551__$1 == null);
var state_30579__$1 = (function (){var statearr_30604 = state_30579;
(statearr_30604[(7)] = inst_30551__$1);

return statearr_30604;
})();
if(cljs.core.truth_(inst_30555)){
var statearr_30605_33320 = state_30579__$1;
(statearr_30605_33320[(1)] = (5));

} else {
var statearr_30609_33321 = state_30579__$1;
(statearr_30609_33321[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (13))){
var state_30579__$1 = state_30579;
var statearr_30612_33322 = state_30579__$1;
(statearr_30612_33322[(2)] = null);

(statearr_30612_33322[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (6))){
var inst_30551 = (state_30579[(7)]);
var inst_30560 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_30551) : p.call(null,inst_30551));
var state_30579__$1 = state_30579;
if(cljs.core.truth_(inst_30560)){
var statearr_30617_33327 = state_30579__$1;
(statearr_30617_33327[(1)] = (9));

} else {
var statearr_30618_33328 = state_30579__$1;
(statearr_30618_33328[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (3))){
var inst_30576 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30579__$1,inst_30576);
} else {
if((state_val_30580 === (12))){
var state_30579__$1 = state_30579;
var statearr_30623_33332 = state_30579__$1;
(statearr_30623_33332[(2)] = null);

(statearr_30623_33332[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (2))){
var state_30579__$1 = state_30579;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30579__$1,(4),ch);
} else {
if((state_val_30580 === (11))){
var inst_30551 = (state_30579[(7)]);
var inst_30564 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30579__$1,(8),inst_30564,inst_30551);
} else {
if((state_val_30580 === (9))){
var state_30579__$1 = state_30579;
var statearr_30632_33339 = state_30579__$1;
(statearr_30632_33339[(2)] = tc);

(statearr_30632_33339[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (5))){
var inst_30557 = cljs.core.async.close_BANG_(tc);
var inst_30558 = cljs.core.async.close_BANG_(fc);
var state_30579__$1 = (function (){var statearr_30636 = state_30579;
(statearr_30636[(8)] = inst_30557);

return statearr_30636;
})();
var statearr_30637_33348 = state_30579__$1;
(statearr_30637_33348[(2)] = inst_30558);

(statearr_30637_33348[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (14))){
var inst_30571 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
var statearr_30639_33352 = state_30579__$1;
(statearr_30639_33352[(2)] = inst_30571);

(statearr_30639_33352[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (10))){
var state_30579__$1 = state_30579;
var statearr_30641_33353 = state_30579__$1;
(statearr_30641_33353[(2)] = fc);

(statearr_30641_33353[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30580 === (8))){
var inst_30566 = (state_30579[(2)]);
var state_30579__$1 = state_30579;
if(cljs.core.truth_(inst_30566)){
var statearr_30646_33354 = state_30579__$1;
(statearr_30646_33354[(1)] = (12));

} else {
var statearr_30647_33355 = state_30579__$1;
(statearr_30647_33355[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_30650 = [null,null,null,null,null,null,null,null,null];
(statearr_30650[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_30650[(1)] = (1));

return statearr_30650;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_30579){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30579);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30652){var ex__27446__auto__ = e30652;
var statearr_30654_33357 = state_30579;
(statearr_30654_33357[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30579[(4)]))){
var statearr_30656_33358 = state_30579;
(statearr_30656_33358[(1)] = cljs.core.first((state_30579[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33359 = state_30579;
state_30579 = G__33359;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_30579){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_30579);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_30658 = f__27607__auto__();
(statearr_30658[(6)] = c__27606__auto___33314);

return statearr_30658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__27606__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_30697){
var state_val_30698 = (state_30697[(1)]);
if((state_val_30698 === (7))){
var inst_30693 = (state_30697[(2)]);
var state_30697__$1 = state_30697;
var statearr_30699_33365 = state_30697__$1;
(statearr_30699_33365[(2)] = inst_30693);

(statearr_30699_33365[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30698 === (1))){
var inst_30662 = init;
var inst_30664 = inst_30662;
var state_30697__$1 = (function (){var statearr_30701 = state_30697;
(statearr_30701[(7)] = inst_30664);

return statearr_30701;
})();
var statearr_30702_33367 = state_30697__$1;
(statearr_30702_33367[(2)] = null);

(statearr_30702_33367[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30698 === (4))){
var inst_30668 = (state_30697[(8)]);
var inst_30668__$1 = (state_30697[(2)]);
var inst_30677 = (inst_30668__$1 == null);
var state_30697__$1 = (function (){var statearr_30703 = state_30697;
(statearr_30703[(8)] = inst_30668__$1);

return statearr_30703;
})();
if(cljs.core.truth_(inst_30677)){
var statearr_30705_33370 = state_30697__$1;
(statearr_30705_33370[(1)] = (5));

} else {
var statearr_30706_33371 = state_30697__$1;
(statearr_30706_33371[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30698 === (6))){
var inst_30684 = (state_30697[(9)]);
var inst_30664 = (state_30697[(7)]);
var inst_30668 = (state_30697[(8)]);
var inst_30684__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_30664,inst_30668) : f.call(null,inst_30664,inst_30668));
var inst_30685 = cljs.core.reduced_QMARK_(inst_30684__$1);
var state_30697__$1 = (function (){var statearr_30708 = state_30697;
(statearr_30708[(9)] = inst_30684__$1);

return statearr_30708;
})();
if(inst_30685){
var statearr_30709_33372 = state_30697__$1;
(statearr_30709_33372[(1)] = (8));

} else {
var statearr_30711_33373 = state_30697__$1;
(statearr_30711_33373[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30698 === (3))){
var inst_30695 = (state_30697[(2)]);
var state_30697__$1 = state_30697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30697__$1,inst_30695);
} else {
if((state_val_30698 === (2))){
var state_30697__$1 = state_30697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30697__$1,(4),ch);
} else {
if((state_val_30698 === (9))){
var inst_30684 = (state_30697[(9)]);
var inst_30664 = inst_30684;
var state_30697__$1 = (function (){var statearr_30714 = state_30697;
(statearr_30714[(7)] = inst_30664);

return statearr_30714;
})();
var statearr_30717_33374 = state_30697__$1;
(statearr_30717_33374[(2)] = null);

(statearr_30717_33374[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30698 === (5))){
var inst_30664 = (state_30697[(7)]);
var state_30697__$1 = state_30697;
var statearr_30719_33375 = state_30697__$1;
(statearr_30719_33375[(2)] = inst_30664);

(statearr_30719_33375[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30698 === (10))){
var inst_30691 = (state_30697[(2)]);
var state_30697__$1 = state_30697;
var statearr_30720_33376 = state_30697__$1;
(statearr_30720_33376[(2)] = inst_30691);

(statearr_30720_33376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30698 === (8))){
var inst_30684 = (state_30697[(9)]);
var inst_30687 = cljs.core.deref(inst_30684);
var state_30697__$1 = state_30697;
var statearr_30721_33377 = state_30697__$1;
(statearr_30721_33377[(2)] = inst_30687);

(statearr_30721_33377[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__27443__auto__ = null;
var cljs$core$async$reduce_$_state_machine__27443__auto____0 = (function (){
var statearr_30722 = [null,null,null,null,null,null,null,null,null,null];
(statearr_30722[(0)] = cljs$core$async$reduce_$_state_machine__27443__auto__);

(statearr_30722[(1)] = (1));

return statearr_30722;
});
var cljs$core$async$reduce_$_state_machine__27443__auto____1 = (function (state_30697){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30697);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30725){var ex__27446__auto__ = e30725;
var statearr_30726_33379 = state_30697;
(statearr_30726_33379[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30697[(4)]))){
var statearr_30727_33381 = state_30697;
(statearr_30727_33381[(1)] = cljs.core.first((state_30697[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33382 = state_30697;
state_30697 = G__33382;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__27443__auto__ = function(state_30697){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__27443__auto____1.call(this,state_30697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__27443__auto____0;
cljs$core$async$reduce_$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__27443__auto____1;
return cljs$core$async$reduce_$_state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_30728 = f__27607__auto__();
(statearr_30728[(6)] = c__27606__auto__);

return statearr_30728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));

return c__27606__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__27606__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_30738){
var state_val_30739 = (state_30738[(1)]);
if((state_val_30739 === (1))){
var inst_30732 = cljs.core.async.reduce(f__$1,init,ch);
var state_30738__$1 = state_30738;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30738__$1,(2),inst_30732);
} else {
if((state_val_30739 === (2))){
var inst_30734 = (state_30738[(2)]);
var inst_30735 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_30734) : f__$1.call(null,inst_30734));
var state_30738__$1 = state_30738;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30738__$1,inst_30735);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__27443__auto__ = null;
var cljs$core$async$transduce_$_state_machine__27443__auto____0 = (function (){
var statearr_30741 = [null,null,null,null,null,null,null];
(statearr_30741[(0)] = cljs$core$async$transduce_$_state_machine__27443__auto__);

(statearr_30741[(1)] = (1));

return statearr_30741;
});
var cljs$core$async$transduce_$_state_machine__27443__auto____1 = (function (state_30738){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30738);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30743){var ex__27446__auto__ = e30743;
var statearr_30744_33407 = state_30738;
(statearr_30744_33407[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30738[(4)]))){
var statearr_30745_33408 = state_30738;
(statearr_30745_33408[(1)] = cljs.core.first((state_30738[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33409 = state_30738;
state_30738 = G__33409;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__27443__auto__ = function(state_30738){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__27443__auto____1.call(this,state_30738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__27443__auto____0;
cljs$core$async$transduce_$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__27443__auto____1;
return cljs$core$async$transduce_$_state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_30746 = f__27607__auto__();
(statearr_30746[(6)] = c__27606__auto__);

return statearr_30746;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));

return c__27606__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__30749 = arguments.length;
switch (G__30749) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__27606__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_30797){
var state_val_30798 = (state_30797[(1)]);
if((state_val_30798 === (7))){
var inst_30765 = (state_30797[(2)]);
var state_30797__$1 = state_30797;
var statearr_30817_33414 = state_30797__$1;
(statearr_30817_33414[(2)] = inst_30765);

(statearr_30817_33414[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (1))){
var inst_30757 = cljs.core.seq(coll);
var inst_30758 = inst_30757;
var state_30797__$1 = (function (){var statearr_30826 = state_30797;
(statearr_30826[(7)] = inst_30758);

return statearr_30826;
})();
var statearr_30829_33415 = state_30797__$1;
(statearr_30829_33415[(2)] = null);

(statearr_30829_33415[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (4))){
var inst_30758 = (state_30797[(7)]);
var inst_30763 = cljs.core.first(inst_30758);
var state_30797__$1 = state_30797;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_30797__$1,(7),ch,inst_30763);
} else {
if((state_val_30798 === (13))){
var inst_30777 = (state_30797[(2)]);
var state_30797__$1 = state_30797;
var statearr_30851_33420 = state_30797__$1;
(statearr_30851_33420[(2)] = inst_30777);

(statearr_30851_33420[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (6))){
var inst_30768 = (state_30797[(2)]);
var state_30797__$1 = state_30797;
if(cljs.core.truth_(inst_30768)){
var statearr_30873_33421 = state_30797__$1;
(statearr_30873_33421[(1)] = (8));

} else {
var statearr_30878_33422 = state_30797__$1;
(statearr_30878_33422[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (3))){
var inst_30781 = (state_30797[(2)]);
var state_30797__$1 = state_30797;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30797__$1,inst_30781);
} else {
if((state_val_30798 === (12))){
var state_30797__$1 = state_30797;
var statearr_30889_33429 = state_30797__$1;
(statearr_30889_33429[(2)] = null);

(statearr_30889_33429[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (2))){
var inst_30758 = (state_30797[(7)]);
var state_30797__$1 = state_30797;
if(cljs.core.truth_(inst_30758)){
var statearr_30890_33433 = state_30797__$1;
(statearr_30890_33433[(1)] = (4));

} else {
var statearr_30891_33434 = state_30797__$1;
(statearr_30891_33434[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (11))){
var inst_30774 = cljs.core.async.close_BANG_(ch);
var state_30797__$1 = state_30797;
var statearr_30893_33437 = state_30797__$1;
(statearr_30893_33437[(2)] = inst_30774);

(statearr_30893_33437[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (9))){
var state_30797__$1 = state_30797;
if(cljs.core.truth_(close_QMARK_)){
var statearr_30894_33444 = state_30797__$1;
(statearr_30894_33444[(1)] = (11));

} else {
var statearr_30895_33445 = state_30797__$1;
(statearr_30895_33445[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (5))){
var inst_30758 = (state_30797[(7)]);
var state_30797__$1 = state_30797;
var statearr_30898_33446 = state_30797__$1;
(statearr_30898_33446[(2)] = inst_30758);

(statearr_30898_33446[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (10))){
var inst_30779 = (state_30797[(2)]);
var state_30797__$1 = state_30797;
var statearr_30899_33453 = state_30797__$1;
(statearr_30899_33453[(2)] = inst_30779);

(statearr_30899_33453[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30798 === (8))){
var inst_30758 = (state_30797[(7)]);
var inst_30770 = cljs.core.next(inst_30758);
var inst_30758__$1 = inst_30770;
var state_30797__$1 = (function (){var statearr_30900 = state_30797;
(statearr_30900[(7)] = inst_30758__$1);

return statearr_30900;
})();
var statearr_30902_33454 = state_30797__$1;
(statearr_30902_33454[(2)] = null);

(statearr_30902_33454[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_30903 = [null,null,null,null,null,null,null,null];
(statearr_30903[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_30903[(1)] = (1));

return statearr_30903;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_30797){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_30797);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e30905){var ex__27446__auto__ = e30905;
var statearr_30906_33461 = state_30797;
(statearr_30906_33461[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_30797[(4)]))){
var statearr_30907_33462 = state_30797;
(statearr_30907_33462[(1)] = cljs.core.first((state_30797[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33463 = state_30797;
state_30797 = G__33463;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_30797){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_30797);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_30908 = f__27607__auto__();
(statearr_30908[(6)] = c__27606__auto__);

return statearr_30908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));

return c__27606__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__30914 = arguments.length;
switch (G__30914) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_33475 = (function (_){
var x__5393__auto__ = (((_ == null))?null:_);
var m__5394__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5394__auto__.call(null,_));
} else {
var m__5392__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5392__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_33475(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_33476 = (function (m,ch,close_QMARK_){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5394__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5392__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_33476(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_33477 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_33477(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_33478 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_33478(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async30933 = (function (ch,cs,meta30934){
this.ch = ch;
this.cs = cs;
this.meta30934 = meta30934;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async30933.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_30935,meta30934__$1){
var self__ = this;
var _30935__$1 = this;
return (new cljs.core.async.t_cljs$core$async30933(self__.ch,self__.cs,meta30934__$1));
}));

(cljs.core.async.t_cljs$core$async30933.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_30935){
var self__ = this;
var _30935__$1 = this;
return self__.meta30934;
}));

(cljs.core.async.t_cljs$core$async30933.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30933.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async30933.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async30933.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async30933.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async30933.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async30933.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta30934","meta30934",64471930,null)], null);
}));

(cljs.core.async.t_cljs$core$async30933.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async30933.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async30933");

(cljs.core.async.t_cljs$core$async30933.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async30933");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async30933.
 */
cljs.core.async.__GT_t_cljs$core$async30933 = (function cljs$core$async$__GT_t_cljs$core$async30933(ch,cs,meta30934){
return (new cljs.core.async.t_cljs$core$async30933(ch,cs,meta30934));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async30933(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__27606__auto___33490 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_31082){
var state_val_31084 = (state_31082[(1)]);
if((state_val_31084 === (7))){
var inst_31078 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31086_33491 = state_31082__$1;
(statearr_31086_33491[(2)] = inst_31078);

(statearr_31086_33491[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (20))){
var inst_30982 = (state_31082[(7)]);
var inst_30995 = cljs.core.first(inst_30982);
var inst_30996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30995,(0),null);
var inst_30997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30995,(1),null);
var state_31082__$1 = (function (){var statearr_31087 = state_31082;
(statearr_31087[(8)] = inst_30996);

return statearr_31087;
})();
if(cljs.core.truth_(inst_30997)){
var statearr_31088_33492 = state_31082__$1;
(statearr_31088_33492[(1)] = (22));

} else {
var statearr_31089_33493 = state_31082__$1;
(statearr_31089_33493[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (27))){
var inst_30951 = (state_31082[(9)]);
var inst_31032 = (state_31082[(10)]);
var inst_31025 = (state_31082[(11)]);
var inst_31027 = (state_31082[(12)]);
var inst_31032__$1 = cljs.core._nth(inst_31025,inst_31027);
var inst_31033 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31032__$1,inst_30951,done);
var state_31082__$1 = (function (){var statearr_31090 = state_31082;
(statearr_31090[(10)] = inst_31032__$1);

return statearr_31090;
})();
if(cljs.core.truth_(inst_31033)){
var statearr_31091_33501 = state_31082__$1;
(statearr_31091_33501[(1)] = (30));

} else {
var statearr_31092_33502 = state_31082__$1;
(statearr_31092_33502[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (1))){
var state_31082__$1 = state_31082;
var statearr_31093_33503 = state_31082__$1;
(statearr_31093_33503[(2)] = null);

(statearr_31093_33503[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (24))){
var inst_30982 = (state_31082[(7)]);
var inst_31002 = (state_31082[(2)]);
var inst_31003 = cljs.core.next(inst_30982);
var inst_30960 = inst_31003;
var inst_30961 = null;
var inst_30962 = (0);
var inst_30963 = (0);
var state_31082__$1 = (function (){var statearr_31094 = state_31082;
(statearr_31094[(13)] = inst_30962);

(statearr_31094[(14)] = inst_30963);

(statearr_31094[(15)] = inst_31002);

(statearr_31094[(16)] = inst_30960);

(statearr_31094[(17)] = inst_30961);

return statearr_31094;
})();
var statearr_31095_33508 = state_31082__$1;
(statearr_31095_33508[(2)] = null);

(statearr_31095_33508[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (39))){
var state_31082__$1 = state_31082;
var statearr_31100_33509 = state_31082__$1;
(statearr_31100_33509[(2)] = null);

(statearr_31100_33509[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (4))){
var inst_30951 = (state_31082[(9)]);
var inst_30951__$1 = (state_31082[(2)]);
var inst_30952 = (inst_30951__$1 == null);
var state_31082__$1 = (function (){var statearr_31101 = state_31082;
(statearr_31101[(9)] = inst_30951__$1);

return statearr_31101;
})();
if(cljs.core.truth_(inst_30952)){
var statearr_31102_33510 = state_31082__$1;
(statearr_31102_33510[(1)] = (5));

} else {
var statearr_31104_33511 = state_31082__$1;
(statearr_31104_33511[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (15))){
var inst_30962 = (state_31082[(13)]);
var inst_30963 = (state_31082[(14)]);
var inst_30960 = (state_31082[(16)]);
var inst_30961 = (state_31082[(17)]);
var inst_30978 = (state_31082[(2)]);
var inst_30979 = (inst_30963 + (1));
var tmp31097 = inst_30962;
var tmp31098 = inst_30960;
var tmp31099 = inst_30961;
var inst_30960__$1 = tmp31098;
var inst_30961__$1 = tmp31099;
var inst_30962__$1 = tmp31097;
var inst_30963__$1 = inst_30979;
var state_31082__$1 = (function (){var statearr_31117 = state_31082;
(statearr_31117[(18)] = inst_30978);

(statearr_31117[(13)] = inst_30962__$1);

(statearr_31117[(14)] = inst_30963__$1);

(statearr_31117[(16)] = inst_30960__$1);

(statearr_31117[(17)] = inst_30961__$1);

return statearr_31117;
})();
var statearr_31124_33520 = state_31082__$1;
(statearr_31124_33520[(2)] = null);

(statearr_31124_33520[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (21))){
var inst_31006 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31141_33521 = state_31082__$1;
(statearr_31141_33521[(2)] = inst_31006);

(statearr_31141_33521[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (31))){
var inst_31032 = (state_31082[(10)]);
var inst_31036 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31032);
var state_31082__$1 = state_31082;
var statearr_31147_33522 = state_31082__$1;
(statearr_31147_33522[(2)] = inst_31036);

(statearr_31147_33522[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (32))){
var inst_31024 = (state_31082[(19)]);
var inst_31026 = (state_31082[(20)]);
var inst_31025 = (state_31082[(11)]);
var inst_31027 = (state_31082[(12)]);
var inst_31038 = (state_31082[(2)]);
var inst_31039 = (inst_31027 + (1));
var tmp31138 = inst_31024;
var tmp31139 = inst_31026;
var tmp31140 = inst_31025;
var inst_31024__$1 = tmp31138;
var inst_31025__$1 = tmp31140;
var inst_31026__$1 = tmp31139;
var inst_31027__$1 = inst_31039;
var state_31082__$1 = (function (){var statearr_31157 = state_31082;
(statearr_31157[(21)] = inst_31038);

(statearr_31157[(19)] = inst_31024__$1);

(statearr_31157[(20)] = inst_31026__$1);

(statearr_31157[(11)] = inst_31025__$1);

(statearr_31157[(12)] = inst_31027__$1);

return statearr_31157;
})();
var statearr_31158_33525 = state_31082__$1;
(statearr_31158_33525[(2)] = null);

(statearr_31158_33525[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (40))){
var inst_31051 = (state_31082[(22)]);
var inst_31055 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_31051);
var state_31082__$1 = state_31082;
var statearr_31159_33529 = state_31082__$1;
(statearr_31159_33529[(2)] = inst_31055);

(statearr_31159_33529[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (33))){
var inst_31042 = (state_31082[(23)]);
var inst_31044 = cljs.core.chunked_seq_QMARK_(inst_31042);
var state_31082__$1 = state_31082;
if(inst_31044){
var statearr_31161_33530 = state_31082__$1;
(statearr_31161_33530[(1)] = (36));

} else {
var statearr_31162_33531 = state_31082__$1;
(statearr_31162_33531[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (13))){
var inst_30972 = (state_31082[(24)]);
var inst_30975 = cljs.core.async.close_BANG_(inst_30972);
var state_31082__$1 = state_31082;
var statearr_31163_33534 = state_31082__$1;
(statearr_31163_33534[(2)] = inst_30975);

(statearr_31163_33534[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (22))){
var inst_30996 = (state_31082[(8)]);
var inst_30999 = cljs.core.async.close_BANG_(inst_30996);
var state_31082__$1 = state_31082;
var statearr_31164_33535 = state_31082__$1;
(statearr_31164_33535[(2)] = inst_30999);

(statearr_31164_33535[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (36))){
var inst_31042 = (state_31082[(23)]);
var inst_31046 = cljs.core.chunk_first(inst_31042);
var inst_31047 = cljs.core.chunk_rest(inst_31042);
var inst_31048 = cljs.core.count(inst_31046);
var inst_31024 = inst_31047;
var inst_31025 = inst_31046;
var inst_31026 = inst_31048;
var inst_31027 = (0);
var state_31082__$1 = (function (){var statearr_31165 = state_31082;
(statearr_31165[(19)] = inst_31024);

(statearr_31165[(20)] = inst_31026);

(statearr_31165[(11)] = inst_31025);

(statearr_31165[(12)] = inst_31027);

return statearr_31165;
})();
var statearr_31166_33539 = state_31082__$1;
(statearr_31166_33539[(2)] = null);

(statearr_31166_33539[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (41))){
var inst_31042 = (state_31082[(23)]);
var inst_31057 = (state_31082[(2)]);
var inst_31058 = cljs.core.next(inst_31042);
var inst_31024 = inst_31058;
var inst_31025 = null;
var inst_31026 = (0);
var inst_31027 = (0);
var state_31082__$1 = (function (){var statearr_31167 = state_31082;
(statearr_31167[(19)] = inst_31024);

(statearr_31167[(20)] = inst_31026);

(statearr_31167[(25)] = inst_31057);

(statearr_31167[(11)] = inst_31025);

(statearr_31167[(12)] = inst_31027);

return statearr_31167;
})();
var statearr_31168_33542 = state_31082__$1;
(statearr_31168_33542[(2)] = null);

(statearr_31168_33542[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (43))){
var state_31082__$1 = state_31082;
var statearr_31169_33543 = state_31082__$1;
(statearr_31169_33543[(2)] = null);

(statearr_31169_33543[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (29))){
var inst_31066 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31170_33546 = state_31082__$1;
(statearr_31170_33546[(2)] = inst_31066);

(statearr_31170_33546[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (44))){
var inst_31075 = (state_31082[(2)]);
var state_31082__$1 = (function (){var statearr_31171 = state_31082;
(statearr_31171[(26)] = inst_31075);

return statearr_31171;
})();
var statearr_31172_33547 = state_31082__$1;
(statearr_31172_33547[(2)] = null);

(statearr_31172_33547[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (6))){
var inst_31016 = (state_31082[(27)]);
var inst_31015 = cljs.core.deref(cs);
var inst_31016__$1 = cljs.core.keys(inst_31015);
var inst_31017 = cljs.core.count(inst_31016__$1);
var inst_31018 = cljs.core.reset_BANG_(dctr,inst_31017);
var inst_31023 = cljs.core.seq(inst_31016__$1);
var inst_31024 = inst_31023;
var inst_31025 = null;
var inst_31026 = (0);
var inst_31027 = (0);
var state_31082__$1 = (function (){var statearr_31176 = state_31082;
(statearr_31176[(28)] = inst_31018);

(statearr_31176[(19)] = inst_31024);

(statearr_31176[(20)] = inst_31026);

(statearr_31176[(11)] = inst_31025);

(statearr_31176[(12)] = inst_31027);

(statearr_31176[(27)] = inst_31016__$1);

return statearr_31176;
})();
var statearr_31179_33548 = state_31082__$1;
(statearr_31179_33548[(2)] = null);

(statearr_31179_33548[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (28))){
var inst_31024 = (state_31082[(19)]);
var inst_31042 = (state_31082[(23)]);
var inst_31042__$1 = cljs.core.seq(inst_31024);
var state_31082__$1 = (function (){var statearr_31183 = state_31082;
(statearr_31183[(23)] = inst_31042__$1);

return statearr_31183;
})();
if(inst_31042__$1){
var statearr_31184_33549 = state_31082__$1;
(statearr_31184_33549[(1)] = (33));

} else {
var statearr_31185_33550 = state_31082__$1;
(statearr_31185_33550[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (25))){
var inst_31026 = (state_31082[(20)]);
var inst_31027 = (state_31082[(12)]);
var inst_31029 = (inst_31027 < inst_31026);
var inst_31030 = inst_31029;
var state_31082__$1 = state_31082;
if(cljs.core.truth_(inst_31030)){
var statearr_31188_33551 = state_31082__$1;
(statearr_31188_33551[(1)] = (27));

} else {
var statearr_31190_33552 = state_31082__$1;
(statearr_31190_33552[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (34))){
var state_31082__$1 = state_31082;
var statearr_31193_33553 = state_31082__$1;
(statearr_31193_33553[(2)] = null);

(statearr_31193_33553[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (17))){
var state_31082__$1 = state_31082;
var statearr_31195_33554 = state_31082__$1;
(statearr_31195_33554[(2)] = null);

(statearr_31195_33554[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (3))){
var inst_31080 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31082__$1,inst_31080);
} else {
if((state_val_31084 === (12))){
var inst_31011 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31196_33555 = state_31082__$1;
(statearr_31196_33555[(2)] = inst_31011);

(statearr_31196_33555[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (2))){
var state_31082__$1 = state_31082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31082__$1,(4),ch);
} else {
if((state_val_31084 === (23))){
var state_31082__$1 = state_31082;
var statearr_31201_33557 = state_31082__$1;
(statearr_31201_33557[(2)] = null);

(statearr_31201_33557[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (35))){
var inst_31064 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31208_33558 = state_31082__$1;
(statearr_31208_33558[(2)] = inst_31064);

(statearr_31208_33558[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (19))){
var inst_30982 = (state_31082[(7)]);
var inst_30986 = cljs.core.chunk_first(inst_30982);
var inst_30987 = cljs.core.chunk_rest(inst_30982);
var inst_30988 = cljs.core.count(inst_30986);
var inst_30960 = inst_30987;
var inst_30961 = inst_30986;
var inst_30962 = inst_30988;
var inst_30963 = (0);
var state_31082__$1 = (function (){var statearr_31216 = state_31082;
(statearr_31216[(13)] = inst_30962);

(statearr_31216[(14)] = inst_30963);

(statearr_31216[(16)] = inst_30960);

(statearr_31216[(17)] = inst_30961);

return statearr_31216;
})();
var statearr_31224_33561 = state_31082__$1;
(statearr_31224_33561[(2)] = null);

(statearr_31224_33561[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (11))){
var inst_30982 = (state_31082[(7)]);
var inst_30960 = (state_31082[(16)]);
var inst_30982__$1 = cljs.core.seq(inst_30960);
var state_31082__$1 = (function (){var statearr_31229 = state_31082;
(statearr_31229[(7)] = inst_30982__$1);

return statearr_31229;
})();
if(inst_30982__$1){
var statearr_31230_33562 = state_31082__$1;
(statearr_31230_33562[(1)] = (16));

} else {
var statearr_31231_33563 = state_31082__$1;
(statearr_31231_33563[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (9))){
var inst_31013 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31233_33564 = state_31082__$1;
(statearr_31233_33564[(2)] = inst_31013);

(statearr_31233_33564[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (5))){
var inst_30958 = cljs.core.deref(cs);
var inst_30959 = cljs.core.seq(inst_30958);
var inst_30960 = inst_30959;
var inst_30961 = null;
var inst_30962 = (0);
var inst_30963 = (0);
var state_31082__$1 = (function (){var statearr_31238 = state_31082;
(statearr_31238[(13)] = inst_30962);

(statearr_31238[(14)] = inst_30963);

(statearr_31238[(16)] = inst_30960);

(statearr_31238[(17)] = inst_30961);

return statearr_31238;
})();
var statearr_31240_33566 = state_31082__$1;
(statearr_31240_33566[(2)] = null);

(statearr_31240_33566[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (14))){
var state_31082__$1 = state_31082;
var statearr_31241_33568 = state_31082__$1;
(statearr_31241_33568[(2)] = null);

(statearr_31241_33568[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (45))){
var inst_31072 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31243_33572 = state_31082__$1;
(statearr_31243_33572[(2)] = inst_31072);

(statearr_31243_33572[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (26))){
var inst_31016 = (state_31082[(27)]);
var inst_31068 = (state_31082[(2)]);
var inst_31069 = cljs.core.seq(inst_31016);
var state_31082__$1 = (function (){var statearr_31248 = state_31082;
(statearr_31248[(29)] = inst_31068);

return statearr_31248;
})();
if(inst_31069){
var statearr_31249_33573 = state_31082__$1;
(statearr_31249_33573[(1)] = (42));

} else {
var statearr_31250_33574 = state_31082__$1;
(statearr_31250_33574[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (16))){
var inst_30982 = (state_31082[(7)]);
var inst_30984 = cljs.core.chunked_seq_QMARK_(inst_30982);
var state_31082__$1 = state_31082;
if(inst_30984){
var statearr_31252_33575 = state_31082__$1;
(statearr_31252_33575[(1)] = (19));

} else {
var statearr_31253_33576 = state_31082__$1;
(statearr_31253_33576[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (38))){
var inst_31061 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31258_33586 = state_31082__$1;
(statearr_31258_33586[(2)] = inst_31061);

(statearr_31258_33586[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (30))){
var state_31082__$1 = state_31082;
var statearr_31259_33587 = state_31082__$1;
(statearr_31259_33587[(2)] = null);

(statearr_31259_33587[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (10))){
var inst_30963 = (state_31082[(14)]);
var inst_30961 = (state_31082[(17)]);
var inst_30971 = cljs.core._nth(inst_30961,inst_30963);
var inst_30972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30971,(0),null);
var inst_30973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30971,(1),null);
var state_31082__$1 = (function (){var statearr_31261 = state_31082;
(statearr_31261[(24)] = inst_30972);

return statearr_31261;
})();
if(cljs.core.truth_(inst_30973)){
var statearr_31263_33589 = state_31082__$1;
(statearr_31263_33589[(1)] = (13));

} else {
var statearr_31264_33593 = state_31082__$1;
(statearr_31264_33593[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (18))){
var inst_31009 = (state_31082[(2)]);
var state_31082__$1 = state_31082;
var statearr_31268_33594 = state_31082__$1;
(statearr_31268_33594[(2)] = inst_31009);

(statearr_31268_33594[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (42))){
var state_31082__$1 = state_31082;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31082__$1,(45),dchan);
} else {
if((state_val_31084 === (37))){
var inst_31051 = (state_31082[(22)]);
var inst_30951 = (state_31082[(9)]);
var inst_31042 = (state_31082[(23)]);
var inst_31051__$1 = cljs.core.first(inst_31042);
var inst_31052 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_31051__$1,inst_30951,done);
var state_31082__$1 = (function (){var statearr_31334 = state_31082;
(statearr_31334[(22)] = inst_31051__$1);

return statearr_31334;
})();
if(cljs.core.truth_(inst_31052)){
var statearr_31337_33596 = state_31082__$1;
(statearr_31337_33596[(1)] = (39));

} else {
var statearr_31339_33597 = state_31082__$1;
(statearr_31339_33597[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31084 === (8))){
var inst_30962 = (state_31082[(13)]);
var inst_30963 = (state_31082[(14)]);
var inst_30965 = (inst_30963 < inst_30962);
var inst_30966 = inst_30965;
var state_31082__$1 = state_31082;
if(cljs.core.truth_(inst_30966)){
var statearr_31341_33598 = state_31082__$1;
(statearr_31341_33598[(1)] = (10));

} else {
var statearr_31342_33599 = state_31082__$1;
(statearr_31342_33599[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__27443__auto__ = null;
var cljs$core$async$mult_$_state_machine__27443__auto____0 = (function (){
var statearr_31346 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31346[(0)] = cljs$core$async$mult_$_state_machine__27443__auto__);

(statearr_31346[(1)] = (1));

return statearr_31346;
});
var cljs$core$async$mult_$_state_machine__27443__auto____1 = (function (state_31082){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_31082);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e31347){var ex__27446__auto__ = e31347;
var statearr_31348_33602 = state_31082;
(statearr_31348_33602[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_31082[(4)]))){
var statearr_31349_33603 = state_31082;
(statearr_31349_33603[(1)] = cljs.core.first((state_31082[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33604 = state_31082;
state_31082 = G__33604;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__27443__auto__ = function(state_31082){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__27443__auto____1.call(this,state_31082);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__27443__auto____0;
cljs$core$async$mult_$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__27443__auto____1;
return cljs$core$async$mult_$_state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_31350 = f__27607__auto__();
(statearr_31350[(6)] = c__27606__auto___33490);

return statearr_31350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__31360 = arguments.length;
switch (G__31360) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_33609 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_33609(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_33615 = (function (m,ch){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5394__auto__.call(null,m,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5392__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_33615(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_33616 = (function (m){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5394__auto__.call(null,m));
} else {
var m__5392__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5392__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_33616(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_33617 = (function (m,state_map){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5394__auto__.call(null,m,state_map));
} else {
var m__5392__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5392__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_33617(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_33618 = (function (m,mode){
var x__5393__auto__ = (((m == null))?null:m);
var m__5394__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5394__auto__.call(null,m,mode));
} else {
var m__5392__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5392__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_33618(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5775__auto__ = [];
var len__5769__auto___33619 = arguments.length;
var i__5770__auto___33620 = (0);
while(true){
if((i__5770__auto___33620 < len__5769__auto___33619)){
args__5775__auto__.push((arguments[i__5770__auto___33620]));

var G__33621 = (i__5770__auto___33620 + (1));
i__5770__auto___33620 = G__33621;
continue;
} else {
}
break;
}

var argseq__5776__auto__ = ((((3) < args__5775__auto__.length))?(new cljs.core.IndexedSeq(args__5775__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5776__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__31386){
var map__31387 = p__31386;
var map__31387__$1 = cljs.core.__destructure_map(map__31387);
var opts = map__31387__$1;
var statearr_31388_33629 = state;
(statearr_31388_33629[(1)] = cont_block);


var temp__5804__auto__ = cljs.core.async.do_alts((function (val){
var statearr_31389_33630 = state;
(statearr_31389_33630[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5804__auto__)){
var cb = temp__5804__auto__;
var statearr_31390_33633 = state;
(statearr_31390_33633[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq31382){
var G__31383 = cljs.core.first(seq31382);
var seq31382__$1 = cljs.core.next(seq31382);
var G__31384 = cljs.core.first(seq31382__$1);
var seq31382__$2 = cljs.core.next(seq31382__$1);
var G__31385 = cljs.core.first(seq31382__$2);
var seq31382__$3 = cljs.core.next(seq31382__$2);
var self__5754__auto__ = this;
return self__5754__auto__.cljs$core$IFn$_invoke$arity$variadic(G__31383,G__31384,G__31385,seq31382__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31395 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31396){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta31396 = meta31396;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31397,meta31396__$1){
var self__ = this;
var _31397__$1 = this;
return (new cljs.core.async.t_cljs$core$async31395(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta31396__$1));
}));

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31397){
var self__ = this;
var _31397__$1 = this;
return self__.meta31396;
}));

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31395.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async31395.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta31396","meta31396",-880324112,null)], null);
}));

(cljs.core.async.t_cljs$core$async31395.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31395.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31395");

(cljs.core.async.t_cljs$core$async31395.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31395");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31395.
 */
cljs.core.async.__GT_t_cljs$core$async31395 = (function cljs$core$async$__GT_t_cljs$core$async31395(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31396){
return (new cljs.core.async.t_cljs$core$async31395(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta31396));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async31395(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__27606__auto___33641 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_31471){
var state_val_31472 = (state_31471[(1)]);
if((state_val_31472 === (7))){
var inst_31427 = (state_31471[(2)]);
var state_31471__$1 = state_31471;
if(cljs.core.truth_(inst_31427)){
var statearr_31473_33643 = state_31471__$1;
(statearr_31473_33643[(1)] = (8));

} else {
var statearr_31474_33644 = state_31471__$1;
(statearr_31474_33644[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (20))){
var inst_31420 = (state_31471[(7)]);
var state_31471__$1 = state_31471;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31471__$1,(23),out,inst_31420);
} else {
if((state_val_31472 === (1))){
var inst_31402 = calc_state();
var inst_31403 = cljs.core.__destructure_map(inst_31402);
var inst_31404 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31403,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31405 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31403,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31406 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31403,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_31407 = inst_31402;
var state_31471__$1 = (function (){var statearr_31475 = state_31471;
(statearr_31475[(8)] = inst_31406);

(statearr_31475[(9)] = inst_31404);

(statearr_31475[(10)] = inst_31405);

(statearr_31475[(11)] = inst_31407);

return statearr_31475;
})();
var statearr_31476_33645 = state_31471__$1;
(statearr_31476_33645[(2)] = null);

(statearr_31476_33645[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (24))){
var inst_31410 = (state_31471[(12)]);
var inst_31407 = inst_31410;
var state_31471__$1 = (function (){var statearr_31477 = state_31471;
(statearr_31477[(11)] = inst_31407);

return statearr_31477;
})();
var statearr_31480_33649 = state_31471__$1;
(statearr_31480_33649[(2)] = null);

(statearr_31480_33649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (4))){
var inst_31422 = (state_31471[(13)]);
var inst_31420 = (state_31471[(7)]);
var inst_31419 = (state_31471[(2)]);
var inst_31420__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31419,(0),null);
var inst_31421 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31419,(1),null);
var inst_31422__$1 = (inst_31420__$1 == null);
var state_31471__$1 = (function (){var statearr_31487 = state_31471;
(statearr_31487[(13)] = inst_31422__$1);

(statearr_31487[(7)] = inst_31420__$1);

(statearr_31487[(14)] = inst_31421);

return statearr_31487;
})();
if(cljs.core.truth_(inst_31422__$1)){
var statearr_31488_33650 = state_31471__$1;
(statearr_31488_33650[(1)] = (5));

} else {
var statearr_31490_33651 = state_31471__$1;
(statearr_31490_33651[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (15))){
var inst_31442 = (state_31471[(15)]);
var inst_31411 = (state_31471[(16)]);
var inst_31442__$1 = cljs.core.empty_QMARK_(inst_31411);
var state_31471__$1 = (function (){var statearr_31497 = state_31471;
(statearr_31497[(15)] = inst_31442__$1);

return statearr_31497;
})();
if(inst_31442__$1){
var statearr_31501_33652 = state_31471__$1;
(statearr_31501_33652[(1)] = (17));

} else {
var statearr_31503_33653 = state_31471__$1;
(statearr_31503_33653[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (21))){
var inst_31410 = (state_31471[(12)]);
var inst_31407 = inst_31410;
var state_31471__$1 = (function (){var statearr_31507 = state_31471;
(statearr_31507[(11)] = inst_31407);

return statearr_31507;
})();
var statearr_31508_33654 = state_31471__$1;
(statearr_31508_33654[(2)] = null);

(statearr_31508_33654[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (13))){
var inst_31434 = (state_31471[(2)]);
var inst_31435 = calc_state();
var inst_31407 = inst_31435;
var state_31471__$1 = (function (){var statearr_31509 = state_31471;
(statearr_31509[(17)] = inst_31434);

(statearr_31509[(11)] = inst_31407);

return statearr_31509;
})();
var statearr_31510_33655 = state_31471__$1;
(statearr_31510_33655[(2)] = null);

(statearr_31510_33655[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (22))){
var inst_31465 = (state_31471[(2)]);
var state_31471__$1 = state_31471;
var statearr_31512_33656 = state_31471__$1;
(statearr_31512_33656[(2)] = inst_31465);

(statearr_31512_33656[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (6))){
var inst_31421 = (state_31471[(14)]);
var inst_31425 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31421,change);
var state_31471__$1 = state_31471;
var statearr_31516_33657 = state_31471__$1;
(statearr_31516_33657[(2)] = inst_31425);

(statearr_31516_33657[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (25))){
var state_31471__$1 = state_31471;
var statearr_31535_33662 = state_31471__$1;
(statearr_31535_33662[(2)] = null);

(statearr_31535_33662[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (17))){
var inst_31421 = (state_31471[(14)]);
var inst_31412 = (state_31471[(18)]);
var inst_31446 = (inst_31412.cljs$core$IFn$_invoke$arity$1 ? inst_31412.cljs$core$IFn$_invoke$arity$1(inst_31421) : inst_31412.call(null,inst_31421));
var inst_31447 = cljs.core.not(inst_31446);
var state_31471__$1 = state_31471;
var statearr_31545_33663 = state_31471__$1;
(statearr_31545_33663[(2)] = inst_31447);

(statearr_31545_33663[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (3))){
var inst_31469 = (state_31471[(2)]);
var state_31471__$1 = state_31471;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31471__$1,inst_31469);
} else {
if((state_val_31472 === (12))){
var state_31471__$1 = state_31471;
var statearr_31556_33665 = state_31471__$1;
(statearr_31556_33665[(2)] = null);

(statearr_31556_33665[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (2))){
var inst_31410 = (state_31471[(12)]);
var inst_31407 = (state_31471[(11)]);
var inst_31410__$1 = cljs.core.__destructure_map(inst_31407);
var inst_31411 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31410__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_31412 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31410__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_31414 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31410__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_31471__$1 = (function (){var statearr_31561 = state_31471;
(statearr_31561[(12)] = inst_31410__$1);

(statearr_31561[(18)] = inst_31412);

(statearr_31561[(16)] = inst_31411);

return statearr_31561;
})();
return cljs.core.async.ioc_alts_BANG_(state_31471__$1,(4),inst_31414);
} else {
if((state_val_31472 === (23))){
var inst_31455 = (state_31471[(2)]);
var state_31471__$1 = state_31471;
if(cljs.core.truth_(inst_31455)){
var statearr_31563_33666 = state_31471__$1;
(statearr_31563_33666[(1)] = (24));

} else {
var statearr_31565_33667 = state_31471__$1;
(statearr_31565_33667[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (19))){
var inst_31450 = (state_31471[(2)]);
var state_31471__$1 = state_31471;
var statearr_31566_33668 = state_31471__$1;
(statearr_31566_33668[(2)] = inst_31450);

(statearr_31566_33668[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (11))){
var inst_31421 = (state_31471[(14)]);
var inst_31431 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_31421);
var state_31471__$1 = state_31471;
var statearr_31572_33670 = state_31471__$1;
(statearr_31572_33670[(2)] = inst_31431);

(statearr_31572_33670[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (9))){
var inst_31421 = (state_31471[(14)]);
var inst_31438 = (state_31471[(19)]);
var inst_31411 = (state_31471[(16)]);
var inst_31438__$1 = (inst_31411.cljs$core$IFn$_invoke$arity$1 ? inst_31411.cljs$core$IFn$_invoke$arity$1(inst_31421) : inst_31411.call(null,inst_31421));
var state_31471__$1 = (function (){var statearr_31574 = state_31471;
(statearr_31574[(19)] = inst_31438__$1);

return statearr_31574;
})();
if(cljs.core.truth_(inst_31438__$1)){
var statearr_31575_33671 = state_31471__$1;
(statearr_31575_33671[(1)] = (14));

} else {
var statearr_31576_33672 = state_31471__$1;
(statearr_31576_33672[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (5))){
var inst_31422 = (state_31471[(13)]);
var state_31471__$1 = state_31471;
var statearr_31579_33673 = state_31471__$1;
(statearr_31579_33673[(2)] = inst_31422);

(statearr_31579_33673[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (14))){
var inst_31438 = (state_31471[(19)]);
var state_31471__$1 = state_31471;
var statearr_31581_33674 = state_31471__$1;
(statearr_31581_33674[(2)] = inst_31438);

(statearr_31581_33674[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (26))){
var inst_31460 = (state_31471[(2)]);
var state_31471__$1 = state_31471;
var statearr_31582_33683 = state_31471__$1;
(statearr_31582_33683[(2)] = inst_31460);

(statearr_31582_33683[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (16))){
var inst_31452 = (state_31471[(2)]);
var state_31471__$1 = state_31471;
if(cljs.core.truth_(inst_31452)){
var statearr_31583_33693 = state_31471__$1;
(statearr_31583_33693[(1)] = (20));

} else {
var statearr_31585_33695 = state_31471__$1;
(statearr_31585_33695[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (10))){
var inst_31467 = (state_31471[(2)]);
var state_31471__$1 = state_31471;
var statearr_31586_33696 = state_31471__$1;
(statearr_31586_33696[(2)] = inst_31467);

(statearr_31586_33696[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (18))){
var inst_31442 = (state_31471[(15)]);
var state_31471__$1 = state_31471;
var statearr_31587_33697 = state_31471__$1;
(statearr_31587_33697[(2)] = inst_31442);

(statearr_31587_33697[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31472 === (8))){
var inst_31420 = (state_31471[(7)]);
var inst_31429 = (inst_31420 == null);
var state_31471__$1 = state_31471;
if(cljs.core.truth_(inst_31429)){
var statearr_31588_33698 = state_31471__$1;
(statearr_31588_33698[(1)] = (11));

} else {
var statearr_31589_33699 = state_31471__$1;
(statearr_31589_33699[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__27443__auto__ = null;
var cljs$core$async$mix_$_state_machine__27443__auto____0 = (function (){
var statearr_31590 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31590[(0)] = cljs$core$async$mix_$_state_machine__27443__auto__);

(statearr_31590[(1)] = (1));

return statearr_31590;
});
var cljs$core$async$mix_$_state_machine__27443__auto____1 = (function (state_31471){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_31471);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e31592){var ex__27446__auto__ = e31592;
var statearr_31593_33701 = state_31471;
(statearr_31593_33701[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_31471[(4)]))){
var statearr_31594_33707 = state_31471;
(statearr_31594_33707[(1)] = cljs.core.first((state_31471[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33709 = state_31471;
state_31471 = G__33709;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__27443__auto__ = function(state_31471){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__27443__auto____1.call(this,state_31471);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__27443__auto____0;
cljs$core$async$mix_$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__27443__auto____1;
return cljs$core$async$mix_$_state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_31597 = f__27607__auto__();
(statearr_31597[(6)] = c__27606__auto___33641);

return statearr_31597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_33720 = (function (p,v,ch,close_QMARK_){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5394__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__5392__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5392__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_33720(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_33737 = (function (p,v,ch){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5394__auto__.call(null,p,v,ch));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5392__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_33737(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_33749 = (function() {
var G__33750 = null;
var G__33750__1 = (function (p){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5394__auto__.call(null,p));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5392__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__33750__2 = (function (p,v){
var x__5393__auto__ = (((p == null))?null:p);
var m__5394__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5393__auto__)]);
if((!((m__5394__auto__ == null)))){
return (m__5394__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5394__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5394__auto__.call(null,p,v));
} else {
var m__5392__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5392__auto__ == null)))){
return (m__5392__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5392__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5392__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__33750 = function(p,v){
switch(arguments.length){
case 1:
return G__33750__1.call(this,p);
case 2:
return G__33750__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33750.cljs$core$IFn$_invoke$arity$1 = G__33750__1;
G__33750.cljs$core$IFn$_invoke$arity$2 = G__33750__2;
return G__33750;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__31640 = arguments.length;
switch (G__31640) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33749(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_33749(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31674 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta31675){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta31675 = meta31675;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31676,meta31675__$1){
var self__ = this;
var _31676__$1 = this;
return (new cljs.core.async.t_cljs$core$async31674(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta31675__$1));
}));

(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31676){
var self__ = this;
var _31676__$1 = this;
return self__.meta31675;
}));

(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5804__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5804__auto__)){
var m = temp__5804__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async31674.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async31674.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta31675","meta31675",1512463763,null)], null);
}));

(cljs.core.async.t_cljs$core$async31674.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async31674.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31674");

(cljs.core.async.t_cljs$core$async31674.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async31674");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async31674.
 */
cljs.core.async.__GT_t_cljs$core$async31674 = (function cljs$core$async$__GT_t_cljs$core$async31674(ch,topic_fn,buf_fn,mults,ensure_mult,meta31675){
return (new cljs.core.async.t_cljs$core$async31674(ch,topic_fn,buf_fn,mults,ensure_mult,meta31675));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__31662 = arguments.length;
switch (G__31662) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5045__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5045__auto__)){
return or__5045__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__31658_SHARP_){
if(cljs.core.truth_((p1__31658_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31658_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__31658_SHARP_.call(null,topic)))){
return p1__31658_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__31658_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async31674(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__27606__auto___33777 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_31780){
var state_val_31781 = (state_31780[(1)]);
if((state_val_31781 === (7))){
var inst_31772 = (state_31780[(2)]);
var state_31780__$1 = state_31780;
var statearr_31808_33778 = state_31780__$1;
(statearr_31808_33778[(2)] = inst_31772);

(statearr_31808_33778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (20))){
var state_31780__$1 = state_31780;
var statearr_31809_33779 = state_31780__$1;
(statearr_31809_33779[(2)] = null);

(statearr_31809_33779[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (1))){
var state_31780__$1 = state_31780;
var statearr_31814_33780 = state_31780__$1;
(statearr_31814_33780[(2)] = null);

(statearr_31814_33780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (24))){
var inst_31755 = (state_31780[(7)]);
var inst_31764 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_31755);
var state_31780__$1 = state_31780;
var statearr_31821_33782 = state_31780__$1;
(statearr_31821_33782[(2)] = inst_31764);

(statearr_31821_33782[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (4))){
var inst_31697 = (state_31780[(8)]);
var inst_31697__$1 = (state_31780[(2)]);
var inst_31698 = (inst_31697__$1 == null);
var state_31780__$1 = (function (){var statearr_31827 = state_31780;
(statearr_31827[(8)] = inst_31697__$1);

return statearr_31827;
})();
if(cljs.core.truth_(inst_31698)){
var statearr_31832_33783 = state_31780__$1;
(statearr_31832_33783[(1)] = (5));

} else {
var statearr_31833_33787 = state_31780__$1;
(statearr_31833_33787[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (15))){
var inst_31743 = (state_31780[(2)]);
var state_31780__$1 = state_31780;
var statearr_31837_33788 = state_31780__$1;
(statearr_31837_33788[(2)] = inst_31743);

(statearr_31837_33788[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (21))){
var inst_31769 = (state_31780[(2)]);
var state_31780__$1 = (function (){var statearr_31840 = state_31780;
(statearr_31840[(9)] = inst_31769);

return statearr_31840;
})();
var statearr_31841_33789 = state_31780__$1;
(statearr_31841_33789[(2)] = null);

(statearr_31841_33789[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (13))){
var inst_31725 = (state_31780[(10)]);
var inst_31727 = cljs.core.chunked_seq_QMARK_(inst_31725);
var state_31780__$1 = state_31780;
if(inst_31727){
var statearr_31845_33790 = state_31780__$1;
(statearr_31845_33790[(1)] = (16));

} else {
var statearr_31846_33791 = state_31780__$1;
(statearr_31846_33791[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (22))){
var inst_31761 = (state_31780[(2)]);
var state_31780__$1 = state_31780;
if(cljs.core.truth_(inst_31761)){
var statearr_31852_33792 = state_31780__$1;
(statearr_31852_33792[(1)] = (23));

} else {
var statearr_31853_33793 = state_31780__$1;
(statearr_31853_33793[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (6))){
var inst_31755 = (state_31780[(7)]);
var inst_31697 = (state_31780[(8)]);
var inst_31757 = (state_31780[(11)]);
var inst_31755__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_31697) : topic_fn.call(null,inst_31697));
var inst_31756 = cljs.core.deref(mults);
var inst_31757__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31756,inst_31755__$1);
var state_31780__$1 = (function (){var statearr_31854 = state_31780;
(statearr_31854[(7)] = inst_31755__$1);

(statearr_31854[(11)] = inst_31757__$1);

return statearr_31854;
})();
if(cljs.core.truth_(inst_31757__$1)){
var statearr_31855_33794 = state_31780__$1;
(statearr_31855_33794[(1)] = (19));

} else {
var statearr_31856_33803 = state_31780__$1;
(statearr_31856_33803[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (25))){
var inst_31766 = (state_31780[(2)]);
var state_31780__$1 = state_31780;
var statearr_31866_33804 = state_31780__$1;
(statearr_31866_33804[(2)] = inst_31766);

(statearr_31866_33804[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (17))){
var inst_31725 = (state_31780[(10)]);
var inst_31734 = cljs.core.first(inst_31725);
var inst_31735 = cljs.core.async.muxch_STAR_(inst_31734);
var inst_31736 = cljs.core.async.close_BANG_(inst_31735);
var inst_31737 = cljs.core.next(inst_31725);
var inst_31707 = inst_31737;
var inst_31708 = null;
var inst_31709 = (0);
var inst_31710 = (0);
var state_31780__$1 = (function (){var statearr_31877 = state_31780;
(statearr_31877[(12)] = inst_31707);

(statearr_31877[(13)] = inst_31708);

(statearr_31877[(14)] = inst_31710);

(statearr_31877[(15)] = inst_31736);

(statearr_31877[(16)] = inst_31709);

return statearr_31877;
})();
var statearr_31882_33815 = state_31780__$1;
(statearr_31882_33815[(2)] = null);

(statearr_31882_33815[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (3))){
var inst_31774 = (state_31780[(2)]);
var state_31780__$1 = state_31780;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31780__$1,inst_31774);
} else {
if((state_val_31781 === (12))){
var inst_31745 = (state_31780[(2)]);
var state_31780__$1 = state_31780;
var statearr_31886_33819 = state_31780__$1;
(statearr_31886_33819[(2)] = inst_31745);

(statearr_31886_33819[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (2))){
var state_31780__$1 = state_31780;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31780__$1,(4),ch);
} else {
if((state_val_31781 === (23))){
var state_31780__$1 = state_31780;
var statearr_31895_33823 = state_31780__$1;
(statearr_31895_33823[(2)] = null);

(statearr_31895_33823[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (19))){
var inst_31697 = (state_31780[(8)]);
var inst_31757 = (state_31780[(11)]);
var inst_31759 = cljs.core.async.muxch_STAR_(inst_31757);
var state_31780__$1 = state_31780;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_31780__$1,(22),inst_31759,inst_31697);
} else {
if((state_val_31781 === (11))){
var inst_31707 = (state_31780[(12)]);
var inst_31725 = (state_31780[(10)]);
var inst_31725__$1 = cljs.core.seq(inst_31707);
var state_31780__$1 = (function (){var statearr_31909 = state_31780;
(statearr_31909[(10)] = inst_31725__$1);

return statearr_31909;
})();
if(inst_31725__$1){
var statearr_31913_33825 = state_31780__$1;
(statearr_31913_33825[(1)] = (13));

} else {
var statearr_31919_33826 = state_31780__$1;
(statearr_31919_33826[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (9))){
var inst_31747 = (state_31780[(2)]);
var state_31780__$1 = state_31780;
var statearr_31921_33827 = state_31780__$1;
(statearr_31921_33827[(2)] = inst_31747);

(statearr_31921_33827[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (5))){
var inst_31704 = cljs.core.deref(mults);
var inst_31705 = cljs.core.vals(inst_31704);
var inst_31706 = cljs.core.seq(inst_31705);
var inst_31707 = inst_31706;
var inst_31708 = null;
var inst_31709 = (0);
var inst_31710 = (0);
var state_31780__$1 = (function (){var statearr_31926 = state_31780;
(statearr_31926[(12)] = inst_31707);

(statearr_31926[(13)] = inst_31708);

(statearr_31926[(14)] = inst_31710);

(statearr_31926[(16)] = inst_31709);

return statearr_31926;
})();
var statearr_31927_33842 = state_31780__$1;
(statearr_31927_33842[(2)] = null);

(statearr_31927_33842[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (14))){
var state_31780__$1 = state_31780;
var statearr_31934_33843 = state_31780__$1;
(statearr_31934_33843[(2)] = null);

(statearr_31934_33843[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (16))){
var inst_31725 = (state_31780[(10)]);
var inst_31729 = cljs.core.chunk_first(inst_31725);
var inst_31730 = cljs.core.chunk_rest(inst_31725);
var inst_31731 = cljs.core.count(inst_31729);
var inst_31707 = inst_31730;
var inst_31708 = inst_31729;
var inst_31709 = inst_31731;
var inst_31710 = (0);
var state_31780__$1 = (function (){var statearr_31935 = state_31780;
(statearr_31935[(12)] = inst_31707);

(statearr_31935[(13)] = inst_31708);

(statearr_31935[(14)] = inst_31710);

(statearr_31935[(16)] = inst_31709);

return statearr_31935;
})();
var statearr_31937_33852 = state_31780__$1;
(statearr_31937_33852[(2)] = null);

(statearr_31937_33852[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (10))){
var inst_31707 = (state_31780[(12)]);
var inst_31708 = (state_31780[(13)]);
var inst_31710 = (state_31780[(14)]);
var inst_31709 = (state_31780[(16)]);
var inst_31716 = cljs.core._nth(inst_31708,inst_31710);
var inst_31718 = cljs.core.async.muxch_STAR_(inst_31716);
var inst_31719 = cljs.core.async.close_BANG_(inst_31718);
var inst_31721 = (inst_31710 + (1));
var tmp31930 = inst_31707;
var tmp31931 = inst_31708;
var tmp31932 = inst_31709;
var inst_31707__$1 = tmp31930;
var inst_31708__$1 = tmp31931;
var inst_31709__$1 = tmp31932;
var inst_31710__$1 = inst_31721;
var state_31780__$1 = (function (){var statearr_31938 = state_31780;
(statearr_31938[(12)] = inst_31707__$1);

(statearr_31938[(13)] = inst_31708__$1);

(statearr_31938[(14)] = inst_31710__$1);

(statearr_31938[(16)] = inst_31709__$1);

(statearr_31938[(17)] = inst_31719);

return statearr_31938;
})();
var statearr_31939_33854 = state_31780__$1;
(statearr_31939_33854[(2)] = null);

(statearr_31939_33854[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (18))){
var inst_31740 = (state_31780[(2)]);
var state_31780__$1 = state_31780;
var statearr_31940_33857 = state_31780__$1;
(statearr_31940_33857[(2)] = inst_31740);

(statearr_31940_33857[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31781 === (8))){
var inst_31710 = (state_31780[(14)]);
var inst_31709 = (state_31780[(16)]);
var inst_31713 = (inst_31710 < inst_31709);
var inst_31714 = inst_31713;
var state_31780__$1 = state_31780;
if(cljs.core.truth_(inst_31714)){
var statearr_31942_33859 = state_31780__$1;
(statearr_31942_33859[(1)] = (10));

} else {
var statearr_31943_33860 = state_31780__$1;
(statearr_31943_33860[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_31946 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31946[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_31946[(1)] = (1));

return statearr_31946;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_31780){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_31780);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e31948){var ex__27446__auto__ = e31948;
var statearr_31952_33862 = state_31780;
(statearr_31952_33862[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_31780[(4)]))){
var statearr_31953_33863 = state_31780;
(statearr_31953_33863[(1)] = cljs.core.first((state_31780[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33864 = state_31780;
state_31780 = G__33864;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_31780){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_31780);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_31955 = f__27607__auto__();
(statearr_31955[(6)] = c__27606__auto___33777);

return statearr_31955;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__31960 = arguments.length;
switch (G__31960) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__31968 = arguments.length;
switch (G__31968) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__31976 = arguments.length;
switch (G__31976) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__27606__auto___33886 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_32077){
var state_val_32078 = (state_32077[(1)]);
if((state_val_32078 === (7))){
var state_32077__$1 = state_32077;
var statearr_32079_33887 = state_32077__$1;
(statearr_32079_33887[(2)] = null);

(statearr_32079_33887[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (1))){
var state_32077__$1 = state_32077;
var statearr_32080_33888 = state_32077__$1;
(statearr_32080_33888[(2)] = null);

(statearr_32080_33888[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (4))){
var inst_31982 = (state_32077[(7)]);
var inst_31983 = (state_32077[(8)]);
var inst_31986 = (inst_31983 < inst_31982);
var state_32077__$1 = state_32077;
if(cljs.core.truth_(inst_31986)){
var statearr_32081_33889 = state_32077__$1;
(statearr_32081_33889[(1)] = (6));

} else {
var statearr_32082_33890 = state_32077__$1;
(statearr_32082_33890[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (15))){
var inst_32060 = (state_32077[(9)]);
var inst_32065 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_32060);
var state_32077__$1 = state_32077;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32077__$1,(17),out,inst_32065);
} else {
if((state_val_32078 === (13))){
var inst_32060 = (state_32077[(9)]);
var inst_32060__$1 = (state_32077[(2)]);
var inst_32061 = cljs.core.some(cljs.core.nil_QMARK_,inst_32060__$1);
var state_32077__$1 = (function (){var statearr_32083 = state_32077;
(statearr_32083[(9)] = inst_32060__$1);

return statearr_32083;
})();
if(cljs.core.truth_(inst_32061)){
var statearr_32084_33891 = state_32077__$1;
(statearr_32084_33891[(1)] = (14));

} else {
var statearr_32085_33892 = state_32077__$1;
(statearr_32085_33892[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (6))){
var state_32077__$1 = state_32077;
var statearr_32086_33893 = state_32077__$1;
(statearr_32086_33893[(2)] = null);

(statearr_32086_33893[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (17))){
var inst_32067 = (state_32077[(2)]);
var state_32077__$1 = (function (){var statearr_32093 = state_32077;
(statearr_32093[(10)] = inst_32067);

return statearr_32093;
})();
var statearr_32094_33895 = state_32077__$1;
(statearr_32094_33895[(2)] = null);

(statearr_32094_33895[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (3))){
var inst_32072 = (state_32077[(2)]);
var state_32077__$1 = state_32077;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32077__$1,inst_32072);
} else {
if((state_val_32078 === (12))){
var _ = (function (){var statearr_32095 = state_32077;
(statearr_32095[(4)] = cljs.core.rest((state_32077[(4)])));

return statearr_32095;
})();
var state_32077__$1 = state_32077;
var ex32092 = (state_32077__$1[(2)]);
var statearr_32097_33896 = state_32077__$1;
(statearr_32097_33896[(5)] = ex32092);


if((ex32092 instanceof Object)){
var statearr_32098_33897 = state_32077__$1;
(statearr_32098_33897[(1)] = (11));

(statearr_32098_33897[(5)] = null);

} else {
throw ex32092;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (2))){
var inst_31980 = cljs.core.reset_BANG_(dctr,cnt);
var inst_31982 = cnt;
var inst_31983 = (0);
var state_32077__$1 = (function (){var statearr_32101 = state_32077;
(statearr_32101[(7)] = inst_31982);

(statearr_32101[(11)] = inst_31980);

(statearr_32101[(8)] = inst_31983);

return statearr_32101;
})();
var statearr_32105_33898 = state_32077__$1;
(statearr_32105_33898[(2)] = null);

(statearr_32105_33898[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (11))){
var inst_32037 = (state_32077[(2)]);
var inst_32039 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_32077__$1 = (function (){var statearr_32106 = state_32077;
(statearr_32106[(12)] = inst_32037);

return statearr_32106;
})();
var statearr_32110_33899 = state_32077__$1;
(statearr_32110_33899[(2)] = inst_32039);

(statearr_32110_33899[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (9))){
var inst_31983 = (state_32077[(8)]);
var _ = (function (){var statearr_32111 = state_32077;
(statearr_32111[(4)] = cljs.core.cons((12),(state_32077[(4)])));

return statearr_32111;
})();
var inst_32046 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_31983) : chs__$1.call(null,inst_31983));
var inst_32047 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_31983) : done.call(null,inst_31983));
var inst_32048 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_32046,inst_32047);
var ___$1 = (function (){var statearr_32112 = state_32077;
(statearr_32112[(4)] = cljs.core.rest((state_32077[(4)])));

return statearr_32112;
})();
var state_32077__$1 = state_32077;
var statearr_32114_33900 = state_32077__$1;
(statearr_32114_33900[(2)] = inst_32048);

(statearr_32114_33900[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (5))){
var inst_32058 = (state_32077[(2)]);
var state_32077__$1 = (function (){var statearr_32115 = state_32077;
(statearr_32115[(13)] = inst_32058);

return statearr_32115;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32077__$1,(13),dchan);
} else {
if((state_val_32078 === (14))){
var inst_32063 = cljs.core.async.close_BANG_(out);
var state_32077__$1 = state_32077;
var statearr_32119_33901 = state_32077__$1;
(statearr_32119_33901[(2)] = inst_32063);

(statearr_32119_33901[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (16))){
var inst_32070 = (state_32077[(2)]);
var state_32077__$1 = state_32077;
var statearr_32120_33902 = state_32077__$1;
(statearr_32120_33902[(2)] = inst_32070);

(statearr_32120_33902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (10))){
var inst_31983 = (state_32077[(8)]);
var inst_32051 = (state_32077[(2)]);
var inst_32052 = (inst_31983 + (1));
var inst_31983__$1 = inst_32052;
var state_32077__$1 = (function (){var statearr_32121 = state_32077;
(statearr_32121[(14)] = inst_32051);

(statearr_32121[(8)] = inst_31983__$1);

return statearr_32121;
})();
var statearr_32122_33903 = state_32077__$1;
(statearr_32122_33903[(2)] = null);

(statearr_32122_33903[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32078 === (8))){
var inst_32056 = (state_32077[(2)]);
var state_32077__$1 = state_32077;
var statearr_32123_33908 = state_32077__$1;
(statearr_32123_33908[(2)] = inst_32056);

(statearr_32123_33908[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_32124 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32124[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_32124[(1)] = (1));

return statearr_32124;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_32077){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_32077);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e32126){var ex__27446__auto__ = e32126;
var statearr_32127_33909 = state_32077;
(statearr_32127_33909[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_32077[(4)]))){
var statearr_32129_33910 = state_32077;
(statearr_32129_33910[(1)] = cljs.core.first((state_32077[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33911 = state_32077;
state_32077 = G__33911;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_32077){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_32077);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_32130 = f__27607__auto__();
(statearr_32130[(6)] = c__27606__auto___33886);

return statearr_32130;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__32138 = arguments.length;
switch (G__32138) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27606__auto___33918 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_32195){
var state_val_32196 = (state_32195[(1)]);
if((state_val_32196 === (7))){
var inst_32160 = (state_32195[(7)]);
var inst_32159 = (state_32195[(8)]);
var inst_32159__$1 = (state_32195[(2)]);
var inst_32160__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32159__$1,(0),null);
var inst_32161 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32159__$1,(1),null);
var inst_32168 = (inst_32160__$1 == null);
var state_32195__$1 = (function (){var statearr_32199 = state_32195;
(statearr_32199[(7)] = inst_32160__$1);

(statearr_32199[(9)] = inst_32161);

(statearr_32199[(8)] = inst_32159__$1);

return statearr_32199;
})();
if(cljs.core.truth_(inst_32168)){
var statearr_32200_33942 = state_32195__$1;
(statearr_32200_33942[(1)] = (8));

} else {
var statearr_32201_33943 = state_32195__$1;
(statearr_32201_33943[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32196 === (1))){
var inst_32144 = cljs.core.vec(chs);
var inst_32145 = inst_32144;
var state_32195__$1 = (function (){var statearr_32202 = state_32195;
(statearr_32202[(10)] = inst_32145);

return statearr_32202;
})();
var statearr_32204_33946 = state_32195__$1;
(statearr_32204_33946[(2)] = null);

(statearr_32204_33946[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32196 === (4))){
var inst_32145 = (state_32195[(10)]);
var state_32195__$1 = state_32195;
return cljs.core.async.ioc_alts_BANG_(state_32195__$1,(7),inst_32145);
} else {
if((state_val_32196 === (6))){
var inst_32191 = (state_32195[(2)]);
var state_32195__$1 = state_32195;
var statearr_32207_33948 = state_32195__$1;
(statearr_32207_33948[(2)] = inst_32191);

(statearr_32207_33948[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32196 === (3))){
var inst_32193 = (state_32195[(2)]);
var state_32195__$1 = state_32195;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32195__$1,inst_32193);
} else {
if((state_val_32196 === (2))){
var inst_32145 = (state_32195[(10)]);
var inst_32147 = cljs.core.count(inst_32145);
var inst_32148 = (inst_32147 > (0));
var state_32195__$1 = state_32195;
if(cljs.core.truth_(inst_32148)){
var statearr_32211_33956 = state_32195__$1;
(statearr_32211_33956[(1)] = (4));

} else {
var statearr_32212_33957 = state_32195__$1;
(statearr_32212_33957[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32196 === (11))){
var inst_32145 = (state_32195[(10)]);
var inst_32184 = (state_32195[(2)]);
var tmp32210 = inst_32145;
var inst_32145__$1 = tmp32210;
var state_32195__$1 = (function (){var statearr_32213 = state_32195;
(statearr_32213[(11)] = inst_32184);

(statearr_32213[(10)] = inst_32145__$1);

return statearr_32213;
})();
var statearr_32214_33961 = state_32195__$1;
(statearr_32214_33961[(2)] = null);

(statearr_32214_33961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32196 === (9))){
var inst_32160 = (state_32195[(7)]);
var state_32195__$1 = state_32195;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32195__$1,(11),out,inst_32160);
} else {
if((state_val_32196 === (5))){
var inst_32189 = cljs.core.async.close_BANG_(out);
var state_32195__$1 = state_32195;
var statearr_32216_33967 = state_32195__$1;
(statearr_32216_33967[(2)] = inst_32189);

(statearr_32216_33967[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32196 === (10))){
var inst_32187 = (state_32195[(2)]);
var state_32195__$1 = state_32195;
var statearr_32218_33980 = state_32195__$1;
(statearr_32218_33980[(2)] = inst_32187);

(statearr_32218_33980[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32196 === (8))){
var inst_32160 = (state_32195[(7)]);
var inst_32161 = (state_32195[(9)]);
var inst_32145 = (state_32195[(10)]);
var inst_32159 = (state_32195[(8)]);
var inst_32179 = (function (){var cs = inst_32145;
var vec__32151 = inst_32159;
var v = inst_32160;
var c = inst_32161;
return (function (p1__32131_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__32131_SHARP_);
});
})();
var inst_32180 = cljs.core.filterv(inst_32179,inst_32145);
var inst_32145__$1 = inst_32180;
var state_32195__$1 = (function (){var statearr_32219 = state_32195;
(statearr_32219[(10)] = inst_32145__$1);

return statearr_32219;
})();
var statearr_32220_33992 = state_32195__$1;
(statearr_32220_33992[(2)] = null);

(statearr_32220_33992[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_32221 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32221[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_32221[(1)] = (1));

return statearr_32221;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_32195){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_32195);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e32222){var ex__27446__auto__ = e32222;
var statearr_32223_34003 = state_32195;
(statearr_32223_34003[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_32195[(4)]))){
var statearr_32224_34007 = state_32195;
(statearr_32224_34007[(1)] = cljs.core.first((state_32195[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34009 = state_32195;
state_32195 = G__34009;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_32195){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_32195);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_32225 = f__27607__auto__();
(statearr_32225[(6)] = c__27606__auto___33918);

return statearr_32225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__32228 = arguments.length;
switch (G__32228) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27606__auto___34016 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_32257){
var state_val_32258 = (state_32257[(1)]);
if((state_val_32258 === (7))){
var inst_32235 = (state_32257[(7)]);
var inst_32235__$1 = (state_32257[(2)]);
var inst_32236 = (inst_32235__$1 == null);
var inst_32237 = cljs.core.not(inst_32236);
var state_32257__$1 = (function (){var statearr_32259 = state_32257;
(statearr_32259[(7)] = inst_32235__$1);

return statearr_32259;
})();
if(inst_32237){
var statearr_32260_34020 = state_32257__$1;
(statearr_32260_34020[(1)] = (8));

} else {
var statearr_32262_34021 = state_32257__$1;
(statearr_32262_34021[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32258 === (1))){
var inst_32230 = (0);
var state_32257__$1 = (function (){var statearr_32264 = state_32257;
(statearr_32264[(8)] = inst_32230);

return statearr_32264;
})();
var statearr_32265_34024 = state_32257__$1;
(statearr_32265_34024[(2)] = null);

(statearr_32265_34024[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32258 === (4))){
var state_32257__$1 = state_32257;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32257__$1,(7),ch);
} else {
if((state_val_32258 === (6))){
var inst_32252 = (state_32257[(2)]);
var state_32257__$1 = state_32257;
var statearr_32266_34025 = state_32257__$1;
(statearr_32266_34025[(2)] = inst_32252);

(statearr_32266_34025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32258 === (3))){
var inst_32254 = (state_32257[(2)]);
var inst_32255 = cljs.core.async.close_BANG_(out);
var state_32257__$1 = (function (){var statearr_32267 = state_32257;
(statearr_32267[(9)] = inst_32254);

return statearr_32267;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32257__$1,inst_32255);
} else {
if((state_val_32258 === (2))){
var inst_32230 = (state_32257[(8)]);
var inst_32232 = (inst_32230 < n);
var state_32257__$1 = state_32257;
if(cljs.core.truth_(inst_32232)){
var statearr_32268_34027 = state_32257__$1;
(statearr_32268_34027[(1)] = (4));

} else {
var statearr_32269_34028 = state_32257__$1;
(statearr_32269_34028[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32258 === (11))){
var inst_32230 = (state_32257[(8)]);
var inst_32240 = (state_32257[(2)]);
var inst_32241 = (inst_32230 + (1));
var inst_32230__$1 = inst_32241;
var state_32257__$1 = (function (){var statearr_32271 = state_32257;
(statearr_32271[(10)] = inst_32240);

(statearr_32271[(8)] = inst_32230__$1);

return statearr_32271;
})();
var statearr_32272_34030 = state_32257__$1;
(statearr_32272_34030[(2)] = null);

(statearr_32272_34030[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32258 === (9))){
var state_32257__$1 = state_32257;
var statearr_32273_34031 = state_32257__$1;
(statearr_32273_34031[(2)] = null);

(statearr_32273_34031[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32258 === (5))){
var state_32257__$1 = state_32257;
var statearr_32274_34032 = state_32257__$1;
(statearr_32274_34032[(2)] = null);

(statearr_32274_34032[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32258 === (10))){
var inst_32247 = (state_32257[(2)]);
var state_32257__$1 = state_32257;
var statearr_32275_34033 = state_32257__$1;
(statearr_32275_34033[(2)] = inst_32247);

(statearr_32275_34033[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32258 === (8))){
var inst_32235 = (state_32257[(7)]);
var state_32257__$1 = state_32257;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32257__$1,(11),out,inst_32235);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_32278 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32278[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_32278[(1)] = (1));

return statearr_32278;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_32257){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_32257);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e32279){var ex__27446__auto__ = e32279;
var statearr_32281_34034 = state_32257;
(statearr_32281_34034[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_32257[(4)]))){
var statearr_32284_34035 = state_32257;
(statearr_32284_34035[(1)] = cljs.core.first((state_32257[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34036 = state_32257;
state_32257 = G__34036;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_32257){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_32257);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_32285 = f__27607__auto__();
(statearr_32285[(6)] = c__27606__auto___34016);

return statearr_32285;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32296 = (function (f,ch,meta32289,_,fn1,meta32297){
this.f = f;
this.ch = ch;
this.meta32289 = meta32289;
this._ = _;
this.fn1 = fn1;
this.meta32297 = meta32297;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32296.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32298,meta32297__$1){
var self__ = this;
var _32298__$1 = this;
return (new cljs.core.async.t_cljs$core$async32296(self__.f,self__.ch,self__.meta32289,self__._,self__.fn1,meta32297__$1));
}));

(cljs.core.async.t_cljs$core$async32296.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32298){
var self__ = this;
var _32298__$1 = this;
return self__.meta32297;
}));

(cljs.core.async.t_cljs$core$async32296.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32296.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async32296.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async32296.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__32286_SHARP_){
var G__32300 = (((p1__32286_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__32286_SHARP_) : self__.f.call(null,p1__32286_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__32300) : f1.call(null,G__32300));
});
}));

(cljs.core.async.t_cljs$core$async32296.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32289","meta32289",-1489667965,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async32288","cljs.core.async/t_cljs$core$async32288",367413855,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta32297","meta32297",682581341,null)], null);
}));

(cljs.core.async.t_cljs$core$async32296.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32296.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32296");

(cljs.core.async.t_cljs$core$async32296.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32296");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32296.
 */
cljs.core.async.__GT_t_cljs$core$async32296 = (function cljs$core$async$__GT_t_cljs$core$async32296(f,ch,meta32289,_,fn1,meta32297){
return (new cljs.core.async.t_cljs$core$async32296(f,ch,meta32289,_,fn1,meta32297));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32288 = (function (f,ch,meta32289){
this.f = f;
this.ch = ch;
this.meta32289 = meta32289;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32290,meta32289__$1){
var self__ = this;
var _32290__$1 = this;
return (new cljs.core.async.t_cljs$core$async32288(self__.f,self__.ch,meta32289__$1));
}));

(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32290){
var self__ = this;
var _32290__$1 = this;
return self__.meta32289;
}));

(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async32296(self__.f,self__.ch,self__.meta32289,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5043__auto__ = ret;
if(cljs.core.truth_(and__5043__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5043__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__32304 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__32304) : self__.f.call(null,G__32304));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32288.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async32288.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32289","meta32289",-1489667965,null)], null);
}));

(cljs.core.async.t_cljs$core$async32288.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32288.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32288");

(cljs.core.async.t_cljs$core$async32288.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32288");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32288.
 */
cljs.core.async.__GT_t_cljs$core$async32288 = (function cljs$core$async$__GT_t_cljs$core$async32288(f,ch,meta32289){
return (new cljs.core.async.t_cljs$core$async32288(f,ch,meta32289));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async32288(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32307 = (function (f,ch,meta32308){
this.f = f;
this.ch = ch;
this.meta32308 = meta32308;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32307.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32309,meta32308__$1){
var self__ = this;
var _32309__$1 = this;
return (new cljs.core.async.t_cljs$core$async32307(self__.f,self__.ch,meta32308__$1));
}));

(cljs.core.async.t_cljs$core$async32307.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32309){
var self__ = this;
var _32309__$1 = this;
return self__.meta32308;
}));

(cljs.core.async.t_cljs$core$async32307.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32307.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32307.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32307.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32307.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32307.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async32307.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32308","meta32308",-1477013793,null)], null);
}));

(cljs.core.async.t_cljs$core$async32307.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32307.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32307");

(cljs.core.async.t_cljs$core$async32307.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32307");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32307.
 */
cljs.core.async.__GT_t_cljs$core$async32307 = (function cljs$core$async$__GT_t_cljs$core$async32307(f,ch,meta32308){
return (new cljs.core.async.t_cljs$core$async32307(f,ch,meta32308));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async32307(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32317 = (function (p,ch,meta32318){
this.p = p;
this.ch = ch;
this.meta32318 = meta32318;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_32319,meta32318__$1){
var self__ = this;
var _32319__$1 = this;
return (new cljs.core.async.t_cljs$core$async32317(self__.p,self__.ch,meta32318__$1));
}));

(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_32319){
var self__ = this;
var _32319__$1 = this;
return self__.meta32318;
}));

(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async32317.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async32317.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta32318","meta32318",298082999,null)], null);
}));

(cljs.core.async.t_cljs$core$async32317.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async32317.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32317");

(cljs.core.async.t_cljs$core$async32317.cljs$lang$ctorPrWriter = (function (this__5330__auto__,writer__5331__auto__,opt__5332__auto__){
return cljs.core._write(writer__5331__auto__,"cljs.core.async/t_cljs$core$async32317");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async32317.
 */
cljs.core.async.__GT_t_cljs$core$async32317 = (function cljs$core$async$__GT_t_cljs$core$async32317(p,ch,meta32318){
return (new cljs.core.async.t_cljs$core$async32317(p,ch,meta32318));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async32317(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__32342 = arguments.length;
switch (G__32342) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27606__auto___34105 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_32369){
var state_val_32370 = (state_32369[(1)]);
if((state_val_32370 === (7))){
var inst_32362 = (state_32369[(2)]);
var state_32369__$1 = state_32369;
var statearr_32373_34110 = state_32369__$1;
(statearr_32373_34110[(2)] = inst_32362);

(statearr_32373_34110[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32370 === (1))){
var state_32369__$1 = state_32369;
var statearr_32374_34114 = state_32369__$1;
(statearr_32374_34114[(2)] = null);

(statearr_32374_34114[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32370 === (4))){
var inst_32347 = (state_32369[(7)]);
var inst_32347__$1 = (state_32369[(2)]);
var inst_32348 = (inst_32347__$1 == null);
var state_32369__$1 = (function (){var statearr_32375 = state_32369;
(statearr_32375[(7)] = inst_32347__$1);

return statearr_32375;
})();
if(cljs.core.truth_(inst_32348)){
var statearr_32376_34115 = state_32369__$1;
(statearr_32376_34115[(1)] = (5));

} else {
var statearr_32377_34116 = state_32369__$1;
(statearr_32377_34116[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32370 === (6))){
var inst_32347 = (state_32369[(7)]);
var inst_32353 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_32347) : p.call(null,inst_32347));
var state_32369__$1 = state_32369;
if(cljs.core.truth_(inst_32353)){
var statearr_32381_34117 = state_32369__$1;
(statearr_32381_34117[(1)] = (8));

} else {
var statearr_32382_34118 = state_32369__$1;
(statearr_32382_34118[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32370 === (3))){
var inst_32364 = (state_32369[(2)]);
var state_32369__$1 = state_32369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32369__$1,inst_32364);
} else {
if((state_val_32370 === (2))){
var state_32369__$1 = state_32369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32369__$1,(4),ch);
} else {
if((state_val_32370 === (11))){
var inst_32356 = (state_32369[(2)]);
var state_32369__$1 = state_32369;
var statearr_32383_34122 = state_32369__$1;
(statearr_32383_34122[(2)] = inst_32356);

(statearr_32383_34122[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32370 === (9))){
var state_32369__$1 = state_32369;
var statearr_32384_34127 = state_32369__$1;
(statearr_32384_34127[(2)] = null);

(statearr_32384_34127[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32370 === (5))){
var inst_32351 = cljs.core.async.close_BANG_(out);
var state_32369__$1 = state_32369;
var statearr_32386_34132 = state_32369__$1;
(statearr_32386_34132[(2)] = inst_32351);

(statearr_32386_34132[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32370 === (10))){
var inst_32359 = (state_32369[(2)]);
var state_32369__$1 = (function (){var statearr_32387 = state_32369;
(statearr_32387[(8)] = inst_32359);

return statearr_32387;
})();
var statearr_32388_34136 = state_32369__$1;
(statearr_32388_34136[(2)] = null);

(statearr_32388_34136[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32370 === (8))){
var inst_32347 = (state_32369[(7)]);
var state_32369__$1 = state_32369;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32369__$1,(11),out,inst_32347);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_32389 = [null,null,null,null,null,null,null,null,null];
(statearr_32389[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_32389[(1)] = (1));

return statearr_32389;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_32369){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_32369);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e32390){var ex__27446__auto__ = e32390;
var statearr_32391_34141 = state_32369;
(statearr_32391_34141[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_32369[(4)]))){
var statearr_32392_34142 = state_32369;
(statearr_32392_34142[(1)] = cljs.core.first((state_32369[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34143 = state_32369;
state_32369 = G__34143;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_32369){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_32369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_32397 = f__27607__auto__();
(statearr_32397[(6)] = c__27606__auto___34105);

return statearr_32397;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__32402 = arguments.length;
switch (G__32402) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__27606__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_32476){
var state_val_32477 = (state_32476[(1)]);
if((state_val_32477 === (7))){
var inst_32472 = (state_32476[(2)]);
var state_32476__$1 = state_32476;
var statearr_32479_34154 = state_32476__$1;
(statearr_32479_34154[(2)] = inst_32472);

(statearr_32479_34154[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (20))){
var inst_32439 = (state_32476[(7)]);
var inst_32453 = (state_32476[(2)]);
var inst_32454 = cljs.core.next(inst_32439);
var inst_32423 = inst_32454;
var inst_32424 = null;
var inst_32425 = (0);
var inst_32426 = (0);
var state_32476__$1 = (function (){var statearr_32480 = state_32476;
(statearr_32480[(8)] = inst_32426);

(statearr_32480[(9)] = inst_32424);

(statearr_32480[(10)] = inst_32453);

(statearr_32480[(11)] = inst_32425);

(statearr_32480[(12)] = inst_32423);

return statearr_32480;
})();
var statearr_32481_34158 = state_32476__$1;
(statearr_32481_34158[(2)] = null);

(statearr_32481_34158[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (1))){
var state_32476__$1 = state_32476;
var statearr_32486_34159 = state_32476__$1;
(statearr_32486_34159[(2)] = null);

(statearr_32486_34159[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (4))){
var inst_32406 = (state_32476[(13)]);
var inst_32406__$1 = (state_32476[(2)]);
var inst_32407 = (inst_32406__$1 == null);
var state_32476__$1 = (function (){var statearr_32487 = state_32476;
(statearr_32487[(13)] = inst_32406__$1);

return statearr_32487;
})();
if(cljs.core.truth_(inst_32407)){
var statearr_32488_34160 = state_32476__$1;
(statearr_32488_34160[(1)] = (5));

} else {
var statearr_32489_34161 = state_32476__$1;
(statearr_32489_34161[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (15))){
var state_32476__$1 = state_32476;
var statearr_32493_34162 = state_32476__$1;
(statearr_32493_34162[(2)] = null);

(statearr_32493_34162[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (21))){
var state_32476__$1 = state_32476;
var statearr_32494_34163 = state_32476__$1;
(statearr_32494_34163[(2)] = null);

(statearr_32494_34163[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (13))){
var inst_32426 = (state_32476[(8)]);
var inst_32424 = (state_32476[(9)]);
var inst_32425 = (state_32476[(11)]);
var inst_32423 = (state_32476[(12)]);
var inst_32433 = (state_32476[(2)]);
var inst_32434 = (inst_32426 + (1));
var tmp32490 = inst_32424;
var tmp32491 = inst_32425;
var tmp32492 = inst_32423;
var inst_32423__$1 = tmp32492;
var inst_32424__$1 = tmp32490;
var inst_32425__$1 = tmp32491;
var inst_32426__$1 = inst_32434;
var state_32476__$1 = (function (){var statearr_32495 = state_32476;
(statearr_32495[(8)] = inst_32426__$1);

(statearr_32495[(9)] = inst_32424__$1);

(statearr_32495[(14)] = inst_32433);

(statearr_32495[(11)] = inst_32425__$1);

(statearr_32495[(12)] = inst_32423__$1);

return statearr_32495;
})();
var statearr_32496_34168 = state_32476__$1;
(statearr_32496_34168[(2)] = null);

(statearr_32496_34168[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (22))){
var state_32476__$1 = state_32476;
var statearr_32497_34169 = state_32476__$1;
(statearr_32497_34169[(2)] = null);

(statearr_32497_34169[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (6))){
var inst_32406 = (state_32476[(13)]);
var inst_32421 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32406) : f.call(null,inst_32406));
var inst_32422 = cljs.core.seq(inst_32421);
var inst_32423 = inst_32422;
var inst_32424 = null;
var inst_32425 = (0);
var inst_32426 = (0);
var state_32476__$1 = (function (){var statearr_32500 = state_32476;
(statearr_32500[(8)] = inst_32426);

(statearr_32500[(9)] = inst_32424);

(statearr_32500[(11)] = inst_32425);

(statearr_32500[(12)] = inst_32423);

return statearr_32500;
})();
var statearr_32501_34170 = state_32476__$1;
(statearr_32501_34170[(2)] = null);

(statearr_32501_34170[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (17))){
var inst_32439 = (state_32476[(7)]);
var inst_32446 = cljs.core.chunk_first(inst_32439);
var inst_32447 = cljs.core.chunk_rest(inst_32439);
var inst_32448 = cljs.core.count(inst_32446);
var inst_32423 = inst_32447;
var inst_32424 = inst_32446;
var inst_32425 = inst_32448;
var inst_32426 = (0);
var state_32476__$1 = (function (){var statearr_32502 = state_32476;
(statearr_32502[(8)] = inst_32426);

(statearr_32502[(9)] = inst_32424);

(statearr_32502[(11)] = inst_32425);

(statearr_32502[(12)] = inst_32423);

return statearr_32502;
})();
var statearr_32503_34171 = state_32476__$1;
(statearr_32503_34171[(2)] = null);

(statearr_32503_34171[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (3))){
var inst_32474 = (state_32476[(2)]);
var state_32476__$1 = state_32476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32476__$1,inst_32474);
} else {
if((state_val_32477 === (12))){
var inst_32462 = (state_32476[(2)]);
var state_32476__$1 = state_32476;
var statearr_32504_34172 = state_32476__$1;
(statearr_32504_34172[(2)] = inst_32462);

(statearr_32504_34172[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (2))){
var state_32476__$1 = state_32476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32476__$1,(4),in$);
} else {
if((state_val_32477 === (23))){
var inst_32470 = (state_32476[(2)]);
var state_32476__$1 = state_32476;
var statearr_32505_34173 = state_32476__$1;
(statearr_32505_34173[(2)] = inst_32470);

(statearr_32505_34173[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (19))){
var inst_32457 = (state_32476[(2)]);
var state_32476__$1 = state_32476;
var statearr_32506_34178 = state_32476__$1;
(statearr_32506_34178[(2)] = inst_32457);

(statearr_32506_34178[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (11))){
var inst_32439 = (state_32476[(7)]);
var inst_32423 = (state_32476[(12)]);
var inst_32439__$1 = cljs.core.seq(inst_32423);
var state_32476__$1 = (function (){var statearr_32508 = state_32476;
(statearr_32508[(7)] = inst_32439__$1);

return statearr_32508;
})();
if(inst_32439__$1){
var statearr_32509_34183 = state_32476__$1;
(statearr_32509_34183[(1)] = (14));

} else {
var statearr_32510_34184 = state_32476__$1;
(statearr_32510_34184[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (9))){
var inst_32464 = (state_32476[(2)]);
var inst_32465 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_32476__$1 = (function (){var statearr_32511 = state_32476;
(statearr_32511[(15)] = inst_32464);

return statearr_32511;
})();
if(cljs.core.truth_(inst_32465)){
var statearr_32512_34189 = state_32476__$1;
(statearr_32512_34189[(1)] = (21));

} else {
var statearr_32513_34190 = state_32476__$1;
(statearr_32513_34190[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (5))){
var inst_32409 = cljs.core.async.close_BANG_(out);
var state_32476__$1 = state_32476;
var statearr_32514_34191 = state_32476__$1;
(statearr_32514_34191[(2)] = inst_32409);

(statearr_32514_34191[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (14))){
var inst_32439 = (state_32476[(7)]);
var inst_32441 = cljs.core.chunked_seq_QMARK_(inst_32439);
var state_32476__$1 = state_32476;
if(inst_32441){
var statearr_32515_34192 = state_32476__$1;
(statearr_32515_34192[(1)] = (17));

} else {
var statearr_32516_34193 = state_32476__$1;
(statearr_32516_34193[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (16))){
var inst_32460 = (state_32476[(2)]);
var state_32476__$1 = state_32476;
var statearr_32517_34194 = state_32476__$1;
(statearr_32517_34194[(2)] = inst_32460);

(statearr_32517_34194[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32477 === (10))){
var inst_32426 = (state_32476[(8)]);
var inst_32424 = (state_32476[(9)]);
var inst_32431 = cljs.core._nth(inst_32424,inst_32426);
var state_32476__$1 = state_32476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32476__$1,(13),out,inst_32431);
} else {
if((state_val_32477 === (18))){
var inst_32439 = (state_32476[(7)]);
var inst_32451 = cljs.core.first(inst_32439);
var state_32476__$1 = state_32476;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32476__$1,(20),out,inst_32451);
} else {
if((state_val_32477 === (8))){
var inst_32426 = (state_32476[(8)]);
var inst_32425 = (state_32476[(11)]);
var inst_32428 = (inst_32426 < inst_32425);
var inst_32429 = inst_32428;
var state_32476__$1 = state_32476;
if(cljs.core.truth_(inst_32429)){
var statearr_32522_34198 = state_32476__$1;
(statearr_32522_34198[(1)] = (10));

} else {
var statearr_32523_34199 = state_32476__$1;
(statearr_32523_34199[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__27443__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__27443__auto____0 = (function (){
var statearr_32524 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32524[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__27443__auto__);

(statearr_32524[(1)] = (1));

return statearr_32524;
});
var cljs$core$async$mapcat_STAR__$_state_machine__27443__auto____1 = (function (state_32476){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_32476);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e32525){var ex__27446__auto__ = e32525;
var statearr_32526_34200 = state_32476;
(statearr_32526_34200[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_32476[(4)]))){
var statearr_32527_34201 = state_32476;
(statearr_32527_34201[(1)] = cljs.core.first((state_32476[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34202 = state_32476;
state_32476 = G__34202;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__27443__auto__ = function(state_32476){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__27443__auto____1.call(this,state_32476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__27443__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__27443__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_32528 = f__27607__auto__();
(statearr_32528[(6)] = c__27606__auto__);

return statearr_32528;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));

return c__27606__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__32531 = arguments.length;
switch (G__32531) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__32537 = arguments.length;
switch (G__32537) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__32545 = arguments.length;
switch (G__32545) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27606__auto___34220 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_32592){
var state_val_32593 = (state_32592[(1)]);
if((state_val_32593 === (7))){
var inst_32586 = (state_32592[(2)]);
var state_32592__$1 = state_32592;
var statearr_32594_34221 = state_32592__$1;
(statearr_32594_34221[(2)] = inst_32586);

(statearr_32594_34221[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32593 === (1))){
var inst_32568 = null;
var state_32592__$1 = (function (){var statearr_32597 = state_32592;
(statearr_32597[(7)] = inst_32568);

return statearr_32597;
})();
var statearr_32598_34224 = state_32592__$1;
(statearr_32598_34224[(2)] = null);

(statearr_32598_34224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32593 === (4))){
var inst_32571 = (state_32592[(8)]);
var inst_32571__$1 = (state_32592[(2)]);
var inst_32572 = (inst_32571__$1 == null);
var inst_32573 = cljs.core.not(inst_32572);
var state_32592__$1 = (function (){var statearr_32601 = state_32592;
(statearr_32601[(8)] = inst_32571__$1);

return statearr_32601;
})();
if(inst_32573){
var statearr_32603_34225 = state_32592__$1;
(statearr_32603_34225[(1)] = (5));

} else {
var statearr_32604_34227 = state_32592__$1;
(statearr_32604_34227[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32593 === (6))){
var state_32592__$1 = state_32592;
var statearr_32605_34233 = state_32592__$1;
(statearr_32605_34233[(2)] = null);

(statearr_32605_34233[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32593 === (3))){
var inst_32588 = (state_32592[(2)]);
var inst_32589 = cljs.core.async.close_BANG_(out);
var state_32592__$1 = (function (){var statearr_32606 = state_32592;
(statearr_32606[(9)] = inst_32588);

return statearr_32606;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_32592__$1,inst_32589);
} else {
if((state_val_32593 === (2))){
var state_32592__$1 = state_32592;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32592__$1,(4),ch);
} else {
if((state_val_32593 === (11))){
var inst_32571 = (state_32592[(8)]);
var inst_32580 = (state_32592[(2)]);
var inst_32568 = inst_32571;
var state_32592__$1 = (function (){var statearr_32607 = state_32592;
(statearr_32607[(7)] = inst_32568);

(statearr_32607[(10)] = inst_32580);

return statearr_32607;
})();
var statearr_32608_34239 = state_32592__$1;
(statearr_32608_34239[(2)] = null);

(statearr_32608_34239[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32593 === (9))){
var inst_32571 = (state_32592[(8)]);
var state_32592__$1 = state_32592;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32592__$1,(11),out,inst_32571);
} else {
if((state_val_32593 === (5))){
var inst_32568 = (state_32592[(7)]);
var inst_32571 = (state_32592[(8)]);
var inst_32575 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32571,inst_32568);
var state_32592__$1 = state_32592;
if(inst_32575){
var statearr_32611_34242 = state_32592__$1;
(statearr_32611_34242[(1)] = (8));

} else {
var statearr_32612_34244 = state_32592__$1;
(statearr_32612_34244[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32593 === (10))){
var inst_32583 = (state_32592[(2)]);
var state_32592__$1 = state_32592;
var statearr_32613_34248 = state_32592__$1;
(statearr_32613_34248[(2)] = inst_32583);

(statearr_32613_34248[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32593 === (8))){
var inst_32568 = (state_32592[(7)]);
var tmp32610 = inst_32568;
var inst_32568__$1 = tmp32610;
var state_32592__$1 = (function (){var statearr_32614 = state_32592;
(statearr_32614[(7)] = inst_32568__$1);

return statearr_32614;
})();
var statearr_32615_34254 = state_32592__$1;
(statearr_32615_34254[(2)] = null);

(statearr_32615_34254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_32619 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32619[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_32619[(1)] = (1));

return statearr_32619;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_32592){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_32592);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e32621){var ex__27446__auto__ = e32621;
var statearr_32622_34260 = state_32592;
(statearr_32622_34260[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_32592[(4)]))){
var statearr_32623_34261 = state_32592;
(statearr_32623_34261[(1)] = cljs.core.first((state_32592[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34262 = state_32592;
state_32592 = G__34262;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_32592){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_32592);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_32624 = f__27607__auto__();
(statearr_32624[(6)] = c__27606__auto___34220);

return statearr_32624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__32627 = arguments.length;
switch (G__32627) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27606__auto___34268 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_32692){
var state_val_32693 = (state_32692[(1)]);
if((state_val_32693 === (7))){
var inst_32687 = (state_32692[(2)]);
var state_32692__$1 = state_32692;
var statearr_32695_34269 = state_32692__$1;
(statearr_32695_34269[(2)] = inst_32687);

(statearr_32695_34269[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (1))){
var inst_32644 = (new Array(n));
var inst_32646 = inst_32644;
var inst_32647 = (0);
var state_32692__$1 = (function (){var statearr_32697 = state_32692;
(statearr_32697[(7)] = inst_32647);

(statearr_32697[(8)] = inst_32646);

return statearr_32697;
})();
var statearr_32698_34274 = state_32692__$1;
(statearr_32698_34274[(2)] = null);

(statearr_32698_34274[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (4))){
var inst_32650 = (state_32692[(9)]);
var inst_32650__$1 = (state_32692[(2)]);
var inst_32652 = (inst_32650__$1 == null);
var inst_32653 = cljs.core.not(inst_32652);
var state_32692__$1 = (function (){var statearr_32702 = state_32692;
(statearr_32702[(9)] = inst_32650__$1);

return statearr_32702;
})();
if(inst_32653){
var statearr_32703_34280 = state_32692__$1;
(statearr_32703_34280[(1)] = (5));

} else {
var statearr_32704_34281 = state_32692__$1;
(statearr_32704_34281[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (15))){
var inst_32681 = (state_32692[(2)]);
var state_32692__$1 = state_32692;
var statearr_32705_34285 = state_32692__$1;
(statearr_32705_34285[(2)] = inst_32681);

(statearr_32705_34285[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (13))){
var state_32692__$1 = state_32692;
var statearr_32706_34286 = state_32692__$1;
(statearr_32706_34286[(2)] = null);

(statearr_32706_34286[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (6))){
var inst_32647 = (state_32692[(7)]);
var inst_32677 = (inst_32647 > (0));
var state_32692__$1 = state_32692;
if(cljs.core.truth_(inst_32677)){
var statearr_32709_34287 = state_32692__$1;
(statearr_32709_34287[(1)] = (12));

} else {
var statearr_32710_34290 = state_32692__$1;
(statearr_32710_34290[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (3))){
var inst_32689 = (state_32692[(2)]);
var state_32692__$1 = state_32692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32692__$1,inst_32689);
} else {
if((state_val_32693 === (12))){
var inst_32646 = (state_32692[(8)]);
var inst_32679 = cljs.core.vec(inst_32646);
var state_32692__$1 = state_32692;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32692__$1,(15),out,inst_32679);
} else {
if((state_val_32693 === (2))){
var state_32692__$1 = state_32692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32692__$1,(4),ch);
} else {
if((state_val_32693 === (11))){
var inst_32669 = (state_32692[(2)]);
var inst_32671 = (new Array(n));
var inst_32646 = inst_32671;
var inst_32647 = (0);
var state_32692__$1 = (function (){var statearr_32711 = state_32692;
(statearr_32711[(7)] = inst_32647);

(statearr_32711[(10)] = inst_32669);

(statearr_32711[(8)] = inst_32646);

return statearr_32711;
})();
var statearr_32713_34296 = state_32692__$1;
(statearr_32713_34296[(2)] = null);

(statearr_32713_34296[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (9))){
var inst_32646 = (state_32692[(8)]);
var inst_32667 = cljs.core.vec(inst_32646);
var state_32692__$1 = state_32692;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32692__$1,(11),out,inst_32667);
} else {
if((state_val_32693 === (5))){
var inst_32647 = (state_32692[(7)]);
var inst_32659 = (state_32692[(11)]);
var inst_32650 = (state_32692[(9)]);
var inst_32646 = (state_32692[(8)]);
var inst_32656 = (inst_32646[inst_32647] = inst_32650);
var inst_32659__$1 = (inst_32647 + (1));
var inst_32660 = (inst_32659__$1 < n);
var state_32692__$1 = (function (){var statearr_32722 = state_32692;
(statearr_32722[(11)] = inst_32659__$1);

(statearr_32722[(12)] = inst_32656);

return statearr_32722;
})();
if(cljs.core.truth_(inst_32660)){
var statearr_32723_34300 = state_32692__$1;
(statearr_32723_34300[(1)] = (8));

} else {
var statearr_32724_34302 = state_32692__$1;
(statearr_32724_34302[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (14))){
var inst_32684 = (state_32692[(2)]);
var inst_32685 = cljs.core.async.close_BANG_(out);
var state_32692__$1 = (function (){var statearr_32726 = state_32692;
(statearr_32726[(13)] = inst_32684);

return statearr_32726;
})();
var statearr_32727_34305 = state_32692__$1;
(statearr_32727_34305[(2)] = inst_32685);

(statearr_32727_34305[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (10))){
var inst_32674 = (state_32692[(2)]);
var state_32692__$1 = state_32692;
var statearr_32728_34307 = state_32692__$1;
(statearr_32728_34307[(2)] = inst_32674);

(statearr_32728_34307[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32693 === (8))){
var inst_32659 = (state_32692[(11)]);
var inst_32646 = (state_32692[(8)]);
var tmp32725 = inst_32646;
var inst_32646__$1 = tmp32725;
var inst_32647 = inst_32659;
var state_32692__$1 = (function (){var statearr_32729 = state_32692;
(statearr_32729[(7)] = inst_32647);

(statearr_32729[(8)] = inst_32646__$1);

return statearr_32729;
})();
var statearr_32730_34308 = state_32692__$1;
(statearr_32730_34308[(2)] = null);

(statearr_32730_34308[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_32732 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32732[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_32732[(1)] = (1));

return statearr_32732;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_32692){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_32692);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e32733){var ex__27446__auto__ = e32733;
var statearr_32734_34309 = state_32692;
(statearr_32734_34309[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_32692[(4)]))){
var statearr_32735_34313 = state_32692;
(statearr_32735_34313[(1)] = cljs.core.first((state_32692[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34315 = state_32692;
state_32692 = G__34315;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_32692){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_32692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_32736 = f__27607__auto__();
(statearr_32736[(6)] = c__27606__auto___34268);

return statearr_32736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__32742 = arguments.length;
switch (G__32742) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__27606__auto___34322 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__27607__auto__ = (function (){var switch__27442__auto__ = (function (state_32803){
var state_val_32804 = (state_32803[(1)]);
if((state_val_32804 === (7))){
var inst_32794 = (state_32803[(2)]);
var state_32803__$1 = state_32803;
var statearr_32807_34323 = state_32803__$1;
(statearr_32807_34323[(2)] = inst_32794);

(statearr_32807_34323[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (1))){
var inst_32744 = [];
var inst_32746 = inst_32744;
var inst_32747 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_32803__$1 = (function (){var statearr_32810 = state_32803;
(statearr_32810[(7)] = inst_32746);

(statearr_32810[(8)] = inst_32747);

return statearr_32810;
})();
var statearr_32811_34324 = state_32803__$1;
(statearr_32811_34324[(2)] = null);

(statearr_32811_34324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (4))){
var inst_32750 = (state_32803[(9)]);
var inst_32750__$1 = (state_32803[(2)]);
var inst_32751 = (inst_32750__$1 == null);
var inst_32752 = cljs.core.not(inst_32751);
var state_32803__$1 = (function (){var statearr_32812 = state_32803;
(statearr_32812[(9)] = inst_32750__$1);

return statearr_32812;
})();
if(inst_32752){
var statearr_32813_34326 = state_32803__$1;
(statearr_32813_34326[(1)] = (5));

} else {
var statearr_32814_34327 = state_32803__$1;
(statearr_32814_34327[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (15))){
var inst_32746 = (state_32803[(7)]);
var inst_32786 = cljs.core.vec(inst_32746);
var state_32803__$1 = state_32803;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32803__$1,(18),out,inst_32786);
} else {
if((state_val_32804 === (13))){
var inst_32781 = (state_32803[(2)]);
var state_32803__$1 = state_32803;
var statearr_32818_34328 = state_32803__$1;
(statearr_32818_34328[(2)] = inst_32781);

(statearr_32818_34328[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (6))){
var inst_32746 = (state_32803[(7)]);
var inst_32783 = inst_32746.length;
var inst_32784 = (inst_32783 > (0));
var state_32803__$1 = state_32803;
if(cljs.core.truth_(inst_32784)){
var statearr_32819_34335 = state_32803__$1;
(statearr_32819_34335[(1)] = (15));

} else {
var statearr_32821_34337 = state_32803__$1;
(statearr_32821_34337[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (17))){
var inst_32791 = (state_32803[(2)]);
var inst_32792 = cljs.core.async.close_BANG_(out);
var state_32803__$1 = (function (){var statearr_32825 = state_32803;
(statearr_32825[(10)] = inst_32791);

return statearr_32825;
})();
var statearr_32826_34338 = state_32803__$1;
(statearr_32826_34338[(2)] = inst_32792);

(statearr_32826_34338[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (3))){
var inst_32796 = (state_32803[(2)]);
var state_32803__$1 = state_32803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32803__$1,inst_32796);
} else {
if((state_val_32804 === (12))){
var inst_32746 = (state_32803[(7)]);
var inst_32770 = cljs.core.vec(inst_32746);
var state_32803__$1 = state_32803;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_32803__$1,(14),out,inst_32770);
} else {
if((state_val_32804 === (2))){
var state_32803__$1 = state_32803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32803__$1,(4),ch);
} else {
if((state_val_32804 === (11))){
var inst_32750 = (state_32803[(9)]);
var inst_32754 = (state_32803[(11)]);
var inst_32746 = (state_32803[(7)]);
var inst_32767 = inst_32746.push(inst_32750);
var tmp32829 = inst_32746;
var inst_32746__$1 = tmp32829;
var inst_32747 = inst_32754;
var state_32803__$1 = (function (){var statearr_32834 = state_32803;
(statearr_32834[(12)] = inst_32767);

(statearr_32834[(7)] = inst_32746__$1);

(statearr_32834[(8)] = inst_32747);

return statearr_32834;
})();
var statearr_32835_34343 = state_32803__$1;
(statearr_32835_34343[(2)] = null);

(statearr_32835_34343[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (9))){
var inst_32747 = (state_32803[(8)]);
var inst_32762 = cljs.core.keyword_identical_QMARK_(inst_32747,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_32803__$1 = state_32803;
var statearr_32837_34344 = state_32803__$1;
(statearr_32837_34344[(2)] = inst_32762);

(statearr_32837_34344[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (5))){
var inst_32755 = (state_32803[(13)]);
var inst_32750 = (state_32803[(9)]);
var inst_32754 = (state_32803[(11)]);
var inst_32747 = (state_32803[(8)]);
var inst_32754__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_32750) : f.call(null,inst_32750));
var inst_32755__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_32754__$1,inst_32747);
var state_32803__$1 = (function (){var statearr_32847 = state_32803;
(statearr_32847[(13)] = inst_32755__$1);

(statearr_32847[(11)] = inst_32754__$1);

return statearr_32847;
})();
if(inst_32755__$1){
var statearr_32851_34346 = state_32803__$1;
(statearr_32851_34346[(1)] = (8));

} else {
var statearr_32853_34348 = state_32803__$1;
(statearr_32853_34348[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (14))){
var inst_32750 = (state_32803[(9)]);
var inst_32754 = (state_32803[(11)]);
var inst_32772 = (state_32803[(2)]);
var inst_32777 = [];
var inst_32778 = inst_32777.push(inst_32750);
var inst_32746 = inst_32777;
var inst_32747 = inst_32754;
var state_32803__$1 = (function (){var statearr_32870 = state_32803;
(statearr_32870[(14)] = inst_32778);

(statearr_32870[(7)] = inst_32746);

(statearr_32870[(8)] = inst_32747);

(statearr_32870[(15)] = inst_32772);

return statearr_32870;
})();
var statearr_32877_34349 = state_32803__$1;
(statearr_32877_34349[(2)] = null);

(statearr_32877_34349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (16))){
var state_32803__$1 = state_32803;
var statearr_32888_34350 = state_32803__$1;
(statearr_32888_34350[(2)] = null);

(statearr_32888_34350[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (10))){
var inst_32765 = (state_32803[(2)]);
var state_32803__$1 = state_32803;
if(cljs.core.truth_(inst_32765)){
var statearr_32891_34351 = state_32803__$1;
(statearr_32891_34351[(1)] = (11));

} else {
var statearr_32893_34352 = state_32803__$1;
(statearr_32893_34352[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (18))){
var inst_32788 = (state_32803[(2)]);
var state_32803__$1 = state_32803;
var statearr_32896_34356 = state_32803__$1;
(statearr_32896_34356[(2)] = inst_32788);

(statearr_32896_34356[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32804 === (8))){
var inst_32755 = (state_32803[(13)]);
var state_32803__$1 = state_32803;
var statearr_32900_34357 = state_32803__$1;
(statearr_32900_34357[(2)] = inst_32755);

(statearr_32900_34357[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__27443__auto__ = null;
var cljs$core$async$state_machine__27443__auto____0 = (function (){
var statearr_32910 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32910[(0)] = cljs$core$async$state_machine__27443__auto__);

(statearr_32910[(1)] = (1));

return statearr_32910;
});
var cljs$core$async$state_machine__27443__auto____1 = (function (state_32803){
while(true){
var ret_value__27444__auto__ = (function (){try{while(true){
var result__27445__auto__ = switch__27442__auto__(state_32803);
if(cljs.core.keyword_identical_QMARK_(result__27445__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__27445__auto__;
}
break;
}
}catch (e32912){var ex__27446__auto__ = e32912;
var statearr_32913_34359 = state_32803;
(statearr_32913_34359[(2)] = ex__27446__auto__);


if(cljs.core.seq((state_32803[(4)]))){
var statearr_32917_34360 = state_32803;
(statearr_32917_34360[(1)] = cljs.core.first((state_32803[(4)])));

} else {
throw ex__27446__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__27444__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34361 = state_32803;
state_32803 = G__34361;
continue;
} else {
return ret_value__27444__auto__;
}
break;
}
});
cljs$core$async$state_machine__27443__auto__ = function(state_32803){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__27443__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__27443__auto____1.call(this,state_32803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__27443__auto____0;
cljs$core$async$state_machine__27443__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__27443__auto____1;
return cljs$core$async$state_machine__27443__auto__;
})()
})();
var state__27608__auto__ = (function (){var statearr_32919 = f__27607__auto__();
(statearr_32919[(6)] = c__27606__auto___34322);

return statearr_32919;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__27608__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
