/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.inventory;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class EquipmentSlotGroup
implements Predicate<EquipmentSlot> {
    private static final Map<String, EquipmentSlotGroup> BY_NAME = new HashMap<String, EquipmentSlotGroup>();
    public static final EquipmentSlotGroup ANY = EquipmentSlotGroup.get("any", test -> true, EquipmentSlot.HAND);
    public static final EquipmentSlotGroup MAINHAND = EquipmentSlotGroup.get("mainhand", EquipmentSlot.HAND);
    public static final EquipmentSlotGroup OFFHAND = EquipmentSlotGroup.get("offhand", EquipmentSlot.OFF_HAND);
    public static final EquipmentSlotGroup HAND = EquipmentSlotGroup.get("hand", test -> test == EquipmentSlot.HAND || test == EquipmentSlot.OFF_HAND, EquipmentSlot.HAND);
    public static final EquipmentSlotGroup FEET = EquipmentSlotGroup.get("feet", EquipmentSlot.FEET);
    public static final EquipmentSlotGroup LEGS = EquipmentSlotGroup.get("legs", EquipmentSlot.LEGS);
    public static final EquipmentSlotGroup CHEST = EquipmentSlotGroup.get("chest", EquipmentSlot.CHEST);
    public static final EquipmentSlotGroup HEAD = EquipmentSlotGroup.get("head", EquipmentSlot.HEAD);
    public static final EquipmentSlotGroup ARMOR = EquipmentSlotGroup.get("armor", test -> test == EquipmentSlot.FEET || test == EquipmentSlot.LEGS || test == EquipmentSlot.CHEST || test == EquipmentSlot.HEAD, EquipmentSlot.CHEST);
    public static final EquipmentSlotGroup BODY = EquipmentSlotGroup.get("body", EquipmentSlot.BODY);
    private final String key;
    private final Predicate<EquipmentSlot> predicate;
    private final EquipmentSlot example;

    private EquipmentSlotGroup(@NotNull String key, @NotNull Predicate<EquipmentSlot> predicate, @NotNull EquipmentSlot example) {
        this.key = key;
        this.predicate = predicate;
        this.example = example;
        BY_NAME.put(key, this);
    }

    @Override
    public boolean test(@NotNull EquipmentSlot test) {
        return this.predicate.test(test);
    }

    public String toString() {
        return this.key;
    }

    @Deprecated
    @NotNull
    @ApiStatus.Internal
    public EquipmentSlot getExample() {
        return this.example;
    }

    @Nullable
    @ApiStatus.Internal
    public static EquipmentSlotGroup getByName(@NotNull String name) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Name cannot be null");
        return BY_NAME.get(name.toLowerCase(Locale.ENGLISH));
    }

    private static EquipmentSlotGroup get(@NotNull String key, @NotNull EquipmentSlot slot) {
        return EquipmentSlotGroup.get(key, test -> test == slot, slot);
    }

    private static EquipmentSlotGroup get(@NotNull String key, @NotNull Predicate<EquipmentSlot> predicate, @NotNull EquipmentSlot example) {
        return new EquipmentSlotGroup(key, predicate, example);
    }
}

