/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import org.bukkit.Location;
import org.bukkit.PortalType;
import org.bukkit.entity.Entity;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityPortalEvent
extends EntityTeleportEvent {
    private static final HandlerList handlers = new HandlerList();
    private int searchRadius = 128;
    private final PortalType type;

    public EntityPortalEvent(@NotNull Entity entity, @NotNull Location from, @Nullable Location to) {
        this(entity, from, to, 128);
    }

    public EntityPortalEvent(@NotNull Entity entity, @NotNull Location from, @Nullable Location to, int searchRadius) {
        super(entity, from, to);
        this.searchRadius = searchRadius;
        this.type = PortalType.CUSTOM;
    }

    public EntityPortalEvent(@NotNull Entity entity, @NotNull Location from, @Nullable Location to, int searchRadius, @NotNull PortalType portalType) {
        super(entity, from, to);
        this.searchRadius = searchRadius;
        this.type = portalType;
    }

    @NotNull
    public PortalType getPortalType() {
        return this.type;
    }

    @Override
    @Nullable
    public Location getTo() {
        return super.getTo();
    }

    @Override
    public void setTo(@Nullable Location to) {
        super.setTo(to);
    }

    public void setSearchRadius(int searchRadius) {
        this.searchRadius = searchRadius;
    }

    public int getSearchRadius() {
        return this.searchRadius;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}

