/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import java.util.Locale;
import java.util.UUID;
import net.kyori.adventure.key.Key;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NamespacedKey
implements Key {
    public static final String MINECRAFT = "minecraft";
    public static final String BUKKIT = "bukkit";
    private final String namespace;
    private final String key;

    private static boolean isValidNamespaceChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-';
    }

    private static boolean isValidKeyChar(char c) {
        return NamespacedKey.isValidNamespaceChar(c) || c == '/';
    }

    private static boolean isValidNamespace(String namespace) {
        int len = namespace.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (NamespacedKey.isValidNamespaceChar(namespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidKey(String key) {
        int len = key.length();
        if (len == 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (NamespacedKey.isValidKeyChar(key.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public NamespacedKey(@NotNull String namespace, @NotNull String key) {
        Preconditions.checkArgument((namespace != null && NamespacedKey.isValidNamespace(namespace) ? 1 : 0) != 0, (String)"Invalid namespace. Must be [a-z0-9._-]: %s", (Object)namespace);
        Preconditions.checkArgument((key != null && NamespacedKey.isValidKey(key) ? 1 : 0) != 0, (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)key);
        this.namespace = namespace;
        this.key = key;
        String string = this.toString();
        Preconditions.checkArgument((string.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"NamespacedKey must be less than 32768 characters", (Object)string);
    }

    public NamespacedKey(@NotNull Plugin plugin, @NotNull String key) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"Plugin cannot be null");
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Key cannot be null");
        this.namespace = plugin.getName().toLowerCase(Locale.ROOT);
        this.key = key.toLowerCase(Locale.ROOT);
        Preconditions.checkArgument((boolean)NamespacedKey.isValidNamespace(this.namespace), (String)"Invalid namespace. Must be [a-z0-9._-]: %s", (Object)this.namespace);
        Preconditions.checkArgument((boolean)NamespacedKey.isValidKey(this.key), (String)"Invalid key. Must be [a-z0-9/._-]: %s", (Object)this.key);
        String string = this.toString();
        Preconditions.checkArgument((string.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)"NamespacedKey must be less than 32768 characters", (Object)string);
    }

    @NotNull
    public String getNamespace() {
        return this.namespace;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.key.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        Key key = (Key)obj;
        return this.namespace.equals(key.namespace()) && this.key.equals(key.value());
    }

    public String toString() {
        return this.namespace + ":" + this.key;
    }

    @Deprecated
    @ApiStatus.Internal
    @NotNull
    public static NamespacedKey randomKey() {
        return new NamespacedKey(BUKKIT, UUID.randomUUID().toString());
    }

    @NotNull
    public static NamespacedKey minecraft(@NotNull String key) {
        return new NamespacedKey(MINECRAFT, key);
    }

    @Nullable
    public static NamespacedKey fromString(@NotNull String string, @Nullable Plugin defaultNamespace) {
        String key;
        Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"Input string must not be null");
        if (string.isEmpty() || string.length() > Short.MAX_VALUE) {
            return null;
        }
        String[] components = string.split(":", 3);
        if (components.length > 2) {
            return null;
        }
        String string2 = key = components.length == 2 ? components[1] : "";
        if (components.length == 1) {
            String value = components[0];
            if (value.isEmpty() || !NamespacedKey.isValidKey(value)) {
                return null;
            }
            return defaultNamespace != null ? new NamespacedKey(defaultNamespace, value) : NamespacedKey.minecraft(value);
        }
        if (components.length == 2 && !NamespacedKey.isValidKey(key)) {
            return null;
        }
        String namespace = components[0];
        if (namespace.isEmpty()) {
            return defaultNamespace != null ? new NamespacedKey(defaultNamespace, key) : NamespacedKey.minecraft(key);
        }
        if (!NamespacedKey.isValidNamespace(namespace)) {
            return null;
        }
        return new NamespacedKey(namespace, key);
    }

    @Nullable
    public static NamespacedKey fromString(@NotNull String key) {
        return NamespacedKey.fromString(key, null);
    }

    @NotNull
    public String namespace() {
        return this.getNamespace();
    }

    @NotNull
    public String value() {
        return this.getKey();
    }

    @NotNull
    public String asString() {
        return this.namespace + ":" + this.key;
    }
}

