/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.server;

import com.destroystokyo.paper.network.StatusClient;
import com.destroystokyo.paper.profile.PlayerProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PaperServerListPingEvent
extends ServerListPingEvent
implements Cancellable {
    @NotNull
    private final StatusClient client;
    private int numPlayers;
    private boolean hidePlayers;
    @NotNull
    private final List<PlayerProfile> playerSample = new ArrayList<PlayerProfile>();
    @NotNull
    private String version;
    private int protocolVersion;
    @Nullable
    private CachedServerIcon favicon;
    private boolean cancelled;
    private boolean originalPlayerCount = true;
    private Object[] players;

    @Deprecated
    @ApiStatus.Internal
    public PaperServerListPingEvent(@NotNull StatusClient client, @NotNull String motd, int numPlayers, int maxPlayers, @NotNull String version, int protocolVersion, @Nullable CachedServerIcon favicon) {
        super("", client.getAddress().getAddress(), motd, numPlayers, maxPlayers);
        this.client = client;
        this.numPlayers = numPlayers;
        this.version = version;
        this.protocolVersion = protocolVersion;
        this.setServerIcon(favicon);
    }

    @ApiStatus.Internal
    public PaperServerListPingEvent(@NotNull StatusClient client, @NotNull Component motd, int numPlayers, int maxPlayers, @NotNull String version, int protocolVersion, @Nullable CachedServerIcon favicon) {
        super("", client.getAddress().getAddress(), motd, numPlayers, maxPlayers);
        this.client = client;
        this.numPlayers = numPlayers;
        this.version = version;
        this.protocolVersion = protocolVersion;
        this.setServerIcon(favicon);
    }

    @NotNull
    public StatusClient getClient() {
        return this.client;
    }

    @Override
    public int getNumPlayers() {
        if (this.hidePlayers) {
            return -1;
        }
        return this.numPlayers;
    }

    public void setNumPlayers(int numPlayers) {
        if (this.numPlayers != numPlayers) {
            this.numPlayers = numPlayers;
            this.originalPlayerCount = false;
        }
    }

    @Override
    public int getMaxPlayers() {
        if (this.hidePlayers) {
            return -1;
        }
        return super.getMaxPlayers();
    }

    public boolean shouldHidePlayers() {
        return this.hidePlayers;
    }

    public void setHidePlayers(boolean hidePlayers) {
        this.hidePlayers = hidePlayers;
    }

    @NotNull
    public List<PlayerProfile> getPlayerSample() {
        return this.playerSample;
    }

    @NotNull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@NotNull String version) {
        this.version = Objects.requireNonNull(version, "version");
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Nullable
    public CachedServerIcon getServerIcon() {
        return this.favicon;
    }

    @Override
    public void setServerIcon(@Nullable CachedServerIcon icon) {
        if (icon != null && icon.isEmpty()) {
            icon = null;
        }
        this.favicon = icon;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public Iterator<Player> iterator() {
        if (this.players == null) {
            this.players = this.getOnlinePlayers();
        }
        return new PlayerIterator();
    }

    @NotNull
    protected Object[] getOnlinePlayers() {
        return Bukkit.getOnlinePlayers().toArray();
    }

    @NotNull
    protected Player getBukkitPlayer(@NotNull Object player) {
        return (Player)player;
    }

    @ApiStatus.Internal
    private final class PlayerIterator
    implements Iterator<Player> {
        private int next;
        private int current;
        @Nullable
        private Player player;

        private PlayerIterator() {
        }

        @Override
        public boolean hasNext() {
            while (this.next < PaperServerListPingEvent.this.players.length) {
                if (PaperServerListPingEvent.this.players[this.next] != null) {
                    return true;
                }
                ++this.next;
            }
            return false;
        }

        @Override
        @NotNull
        public Player next() {
            if (!this.hasNext()) {
                this.player = null;
                throw new NoSuchElementException();
            }
            this.current = this.next++;
            this.player = PaperServerListPingEvent.this.getBukkitPlayer(PaperServerListPingEvent.this.players[this.current]);
            return this.player;
        }

        @Override
        public void remove() {
            if (this.player == null) {
                throw new IllegalStateException();
            }
            UUID uniqueId = this.player.getUniqueId();
            this.player = null;
            PaperServerListPingEvent.this.players[this.current] = null;
            PaperServerListPingEvent.this.getPlayerSample().removeIf(p -> uniqueId.equals(p.getId()));
            if (PaperServerListPingEvent.this.originalPlayerCount) {
                --PaperServerListPingEvent.this.numPlayers;
            }
        }
    }
}

