/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paper.event.player;

import java.util.Set;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerArmorChangeEvent
extends PlayerEvent {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    @NotNull
    private final SlotType slotType;
    @NotNull
    private final ItemStack oldItem;
    @NotNull
    private final ItemStack newItem;

    @ApiStatus.Internal
    public PlayerArmorChangeEvent(@NotNull Player player, @NotNull SlotType slotType, @NotNull ItemStack oldItem, @NotNull ItemStack newItem) {
        super(player);
        this.slotType = slotType;
        this.oldItem = oldItem;
        this.newItem = newItem;
    }

    @NotNull
    public SlotType getSlotType() {
        return this.slotType;
    }

    @NotNull
    public ItemStack getOldItem() {
        return this.oldItem;
    }

    @NotNull
    public ItemStack getNewItem() {
        return this.newItem;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    public static enum SlotType {
        HEAD(Material.NETHERITE_HELMET, Material.DIAMOND_HELMET, Material.GOLDEN_HELMET, Material.IRON_HELMET, Material.CHAINMAIL_HELMET, Material.LEATHER_HELMET, Material.CARVED_PUMPKIN, Material.PLAYER_HEAD, Material.SKELETON_SKULL, Material.ZOMBIE_HEAD, Material.CREEPER_HEAD, Material.WITHER_SKELETON_SKULL, Material.TURTLE_HELMET, Material.DRAGON_HEAD, Material.PIGLIN_HEAD),
        CHEST(Material.NETHERITE_CHESTPLATE, Material.DIAMOND_CHESTPLATE, Material.GOLDEN_CHESTPLATE, Material.IRON_CHESTPLATE, Material.CHAINMAIL_CHESTPLATE, Material.LEATHER_CHESTPLATE, Material.ELYTRA),
        LEGS(Material.NETHERITE_LEGGINGS, Material.DIAMOND_LEGGINGS, Material.GOLDEN_LEGGINGS, Material.IRON_LEGGINGS, Material.CHAINMAIL_LEGGINGS, Material.LEATHER_LEGGINGS),
        FEET(Material.NETHERITE_BOOTS, Material.DIAMOND_BOOTS, Material.GOLDEN_BOOTS, Material.IRON_BOOTS, Material.CHAINMAIL_BOOTS, Material.LEATHER_BOOTS);

        private final Set<Material> types;

        private SlotType(Material ... types) {
            this.types = Set.of(types);
        }

        @NotNull
        public Set<Material> getTypes() {
            return this.types;
        }

        @Nullable
        public static SlotType getByMaterial(@NotNull Material material) {
            for (SlotType slotType : SlotType.values()) {
                if (!slotType.getTypes().contains(material)) continue;
                return slotType;
            }
            return null;
        }

        public static boolean isEquipable(@NotNull Material material) {
            return SlotType.getByMaterial(material) != null;
        }
    }
}

