/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.regionized.paper;

import com.github.puregero.multilib.regionized.EntityScheduler;
import com.github.puregero.multilib.regionized.RegionizedLib;
import com.github.puregero.multilib.regionized.RegionizedScheduler;
import com.github.puregero.multilib.regionized.paper.PaperEntitySchedulerImpl;
import com.github.puregero.multilib.regionized.paper.PaperRegionizedSchedulerImpl;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class PaperRegionizedLibImpl
implements RegionizedLib {
    private final PaperRegionizedSchedulerImpl regionScheduler = new PaperRegionizedSchedulerImpl(Bukkit.getRegionScheduler());

    public PaperRegionizedLibImpl() {
        try {
            Entity.class.getMethod("getScheduler", new Class[0]);
            Server.class.getMethod("getRegionScheduler", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Not a Folia-compatible Paper environment", e);
        }
    }

    public RegionizedScheduler getRegionScheduler() {
        return this.regionScheduler;
    }

    public EntityScheduler getEntityScheduler(Entity entity) {
        return new PaperEntitySchedulerImpl(entity.getScheduler());
    }

    public boolean isOwnedByCurrentRegion(World world, int chunkX, int chunkZ) {
        return Bukkit.isOwnedByCurrentRegion((World)world, (int)chunkX, (int)chunkZ);
    }

    public boolean isOwnedByCurrentRegion(Location location) {
        return Bukkit.isOwnedByCurrentRegion((Location)location);
    }

    public boolean isOwnedByCurrentRegion(Entity entity) {
        return Bukkit.isOwnedByCurrentRegion((Entity)entity);
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z, boolean gen, boolean urgent) {
        return world.getChunkAtAsync(x, z, gen, urgent);
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z, boolean gen) {
        return world.getChunkAtAsync(x, z, gen);
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z) {
        return world.getChunkAtAsync(x, z);
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(Location location) {
        return location.getWorld().getChunkAtAsync(location);
    }

    @NotNull
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause cause) {
        return entity.teleportAsync(location, cause);
    }
}

