/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.regionized.bukkit;

import com.github.puregero.multilib.regionized.EntityScheduler;
import com.github.puregero.multilib.regionized.RegionizedLib;
import com.github.puregero.multilib.regionized.RegionizedScheduler;
import com.github.puregero.multilib.regionized.bukkit.BukkitEntitySchedulerImpl;
import com.github.puregero.multilib.regionized.bukkit.BukkitRegionizedSchedulerImpl;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;

public class BukkitRegionizedLibImpl
implements RegionizedLib {
    private final BukkitRegionizedSchedulerImpl regionScheduler = new BukkitRegionizedSchedulerImpl();

    public RegionizedScheduler getRegionScheduler() {
        return this.regionScheduler;
    }

    public EntityScheduler getEntityScheduler(Entity entity) {
        return new BukkitEntitySchedulerImpl(entity);
    }

    public boolean isOwnedByCurrentRegion(World world, int chunkX, int chunkZ) {
        return Bukkit.isPrimaryThread();
    }

    @NotNull
    public CompletableFuture<Chunk> getChunkAtAsync(World world, int x, int z, boolean gen, boolean urgent) {
        return CompletableFuture.completedFuture(world.getChunkAt(x, z));
    }

    @NotNull
    public CompletableFuture<Boolean> teleportAsync(Entity entity, Location location, PlayerTeleportEvent.TeleportCause cause) {
        return CompletableFuture.completedFuture(entity.teleport(location, cause));
    }
}

