/*
 * Decompiled with CFR 0.152.
 */
package com.github.puregero.multilib.regionized.bukkit;

import com.github.puregero.multilib.regionized.RegionizedTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public class BukkitRegionizedTaskWrapper
implements RegionizedTask,
Runnable {
    private final Plugin plugin;
    private final Consumer<RegionizedTask> task;
    private final long initialDelayTicks;
    private final long periodTicks;
    private BukkitTask bukkitTask;
    private AtomicReference<RegionizedTask.ExecutionState> executionState = new AtomicReference<RegionizedTask.ExecutionState>(RegionizedTask.ExecutionState.IDLE);

    public BukkitRegionizedTaskWrapper(Plugin plugin, Consumer<RegionizedTask> task) {
        this(plugin, task, 0L);
    }

    public BukkitRegionizedTaskWrapper(Plugin plugin, Consumer<RegionizedTask> task, long delayTicks) {
        this(plugin, task, delayTicks, -1L);
    }

    public BukkitRegionizedTaskWrapper(Plugin plugin, Consumer<RegionizedTask> task, long initialDelayTicks, long periodTicks) {
        this.plugin = plugin;
        this.task = task;
        this.initialDelayTicks = initialDelayTicks;
        this.periodTicks = periodTicks;
    }

    @Override
    public void run() {
        if (!this.executionState.compareAndSet(RegionizedTask.ExecutionState.IDLE, RegionizedTask.ExecutionState.RUNNING)) {
            return;
        }
        try {
            this.task.accept(this);
        }
        finally {
            if (this.isRepeatingTask()) {
                this.executionState.compareAndSet(RegionizedTask.ExecutionState.RUNNING, RegionizedTask.ExecutionState.IDLE);
            } else {
                this.executionState.compareAndSet(RegionizedTask.ExecutionState.RUNNING, RegionizedTask.ExecutionState.FINISHED);
            }
            this.executionState.compareAndSet(RegionizedTask.ExecutionState.CANCELLED_RUNNING, RegionizedTask.ExecutionState.CANCELLED);
        }
    }

    public BukkitRegionizedTaskWrapper schedule() {
        this.bukkitTask = this.isRepeatingTask() ? this.plugin.getServer().getScheduler().runTaskTimer(this.plugin, (Runnable)this, this.initialDelayTicks, this.periodTicks) : this.plugin.getServer().getScheduler().runTaskLater(this.plugin, (Runnable)this, this.initialDelayTicks);
        return this;
    }

    @NotNull
    public Plugin getOwningPlugin() {
        return this.plugin;
    }

    public boolean isRepeatingTask() {
        return this.periodTicks > 0L;
    }

    @NotNull
    public RegionizedTask.CancelledState cancel() {
        if (this.executionState.compareAndSet(RegionizedTask.ExecutionState.IDLE, RegionizedTask.ExecutionState.CANCELLED)) {
            this.bukkitTask.cancel();
            return RegionizedTask.CancelledState.CANCELLED_BY_CALLER;
        }
        if (this.executionState.compareAndSet(RegionizedTask.ExecutionState.RUNNING, RegionizedTask.ExecutionState.CANCELLED_RUNNING)) {
            this.bukkitTask.cancel();
            if (this.isRepeatingTask()) {
                return RegionizedTask.CancelledState.NEXT_RUNS_CANCELLED;
            }
            return RegionizedTask.CancelledState.RUNNING;
        }
        return switch (this.executionState.get()) {
            default -> throw new IncompatibleClassChangeError();
            case RegionizedTask.ExecutionState.IDLE, RegionizedTask.ExecutionState.RUNNING -> {
                this.bukkitTask.cancel();
                this.executionState.set(RegionizedTask.ExecutionState.CANCELLED);
                yield RegionizedTask.CancelledState.CANCELLED_BY_CALLER;
            }
            case RegionizedTask.ExecutionState.CANCELLED -> RegionizedTask.CancelledState.CANCELLED_ALREADY;
            case RegionizedTask.ExecutionState.CANCELLED_RUNNING -> RegionizedTask.CancelledState.NEXT_RUNS_CANCELLED_ALREADY;
            case RegionizedTask.ExecutionState.FINISHED -> RegionizedTask.CancelledState.ALREADY_EXECUTED;
        };
    }

    @NotNull
    public RegionizedTask.ExecutionState getExecutionState() {
        return this.getExecutionState();
    }

    public boolean isCancelled() {
        return this.bukkitTask.isCancelled();
    }
}

