/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.UnsafeValues;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.jetbrains.annotations.NotNull;

public class PluginsCommand
extends BukkitCommand {
    public PluginsCommand(@NotNull String name) {
        super(name);
        this.description = "Gets a list of plugins running on the server";
        this.usageMessage = "/plugins";
        this.setPermission("bukkit.command.plugins");
        this.setAliases(Arrays.asList("pl"));
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (sender instanceof Player && sender.hasPermission("bukkit.command.version")) {
            sender.sendMessage((Component)this.getPluginListSpigot());
        } else {
            sender.sendMessage("Plugins " + this.getPluginList());
        }
        return true;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) throws IllegalArgumentException {
        return Collections.emptyList();
    }

    @NotNull
    private String getPluginList() {
        TreeMap<String, Plugin> plugins = new TreeMap<String, Plugin>(String.CASE_INSENSITIVE_ORDER);
        for (Plugin plugin : Bukkit.getPluginManager().getPlugins()) {
            plugins.put(plugin.getDescription().getName(), plugin);
        }
        StringBuilder pluginList = new StringBuilder();
        for (Map.Entry entry : plugins.entrySet()) {
            Plugin plugin;
            if (pluginList.length() > 0) {
                pluginList.append((Object)ChatColor.WHITE);
                pluginList.append(", ");
            }
            pluginList.append((Object)((plugin = (Plugin)entry.getValue()).isEnabled() ? ChatColor.GREEN : ChatColor.RED));
            Object pluginName = plugin.getDescription().getName();
            if (UnsafeValues.isLegacyPlugin(plugin)) {
                pluginName = (String)pluginName + "*";
            }
            pluginList.append((String)pluginName);
            if (plugin.getDescription().getProvides().size() <= 0) continue;
            pluginList.append(" (").append(String.join((CharSequence)", ", plugin.getDescription().getProvides())).append(")");
        }
        return "(" + plugins.size() + "): " + pluginList.toString();
    }

    @NotNull
    private TextComponent getPluginListSpigot() {
        Plugin[] plugins = (Plugin[])Arrays.stream(Bukkit.getPluginManager().getPlugins()).sorted(Comparator.comparing(plugin -> plugin.getName().toLowerCase())).toArray(Plugin[]::new);
        TextComponent.Builder builder = Component.text();
        builder.append((Component)Component.text((String)("Plugins (" + plugins.length + "): ")));
        int index = 0;
        for (Plugin plugin2 : plugins) {
            if (index++ > 0) {
                builder.append((Component)Component.text((String)", ", (TextColor)NamedTextColor.WHITE));
            }
            PluginDescriptionFile description = plugin2.getDescription();
            TextComponent.Builder hover = Component.text();
            ((TextComponent.Builder)hover.append((Component)Component.text((String)"Version: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)description.getVersion(), (TextColor)NamedTextColor.GREEN));
            if (description.getDescription() != null) {
                ((TextComponent.Builder)((TextComponent.Builder)hover.append((Component)Component.newline())).append((Component)Component.text((String)"Description: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)description.getDescription(), (TextColor)NamedTextColor.GREEN));
            }
            if (description.getWebsite() != null) {
                ((TextComponent.Builder)((TextComponent.Builder)hover.append((Component)Component.newline())).append((Component)Component.text((String)"Website: ", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)description.getWebsite(), (TextColor)NamedTextColor.GREEN));
            }
            if (!description.getAuthors().isEmpty()) {
                hover.append((Component)Component.newline());
                if (description.getAuthors().size() == 1) {
                    hover.append((Component)Component.text((String)"Author: "));
                } else {
                    hover.append((Component)Component.text((String)"Authors: "));
                }
                hover.append((Component)this.getAuthors(description));
            }
            builder.append(((TextComponent)Component.text((String)plugin2.getDescription().getName(), (TextColor)(plugin2.isEnabled() ? NamedTextColor.GREEN : NamedTextColor.RED)).hoverEvent((HoverEventSource)hover.build())).clickEvent(ClickEvent.suggestCommand((String)("/version " + description.getName()))));
            if (plugin2.getDescription().getProvides().size() <= 0) continue;
            ((TextComponent.Builder)((TextComponent.Builder)builder.append((Component)Component.text((String)" (", (TextColor)NamedTextColor.WHITE))).append((Component)Component.text((String)String.join((CharSequence)", ", plugin2.getDescription().getProvides())))).append((Component)Component.text((String)")"));
        }
        return (TextComponent)builder.build();
    }

    @NotNull
    private TextComponent getAuthors(@NotNull PluginDescriptionFile description) {
        TextComponent.Builder builder = Component.text();
        List<String> authors = description.getAuthors();
        for (int i = 0; i < authors.size(); ++i) {
            if (i > 0) {
                builder.append((Component)Component.text((String)(i < authors.size() - 1 ? ", " : " and "), (TextColor)NamedTextColor.WHITE));
            }
            builder.append((Component)Component.text((String)authors.get(i), (TextColor)NamedTextColor.GREEN));
        }
        return (TextComponent)builder.build();
    }
}

