package org.purpurmc.purpur.language;

import net.kyori.adventure.translation.Translatable;
import org.jetbrains.annotations.NotNull;

/**
 * Represents a language that can translate translation keys
 */
public abstract class Language {
    private static Language language;

    /**
     * Returns the default language of the server
     */
    @NotNull
    public static Language getLanguage() {
        return language;
    }

    public static void setLanguage(@NotNull Language language) {
        if (Language.language != null) {
            throw new UnsupportedOperationException("Cannot redefine singleton Language");
        }
        Language.language = language;
    }

    /**
     * Checks if a certain translation key is translatable with this language
     * @param key The translation key
     * @return Whether this language can translate the key
     */
    abstract public boolean has(@NotNull String key);

    /**
     * Checks if a certain translation key is translatable with this language
     * @param key The translation key
     * @return Whether this language can translate the key
     */
    public boolean has(@NotNull Translatable key) {
        return has(key.translationKey());
    }

    /**
     * Translates a translation key to this language
     * @param key The translation key
     * @return The translated key, or the translation key if it couldn't be translated
     */
    @NotNull
    abstract public String getOrDefault(@NotNull String key);

    /**
     * Translates a translation key to this language
     * @param key The translation key
     * @return The translated key, or the translation key if it couldn't be translated
     */
    @NotNull
    public String getOrDefault(@NotNull Translatable key) {
        return getOrDefault(key.translationKey());
    }
}
