package org.purpurmc.purpur.event.entity;

import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/**
 * Called when a bee stops pollinating
 */
public class BeeStopPollinatingEvent extends EntityEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Location location;
    private final boolean success;

    public BeeStopPollinatingEvent(@NotNull Bee bee, @Nullable Location location, boolean success) {
        super(bee);
        this.location = location;
        this.success = success;
    }

    @Override
    @NotNull
    public Bee getEntity() {
        return (Bee) super.getEntity();
    }

    /**
     * Returns the location of the flower that the bee stopped pollinating
     *
     * @return The location of the flower
     */
    @Nullable
    public Location getLocation() {
        return location;
    }

    /**
     * Returns whether the bee successfully pollinated the flower
     *
     * @return True if the pollination was successful
     */
    public boolean wasSuccessful() {
        return success;
    }


    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}
