package org.purpurmc.purpur.event.entity;

import org.bukkit.Location;
import org.bukkit.entity.Bee;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.NotNull;

/**
 * Called when a bee starts pollinating
 */
public class BeeStartedPollinatingEvent extends EntityEvent {
    private static final HandlerList handlers = new HandlerList();
    private final Location location;

    public BeeStartedPollinatingEvent(@NotNull Bee bee, @NotNull Location location) {
        super(bee);
        this.location = location;
    }

    @Override
    @NotNull
    public Bee getEntity() {
        return (Bee) super.getEntity();
    }

    /**
     * Returns the location of the flower that the bee pollinates
     *
     * @return The location of the flower
     */
    @NotNull
    public Location getLocation() {
        return this.location;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return handlers;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return handlers;
    }
}
