package org.bukkit.entity.minecart;

import org.bukkit.entity.Minecart;

/**
 * Represents a Minecart with TNT inside it that can explode when triggered.
 */
public interface ExplosiveMinecart extends Minecart {
    // Paper start - Entity API
    /**
     * Set the number of ticks until the minecart explodes after being primed.
     *
     * @param fuseTicks fuse ticks or -1 if the fuse isn't primed
     */
    void setFuseTicks(int fuseTicks);

    /**
     * Retrieve the number of ticks until the explosive minecart explodes
     *
     * @return number of ticks or -1 if the fuse isn't primed
     */
    int getFuseTicks();
    // Paper end
}
